# ErgoDox EZ naps62 Configuration

## Motivation

I wanted a layout that suited my Linux & Vim usage. I also didn't like the lack of efficient access to some of the more common special characters used in programming.

## Key features / changes

### Base Layer (L1)

* **No `MT(mod, kc)` keys (modifier when pressed, key when tapped).** Those keys work with a global timeout. When a key press is shorter than the timeout, it's considered a tap, otherwise it's a hold. I couldn't find any particular timeout that would work for me. I need to use mods extremely fast, but also want the confort of using them more slowly in other occasions. So I gave up on this feature altogether.
* **Direct access to `{}[]`.** When programming, these are used extremely often. I was still getting used to the coder layer, and I prefer the arrows on the home row, so I used the bottom-right keys for this.
* **Layer keys everywhere.** I either use my little finger or my index finger to go to L1, whichever is more confortable in any given situation. L2 is not used while coding/writing, so I don't need an extremely-optimized access to it.
* **Lang key.** This is nothing more than `Super-Space` combo, which in my systems (both Linux & Windows) is the shortcut to change the keyboard language. I'm Portuguese, so I often cycle between US layout for coding, and PT layout for writing.
* **Special chars on the right-most column.** I only use Ctrl & Shift keys on the left side, so I used the right keys to include some of the more useful special characters as well.

### Coder Layer (L2)

* The `=` and `-` signs where nowhere to be found. `-` was already on the base layer, but it's still useful to have a fully-featured NumPad on the coder layer.

### Media Layer (L3)

* **Better media keys**. Why was Play/Pause so far away? And where was Mute? I put all my media keys close to each other, including the missing ones
* **Arrow keys on home row.** I use vim, so I'm always on my home row. I use this sometimes to get around, but not as often as to need them on the base row. I'm fine with them here
* I don't use mouse keys. They're still set up, and I made some changes as an experiment, but I mostly forgot they exist by now.

## Author

[Miguel Palhas](https://github.com/naps62)
