/* Copyright 2016 James Kay
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include "keymap.h"

// clang-format off

/*
 * ┌───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───┬───────┐
 * │   │Num│   │   │   │   │   │   │   │   │   │   │   │       │
 * ├───┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─────┤
 * │     │ S │ T │ P │ H │   │ * │ F │ P │ L │ T │ D │   │     │
 * ├─────┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴┬──┴─────┤
 * │      │   │ K │ W │ R │   │   │ R │ B │ G │ S │ Z │        │
 * ├──────┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴─┬─┴────────┤
 * │        │   │   │ A │ O │   │ E │ U │   │   │   │          │
 * ├────┬───┴┬──┴─┬─┴───┴───┴───┴───┴───┴──┬┴───┼───┴┬────┬────┤
 * │    │    │    │                        │    │    │    │    │
 * └────┴────┴────┴────────────────────────┴────┴────┴────┴────┘
 */
// Row 1
#define PV_NUM  KC_1

// Row 2
#define PV_LS   KC_Q
#define PV_LT   KC_W
#define PV_LP   KC_E
#define PV_LH   KC_R
#define PV_STAR KC_Y
#define PV_RF   KC_U
#define PV_RP   KC_I
#define PV_RL   KC_O
#define PV_RT   KC_P
#define PV_RD   KC_LBRC

// Row 3
#define PV_LK   KC_S
#define PV_LW   KC_D
#define PV_LR   KC_F
#define PV_RR   KC_J
#define PV_RB   KC_K
#define PV_RG   KC_L
#define PV_RS   KC_SCLN
#define PV_RZ   KC_QUOT

// Row 4
#define PV_A    KC_C
#define PV_O    KC_V
#define PV_E    KC_N
#define PV_U    KC_M
