#pragma once

// additional fonts from
// https://github.com/datacute/TinyOLED-Fonts

#if __has_include("oled_font.h")
#    include "oled_font.h"
#else

// additional fonts from
// https://github.com/datacute/TinyOLED-Fonts

#    include "progmem.h"

// clang-format off
static const unsigned char font[] PROGMEM = {
    0x07, 0x08, 0x7F, 0x08, 0x07, 0x00,
    0x3E, 0x5B, 0x4F, 0x5B, 0x3E, 0x00,
    0x3E, 0x6B, 0x4F, 0x6B, 0x3E, 0x00,
    0x1C, 0x3E, 0x7C, 0x3E, 0x1C, 0x00,
    0x18, 0x3C, 0x7E, 0x3C, 0x18, 0x00,
    0x1C, 0x57, 0x7D, 0x57, 0x1C, 0x00,
    0x1C, 0x5E, 0x7F, 0x5E, 0x1C, 0x00,
    0x00, 0x18, 0x3C, 0x18, 0x00, 0x00,
    0xFF, 0xE7, 0xC3, 0xE7, 0xFF, 0x00,
    0x00, 0x18, 0x24, 0x18, 0x00, 0x00,
    0xFF, 0xE7, 0xDB, 0xE7, 0xFF, 0x00,
    0x30, 0x48, 0x3A, 0x06, 0x0E, 0x00,
    0x26, 0x29, 0x79, 0x29, 0x26, 0x00,
    0x40, 0x7F, 0x05, 0x05, 0x07, 0x00,
    0x40, 0x7F, 0x05, 0x25, 0x3F, 0x00,
    0x5A, 0x3C, 0xE7, 0x3C, 0x5A, 0x00,
    0x7F, 0x3E, 0x1C, 0x1C, 0x08, 0x00,
    0x08, 0x1C, 0x1C, 0x3E, 0x7F, 0x00,
    0x14, 0x22, 0x7F, 0x22, 0x14, 0x00,
    0x5F, 0x5F, 0x00, 0x5F, 0x5F, 0x00,
    0x06, 0x09, 0x7F, 0x01, 0x7F, 0x00,
    0x00, 0x66, 0x89, 0x95, 0x6A, 0x00,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x00,
    0x94, 0xA2, 0xFF, 0xA2, 0x94, 0x00,
    0x08, 0x04, 0x7E, 0x04, 0x08, 0x00,
    0x10, 0x20, 0x7E, 0x20, 0x10, 0x00,
    0x08, 0x08, 0x2A, 0x1C, 0x08, 0x00,
    0x08, 0x1C, 0x2A, 0x08, 0x08, 0x00,
    0x1E, 0x10, 0x10, 0x10, 0x10, 0x00,
    0x0C, 0x1E, 0x0C, 0x1E, 0x0C, 0x00,
    0x30, 0x38, 0x3E, 0x38, 0x30, 0x00,
    0x06, 0x0E, 0x3E, 0x0E, 0x06, 0x00,

#    if defined(OLED_FONT_5X5)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x5c, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x06, 0x00, 0x06, 0x00, 0x00, 0x00,
    0x28, 0x7c, 0x28, 0x7c, 0x28, 0x00,
    0x5c, 0x54, 0xfe, 0x54, 0x74, 0x00,
    0x44, 0x20, 0x10, 0x08, 0x44, 0x00,
    0x28, 0x54, 0x54, 0x20, 0x50, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x38, 0x44, 0x00, 0x00, 0x00, 0x00,
    0x44, 0x38, 0x00, 0x00, 0x00, 0x00,
    0x02, 0x07, 0x02, 0x00, 0x00, 0x00,
    0x10, 0x10, 0x7c, 0x10, 0x10, 0x00,
    0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x00,
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x60, 0x10, 0x0c, 0x00, 0x00, 0x00,
    0x7c, 0x64, 0x54, 0x4c, 0x7c, 0x00,
    0x48, 0x7c, 0x40, 0x00, 0x00, 0x00,
    0x64, 0x54, 0x54, 0x54, 0x48, 0x00,
    0x44, 0x54, 0x54, 0x54, 0x6c, 0x00,
    0x3c, 0x20, 0x70, 0x20, 0x20, 0x00,
    0x5c, 0x54, 0x54, 0x54, 0x24, 0x00,
    0x7c, 0x54, 0x54, 0x54, 0x74, 0x00,
    0x04, 0x04, 0x64, 0x14, 0x0c, 0x00,
    0x7c, 0x54, 0x54, 0x54, 0x7c, 0x00,
    0x5c, 0x54, 0x54, 0x54, 0x7c, 0x00,
    0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xc4, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x10, 0x28, 0x44, 0x00, 0x00, 0x00,
    0x28, 0x28, 0x28, 0x28, 0x28, 0x00,
    0x44, 0x28, 0x10, 0x00, 0x00, 0x00,
    0x08, 0x04, 0x54, 0x08, 0x00, 0x00,
    0x7c, 0x44, 0x54, 0x54, 0x5c, 0x00,
    0x7c, 0x24, 0x24, 0x24, 0x7c, 0x00,
    0x7c, 0x54, 0x54, 0x54, 0x6c, 0x00,
    0x7c, 0x44, 0x44, 0x44, 0x44, 0x00,
    0x7c, 0x44, 0x44, 0x44, 0x38, 0x00,
    0x7c, 0x54, 0x54, 0x54, 0x44, 0x00,
    0x7c, 0x14, 0x14, 0x14, 0x04, 0x00,
    0x7c, 0x44, 0x44, 0x54, 0x74, 0x00,
    0x7c, 0x10, 0x10, 0x10, 0x7c, 0x00,
    0x44, 0x44, 0x7c, 0x44, 0x44, 0x00,
    0x60, 0x40, 0x40, 0x44, 0x7c, 0x00,
    0x7c, 0x10, 0x10, 0x28, 0x44, 0x00,
    0x7c, 0x40, 0x40, 0x40, 0x40, 0x00,
    0x7c, 0x08, 0x10, 0x08, 0x7c, 0x00,
    0x7c, 0x08, 0x10, 0x20, 0x7c, 0x00,
    0x38, 0x44, 0x44, 0x44, 0x38, 0x00,
    0x7c, 0x14, 0x14, 0x14, 0x08, 0x00,
    0x3c, 0x24, 0x64, 0x24, 0x3c, 0x00,
    0x7c, 0x14, 0x14, 0x14, 0x68, 0x00,
    0x5c, 0x54, 0x54, 0x54, 0x74, 0x00,
    0x04, 0x04, 0x7c, 0x04, 0x04, 0x00,
    0x7c, 0x40, 0x40, 0x40, 0x7c, 0x00,
    0x0c, 0x30, 0x40, 0x30, 0x0c, 0x00,
    0x3c, 0x40, 0x30, 0x40, 0x3c, 0x00,
    0x44, 0x28, 0x10, 0x28, 0x44, 0x00,
    0x0c, 0x10, 0x60, 0x10, 0x0c, 0x00,
    0x44, 0x64, 0x54, 0x4c, 0x44, 0x00,
    0x7c, 0x44, 0x00, 0x00, 0x00, 0x00,
    0x0c, 0x10, 0x60, 0x00, 0x00, 0x00,
    0x44, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x01, 0x00, 0x00,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x7c, 0x24, 0x24, 0x24, 0x7c, 0x00,
    0x7c, 0x54, 0x54, 0x54, 0x6c, 0x00,
    0x7c, 0x44, 0x44, 0x44, 0x44, 0x00,
    0x7c, 0x44, 0x44, 0x44, 0x38, 0x00,
    0x7c, 0x54, 0x54, 0x54, 0x44, 0x00,
    0x7c, 0x14, 0x14, 0x14, 0x04, 0x00,
    0x7c, 0x44, 0x44, 0x54, 0x74, 0x00,
    0x7c, 0x10, 0x10, 0x10, 0x7c, 0x00,
    0x44, 0x44, 0x7c, 0x44, 0x44, 0x00,
    0x60, 0x40, 0x40, 0x44, 0x7c, 0x00,
    0x7c, 0x10, 0x10, 0x28, 0x44, 0x00,
    0x7c, 0x40, 0x40, 0x40, 0x40, 0x00,
    0x7c, 0x08, 0x10, 0x08, 0x7c, 0x00,
    0x7c, 0x08, 0x10, 0x20, 0x7c, 0x00,
    0x38, 0x44, 0x44, 0x44, 0x38, 0x00,
    0x7c, 0x14, 0x14, 0x14, 0x08, 0x00,
    0x3c, 0x24, 0x64, 0x24, 0x3c, 0x00,
    0x7c, 0x14, 0x14, 0x14, 0x68, 0x00,
    0x5c, 0x54, 0x54, 0x54, 0x74, 0x00,
    0x04, 0x04, 0x7c, 0x04, 0x04, 0x00,
    0x7c, 0x40, 0x40, 0x40, 0x7c, 0x00,
    0x0c, 0x30, 0x40, 0x30, 0x0c, 0x00,
    0x3c, 0x40, 0x30, 0x40, 0x3c, 0x00,
    0x44, 0x28, 0x10, 0x28, 0x44, 0x00,
    0x0c, 0x10, 0x60, 0x10, 0x0c, 0x00,
    0x44, 0x64, 0x54, 0x4c, 0x44, 0x00,
    0x10, 0x7c, 0x44, 0x00, 0x00, 0x00,
    0x6c, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x44, 0x7c, 0x10, 0x00, 0x00, 0x00,
    0x02, 0x01, 0x02, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#    lif defined(OLED_FONT_AZTECH)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x2e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x02, 0x00, 0x02, 0x00, 0x00,
    0x00, 0x0a, 0x1e, 0x0a, 0x1e, 0x00,
    0x00, 0x0e, 0x2a, 0x6b, 0x2a, 0x3a,
    0x00, 0x06, 0x06, 0x26, 0x18, 0x06,
    0x38, 0x3e, 0x2a, 0x2a, 0x28, 0x38,
    0x18, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x3e, 0x22, 0x00, 0x00, 0x00,
    0x00, 0x22, 0x3e, 0x00, 0x00, 0x00,
    0x00, 0x0e, 0x0e, 0x0e, 0x04, 0x00,
    0x00, 0x08, 0x1c, 0x08, 0x00, 0x00,
    0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x08, 0x08, 0x00, 0x00,
    0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x20, 0x18, 0x06, 0x00, 0x00,
    0x00, 0x3e, 0x22, 0x2a, 0x22, 0x3e,
    0x02, 0x3e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x38, 0x28, 0x2a, 0x2a, 0x2e,
    0x00, 0x22, 0x2a, 0x2e, 0x38, 0x00,
    0x00, 0x0e, 0x08, 0x08, 0x3e, 0x08,
    0x00, 0x2e, 0x2a, 0x2a, 0x28, 0x38,
    0x00, 0x3e, 0x2a, 0x2a, 0x28, 0x38,
    0x00, 0x06, 0x02, 0x02, 0x0a, 0x3e,
    0x00, 0x38, 0x2e, 0x2a, 0x2e, 0x38,
    0x00, 0x0e, 0x0a, 0x2a, 0x2a, 0x3e,
    0x00, 0x28, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x28, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x14, 0x22, 0x00, 0x00,
    0x00, 0x14, 0x14, 0x14, 0x14, 0x00,
    0x00, 0x22, 0x14, 0x08, 0x00, 0x00,
    0x00, 0x06, 0x02, 0x2a, 0x0a, 0x06,
    0x00, 0x3e, 0x02, 0x3a, 0x2a, 0x0a,
    0x22, 0x3e, 0x02, 0x0a, 0x0a, 0x3e,
    0x00, 0x3e, 0x22, 0x2a, 0x2e, 0x38,
    0x00, 0x3e, 0x22, 0x22, 0x20, 0x30,
    0x00, 0x3e, 0x22, 0x22, 0x22, 0x3c,
    0x00, 0x3e, 0x2a, 0x22, 0x20, 0x30,
    0x00, 0x3e, 0x0a, 0x0a, 0x06, 0x02,
    0x00, 0x3e, 0x22, 0x2a, 0x28, 0x38,
    0x00, 0x3e, 0x08, 0x08, 0x08, 0x3e,
    0x00, 0x22, 0x3e, 0x22, 0x00, 0x00,
    0x00, 0x30, 0x20, 0x20, 0x22, 0x3e,
    0x00, 0x3e, 0x08, 0x08, 0x0e, 0x38,
    0x00, 0x3e, 0x20, 0x20, 0x20, 0x30,
    0x00, 0x3e, 0x02, 0x3e, 0x20, 0x3e,
    0x3e, 0x3e, 0x02, 0x3e, 0x20, 0x3e,
    0x00, 0x3e, 0x22, 0x22, 0x22, 0x3e,
    0x00, 0x3e, 0x02, 0x0a, 0x0a, 0x0e,
    0x00, 0x3e, 0x22, 0x22, 0x22, 0x3e,
    0x00, 0x3e, 0x02, 0x0a, 0x0e, 0x38,
    0x00, 0x0e, 0x0a, 0x2a, 0x2a, 0x3a,
    0x00, 0x06, 0x02, 0x3e, 0x02, 0x06,
    0x00, 0x3e, 0x20, 0x20, 0x20, 0x3e,
    0x00, 0x3e, 0x20, 0x20, 0x3e, 0x00,
    0x00, 0x3e, 0x20, 0x3e, 0x02, 0x3e,
    0x3e, 0x3a, 0x0e, 0x08, 0x0e, 0x3a,
    0x00, 0x0e, 0x08, 0x08, 0x28, 0x3e,
    0x00, 0x3a, 0x2a, 0x2a, 0x0a, 0x0e,
    0x00, 0x3e, 0x22, 0x00, 0x00, 0x00,
    0x00, 0x02, 0x0c, 0x30, 0x00, 0x00,
    0x22, 0x3e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x01, 0x00, 0x00,
    0x00, 0x20, 0x20, 0x20, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x38, 0x28, 0x28, 0x08, 0x38,
    0x00, 0x3e, 0x20, 0x28, 0x28, 0x38,
    0x00, 0x38, 0x28, 0x28, 0x20, 0x30,
    0x00, 0x38, 0x28, 0x28, 0x20, 0x3e,
    0x00, 0xf8, 0x88, 0x28, 0x28, 0x38,
    0x00, 0xf8, 0x28, 0x28, 0x18, 0x08,
    0x00, 0x38, 0x28, 0xa8, 0x88, 0xf8,
    0x00, 0x3c, 0x08, 0x08, 0x08, 0x38,
    0x00, 0x3a, 0x00, 0x00, 0x00, 0x00,
    0x80, 0xfa, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x3e, 0x08, 0x08, 0x38, 0x2c,
    0x00, 0x3e, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x38, 0x08, 0x38, 0x20, 0x38,
    0x38, 0x38, 0x08, 0x38, 0x20, 0x38,
    0x00, 0x38, 0x28, 0x28, 0x28, 0x38,
    0x00, 0xf8, 0x08, 0x28, 0x28, 0x38,
    0x00, 0x38, 0x28, 0x28, 0x08, 0xf8,
    0x00, 0x38, 0x08, 0x08, 0x18, 0x08,
    0x00, 0x38, 0x28, 0xa8, 0xa8, 0xe8,
    0x00, 0x3e, 0x28, 0x28, 0x20, 0x30,
    0x00, 0x38, 0x20, 0x20, 0x20, 0x38,
    0x00, 0x38, 0x20, 0x38, 0x00, 0x00,
    0x00, 0x38, 0x20, 0x38, 0x08, 0x38,
    0x38, 0x28, 0x38, 0x10, 0x38, 0x28,
    0x00, 0x38, 0x20, 0xa0, 0xa0, 0xf8,
    0x00, 0xe8, 0xa8, 0xa8, 0x28, 0x38,
    0x08, 0x3e, 0x22, 0x00, 0x00, 0x00,
    0x00, 0x3f, 0x00, 0x00, 0x00, 0x00,
    0x22, 0x3e, 0x08, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#    elif defined(OLED_FONT_BMPLAIN)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x2e, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x00, 0x03, 0x00, 0x00, 0x00,
    0x0a, 0x1f, 0x0a, 0x1f, 0x0a, 0x00,
    0x2e, 0x2a, 0x6b, 0x2a, 0x3a, 0x00,
    0x0e, 0x2a, 0x1e, 0x08, 0x3c, 0x2a,
    0x3e, 0x2a, 0x2a, 0x22, 0x38, 0x08,
    0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x1c, 0x22, 0x00, 0x00, 0x00, 0x00,
    0x22, 0x1c, 0x00, 0x00, 0x00, 0x00,
    0x15, 0x0e, 0x04, 0x0e, 0x15, 0x00,
    0x08, 0x08, 0x3e, 0x08, 0x08, 0x00,
    0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x08, 0x08, 0x08, 0x08, 0x00,
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x10, 0x08, 0x04, 0x02, 0x00,
    0x3e, 0x22, 0x2a, 0x22, 0x3e, 0x00,
    0x04, 0x3e, 0x00, 0x00, 0x00, 0x00,
    0x3a, 0x2a, 0x2a, 0x2a, 0x2e, 0x00,
    0x2a, 0x2a, 0x2a, 0x2a, 0x3e, 0x00,
    0x0e, 0x08, 0x08, 0x08, 0x3e, 0x00,
    0x2e, 0x2a, 0x2a, 0x2a, 0x3a, 0x00,
    0x3e, 0x2a, 0x2a, 0x2a, 0x3a, 0x00,
    0x02, 0x02, 0x02, 0x02, 0x3e, 0x00,
    0x3e, 0x2a, 0x2a, 0x2a, 0x3e, 0x00,
    0x2e, 0x2a, 0x2a, 0x2a, 0x3e, 0x00,
    0x14, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x34, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x14, 0x22, 0x00, 0x00, 0x00,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x00,
    0x22, 0x14, 0x08, 0x00, 0x00, 0x00,
    0x06, 0x02, 0x2a, 0x0a, 0x0e, 0x00,
    0x3e, 0x02, 0x3a, 0x2a, 0x3e, 0x00,
    0x3e, 0x12, 0x12, 0x12, 0x3e, 0x00,
    0x3e, 0x2a, 0x2a, 0x2a, 0x36, 0x00,
    0x3e, 0x22, 0x22, 0x22, 0x22, 0x00,
    0x3e, 0x22, 0x22, 0x22, 0x1c, 0x00,
    0x3e, 0x2a, 0x2a, 0x2a, 0x22, 0x00,
    0x3e, 0x0a, 0x0a, 0x0a, 0x02, 0x00,
    0x3e, 0x22, 0x2a, 0x2a, 0x3a, 0x00,
    0x3e, 0x08, 0x08, 0x08, 0x3e, 0x00,
    0x22, 0x3e, 0x22, 0x00, 0x00, 0x00,
    0x38, 0x20, 0x20, 0x20, 0x3e, 0x00,
    0x3e, 0x08, 0x08, 0x14, 0x22, 0x00,
    0x3e, 0x20, 0x20, 0x20, 0x20, 0x00,
    0x3e, 0x04, 0x38, 0x04, 0x3e, 0x00,
    0x3e, 0x04, 0x08, 0x10, 0x3e, 0x00,
    0x3e, 0x22, 0x22, 0x22, 0x3e, 0x00,
    0x3e, 0x0a, 0x0a, 0x0a, 0x0e, 0x00,
    0x3e, 0x22, 0x72, 0x22, 0x3e, 0x00,
    0x3e, 0x0a, 0x0a, 0x1a, 0x2e, 0x00,
    0x2e, 0x2a, 0x2a, 0x2a, 0x3a, 0x00,
    0x02, 0x02, 0x3e, 0x02, 0x02, 0x00,
    0x1e, 0x20, 0x20, 0x20, 0x1e, 0x00,
    0x0e, 0x10, 0x20, 0x10, 0x0e, 0x00,
    0x3e, 0x10, 0x0e, 0x10, 0x3e, 0x00,
    0x22, 0x14, 0x08, 0x14, 0x22, 0x00,
    0x02, 0x04, 0x38, 0x04, 0x02, 0x00,
    0x3a, 0x2a, 0x2a, 0x2a, 0x2e, 0x00,
    0x3e, 0x22, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0x21, 0x3f, 0x00, 0x00, 0x00,
    0x22, 0x3e, 0x00, 0x00, 0x00, 0x00,
    0x0c, 0x1e, 0x3c, 0x1e, 0x0c, 0x00,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x00,
    0x1c, 0x3e, 0x3e, 0x3e, 0x1c, 0x00,
    0x3c, 0x24, 0x24, 0x24, 0x3c, 0x20,
    0x3e, 0x24, 0x24, 0x24, 0x3c, 0x00,
    0x3c, 0x24, 0x24, 0x24, 0x24, 0x00,
    0x3c, 0x24, 0x24, 0x24, 0x3e, 0x00,
    0x3c, 0x24, 0x34, 0x2c, 0x24, 0x00,
    0x08, 0x3e, 0x0a, 0x0a, 0x00, 0x00,
    0x1c, 0x54, 0x54, 0x54, 0x7c, 0x00,
    0x3e, 0x04, 0x04, 0x04, 0x3c, 0x00,
    0x3a, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x7a, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3e, 0x08, 0x14, 0x22, 0x00, 0x00,
    0x02, 0x3e, 0x00, 0x00, 0x00, 0x00,
    0x3c, 0x04, 0x3c, 0x04, 0x3c, 0x00,
    0x3c, 0x04, 0x04, 0x04, 0x3c, 0x00,
    0x3c, 0x24, 0x24, 0x24, 0x3c, 0x00,
    0x7c, 0x24, 0x24, 0x24, 0x3c, 0x00,
    0x3c, 0x24, 0x24, 0x24, 0x7c, 0x00,
    0x3c, 0x04, 0x04, 0x04, 0x00, 0x00,
    0x24, 0x2c, 0x34, 0x24, 0x00, 0x00,
    0x04, 0x3e, 0x24, 0x24, 0x00, 0x00,
    0x3c, 0x20, 0x20, 0x20, 0x3c, 0x00,
    0x0c, 0x10, 0x20, 0x10, 0x0c, 0x00,
    0x3c, 0x20, 0x3c, 0x20, 0x3c, 0x00,
    0x24, 0x24, 0x18, 0x24, 0x24, 0x00,
    0x1c, 0x50, 0x50, 0x50, 0x7c, 0x00,
    0x24, 0x34, 0x2c, 0x24, 0x00, 0x00,
    0x08, 0x3e, 0x22, 0x00, 0x00, 0x00,
    0x1c, 0x22, 0x22, 0x22, 0x1c, 0x00,
    0x22, 0x3e, 0x08, 0x00, 0x00, 0x00,
    0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#    elif defined(OLED_FONT_CRACKERS)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x5E, 0x06, 0x06, 0x00, 0x00, 0x00,
    0x1E, 0x00, 0x00, 0x1E, 0x00, 0x00,
    0x20, 0x7C, 0x38, 0x38, 0x7C, 0x08,
    0x48, 0xFE, 0x64, 0x64, 0x00, 0x00,
    0x64, 0x60, 0x60, 0x18, 0x0C, 0x0C,
    0x74, 0x4A, 0x4A, 0x7E, 0x48, 0x00,
    0x1E, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3C, 0x7E, 0x7E, 0x42, 0x00, 0x00,
    0x42, 0x7E, 0x7E, 0x3C, 0x00, 0x00,
    0x04, 0x0C, 0x04, 0x06, 0x0C, 0x04,
    0x10, 0x3C, 0x3C, 0x3C, 0x10, 0x00,
    0x00, 0x60, 0xE0, 0x00, 0x00, 0x00,
    0x08, 0x08, 0x08, 0x00, 0x00, 0x00,
    0x60, 0x60, 0x60, 0x00, 0x00, 0x00,
    0x60, 0x78, 0x78, 0x1E, 0x06, 0x00,
    0x3C, 0x3C, 0x7E, 0x42, 0x7E, 0x7E,
    0x04, 0x7E, 0x7E, 0x7E, 0x00, 0x00,
    0x76, 0x7A, 0x7E, 0x7E, 0x4C, 0x00,
    0x4A, 0x7E, 0x7E, 0x7C, 0x00, 0x00,
    0x0E, 0x08, 0x7E, 0x7E, 0x7E, 0x00,
    0x4E, 0x4E, 0x4E, 0x7A, 0x1A, 0x00,
    0x3C, 0x7E, 0x7E, 0x4A, 0x7A, 0x00,
    0x02, 0x02, 0x0A, 0x7E, 0x7E, 0x7E,
    0x7E, 0x7E, 0x7E, 0x4A, 0x7E, 0x00,
    0x0C, 0x4A, 0x7E, 0x7E, 0x3C, 0x00,
    0x66, 0x66, 0x66, 0x00, 0x00, 0x00,
    0x66, 0xE6, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x3C, 0x7E, 0x7E, 0x62, 0x00,
    0x14, 0x14, 0x14, 0x00, 0x00, 0x00,
    0x62, 0x7E, 0x7E, 0x3C, 0x08, 0x00,
    0x02, 0x4A, 0x0E, 0x0E, 0x0C, 0x00,
    0x3C, 0x7E, 0x7E, 0x4A, 0x72, 0x30,
    0x7A, 0x4A, 0x7E, 0x7E, 0x7C, 0x00,
    0x7E, 0x7E, 0x7E, 0x4A, 0x24, 0x00,
    0x3C, 0x7E, 0x7E, 0x7E, 0x46, 0x00,
    0x7E, 0x7E, 0x7E, 0x62, 0x3C, 0x00,
    0x7E, 0x7E, 0x7E, 0x4A, 0x00, 0x00,
    0x7E, 0x7E, 0x7E, 0x0A, 0x00, 0x00,
    0x3C, 0x7E, 0x7E, 0x42, 0x62, 0x00,
    0x7E, 0x7E, 0x7E, 0x18, 0x7E, 0x00,
    0x7E, 0x7E, 0x7E, 0x00, 0x00, 0x00,
    0x40, 0x7E, 0x7E, 0x7E, 0x00, 0x00,
    0x7E, 0x7E, 0x7E, 0x3C, 0x66, 0x00,
    0x7E, 0x7E, 0x7E, 0x40, 0x00, 0x00,
    0x7E, 0x3E, 0x3E, 0x7C, 0x3E, 0x3E,
    0x7E, 0x3E, 0x7E, 0x7C, 0x7E, 0x00,
    0x3C, 0x3C, 0x7E, 0x62, 0x7E, 0x7E,
    0x7E, 0x7E, 0x7E, 0x22, 0x0C, 0x00,
    0x3C, 0x7E, 0x7E, 0x62, 0x7E, 0x7C,
    0x7E, 0x7E, 0x7E, 0x0A, 0x64, 0x00,
    0x4C, 0x4E, 0x4E, 0x7A, 0x1A, 0x00,
    0x02, 0x7E, 0x7E, 0x7E, 0x02, 0x00,
    0x7E, 0x60, 0x7E, 0x7E, 0x7E, 0x00,
    0x3E, 0x60, 0x7E, 0x7E, 0x3E, 0x00,
    0x7E, 0x7C, 0x7C, 0x3E, 0x7C, 0x7C,
    0x46, 0x7E, 0x08, 0x7E, 0x62, 0x62,
    0x5E, 0x5E, 0x5E, 0x70, 0x3E, 0x00,
    0x66, 0x7A, 0x7A, 0x5E, 0x66, 0x00,
    0x7E, 0x7E, 0x7E, 0x42, 0x00, 0x00,
    0x06, 0x1E, 0x1E, 0x78, 0x60, 0x00,
    0x42, 0x7E, 0x7E, 0x7E, 0x00, 0x00,
    0x0C, 0x06, 0x0C, 0x00, 0x00, 0x00,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x00,
    0x02, 0x06, 0x06, 0x04, 0x00, 0x00,
    0x78, 0x24, 0x7C, 0x7C, 0x78, 0x00,
    0x7C, 0x7C, 0x7C, 0x48, 0x20, 0x00,
    0x18, 0x7C, 0x7C, 0x7C, 0x4C, 0x00,
    0x20, 0x48, 0x7C, 0x7C, 0x7C, 0x00,
    0x18, 0x7C, 0x7C, 0x74, 0x4C, 0x00,
    0x78, 0x7C, 0x7C, 0x24, 0x00, 0x00,
    0x18, 0x7C, 0x7C, 0x44, 0x74, 0x00,
    0x7C, 0x7C, 0x7C, 0x08, 0x60, 0x00,
    0x7C, 0x7C, 0x7C, 0x00, 0x00, 0x00,
    0x40, 0x7C, 0x7C, 0x7C, 0x00, 0x00,
    0x7C, 0x7C, 0x7C, 0x20, 0x48, 0x00,
    0x7C, 0x7C, 0x7C, 0x40, 0x00, 0x00,
    0x7C, 0x3C, 0x3C, 0x78, 0x3C, 0x3C,
    0x7C, 0x7C, 0x7C, 0x04, 0x78, 0x00,
    0x18, 0x18, 0x7C, 0x44, 0x7C, 0x7C,
    0x7C, 0x7C, 0x7C, 0x24, 0x08, 0x00,
    0x18, 0x18, 0x7C, 0x44, 0x7C, 0x7C,
    0x7C, 0x7C, 0x7C, 0x04, 0x00, 0x00,
    0x5C, 0x7C, 0x7C, 0x74, 0x00, 0x00,
    0x08, 0x7C, 0x7C, 0x7C, 0x48, 0x00,
    0x7C, 0x60, 0x7C, 0x7C, 0x7C, 0x00,
    0x3C, 0x60, 0x7C, 0x7C, 0x3C, 0x00,
    0x7C, 0x78, 0x78, 0x3C, 0x78, 0x78,
    0x4C, 0x3C, 0x3C, 0x78, 0x64, 0x00,
    0x4C, 0x4C, 0x4C, 0x78, 0x3C, 0x00,
    0x5C, 0x74, 0x44, 0x5C, 0x74, 0x00,
    0x24, 0x7E, 0x42, 0x42, 0x00, 0x00,
    0x7E, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x7E, 0x24, 0x00, 0x00, 0x00,
    0x04, 0x06, 0x06, 0x02, 0x04, 0x06,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#    elif defined(OLED_FONT_EIN)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x5F, 0x00, 0x00, 0x00,
    0x00, 0x07, 0x00, 0x07, 0x00, 0x00,
    0x14, 0x7F, 0x14, 0x7F, 0x14, 0x00,
    0x24, 0x2A, 0x7F, 0x2A, 0x12, 0x00,
    0x23, 0x13, 0x08, 0x64, 0x62, 0x00,
    0x36, 0x49, 0x56, 0x20, 0x50, 0x00,
    0x00, 0x08, 0x07, 0x03, 0x00, 0x00,
    0x00, 0x1C, 0x22, 0x41, 0x00, 0x00,
    0x00, 0x41, 0x22, 0x1C, 0x00, 0x00,
    0x2A, 0x1C, 0x7F, 0x1C, 0x2A, 0x00,
    0x08, 0x08, 0x3E, 0x08, 0x08, 0x00,
    0x00, 0x80, 0x70, 0x30, 0x00, 0x00,
    0x08, 0x08, 0x08, 0x08, 0x08, 0x00,
    0x00, 0x00, 0x60, 0x60, 0x00, 0x00,
    0x20, 0x10, 0x08, 0x04, 0x02, 0x00,
    0x3E, 0x51, 0x49, 0x45, 0x3E, 0x00,
    0x00, 0x42, 0x7F, 0x40, 0x00, 0x00,
    0x72, 0x49, 0x49, 0x49, 0x46, 0x00,
    0x21, 0x41, 0x49, 0x4D, 0x33, 0x00,
    0x18, 0x14, 0x12, 0x7F, 0x10, 0x00,
    0x27, 0x45, 0x45, 0x45, 0x39, 0x00,
    0x3C, 0x4A, 0x49, 0x49, 0x31, 0x00,
    0x41, 0x21, 0x11, 0x09, 0x07, 0x00,
    0x36, 0x49, 0x49, 0x49, 0x36, 0x00,
    0x46, 0x49, 0x49, 0x29, 0x1E, 0x00,
    0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
    0x00, 0x40, 0x34, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x14, 0x22, 0x41, 0x00,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x00,
    0x00, 0x41, 0x22, 0x14, 0x08, 0x00,
    0x02, 0x01, 0x59, 0x09, 0x06, 0x00,
    0x00, 0x41, 0x5D, 0x59, 0x4E, 0x00,
    0x7C, 0x12, 0x11, 0x12, 0x7C, 0x00,
    0x7F, 0x49, 0x49, 0x49, 0x36, 0x00,
    0x3E, 0x41, 0x41, 0x41, 0x22, 0x00,
    0x7F, 0x41, 0x41, 0x41, 0x3E, 0x00,
    0x7F, 0x49, 0x49, 0x49, 0x41, 0x00,
    0x7F, 0x09, 0x09, 0x09, 0x01, 0x00,
    0x3E, 0x41, 0x41, 0x51, 0x73, 0x00,
    0x7F, 0x08, 0x08, 0x08, 0x7F, 0x00,
    0x00, 0x00, 0x7F, 0x00, 0x00, 0x00,
    0x20, 0x40, 0x40, 0x3F, 0x00, 0x00,
    0x7F, 0x08, 0x14, 0x22, 0x41, 0x00,
    0x7F, 0x40, 0x40, 0x40, 0x40, 0x00,
    0x7F, 0x02, 0x1C, 0x02, 0x7F, 0x00,
    0x7F, 0x04, 0x08, 0x10, 0x7F, 0x00,
    0x3E, 0x41, 0x41, 0x41, 0x3E, 0x00,
    0x7F, 0x09, 0x09, 0x09, 0x06, 0x00,
    0x3E, 0x41, 0x51, 0x21, 0x5E, 0x00,
    0x7F, 0x09, 0x19, 0x29, 0x46, 0x00,
    0x26, 0x49, 0x49, 0x49, 0x32, 0x00,
    0x01, 0x01, 0x7F, 0x01, 0x01, 0x00,
    0x3F, 0x40, 0x40, 0x40, 0x3F, 0x00,
    0x1F, 0x20, 0x40, 0x20, 0x1F, 0x00,
    0x3F, 0x40, 0x38, 0x40, 0x3F, 0x00,
    0x63, 0x14, 0x08, 0x14, 0x63, 0x00,
    0x03, 0x04, 0x78, 0x04, 0x03, 0x00,
    0x61, 0x59, 0x49, 0x4D, 0x43, 0x00,
    0x00, 0x7F, 0x41, 0x41, 0x41, 0x00,
    0x02, 0x04, 0x08, 0x10, 0x20, 0x00,
    0x00, 0x41, 0x41, 0x41, 0x7F, 0x00,
    0x04, 0x02, 0x01, 0x02, 0x04, 0x00,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x00,
    0x00, 0x03, 0x07, 0x08, 0x00, 0x00,
    0x78, 0x14, 0x14, 0x78, 0x00, 0x00,
    0x7C, 0x54, 0x54, 0x28, 0x00, 0x00,
    0x38, 0x44, 0x44, 0x28, 0x00, 0x00,
    0x7C, 0x44, 0x44, 0x38, 0x00, 0x00,
    0x7C, 0x54, 0x54, 0x44, 0x00, 0x00,
    0x7C, 0x14, 0x14, 0x04, 0x00, 0x00,
    0x38, 0x44, 0x54, 0x34, 0x00, 0x00,
    0x7C, 0x10, 0x10, 0x7C, 0x00, 0x00,
    0x00, 0x7C, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x40, 0x40, 0x3C, 0x00, 0x00,
    0x7C, 0x10, 0x28, 0x44, 0x00, 0x00,
    0x7C, 0x40, 0x40, 0x40, 0x00, 0x00,
    0x7C, 0x08, 0x70, 0x08, 0x7C, 0x00,
    0x7C, 0x08, 0x10, 0x7C, 0x00, 0x00,
    0x38, 0x44, 0x44, 0x38, 0x00, 0x00,
    0x7C, 0x14, 0x14, 0x08, 0x00, 0x00,
    0x38, 0x44, 0x24, 0x58, 0x00, 0x00,
    0x7C, 0x14, 0x34, 0x48, 0x00, 0x00,
    0x48, 0x54, 0x54, 0x24, 0x00, 0x00,
    0x04, 0x7C, 0x04, 0x00, 0x00, 0x00,
    0x3C, 0x40, 0x40, 0x3C, 0x00, 0x00,
    0x3C, 0x40, 0x20, 0x1C, 0x00, 0x00,
    0x3C, 0x40, 0x30, 0x40, 0x3C, 0x00,
    0x44, 0x28, 0x10, 0x28, 0x44, 0x00,
    0x0C, 0x10, 0x70, 0x10, 0x0C, 0x00,
    0x44, 0x64, 0x54, 0x4C, 0x44, 0x00,
    0x00, 0x08, 0x36, 0x41, 0x00, 0x00,
    0x00, 0x00, 0x77, 0x00, 0x00, 0x00,
    0x00, 0x41, 0x36, 0x08, 0x00, 0x00,
    0x02, 0x01, 0x02, 0x04, 0x02, 0x00,
    0x3C, 0x26, 0x23, 0x26, 0x3C, 0x00,
#    elif defined(OLED_FONT_HISKYF21)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x5C, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0C, 0x00, 0x0C, 0x00, 0x00, 0x00,
    0x28, 0x7C, 0x28, 0x7C, 0x28, 0x00,
    0x48, 0x54, 0x54, 0xFE, 0x54, 0x54,
    0x44, 0x20, 0x10, 0x08, 0x44, 0x00,
    0x28, 0x54, 0x54, 0x54, 0x74, 0x10,
    0x0C, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x78, 0x84, 0x00, 0x00, 0x00, 0x00,
    0x84, 0x78, 0x00, 0x00, 0x00, 0x00,
    0x48, 0x30, 0x30, 0x48, 0x00, 0x00,
    0x10, 0x38, 0x10, 0x00, 0x00, 0x00,
    0xC0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x10, 0x10, 0x10, 0x10, 0x00, 0x00,
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x60, 0x10, 0x0C, 0x00, 0x00, 0x00,
    0x38, 0x44, 0x44, 0x44, 0x44, 0x38,
    0x08, 0x7C, 0x00, 0x00, 0x00, 0x00,
    0x64, 0x54, 0x54, 0x54, 0x48, 0x00,
    0x44, 0x54, 0x54, 0x54, 0x28, 0x00,
    0x1C, 0x10, 0x10, 0x10, 0x7C, 0x00,
    0x4C, 0x54, 0x54, 0x54, 0x24, 0x00,
    0x38, 0x54, 0x54, 0x54, 0x54, 0x20,
    0x44, 0x24, 0x14, 0x0C, 0x00, 0x00,
    0x28, 0x54, 0x54, 0x54, 0x54, 0x28,
    0x08, 0x54, 0x54, 0x54, 0x54, 0x38,
    0x48, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xC8, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x10, 0x28, 0x44, 0x00, 0x00, 0x00,
    0x28, 0x28, 0x28, 0x28, 0x00, 0x00,
    0x44, 0x28, 0x10, 0x00, 0x00, 0x00,
    0x04, 0x54, 0x14, 0x14, 0x08, 0x00,
    0x38, 0x44, 0x5C, 0x54, 0x48, 0x00,
    0x60, 0x18, 0x14, 0x14, 0x18, 0x60,
    0x7C, 0x54, 0x54, 0x54, 0x58, 0x30,
    0x38, 0x44, 0x44, 0x44, 0x40, 0x00,
    0x7C, 0x44, 0x44, 0x44, 0x38, 0x00,
    0x7C, 0x54, 0x54, 0x54, 0x54, 0x40,
    0x7C, 0x14, 0x14, 0x14, 0x10, 0x00,
    0x38, 0x44, 0x44, 0x44, 0x70, 0x10,
    0x7C, 0x10, 0x10, 0x10, 0x10, 0x7C,
    0x7C, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x40, 0x40, 0x40, 0x40, 0x3C,
    0x7C, 0x10, 0x10, 0x28, 0x44, 0x00,
    0x7C, 0x40, 0x40, 0x40, 0x00, 0x00,
    0x7C, 0x08, 0x10, 0x60, 0x10, 0x08,
    0x7C, 0x08, 0x10, 0x20, 0x7C, 0x00,
    0x38, 0x44, 0x44, 0x44, 0x44, 0x38,
    0x7C, 0x24, 0x24, 0x24, 0x18, 0x00,
    0x38, 0x44, 0x64, 0x44, 0x38, 0x00,
    0x7C, 0x14, 0x14, 0x14, 0x68, 0x00,
    0x48, 0x54, 0x54, 0x54, 0x54, 0x20,
    0x04, 0x04, 0x7C, 0x04, 0x04, 0x00,
    0x3C, 0x40, 0x40, 0x40, 0x3C, 0x00,
    0x0C, 0x30, 0x40, 0x30, 0x0C, 0x00,
    0x0C, 0x30, 0x40, 0x20, 0x1C, 0x20,
    0x74, 0x2C, 0x10, 0x28, 0x44, 0x00,
    0x04, 0x08, 0x70, 0x08, 0x04, 0x00,
    0x44, 0x64, 0x54, 0x4C, 0x44, 0x00,
    0xFC, 0x84, 0x00, 0x00, 0x00, 0x00,
    0x0C, 0x10, 0x60, 0x00, 0x00, 0x00,
    0x84, 0xFC, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x7F, 0x41, 0x7F, 0x00, 0x00,
    0x40, 0x40, 0x40, 0x40, 0x00, 0x00,
    0x00, 0x7F, 0x41, 0x7F, 0x00, 0x00,
    0x60, 0x18, 0x14, 0x14, 0x18, 0x60,
    0x7C, 0x54, 0x54, 0x54, 0x58, 0x30,
    0x38, 0x44, 0x44, 0x44, 0x40, 0x00,
    0x7C, 0x44, 0x44, 0x44, 0x38, 0x00,
    0x7C, 0x54, 0x54, 0x54, 0x54, 0x40,
    0x7C, 0x14, 0x14, 0x14, 0x10, 0x00,
    0x38, 0x44, 0x44, 0x44, 0x70, 0x10,
    0x7C, 0x10, 0x10, 0x10, 0x10, 0x7C,
    0x7C, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x40, 0x40, 0x40, 0x40, 0x3C,
    0x7C, 0x10, 0x10, 0x28, 0x44, 0x00,
    0x7C, 0x40, 0x40, 0x40, 0x00, 0x00,
    0x7C, 0x08, 0x10, 0x60, 0x10, 0x08,
    0x7C, 0x08, 0x10, 0x20, 0x7C, 0x00,
    0x38, 0x44, 0x44, 0x44, 0x44, 0x38,
    0x7C, 0x24, 0x24, 0x24, 0x18, 0x00,
    0x38, 0x44, 0x64, 0x44, 0x38, 0x00,
    0x7C, 0x14, 0x14, 0x14, 0x68, 0x00,
    0x48, 0x54, 0x54, 0x54, 0x54, 0x20,
    0x04, 0x04, 0x7C, 0x04, 0x04, 0x00,
    0x3C, 0x40, 0x40, 0x40, 0x3C, 0x00,
    0x0C, 0x30, 0x40, 0x30, 0x0C, 0x00,
    0x0C, 0x30, 0x40, 0x20, 0x1C, 0x20,
    0x74, 0x2C, 0x10, 0x28, 0x44, 0x00,
    0x04, 0x08, 0x70, 0x08, 0x04, 0x00,
    0x44, 0x64, 0x54, 0x4C, 0x44, 0x00,
    0x00, 0x7F, 0x41, 0x7F, 0x00, 0x00,
    0xFC, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x7F, 0x41, 0x7F, 0x00, 0x00,
    0x00, 0x7F, 0x41, 0x7F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#    elif defined(OLED_FONT_SUPER_DIGG)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x58, 0x5C, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x01, 0x00, 0x00, 0x01, 0x00,
    0x14, 0x7F, 0x14, 0x7F, 0x14, 0x00,
    0x5C, 0xFE, 0x54, 0xFE, 0x74, 0x00,
    0x03, 0x63, 0x38, 0x0C, 0x63, 0x60,
    0x70, 0x5C, 0x54, 0x74, 0x7C, 0x50,
    0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x70, 0x7C, 0x44, 0x00, 0x00, 0x00,
    0x44, 0x7C, 0x70, 0x00, 0x00, 0x00,
    0x2A, 0x1C, 0x7F, 0x1C, 0x2A, 0x00,
    0x10, 0x10, 0x70, 0x7C, 0x10, 0x00,
    0x40, 0xC0, 0x00, 0x00, 0x00, 0x00,
    0x10, 0x10, 0x10, 0x10, 0x00, 0x00,
    0x40, 0x40, 0x00, 0x00, 0x00, 0x00,
    0x70, 0x7C, 0x03, 0x00, 0x00, 0x00,
    0x7C, 0x44, 0x44, 0x44, 0x7C, 0x1C,
    0x04, 0x04, 0x7C, 0x1C, 0x00, 0x00,
    0x74, 0x74, 0x54, 0x54, 0x5C, 0x00,
    0x44, 0x54, 0x54, 0x54, 0x7C, 0x70,
    0x1C, 0x10, 0x10, 0x7C, 0x7C, 0x00,
    0x5C, 0x5C, 0x54, 0x54, 0x74, 0x00,
    0x70, 0x7C, 0x54, 0x54, 0x74, 0x00,
    0x04, 0x14, 0x14, 0x14, 0x7C, 0x70,
    0x70, 0x5C, 0x54, 0x74, 0x7C, 0x00,
    0x5C, 0x54, 0x54, 0x54, 0x7C, 0x1C,
    0x50, 0x50, 0x00, 0x00, 0x00, 0x00,
    0x50, 0xD0, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x24, 0x42, 0x00, 0x00,
    0x28, 0x28, 0x28, 0x28, 0x00, 0x00,
    0x42, 0x24, 0x18, 0x18, 0x00, 0x00,
    0x04, 0x14, 0x54, 0x54, 0x1C, 0x1C,
    0xF8, 0x04, 0x74, 0x74, 0x54, 0x54,
    0x70, 0x7C, 0x14, 0x14, 0x3C, 0x00,
    0x7C, 0x74, 0x54, 0x54, 0x7C, 0x00,
    0x70, 0x7C, 0x44, 0x44, 0x44, 0x44,
    0x70, 0x7C, 0x44, 0x44, 0x48, 0x70,
    0x70, 0x7C, 0x54, 0x54, 0x54, 0x44,
    0x70, 0x7C, 0x14, 0x14, 0x14, 0x04,
    0x70, 0x7C, 0x44, 0x44, 0x54, 0x74,
    0x70, 0x7C, 0x10, 0x10, 0x7C, 0x00,
    0x70, 0x7C, 0x00, 0x00, 0x00, 0x00,
    0x60, 0x40, 0x40, 0x40, 0x7C, 0x70,
    0x7C, 0x70, 0x10, 0x1C, 0x70, 0x00,
    0x70, 0x7C, 0x40, 0x40, 0x40, 0x60,
    0x70, 0x7C, 0x04, 0x04, 0x7C, 0x04,
    0x70, 0x7C, 0x04, 0x04, 0x04, 0x7C,
    0x70, 0x7C, 0x44, 0x44, 0x44, 0x7C,
    0x70, 0x7C, 0x24, 0x24, 0x3C, 0x00,
    0x7C, 0x44, 0x44, 0x44, 0x7C, 0x00,
    0x7C, 0x74, 0x14, 0x14, 0x3C, 0x00,
    0x5C, 0x5C, 0x54, 0x54, 0x74, 0x00,
    0x04, 0x04, 0x7C, 0x74, 0x04, 0x00,
    0x70, 0x7C, 0x40, 0x40, 0x40, 0x7C,
    0x70, 0x7C, 0x40, 0x40, 0x20, 0x1C,
    0x70, 0x7C, 0x40, 0x40, 0x7C, 0x40,
    0x70, 0x7C, 0x10, 0x10, 0x3C, 0x00,
    0x1C, 0x10, 0x70, 0x70, 0x1C, 0x00,
    0x74, 0x74, 0x54, 0x54, 0x5C, 0x00,
    0xF0, 0xFE, 0x82, 0x00, 0x00, 0x00,
    0x03, 0x7C, 0x70, 0x00, 0x00, 0x00,
    0x82, 0xFE, 0xF0, 0x00, 0x00, 0x00,
    0x04, 0x02, 0x01, 0x06, 0x04, 0x00,
    0x40, 0x40, 0x40, 0x40, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x70, 0x7C, 0x14, 0x14, 0x3C, 0x00,
    0x7C, 0x74, 0x54, 0x54, 0x7C, 0x00,
    0x70, 0x7C, 0x44, 0x44, 0x44, 0x44,
    0x70, 0x7C, 0x44, 0x44, 0x48, 0x70,
    0x70, 0x7C, 0x54, 0x54, 0x54, 0x44,
    0x70, 0x7C, 0x14, 0x14, 0x14, 0x04,
    0x70, 0x7C, 0x44, 0x44, 0x54, 0x74,
    0x70, 0x7C, 0x10, 0x10, 0x7C, 0x00,
    0x70, 0x7C, 0x00, 0x00, 0x00, 0x00,
    0x60, 0x40, 0x40, 0x40, 0x7C, 0x70,
    0x7C, 0x70, 0x10, 0x1C, 0x70, 0x00,
    0x70, 0x7C, 0x40, 0x40, 0x40, 0x60,
    0x70, 0x7C, 0x04, 0x04, 0x7C, 0x04,
    0x70, 0x7C, 0x04, 0x04, 0x04, 0x7C,
    0x70, 0x7C, 0x44, 0x44, 0x44, 0x7C,
    0x70, 0x7C, 0x24, 0x24, 0x3C, 0x00,
    0x7C, 0x44, 0x44, 0x44, 0x7C, 0x00,
    0x7C, 0x74, 0x14, 0x14, 0x3C, 0x00,
    0x5C, 0x5C, 0x54, 0x54, 0x74, 0x00,
    0x04, 0x04, 0x7C, 0x74, 0x04, 0x00,
    0x70, 0x7C, 0x40, 0x40, 0x40, 0x7C,
    0x70, 0x7C, 0x40, 0x40, 0x20, 0x1C,
    0x70, 0x7C, 0x40, 0x40, 0x7C, 0x40,
    0x70, 0x7C, 0x10, 0x10, 0x3C, 0x00,
    0x1C, 0x10, 0x70, 0x70, 0x1C, 0x00,
    0x74, 0x74, 0x54, 0x54, 0x5C, 0x00,
    0x10, 0xFE, 0xC2, 0x00, 0x00, 0x00,
    0x00, 0x44, 0x77, 0x00, 0x00, 0x00,
    0xC2, 0xFE, 0x10, 0x00, 0x00, 0x00,
    0x02, 0x01, 0x03, 0x04, 0x06, 0x02,
    0x3C, 0x22, 0x21, 0x22, 0x3C, 0x00,
#elif defined (OLED_FONT_ZXPIX)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x2F, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x00, 0x03, 0x00, 0x00, 0x00,
    0x12, 0x3F, 0x12, 0x12, 0x3F, 0x12,
    0x2E, 0x2A, 0x7F, 0x2A, 0x3A, 0x00,
    0x23, 0x13, 0x08, 0x04, 0x32, 0x31,
    0x10, 0x2A, 0x25, 0x2A, 0x10, 0x20,
    0x02, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x1E, 0x21, 0x00, 0x00, 0x00, 0x00,
    0x21, 0x1E, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x2A, 0x1C, 0x2A, 0x08, 0x08,
    0x08, 0x08, 0x3E, 0x08, 0x08, 0x08,
    0x80, 0x60, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x08, 0x08, 0x08, 0x08, 0x00,
    0x30, 0x30, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x10, 0x08, 0x04, 0x02, 0x00,
    0x1E, 0x31, 0x29, 0x25, 0x23, 0x1E,
    0x22, 0x21, 0x3F, 0x20, 0x20, 0x20,
    0x32, 0x29, 0x29, 0x29, 0x29, 0x26,
    0x12, 0x21, 0x21, 0x25, 0x25, 0x1A,
    0x18, 0x14, 0x12, 0x3F, 0x10, 0x10,
    0x17, 0x25, 0x25, 0x25, 0x25, 0x19,
    0x1E, 0x25, 0x25, 0x25, 0x25, 0x18,
    0x01, 0x01, 0x31, 0x09, 0x05, 0x03,
    0x1A, 0x25, 0x25, 0x25, 0x25, 0x1A,
    0x06, 0x29, 0x29, 0x29, 0x29, 0x1E,
    0x24, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x80, 0x64, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x14, 0x22, 0x00, 0x00, 0x00,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x00,
    0x22, 0x14, 0x08, 0x00, 0x00, 0x00,
    0x02, 0x01, 0x01, 0x29, 0x05, 0x02,
    0x1E, 0x21, 0x2D, 0x2B, 0x2D, 0x0E,
    0x3E, 0x09, 0x09, 0x09, 0x09, 0x3E,
    0x3F, 0x25, 0x25, 0x25, 0x25, 0x1A,
    0x1E, 0x21, 0x21, 0x21, 0x21, 0x12,
    0x3F, 0x21, 0x21, 0x21, 0x12, 0x0C,
    0x3F, 0x25, 0x25, 0x25, 0x25, 0x21,
    0x3F, 0x05, 0x05, 0x05, 0x05, 0x01,
    0x1E, 0x21, 0x21, 0x21, 0x29, 0x1A,
    0x3F, 0x04, 0x04, 0x04, 0x04, 0x3F,
    0x21, 0x21, 0x3F, 0x21, 0x21, 0x21,
    0x10, 0x20, 0x20, 0x20, 0x20, 0x1F,
    0x3F, 0x04, 0x0C, 0x0A, 0x11, 0x20,
    0x3F, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x3F, 0x02, 0x04, 0x04, 0x02, 0x3F,
    0x3F, 0x02, 0x04, 0x08, 0x10, 0x3F,
    0x1E, 0x21, 0x21, 0x21, 0x21, 0x1E,
    0x3F, 0x09, 0x09, 0x09, 0x09, 0x06,
    0x1E, 0x21, 0x29, 0x31, 0x21, 0x1E,
    0x3F, 0x09, 0x09, 0x09, 0x19, 0x26,
    0x12, 0x25, 0x25, 0x25, 0x25, 0x18,
    0x01, 0x01, 0x01, 0x3F, 0x01, 0x01,
    0x1F, 0x20, 0x20, 0x20, 0x20, 0x1F,
    0x0F, 0x10, 0x20, 0x20, 0x10, 0x0F,
    0x1F, 0x20, 0x10, 0x10, 0x20, 0x1F,
    0x21, 0x12, 0x0C, 0x0C, 0x12, 0x21,
    0x01, 0x02, 0x0C, 0x38, 0x04, 0x02,
    0x21, 0x31, 0x29, 0x25, 0x23, 0x21,
    0x3F, 0x21, 0x00, 0x00, 0x00, 0x00,
    0x02, 0x04, 0x08, 0x10, 0x20, 0x00,
    0x21, 0x3F, 0x00, 0x00, 0x00, 0x00,
    0x04, 0x02, 0x3F, 0x02, 0x04, 0x00,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x01, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x10, 0x30, 0x2A, 0x2A, 0x3C, 0x00,
    0x3F, 0x24, 0x24, 0x24, 0x18, 0x00,
    0x0C, 0x14, 0x22, 0x22, 0x00, 0x00,
    0x18, 0x24, 0x24, 0x24, 0x3F, 0x00,
    0x1C, 0x2C, 0x2A, 0x2A, 0x24, 0x00,
    0x3E, 0x05, 0x01, 0x00, 0x00, 0x00,
    0x18, 0x28, 0xA4, 0xA4, 0x7C, 0x00,
    0x3F, 0x04, 0x04, 0x0C, 0x30, 0x00,
    0x24, 0x3D, 0x20, 0x00, 0x00, 0x00,
    0x20, 0x40, 0x40, 0x3D, 0x00, 0x00,
    0x3F, 0x0C, 0x12, 0x20, 0x00, 0x00,
    0x1F, 0x20, 0x20, 0x00, 0x00, 0x00,
    0x3E, 0x02, 0x3C, 0x02, 0x3C, 0x00,
    0x3E, 0x02, 0x02, 0x02, 0x3C, 0x00,
    0x0C, 0x14, 0x22, 0x32, 0x0C, 0x00,
    0xFC, 0x24, 0x24, 0x24, 0x18, 0x00,
    0x18, 0x24, 0x24, 0x24, 0xFC, 0x80,
    0x3C, 0x04, 0x02, 0x02, 0x00, 0x00,
    0x24, 0x2C, 0x2A, 0x2A, 0x10, 0x00,
    0x02, 0x1F, 0x22, 0x20, 0x00, 0x00,
    0x1E, 0x20, 0x20, 0x20, 0x1E, 0x00,
    0x06, 0x18, 0x20, 0x18, 0x06, 0x00,
    0x1E, 0x30, 0x1C, 0x30, 0x0E, 0x00,
    0x22, 0x14, 0x08, 0x14, 0x22, 0x00,
    0x0C, 0x10, 0xA0, 0xA0, 0x7C, 0x00,
    0x22, 0x32, 0x2A, 0x26, 0x22, 0x22,
    0x0C, 0x3F, 0x21, 0x00, 0x00, 0x00,
    0x3F, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x21, 0x3F, 0x0C, 0x00, 0x00, 0x00,
    0x02, 0x01, 0x02, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#    else // default font
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x5F, 0x00, 0x00, 0x00,
    0x00, 0x07, 0x00, 0x07, 0x00, 0x00,
    0x14, 0x7F, 0x14, 0x7F, 0x14, 0x00,
    0x24, 0x2A, 0x7F, 0x2A, 0x12, 0x00,
    0x23, 0x13, 0x08, 0x64, 0x62, 0x00,
    0x36, 0x49, 0x56, 0x20, 0x50, 0x00,
    0x00, 0x08, 0x07, 0x03, 0x00, 0x00,
    0x00, 0x1C, 0x22, 0x41, 0x00, 0x00,
    0x00, 0x41, 0x22, 0x1C, 0x00, 0x00,
    0x2A, 0x1C, 0x7F, 0x1C, 0x2A, 0x00,
    0x08, 0x08, 0x3E, 0x08, 0x08, 0x00,
    0x00, 0x80, 0x70, 0x30, 0x00, 0x00,
    0x08, 0x08, 0x08, 0x08, 0x08, 0x00,
    0x00, 0x00, 0x60, 0x60, 0x00, 0x00,
    0x20, 0x10, 0x08, 0x04, 0x02, 0x00,
    0x3E, 0x51, 0x49, 0x45, 0x3E, 0x00,
    0x00, 0x42, 0x7F, 0x40, 0x00, 0x00,
    0x72, 0x49, 0x49, 0x49, 0x46, 0x00,
    0x21, 0x41, 0x49, 0x4D, 0x33, 0x00,
    0x18, 0x14, 0x12, 0x7F, 0x10, 0x00,
    0x27, 0x45, 0x45, 0x45, 0x39, 0x00,
    0x3C, 0x4A, 0x49, 0x49, 0x31, 0x00,
    0x41, 0x21, 0x11, 0x09, 0x07, 0x00,
    0x36, 0x49, 0x49, 0x49, 0x36, 0x00,
    0x46, 0x49, 0x49, 0x29, 0x1E, 0x00,
    0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
    0x00, 0x40, 0x34, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x14, 0x22, 0x41, 0x00,
    0x14, 0x14, 0x14, 0x14, 0x14, 0x00,
    0x00, 0x41, 0x22, 0x14, 0x08, 0x00,
    0x02, 0x01, 0x59, 0x09, 0x06, 0x00,
    0x3E, 0x41, 0x5D, 0x59, 0x4E, 0x00,
    0x7C, 0x12, 0x11, 0x12, 0x7C, 0x00,
    0x7F, 0x49, 0x49, 0x49, 0x36, 0x00,
    0x3E, 0x41, 0x41, 0x41, 0x22, 0x00,
    0x7F, 0x41, 0x41, 0x41, 0x3E, 0x00,
    0x7F, 0x49, 0x49, 0x49, 0x41, 0x00,
    0x7F, 0x09, 0x09, 0x09, 0x01, 0x00,
    0x3E, 0x41, 0x41, 0x51, 0x73, 0x00,
    0x7F, 0x08, 0x08, 0x08, 0x7F, 0x00,
    0x00, 0x41, 0x7F, 0x41, 0x00, 0x00,
    0x20, 0x40, 0x41, 0x3F, 0x01, 0x00,
    0x7F, 0x08, 0x14, 0x22, 0x41, 0x00,
    0x7F, 0x40, 0x40, 0x40, 0x40, 0x00,
    0x7F, 0x02, 0x1C, 0x02, 0x7F, 0x00,
    0x7F, 0x04, 0x08, 0x10, 0x7F, 0x00,
    0x3E, 0x41, 0x41, 0x41, 0x3E, 0x00,
    0x7F, 0x09, 0x09, 0x09, 0x06, 0x00,
    0x3E, 0x41, 0x51, 0x21, 0x5E, 0x00,
    0x7F, 0x09, 0x19, 0x29, 0x46, 0x00,
    0x26, 0x49, 0x49, 0x49, 0x32, 0x00,
    0x03, 0x01, 0x7F, 0x01, 0x03, 0x00,
    0x3F, 0x40, 0x40, 0x40, 0x3F, 0x00,
    0x1F, 0x20, 0x40, 0x20, 0x1F, 0x00,
    0x3F, 0x40, 0x38, 0x40, 0x3F, 0x00,
    0x63, 0x14, 0x08, 0x14, 0x63, 0x00,
    0x03, 0x04, 0x78, 0x04, 0x03, 0x00,
    0x61, 0x59, 0x49, 0x4D, 0x43, 0x00,
    0x00, 0x7F, 0x41, 0x41, 0x41, 0x00,
    0x02, 0x04, 0x08, 0x10, 0x20, 0x00,
    0x00, 0x41, 0x41, 0x41, 0x7F, 0x00,
    0x04, 0x02, 0x01, 0x02, 0x04, 0x00,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x00,
    0x00, 0x03, 0x07, 0x08, 0x00, 0x00,
    0x20, 0x54, 0x54, 0x78, 0x40, 0x00,
    0x7F, 0x28, 0x44, 0x44, 0x38, 0x00,
    0x38, 0x44, 0x44, 0x44, 0x28, 0x00,
    0x38, 0x44, 0x44, 0x28, 0x7F, 0x00,
    0x38, 0x54, 0x54, 0x54, 0x18, 0x00,
    0x00, 0x08, 0x7E, 0x09, 0x02, 0x00,
    0x18, 0x24, 0x24, 0x1C, 0x78, 0x00,
    0x7F, 0x08, 0x04, 0x04, 0x78, 0x00,
    0x00, 0x44, 0x7D, 0x40, 0x00, 0x00,
    0x20, 0x40, 0x40, 0x3D, 0x00, 0x00,
    0x7F, 0x10, 0x28, 0x44, 0x00, 0x00,
    0x00, 0x41, 0x7F, 0x40, 0x00, 0x00,
    0x7C, 0x04, 0x78, 0x04, 0x78, 0x00,
    0x7C, 0x08, 0x04, 0x04, 0x78, 0x00,
    0x38, 0x44, 0x44, 0x44, 0x38, 0x00,
    0x7C, 0x18, 0x24, 0x24, 0x18, 0x00,
    0x18, 0x24, 0x24, 0x18, 0x7C, 0x00,
    0x7C, 0x08, 0x04, 0x04, 0x08, 0x00,
    0x48, 0x54, 0x54, 0x54, 0x24, 0x00,
    0x04, 0x04, 0x3F, 0x44, 0x24, 0x00,
    0x3C, 0x40, 0x40, 0x20, 0x7C, 0x00,
    0x1C, 0x20, 0x40, 0x20, 0x1C, 0x00,
    0x3C, 0x40, 0x30, 0x40, 0x3C, 0x00,
    0x44, 0x28, 0x10, 0x28, 0x44, 0x00,
    0x4C, 0x90, 0x90, 0x90, 0x7C, 0x00,
    0x44, 0x64, 0x54, 0x4C, 0x44, 0x00,
    0x00, 0x08, 0x36, 0x41, 0x00, 0x00,
    0x00, 0x00, 0x77, 0x00, 0x00, 0x00,
    0x00, 0x41, 0x36, 0x08, 0x00, 0x00,
    0x02, 0x01, 0x02, 0x04, 0x02, 0x00,
    0x3C, 0x26, 0x23, 0x26, 0x3C, 0x00,
#    endif

// top Logo section
#    if defined(OLED_LOGO_GMK_BAD)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x80, 0xC0, 0xE0, 0xF0, 0xF0, 0x70,
    0x38, 0x38, 0x38, 0x78, 0x70, 0xF0,
    0xE0, 0xE0, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x80, 0xF0, 0xF8,
    0xF8, 0xF8, 0xF8, 0x00, 0x00, 0x00,
    0x80, 0xE0, 0xF8, 0xF8, 0xF8, 0xF8,
    0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x80, 0xF8, 0xF8, 0xF8, 0x38, 0x00,
    0x80, 0xE0, 0xF0, 0xF8, 0x78, 0x38,
    0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x80, 0xF8, 0xF8, 0xF8, 0x38, 0x38,
    0x38, 0xF8, 0xF0, 0xF0, 0xE0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x80, 0xFC, 0xFC,
    0xFC, 0x1C, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#    elif defined(OLED_LOGO_HUE_MANITEE)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x80, 0xC0, 0xC0,
    0x90, 0x70, 0xE8, 0xA8, 0xE4, 0xC4,
    0xC4, 0xA0, 0xE4, 0xB0, 0xDC, 0xE4,
    0xFC, 0xFC, 0xFC, 0xFC, 0x3C, 0x3C,
    0xFC, 0xF8, 0xF0, 0xF0, 0xE0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xF8, 0xF8,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xF8, 0xF8, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#    elif defined(OLED_LOGO_CORNE)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xC0, 0xE0,
    0xF0, 0xF8, 0xF8, 0x18, 0x00, 0xC0,
    0xF0, 0xFC, 0xFE, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x7E, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x80, 0xC0, 0xE0, 0xE0,
    0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0,
    0xC0, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x80, 0xC0, 0xE0, 0xE0, 0xE0, 0xE0,
    0xE0, 0xE0, 0xE0, 0xE0, 0xC0, 0x80,
    0x00, 0x00, 0x00, 0xE0, 0xE0, 0xC0,
    0xC0, 0xE0, 0xE0, 0xE0, 0xE0, 0x00,
    0x00, 0xE0, 0xE0, 0xC0, 0xC0, 0xE0,
    0xE0, 0xE0, 0xE0, 0xE0, 0xC0, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x80, 0xC0,
    0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0,
    0xE0, 0xE0, 0xC0, 0x80, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#    elif defined(OLED_LOGO_LOOSE)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xC0, 0xE0, 0xF0, 0xF8,
    0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0x00,
    0xFC, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE,
    0x02, 0xF9, 0x01, 0x01, 0x05, 0x09,
    0x11, 0x22, 0x06, 0xFE, 0xFE, 0xFE,
    0xFE, 0xFE, 0xFE, 0xFE, 0x46, 0x46,
    0x44, 0x44, 0x45, 0x44, 0x29, 0x28,
    0x2A, 0x28, 0x11, 0x13, 0x05, 0x07,
    0x05, 0x07, 0x05, 0x07, 0x05, 0x07,
    0xE5, 0xE7, 0xE5, 0x07, 0x05, 0x07,
    0x05, 0x07, 0x05, 0x07, 0x05, 0x07,
    0x85, 0xC7, 0xE5, 0xE7, 0xE5, 0xE7,
    0xE5, 0xE7, 0xE5, 0xC7, 0x85, 0x07,
    0x85, 0xC7, 0xE5, 0xE7, 0xE5, 0xE7,
    0xE5, 0xE7, 0xE5, 0xC7, 0x85, 0x07,
    0x85, 0xC7, 0xE5, 0xE7, 0xE5, 0xE7,
    0xE5, 0xE7, 0xE5, 0xE7, 0xE5, 0x07,
    0xE5, 0xE7, 0xE5, 0xE7, 0xE5, 0xE7,
    0xE5, 0xE7, 0xE5, 0xE7, 0xE5, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#    elif defined(OLED_LOGO_SKEEB)
    0xC0, 0x20, 0x10, 0x08, 0x04, 0x02,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x03, 0x07, 0x0F, 0x1F,
    0x3F, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0x01,
    0xFF, 0xFF, 0x01, 0x01, 0xFF, 0xFF,
    0x01, 0x01, 0xFF, 0xFF, 0x19, 0x19,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x01, 0x01, 0xFF, 0xFF, 0x81, 0x81,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x19, 0x19, 0xFF, 0xFF, 0xF9, 0xF9,
    0xF9, 0xF9, 0x01, 0x01, 0xF9, 0xF9,
    0xF9, 0xF9, 0xFF, 0xFF, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0xF9, 0xF9, 0xFF, 0xFF, 0x19, 0x19,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x67, 0x67, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0x3F,
    0x1F, 0x0F, 0x07, 0x03, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x02, 0x04, 0x08, 0x10, 0x20, 0xC0,
#    else
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x40, 0x40, 0xF0, 0xF8, 0xF8,
    0xFF, 0x38, 0xFF, 0xF8, 0xF8, 0x3F,
    0xF8, 0xF8, 0xFF, 0x38, 0xFF, 0xF8,
    0xF8, 0xF0, 0x40, 0x40, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
    0xC0, 0xC0, 0xC0, 0x80, 0x00, 0x00,
    0xC0, 0xC0, 0x80, 0x00, 0x00, 0x00,
    0x80, 0xC0, 0xC0, 0x00, 0xC0, 0xC0,
    0x00, 0x00, 0x80, 0xC0, 0xC0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0,
    0xC0, 0xC0, 0xC0, 0x00, 0xC0, 0xC0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#endif

// First icon section
    0xE0, 0xF0, 0xF0, 0xF0, 0xE0, 0xEC,
    0xEE, 0xF7, 0xF3, 0x70, 0x20, 0x00,
    0x7C, 0x7C, 0x7C, 0x7E, 0x00, 0x7E,
    0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x00,
    0x00, 0x80, 0xC0, 0xE0, 0x7E, 0x5B,
    0x4F, 0x5B, 0xFE, 0xC0, 0x00, 0x00,
    0xC0, 0x00, 0xDC, 0xD7, 0xDE, 0xDE,
    0xDE, 0xD7, 0xDC, 0x00, 0xC0, 0x00,
    0x3E, 0x4A, 0x4F, 0x4A, 0x3E, 0x00,
    0x18, 0x3C, 0x7C, 0x3A, 0x7D, 0x24,
    0x14, 0x36, 0x00, 0x36, 0x77, 0x77,

// middle logo section
#    if defined(OLED_LOGO_GMK_BAD)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3C,
    0xFF, 0xFF, 0xFF, 0xC1, 0x80, 0x00,
    0x00, 0x38, 0x38, 0xB8, 0xB8, 0xF9,
    0xF9, 0xF8, 0x38, 0x00, 0x00, 0x00,
    0x00, 0xC0, 0xF8, 0xFF, 0xFF, 0x1F,
    0x01, 0x3F, 0xFF, 0xFF, 0xF0, 0xFE,
    0x7F, 0x0F, 0x03, 0xFF, 0xFF, 0xFF,
    0xFF, 0x00, 0x00, 0x00, 0x00, 0x80,
    0xFF, 0xFF, 0xFF, 0x3F, 0x1E, 0x7F,
    0xFF, 0xFF, 0xF3, 0xC1, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
    0xFF, 0xFF, 0xFF, 0x3F, 0x1C, 0x1C,
    0x9C, 0xFF, 0xFF, 0xF3, 0xE1, 0x00,
    0x00, 0x00, 0x00, 0xF0, 0xFC, 0xFE,
    0xFF, 0x0F, 0x07, 0x07, 0x8E, 0xFF,
    0xFF, 0xFF, 0x3F, 0x00, 0x00, 0x00,
    0x00, 0xF0, 0xFC, 0xFE, 0xFF, 0x8F,
    0x07, 0x07, 0x8E, 0xFF, 0xFF, 0xFF,
    0x3F, 0x00, 0x00, 0x00, 0x00, 0x80,
    0xC0, 0x80, 0x00, 0x00, 0x00, 0x00,
#    elif defined(OLED_LOGO_HUE_MANITEE)
    0x00, 0x00, 0x00, 0x00, 0x00, 0xF0,
    0xFC, 0xF6, 0xF7, 0xEF, 0xFF, 0x87,
    0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
    0x1F, 0x1F, 0x1F, 0xFF, 0xFF, 0xFF,
    0xFF, 0x07, 0x1F, 0x1F, 0x19, 0x15,
    0xF7, 0x16, 0x1A, 0x1B, 0x16, 0x07,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0C, 0x0C, 0x33, 0x33,
    0x33, 0x33, 0x33, 0x33, 0xC0, 0xC0,
    0x00, 0x00, 0x03, 0x03, 0xFF, 0xFF,
    0x03, 0x03, 0x00, 0x00, 0xC0, 0xC0,
    0x00, 0x00, 0x00, 0xFC, 0xFC, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0xFC,
    0xFC, 0x00, 0x00, 0x00, 0xFC, 0xFC,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0x30, 0x30, 0xCC, 0xCC,
    0x03, 0x03, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#    elif defined(OLED_LOGO_CORNE)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xF8, 0xFC, 0xFE,
    0xFF, 0xE0, 0x00, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0x80, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0x1F, 0x07, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xFF, 0xFF, 0xFF, 0x81, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x81,
    0xC3, 0xC3, 0xC3, 0x00, 0x00, 0xFF,
    0xFF, 0xFF, 0x81, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x81, 0xFF, 0xFF,
    0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xFF, 0xFF, 0xFF, 0x01, 0x00,
    0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF,
    0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
    0x9D, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C,
    0x1C, 0x9D, 0xDF, 0xDF, 0xDF, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#    elif defined(OLED_LOGO_LOOSE)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xE3, 0xC1, 0xC1, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x00, 0xFF, 0x00, 0x00, 0x80, 0x00,
    0x1C, 0x3E, 0x7F, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x14, 0x14, 0x14,
    0x14, 0x14, 0x08, 0x08, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0xBE,
    0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0x81, 0xBD,
    0x81, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
    0x8F, 0x9F, 0x9C, 0x9C, 0x9C, 0x9C,
    0x9C, 0x9C, 0x9C, 0xFC, 0xF8, 0x00,
    0xFF, 0xFF, 0xFF, 0x9C, 0x9C, 0x9C,
    0x9C, 0x9C, 0x9C, 0x80, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#    elif defined(OLED_LOGO_SKEEB)
    0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x01, 0x03, 0x07,
    0x0F, 0x0F, 0x0F, 0x0F, 0x08, 0x08,
    0x0F, 0x0F, 0x0E, 0x0E, 0x0F, 0x0F,
    0x08, 0x08, 0x0F, 0x0F, 0x08, 0x08,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x08, 0x08, 0x0F, 0x0F, 0x09, 0x09,
    0x09, 0x09, 0xF9, 0xF9, 0x09, 0x09,
    0x08, 0x08, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x08, 0x08, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x09, 0x09,
    0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
    0x09, 0x09, 0x0F, 0x0F, 0x08, 0x08,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x08, 0x08, 0x0F, 0x0F, 0x0F, 0x0F,
    0x07, 0x03, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
#    else
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x49, 0x49, 0x49, 0xFF, 0xFF, 0xFF,
    0xFF, 0xE0, 0xDF, 0xBF, 0xBF, 0x00,
    0xBF, 0xBF, 0xDF, 0xE0, 0xFF, 0xFF,
    0xFF, 0xFF, 0x49, 0x49, 0x49, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x1F, 0x3F,
    0x60, 0x60, 0xE0, 0xBF, 0x1F, 0x00,
    0x7F, 0x7F, 0x07, 0x1E, 0x38, 0x1E,
    0x07, 0x7F, 0x7F, 0x00, 0x7F, 0x7F,
    0x0E, 0x1F, 0x3B, 0x71, 0x60, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x7F, 0x7F,
    0x0C, 0x0C, 0x0C, 0x00, 0x7E, 0x7E,
    0x00, 0x7F, 0x7E, 0x03, 0x03, 0x00,
    0x7F, 0x7E, 0x03, 0x03, 0x7E, 0x7E,
    0x03, 0x03, 0x7F, 0x7E, 0x00, 0x0F,
    0x3E, 0x70, 0x3C, 0x06, 0x3C, 0x70,
    0x3E, 0x0F, 0x00, 0x32, 0x7B, 0x49,
    0x49, 0x3F, 0x7E, 0x00, 0x7F, 0x7E,
    0x03, 0x03, 0x00, 0x1E, 0x3F, 0x69,
    0x69, 0x6F, 0x26, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#    endif

// second icon section
    0x0F, 0x1F, 0x3F, 0x7F, 0x7F, 0x7F,
    0x7F, 0x7F, 0x3F, 0x1E, 0x0C, 0x00,
    0x1F, 0x1F, 0x1F, 0x3F, 0x00, 0x3F,
    0x3F, 0x3F, 0x7F, 0x7F, 0x7F, 0x00,
    0x30, 0x7B, 0x7F, 0x78, 0x30, 0x20,
    0x20, 0x30, 0x78, 0x7F, 0x3B, 0x00,
    0x03, 0x00, 0x0F, 0x7F, 0x0F, 0x0F,
    0x0F, 0x7F, 0x0F, 0x00, 0x03, 0x00,
    0x00, 0x44, 0x28, 0xFF, 0x5A, 0x24,
    0xF0, 0xFE, 0xF1, 0x91, 0xF6, 0xF0,
    0xF0, 0xFC, 0xF2, 0x92, 0xFC, 0xF0,

// bottom logo section
#    if defined(OLED_LOGO_GMK_BAD)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x01, 0x03, 0x03, 0x03, 0x07,
    0x07, 0x07, 0x07, 0x03, 0x03, 0x03,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x06, 0x07, 0x07, 0x07, 0x01, 0x00,
    0x00, 0x00, 0x07, 0x07, 0x07, 0x01,
    0x00, 0x00, 0x00, 0x07, 0x07, 0x07,
    0x07, 0x00, 0x00, 0x00, 0x00, 0x07,
    0x07, 0x07, 0x07, 0x00, 0x00, 0x00,
    0x00, 0x03, 0x07, 0x07, 0x07, 0x06,
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x03, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x03, 0x07,
    0x07, 0x07, 0x07, 0x03, 0x07, 0x07,
    0x07, 0x07, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x03, 0x07, 0x07, 0x07,
    0x07, 0x03, 0x07, 0x07, 0x07, 0x07,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x07,
    0x07, 0x07, 0x01, 0x00, 0x00, 0x00,
#    elif defined(OLED_LOGO_HUE_MANITEE)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
    0x03, 0x07, 0x07, 0x07, 0x07, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x03, 0x07, 0x07,
    0x03, 0x00, 0x00, 0x02, 0x04, 0x00,
    0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x03, 0x03, 0x03, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x03, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x03, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#    elif defined(OLED_LOGO_CORNE)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x03, 0x0F, 0x1F,
    0x3F, 0x3F, 0x3F, 0x3F, 0x1F, 0x1F,
    0x3F, 0x3F, 0x7F, 0x7F, 0x7F, 0x3F,
    0x3F, 0x1F, 0x3F, 0x7F, 0x7F, 0x7F,
    0x7F, 0x7C, 0x78, 0x78, 0x38, 0x1C,
    0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x01, 0x03, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x03, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x03, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x03, 0x01,
    0x00, 0x00, 0x00, 0x07, 0x07, 0x07,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x07, 0x07, 0x07, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x07, 0x07,
    0x07, 0x00, 0x00, 0x00, 0x01, 0x03,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x03, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#    elif defined(OLED_LOGO_LOOSE)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x01, 0x03, 0x07, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x00,
    0x1F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
    0x20, 0x47, 0x48, 0x50, 0x40, 0x41,
    0x42, 0x24, 0x30, 0x3F, 0x3F, 0x3F,
    0x3F, 0x3F, 0x3F, 0x3F, 0x31, 0x31,
    0x11, 0x51, 0x11, 0x11, 0x4A, 0x0A,
    0x2A, 0x0A, 0x44, 0x64, 0x50, 0x70,
    0x50, 0x70, 0x50, 0x70, 0x50, 0x70,
    0x53, 0x73, 0x53, 0x73, 0x53, 0x73,
    0x53, 0x73, 0x53, 0x73, 0x53, 0x70,
    0x50, 0x71, 0x53, 0x73, 0x53, 0x73,
    0x53, 0x73, 0x53, 0x71, 0x50, 0x70,
    0x50, 0x71, 0x53, 0x73, 0x53, 0x73,
    0x53, 0x73, 0x53, 0x71, 0x50, 0x70,
    0x53, 0x73, 0x53, 0x73, 0x53, 0x73,
    0x53, 0x73, 0x53, 0x73, 0x51, 0x70,
    0x53, 0x73, 0x53, 0x73, 0x53, 0x73,
    0x53, 0x73, 0x53, 0x73, 0x53, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#    elif defined(OLED_LOGO_SKEEB)
    0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0x08, 0x08, 0x08, 0x08, 0x08,
    0x08, 0x08, 0x08, 0x08, 0x08, 0xFF,
    0x08, 0x08, 0x0F, 0x0F, 0x08, 0x08,
    0x03, 0x04, 0x08, 0x10, 0x20, 0x40,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x40, 0x20, 0x10, 0x08, 0x04, 0x03,
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
    0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00,
    0x80, 0xC0, 0xE0, 0xF0, 0xF8, 0xF8,
    0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8,
    0xF8, 0xF8, 0xF0, 0xE0, 0xC0, 0x80,
    0x01, 0x02, 0xFC, 0xF8, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
#else
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x01, 0x01, 0x07, 0x0F, 0x0F,
    0x7F, 0x0F, 0x7F, 0x0F, 0x0F, 0x7E,
    0x0F, 0x0F, 0x7F, 0x0F, 0x7F, 0x0F,
    0x0F, 0x07, 0x01, 0x01, 0x01, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x01, 0x01, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#endif

// third icon section
    0x1F, 0x05, 0x00, 0x02, 0x1F, 0x00,
    0x1F, 0x05, 0x00, 0x1D, 0x17, 0x00,
    0x1F, 0x05, 0x00, 0x15, 0x1F, 0x00,
    0x1F, 0x05, 0x00, 0x07, 0x1C, 0x00,
    0x1F, 0x05, 0x00, 0x17, 0x1D, 0x00,
    0x1F, 0x05, 0x00, 0x1F, 0x1D, 0x00,
    0x1F, 0x05, 0x00, 0x01, 0x1F, 0x00,
    0x1F, 0x05, 0x00, 0x1F, 0x1F, 0x00,
    0x1F, 0x05, 0x00, 0x07, 0x1F, 0x00,
    0x1F, 0x05, 0x00, 0x70, 0x77, 0x00,
    0x1F, 0x05, 0x00, 0x00, 0x77, 0x00,

// fourth icon section
    0x00, 0x1C, 0x1C, 0x3E, 0x7F, 0x7F,
    0x00, 0x14, 0x08, 0x14, 0x00, 0x00,
    0x00, 0x1C, 0x1C, 0x3E, 0x7F, 0x7F,
    0x00, 0x22, 0x1C, 0x41, 0x3E, 0x00,
    0x00, 0x00, 0x00, 0x30, 0x18, 0x0C,
    0x06, 0x0C, 0x18, 0x30, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x06, 0x06, 0x0C,
    0x18, 0x30, 0x66, 0x66, 0x66, 0x00,
    0x00, 0x00, 0x00, 0x08, 0x0C, 0x7E,
    0x7F, 0x7E, 0x0C, 0x08, 0x00, 0x00,
    0x00, 0x00, 0x77, 0x77, 0x77, 0x00,
    0x77, 0x77, 0x77, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xE7, 0xA5, 0xFF, 0x24,
    0x24, 0xFF, 0xA5, 0xE7, 0x00, 0x00,
    0x00, 0x00, 0x1C, 0x22, 0xC9, 0xD1,
    0xC9, 0x22, 0x1C, 0x00, 0x00, 0x00,
    0x00, 0x10, 0x02, 0x38, 0xFC, 0xED,
    0xFC, 0x38, 0x02, 0x10, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x3E, 0x4A, 0x4F,
    0x4A, 0x3E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x40, 0x60, 0x6A, 0x64,
    0x6A, 0x60, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x04, 0x42, 0x69, 0x65, 0x65,
    0x65, 0x69, 0x42, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x1C, 0x14, 0x1C, 0x08,
    0x18, 0x08, 0x18, 0x00, 0x00, 0x00,
    0x00, 0x70, 0xC8, 0xEE, 0xF9, 0x70,
    0x1F, 0x05, 0x00, 0x10, 0x77, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  };
// clang-format on
#endif
