package fate

import "github.com/godcong/chronos"

type Star struct {
	Title       string `json:"title"`
	Date        string `json:"date"`
	Description string `json:"description"`
	Content     string `json:"content"`
	Advantage   string `json:"advantage"`
	Drawback    string `json:"drawback"`
}

var starList = map[int]Star{
	1: {
		Title: "水瓶座",
		Date: "1月20日 - 2月18日",
		Description: "水瓶座（Aquarius），日期为1月20日—2月18日，黄道星座之第十一宫，在摩羯座之东，双鱼座之西。水瓶座的人善于重新组织自己的精神生活。",
		Content: "",
		Advantage: "崇尚自由、充满人道精神、兴趣广泛、创意十足、乐於发掘真象、有前瞻性、拥有理性的智慧、独立，有个人风格、乐於助人、对自己的感情忠实",
		Drawback: "缺乏热情、想法过於理想化、不按牌理出牌、打破砂锅问到底、太相信自己的判断、思想多变，没有恒心、对朋友很难推心置腹、过於强调生活的自主权、喜欢多管闲事、太过理智，情趣不足",
	},
	2: {
		Title: "双鱼座",
		Date: "2月19日 - 3月20日",
		Description: "双鱼座（Pisces）的出生日期为2月19日—3月20日，黄道星座之第十二宫，位于水瓶座之东，白羊座之西。守护星是木星、海王星。代表色是海蓝色。",
		Content: "",
		Advantage: "感情丰富、心地仁慈，舍己为人，不自私、具有想像力、善解人意、直觉力强、懂得包容、温和有礼、容易信赖别人，不多疑、浪漫",
		Drawback: "不够实际，幻想太多、没有足够的危险意识、太情绪化，多愁善感、意志不坚定、缺乏面对现实的勇气、容易陷入沮丧而不可自拨、很容易养成说谎的习惯、不善于理财、容易受环境影响、缺乏理性，感情用事",
	},
	3: {
		Title: "白羊座",
		Date: "3月21日 - 4月19日",
		Description: "白羊座♈（Aries），黄道十二星座之第一宫，位于双鱼座之东，金牛座之西，出生日期为阳历3月21日~4月19日。白羊座就像小孩子一样，直率、热情、冲动，但也以自我为中心和十分孩子气。",
		Content: "",
		Advantage: "不畏权势、有领导风范、热情有活力、勇于接受挑战、做事积极、坦白、乐观进取有自信、有明快的决断力、率真、深爱自由、勇于接受新观念、讲义气有担当、精力旺盛、有企图心和冒险精神、一旦确定目标就会全力以赴",
		Drawback: "自我中心太强、缺乏耐心考虑、好斗、三分钟热度、粗枝大叶不细心、有时过于感性、记性差",
	},
	4: {
		Title: "金牛座",
		Date: "4月20日 - 5月20日",
		Description: "金牛座（Taurus），出生日期为阳历4月20日~5月20日， [1]  是黄道十二宫的第二宫，位于白羊座之东，双子座之西。",
		Content: "",
		Advantage: "踏实靠谱、善于财务的管理、艺术细胞很强、思维缜密、脚踏实地",
		Drawback: "固执、不懂变通、缺乏自信、容易敏感、容易伤感、容易被人误解、缺乏朋友、忧心忡忡、反应过慢",
	},
	5: {
		Title: "双子座",
		Date: "5月21日 - 6月21日",
		Description: "双子座（Gemini），出生日期为5月21日~6月21日，是黄道十二宫里的第三宫，位于金牛座之东，巨蟹座之西；代表了善变、沟通。然的春意表现在双子座的人性格上的主要特征是思维善变，无拘无束，对外界包罗万象的事物的永无休止的好奇心，可以说是机敏的星座。",
		Content: "",
		Advantage: "擅长争辩、搞怪机灵、反应灵敏、充满好奇心、风趣幽默、口才良好、解决问题能力强、积极主动、神秘、行动力强、豁达开朗",
		Drawback: "低迷、耐力差、孩子气、缺乏安全感、容易敏感、不易上当、过于神经质、双重性格、缺乏耐性、蜻蜓点水、没法深入",
	},
	6: {
		Title: "巨蟹座",
		Date: "6月22日 - 7月22日",
		Description: "巨蟹座，出生日期为6月22日至7月22日（西历），位于黄道十二宫的第四宫，星座位于双子座之东，狮子座之西。",
		Content: "",
		Advantage: "低调、谦虚、谨慎、不喜抛头露面、有上进心、",
		Drawback: "平庸无知、相貌丑陋、被人遗忘、生性多疑、偶尔情绪化、邋遢爱抱怨、懒惰不爱动、容易与人结仇、土里土气、人际关系差、爱斤斤计较、不被人看好、容易让人反感、受气包、总被人嫌弃",
	},
	7: {
		Title: "狮子座",
		Date: "7月23日 - 8月22日",
		Description: "狮子座（Leo）出生日期为7月23日~8月22日，位于巨蟹座之东，处女座之西。",
		Content: "",
		Advantage: "有领导能力、具有激励人心的气质、组织力强、热情开朗、对人慷慨大方、心胸宽大，懂得宽怒、一言九鼎有信用、乐观、不多疑、诚恳正直",
		Drawback: "死爱面子活受罪、好大喜功、莫名的优越感、喜欢接受奉承、缺乏节俭的美德、喜欢指挥别人、缺乏耐性、刚愎自用，自以为是、缅怀过去、能伸不能屈",
	},
	8: {
		Title: "处女座",
		Date: "8月23日 - 9月22日",
		Description: "处女座（virgo）是黄道十二宫的第六宫，出生日期为8月23日—9月22日，在狮子座之东，天秤座之西。处女座细心大方，外表柔和，内在充满激情的星座；喜欢关注细节，容易挑剔和神经紧张，做事一丝不苟，虽然较内向难免会使心情忧郁，但天生的优点就是放得开，不会因此一蹶不振，有目标才有进步，需要时时的鼓励。",
		Content: "",
		Advantage: "追求完美，永不气馁、脚踏实地、事事谨慎小心、善于收集资料、勤奋努力、守本份，靠得住、谦逊不夸大、有精确的观察力、有耐性、对爱情忠实",
		Drawback: "太过吹毛求疵、唠叨琐碎、杞人忧天穷紧张、自扫门前雪、有洁癖顷向",
	},
	9: {
		Title: "天秤座",
		Date: "9月23日 - 10月23日",
		Description: "天秤座，也译作天平座(英文名：Libra) ，位于处女座之东，天蝎座之西，是黄道十二宫的第七宫。",
		Content: "",
		Advantage: "公平客观、有正义感、适应力强、对美感有鉴赏力、逻辑强，善分析、天生的优雅风采、浪漫的恋爱高手、有外交手腕、因事制宜，能屈能伸，适应力强",
		Drawback: "优柔寡断，犹豫不决、意志不坚定，容易受人影响、乡愿，怕得罪人、不能承受压力，没有担当、过份要求公平，吃不得亏、息事宁人，治标不治本、总是自愿其说，藉口太多、喜欢享受，好逸恶劳、常不经意地乱放电、缺乏自省能力",
	},
	10: {
		Title: "天蝎座",
		Date: "10月24日 - 11月22日",
		Description: "天蝎座（Scorpio），是黄道十二星座之一，位于天秤座之东，射手座之西。出生日期为10月24日-11月22日。",
		Content: "",
		Advantage: "深谋远虑、恩怨分明、直觉敏锐、对决定的事有执行力、不畏挫折，坚持到底、对朋友讲义气、天生的性感魅力、坚持追求事情的真相、善于保守秘密、对人生有潜在的热情",
		Drawback: "太过好强、占有欲过高、善妒，爱吃醋、疑心病重、报复心太强、得理不饶人、感情用事，明知故犯、口是心非，城府太深、爱恨太强烈",
	},
	11: {
		Title: "射手座",
		Date: "11月23日 - 12月21日",
		Description: "射手座（Sagittarius），出生时间是11月23日~12月21日，黄道十二宫之第九宫，位于天蝎座之东，摩羯座之西。射手座是象征着冬季来临的星座，符号是指向右上方的箭。射手座的人为人坦率，宽厚，待人真实；注重文化修养，重视友情。",
		Content: "",
		Advantage: "天生乐观、对人生充满理想、正直坦率、丰富的幽默感、酷爱和平、待人友善、行动力强、有自己的处世哲学、经得起打击、有救世救人的热情",
		Drawback: "粗心大意、心直口快，容易得罪人、缺乏耐性、不懂人情世故、做事冲动，不懂三思而行、不信邪，不听劝告、过度理想化，不切实际、缺乏按部就班的计划、喜怒太形于色",
	},
	12: {
		Title: "摩羯座",
		Date: "12月22日 - 1月19日",
		Description: "摩羯座（Capricornus），摩羯座也是黄道十二宫的第十宫，出生日期为12月22日至1月19日，位于射手座之东，水瓶座之西。摩羯座是象征着冬天开始的星座，是天使与魔鬼兼并融合的星座。冬天把“绝对意识”毫无保留地带给了摩羯座的人。摩羯座的人踏实温润，你将是一个徘徊在理想与现实之间的人，你很难在这之间寻找平衡点，而且你会是一个主观意识很强的人。",
		Content: "",
		Advantage: "有实际的人生观、做事脚踏实地、意志力强，不容易受影响、处处谨慎、有克服困难的毅力、坚守原则、重视纪律、有家庭观念、对人谦逊、有独树一格的幽默感",
		Drawback: "太过现实、固执、不够乐观、个人利己主义、缺乏浪漫情趣、过于压抑自己的欲望、太专注于个人的目标、缺乏对人群的关怀和热情、不擅于沟通、不能随机应变",
	},
}

var fixedStar = map[int]int {
	1: 20,
	2: 19,
	3: 21,
	4: 20,
	5: 21,
	6: 22,
	7: 23,
	8: 23,
	9: 23,
	10: 24,
	11: 23,
	12: 22,
}

func GetStar(c chronos.Calendar) *Star {
	t := c.Solar().Time()
	month := int(t.Month())
	day := t.Day()
	starIndex := month
	if day < fixedStar[month] {
		starIndex = month - 1
		if month == 1 {
			starIndex = 12
		}
	}
	star := starList[starIndex]
	return &star
}

func GetStarScore(c chronos.Calendar) int {
	score := 100
	t := c.Solar().Time()
	month := int(t.Month())
	day := t.Day()
	if day < fixedStar[month] {
		score = 99
	}

	return score
}