package library

import (
	"fmt"
	"log"
	"testing"
)

func TestParseDescription(t *testing.T) {
	str := "广西玉林市博白县凤山中学一学生因点外卖，被校务人员按倒在地训斥教育，登上网络热搜。3月21日上午，博白县教育局回应记者时表示，有工作人员在调查处理此事，并将适时公布调查情况。网络视频显示，一名男生被一名黑衣男子按倒在地，该黑衣男子大声说道：“点多少次了啊，还这样搞……”随后，记者与广西玉林市博白县凤山中学取得联系，相关负责人称，视频中的男生是因为点外卖被批评，学校对安全管理很严格，外面食品不能带进学校的，另外已针对该校务人员的工作方法进行了批评教育。据央视网报道，3月20日上午，牙冠竞价挂网于在四川成都举行并产生入围结果。口腔牙齿种植的费用大致包括种植体、牙冠和医疗服务费用三部分。其中，种植体集中带量采购已于今年1月开展，中选产品价格平均降至900多元，平均降幅55%；医疗服务方面，此前国家医保局发文要求，三级公立医院单颗常规种植牙医疗服务价格调控目标为4500元，多地已根据要求出台或落实了相关政策；叠加此次牙冠竞价挂网，预计种植一颗牙的整体费用有望降低50%左右。"

	desc := ParseDescription(str)

	log.Println(desc)
}

func TestParseContentTitles(t *testing.T) {
	str := `<div class="site-content"><h2 id="content-dir-0">支持的系统</h2>支持 Windows 7、Windows 8、Windows 10、Windows 11、Windows server 各个版本。 Windows XP 未测试<br>支持 Ubuntu、Centos、Red Hat、Debian 等 基于 X86 的 Linux 版本。<br>支持 MacOS。<br><br><h2 id="content-dir-1">Linux服务器上部署AnQiCMS</h2>先从 <a href="/download" target="_blank">/download</a> 下载 AnQiCMS Linux 安装包。<br><br><img src="/uploads/202212/07/4fa2f037ac88f39c.webp" style="max-width:100%;" contenteditable="false"><br><br><h3 id="content-dir-2">宝塔上部署</h3><h4 id="content-dir-3">首次安装：</h4>宝塔面板7.9.3版本以上支持更快捷的部署，建议升级宝塔面板到7.9.3以上版本。<br><br><h5 id="content-dir-4">创建目录和上传安装包</h5>1.&nbsp;&nbsp;<span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;">点击左侧菜单的 </span><code style="font-size: 14px;">文件</code><span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;"> 菜单，切换目录到 </span><code style="font-size: 14px;">/www/wwwroot/</code><span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;"> 目录，在 </span><code style="font-size: 14px;">wwwroot</code><span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;"> 目录下创建一个新目录，目录一般以域名命名，如 </span><code style="font-size: 14px;">anqicms.com</code><span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;">。如图：</span><div><br><img src="/uploads/202212/20/bbbc4d783ddddea5.webp" style="max-width:100%;" contenteditable="false"><br><p><br></p>2. <span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;">点击 </span><code style="font-size: 14px;">anqicms.com</code><span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;">，进入 </span><code style="font-size: 14px;">anqicms.com</code><span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;"> 文件夹，将Linux安装包 </span><code style="font-size: 14px;">anqicms-linux-v3.x.x.zip</code><span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;"> 上传到当前目录。在安装包 </span><code style="font-size: 14px;">anqicms-linux-v3.x.x.zip</code><span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;"> 上单击右键，选择解压，将安装包解压到当前文件夹。如图：</span><div><br><img src="/uploads/202212/20/c85a28f3784583a5.webp" style="max-width:100%;" contenteditable="false"><br><br><h5 id="content-dir-5">宝塔面板7.9.3版本以上部署：</h5><p>点击左侧菜单的 <code>网站</code> 菜单，点击 <code>Go项目</code>，来到Go项目网站创建页面，点击 <code>添加Go项目</code> 按钮，在弹出的弹窗中，进行配置。项目执行文件选择 <code>/www/wwwroot/anqicms.com/anqicms</code>；项目名称填写 <code>AnQICMS</code>；项目端口 填写 <code>8001</code>；执行命令填写 <code>/www/wwwroot/anqicms.com/anqicms</code> ；运行用户选 <code>www</code>；并勾选开机启动，备注可以按需填写，默认即可；绑定域名填写你解析到服务器的域名。填写完成后，点击提交按钮，完成添加。如图：</p><br><img src="/uploads/202212/20/66993f4ad54f002a.webp" style="max-width:100%;" contenteditable="false"><br><br><h5 id="content-dir-6">在旧版宝塔部署：</h5><p>旧版没有使用Go项目部署，则选择其他项目部署。</p><p>点击左侧菜单的 <code>网站</code> 菜单，点击 <code>其他项目</code>，来到其他项目网站创建页面，点击 <code>添加通用项目</code> 按钮，在弹出的弹窗中，进行配置，配置项和宝塔7.9.3版本以上版本填写内容一致。项目执行文件选择 <code>/www/wwwroot/anqicms.com/anqicms</code>；项目名称填写 <code>AnQICMS</code>；项目端口 填写 <code>8001</code>；执行命令填写 <code>/www/wwwroot/anqicms.com/anqicms</code> ；运行用户选 <code>www</code>；并勾选开机启动，备注可以按需填写，默认即可；绑定域名填写你解析到服务器的域名。填写完成后，点击提交按钮，完成添加。</p><br><h5 id="content-dir-7">初始化安装网站</h5>在浏览器中 访问你绑定的域名，来到 AnQICMS初始化安装界面，填写数据库信息，后台账号密码信息，以及网站地址。如图：<br><br><img src="/uploads/202212/07/67c379cf3cabfeb7.webp" style="max-width:100%;" contenteditable="false"><br><br>如果安装失败，可能出现的情况有：1，数据库账号密码不正确，请重新检查数据库账号密码。2. 数据库账号权限不足，无法创建数据库，请提前创建数据库或使用更高权限的账号。3. 管理员密码长度不足，请设置更复杂的密码。<br><br>安装成功后，访问前台和后台，检查是否一切正常。<br><br>如果安装失败，可能出现的情况有：1，数据库账号密码不正确，请重新检查数据库账号密码。2. 数据库账号权限不足，无法创建数据库，请提前创建数据库或使用更高权限的账号。3. 管理员密码长度不足，请设置更复杂的密码。<br><br>安装成功后，访问前台和后台，检查是否一切正常。<br><br><h4 id="content-dir-8">一台服务器上安装多站点：</h4>AnQiCMS 在一台服务器上安装多个站点不需要复制多份AnQICMS代码，请按下面操作流程来添加多个站点。<br><br>1. <span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;">在宝塔面板左侧菜单中，点击 </span><code style="font-size: 14px;">网站</code><span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;"> 菜单，点击</span><code style="font-size: 14px;">PHP项目</code><span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;">，添加一个PHP站点，在创建站点中，填写已解析到服务器上的域名，根目录按默认即可，复制根目录地址，等会下一步要用到，FTP、数据库均选择不创建，PHP版本选择纯静态。最后点击提交。如图：</span><ol><li><br></li></ol><img src="/uploads/202212/07/56a7ab6de4a91bf1.webp" style="max-width:100%;" contenteditable="false"><br><br>2. <span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;">登录站点后台，在左侧菜单中点击 </span><code style="font-size: 14px;">多站点管理</code><span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;"> 菜单（只有默认安装的站点具有多站点管理权限）。在多站点管理界面中，点击添加新站点按钮。在弹出的弹窗中，根据实际填写表单。站点名称按实际情况填写，方便区分不同站点；站点根目录请填写一个新目录，粘贴第一步复制的站点根目录，如：</span><code style="font-size: 14px;">/www/wwwroot/study.ykbh168.com</code><span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;">，新目录需要提前在服务器上创建；站点网址填写新网址，这个网址也需要提前解析到服务器上。管理员账号和管理员密码是新站点管理员账号密码；数据库名称需要是一个新的数据库，不要填写已存在的站点的数据库，否则会导致数据覆盖，如果默认安装使用root账号安装，可以选择复用数据库账号，免去填写账号信息。最后点击确定按钮，完成新站点的创建。如图：</span><ol><li><br></li></ol><img src="/uploads/202212/07/d2f7be8b6ae13a36.webp" style="max-width:100%;" contenteditable="false"><br><br>3. <span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;">在宝塔中，新建的网站操作栏中点击设置，在弹出的界面中，选择 </span><code style="font-size: 14px;">网站目录</code><span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;"> 菜单，更改运行目录为 </span><code style="font-size: 14px;">/public</code><span style="font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;">，点击保存。如图：</span><ol><li><br></li></ol><img src="/uploads/202212/07/971928a0175c88cc.webp" style="max-width:100%;" contenteditable="false"><br><br>4. 伪静态设置<br>- Nginx 伪静态设置<br>选择 <code>伪静态</code> 菜单，填写伪静态规则，并点击保存，可以点击另存为模板，方便下次使用：<br><pre><code class="Bash">    location @AnqiCMS {
        proxy_pass http://127.0.0.1:8001;
        proxy_set_header   Host             $host;
        proxy_set_header   X-Real-IP        $remote_addr;
        proxy_set_header   X-Forwarded-For  $proxy_add_x_forwarded_for;
    }
    error_page 404 =200  @AnqiCMS;
    location / {
       try_files $uri $uri/index.html @AnqiCMS;
    }</code></pre><img src="/uploads/202212/20/26ec330729bea3bf.webp" style="max-width:100%;" contenteditable="false"><br><br></div><div>- Apache 伪静态配置<br>如果你使用的 Apache软件，则伪静态规则会不一致。伪静态一栏请留空，选择反向代理，在目标URL中填写 <a href="http://127.0.0.1:8001" target="_blank" rel="nofollow">http://127.0.0.1:8001/</a>，如图：<br><br><img src="/uploads/202212/07/532544a856ea233d.webp" style="max-width:100%;" contenteditable="false"><br><br>这样新站点就添加完成了。</div><div><br></div><h4 id="content-dir-9">默认的config.json配置：</h4><div><pre><code class="Bash">{
	"server": {
		"site_name": "安企内容管理系统(AnqiCMS)",
		"env": "production",
		"port": 8001,
		"log_level": "release"
	}
}</code></pre><br><h3 id="content-dir-10">命令行下部署安装AnQiCMS</h3>如果你的服务器没有安装可视化的环境管理软件，使用的是 <code>lnmp.org</code> 的LNMP一键安装包环境，或者是自行编译的服务器环境，包括本地的Linux桌面版，如Ubuntu、CentOS桌面版等，都可使用命令部署。以下操作默认认为你已经安装好了LNMP环境了。<br><br>1. <span style="font-size: 16px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;">从官网下载 Linux版本的AnQiCMS安装包，并将安装包解压到指定位置。假设解压到 </span><code style="font-size: 16px;">/www/wwwroot/anqicms.com</code><span style="font-size: 16px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;"> 目录。</span><br><br>2. 添加启动计划任务：<br><br><pre><code class="Bash">crontab -e</code></pre><p><br></p>在打开的编辑界面中，添加一条命令<br><br><pre><code class="Bash">*/1 * * * * /www/wwwroot/anqicms.com/start.sh
# ws 保存并退出。</code></pre><p><br></p>这里要注意，如果你手动修改了anqicms可执行文件名，则需要手动打开start.sh编辑，将里面的anqicms改成对应的新文件名。<br><br>添加计划任务后，再顺手执行一次：<br><br><pre><code class="Bash">./start.sh</code></pre><p><br></p>3. 配置 Nginx 站点<br>一般上，还需要配置nginx代理，来使用80端口或https端口。下面以站点跟目录为 /www/wwwroot/anqicms.com，域名 dev.anqicms.com 配置为例：<br><br>我们需要将网站的运行目录，也就是nginx 的 root 目录配置到站点目录下的public目录。<br><br>并设置反向代理，目标URL：<a href="http://127.0.0.1:8001" target="_blank" rel="nofollow">http://127.0.0.1:8001/</a><br><br>nginx代理代码如下：<br><br><pre><code class="Bash">    location @AnqiCMS {
        proxy_pass http://127.0.0.1:8001;
        proxy_set_header   Host             $host;
        proxy_set_header   X-Real-IP        $remote_addr;
        proxy_set_header   X-Forwarded-For  $proxy_add_x_forwarded_for;
    }
    error_page 404 =200  @AnqiCMS;
    location / {
       try_files $uri $uri/index.html @AnqiCMS;
    }</code></pre><p><br></p>完整的nginx配置：<br><pre><code class="Bash">server
{
    listen       80;
    server_name www.anqicms.com m.anqicms.com;
    root /www/wwwroot/anqicms.com/public;

    location @AnqiCMS {
        proxy_pass http://127.0.0.1:8001;
        proxy_set_header   Host             $host;
        proxy_set_header   X-Real-IP        $remote_addr;
        proxy_set_header   X-Forwarded-For  $proxy_add_x_forwarded_for;
    }
    error_page 404 =200  @AnqiCMS;
    location / {
       try_files $uri $uri/index.html @AnqiCMS;
    }
    access_log access.log;
}</code></pre>nginx设置完成，重启nginx来让配置生效。<br><br>4. 多站点的配置<br>只需要重复上面第三步，需要变动的地方只有2处，分别是 server_name 和 root，server_name 填写新的域名，root 填写新的站点根目录。<br>添加了Nginx站点后，再到 AnQiCMS 后台多站点管理中，添加对应的站点即可。<br><br><h3 id="content-dir-11">从 AnQiCMS 2.x 版本升级到 3.x 版</h3>由于 AnQiCMS 2.x 版吧服务器安装部署教程较为复杂，容易导致一些问题出现，而普通用户无法自行排查解决，并且，2.x版本不支持后台重启功能，因此这里建议升级使用3.x版本。升级方法如下：<br><br>1. 选择第一个安装的站点作为默认站点，登录网站后台，从后台升级到最新版。升级完成后，通过原来的计划任务，进行站点的重启。如果尝试重启后，后台版本没有更新为新版，则可以采用结尾的常见问题方法解决。<br><br>2. 先用计划任务停止项目，再删除掉计划任务。<br><br>3. 按 宝塔面板7.9.3版本以上部署 方法开始添加为Go项目。添加项目的时候，选择的执行文件为第一个站点的anqicms可执行文件，端口为第一个站点的端口。添加完项目后就可以恢复网站访问了。不会进入初始化步骤。<br><br>4. 如果原来已经在服务器上安装了多套 AnQiCMS，则现在需要在计划任务中，把它们都停止掉，然后将计划任务删除。接着，按一台服务器上安装多站点的方法部署成新站点。注意，添加新站点的时候，填写的站点根目录为对于站点原来的根目录，数据库信息为对于站的原来数据库和账号信息，这样它会自动继承原站的数据，不会进入初始化安装步骤。<br><br>以上方法可以将多站点合并到使用一个AnQiCMS部署管理。不做以上变更不影响实际使用。<br><br><h2 id="content-dir-12">Windows 上测试使用AnQiCMS</h2>Windows 上可以测试使用AnQiCMS，并做本地开发调试使用。Windows上，也建议安装使用 宝塔软件 管理环境，或安装使用 小皮(phpStudy) 软件开发环境。<br><br>从官网下载 Windows 版本的安装包，可以放到任意目录。解压缩到指定文件夹中，例如解压到anqicms 文件夹，进入文件夹，双击运行 anqicms.exe 文件，即可测试使用了。需要在本地运行多站点，则需要配合 宝塔软件 或 小皮(phpStudy) 软件，通过其管理界面的网站菜单，添加多个站点，在伪静态规则中添加伪静态规则。伪静态规则可按伪静态设置中设置方式添加。本地的测试域名，需要写入到 hosts 中。<br><br>Windows 上如何停止或关闭AnQiCMS<br>Windows上关闭AnQiCMS需要借助Windows自带的任务管理器。<br>按 Win键+R，调出 运行窗口，输入 taskmgr 打开任务管理器，或者在任务栏，单击右键，选择任务管理器。在任务管理器中，找到 anqicms.exe 然后点结束按钮，结束它。<br><br><h2 id="content-dir-13">MacOS 上测试使用AnQiCMS</h2>MacOS上可以测试使用AnQiCMS，并做本地开发调试使用。MacOS上，需要自行先安装MySQL 和 Nginx 环境。<br><br>从官网上下载 MacOS版本的安装包，可放到任意目录，解压缩，并双击运行目录内的anqicms文件，即可测试使用了。多站点的测试方法，可按命令行下部署安装AnQiCMS方法进行，使用域名需要先写入到 /etc/hosts 中。<br><br><h2 id="content-dir-14">安装过程中常见错误</h2>1. 端口已被占用。<br>在服务器上反复安装、安装多个anqicms的时候，可能会出现端口被占用的情况。如果设置了，但是网站无法访问，则可能是这个原因。<br>linux下，使用如下命令 lsof -i:{端口号} 查看端口情况。如要查找8001端口是否被占用：<br><br><pre><code class="Bash">lsof -i:8001</code></pre><img src="/uploads/202212/07/f91034b8013e614f.webp" style="max-width:100%;" contenteditable="false"><br><br>查找到被占用的PID后，通过 kill -9 {PID} 来结束它。<br><pre><code class="Bash">kill -9 7621</code></pre><img src="/uploads/202212/07/198e2a7f537630a4.webp" style="max-width:100%;" contenteditable="false"><br><br>2. 伪静态规则设置不正确。<br></div></div></div>`

	titles := ParseContentTitles(str)

	for i, title := range titles {
		fmt.Println(i, title.Prefix, title.Tag, title.Level, title.Title)
	}
}
