/*
 * this header needs to be included after
 * some kind of avcodec/avformat/etc header, it
 * relies on AV_VERSION_INT
 */

/*
 * before ffmpeg 0.5 there was only
 * AVCODEC and AVFORMAT, but also this project
 * is only tested down to 2.8, these are more for reference
 */

/* all defines prefixed with "ICH" ("IceCast HLS") to
 * prevent any conflict with ffmpeg heraders */

/* ffmpeg 0.5 */
#define ICH_LIBAVCODEC_0_5 AV_VERSION_INT(52,20,0)
#define ICH_LIBAVFORMAT_0_5 AV_VERSION_INT(52,31,0)
#define ICH_LIBAVUTIL_0_5 AV_VERSION_INT(49,15,0)
#define ICH_LIBAVFILTER_0_5 AV_VERSION_INT(0,4,0)

/* ffmpeg 0.6 */
#define ICH_LIBAVCODEC_0_6 AV_VERSION_INT(52,72,2)
#define ICH_LIBAVFORMAT_0_6 AV_VERSION_INT(52,64,2)
#define ICH_LIBAVUTIL_0_6 AV_VERSION_INT(50,15,1)
#define ICH_LIBAVFILTER_0_6 AV_VERSION_INT(1,19,0)

/* ffmpeg 0.7 */
#define ICH_LIBAVCODEC_0_7 AV_VERSION_INT(52,122,0)
#define ICH_LIBAVFORMAT_0_7 AV_VERSION_INT(52,110,0)
#define ICH_LIBAVUTIL_0_7 AV_VERSION_INT(50,43,0)
#define ICH_LIBAVFILTER_0_7 AV_VERSION_INT(1,80,0)

/* ffmpeg 0.8 */
#define ICH_LIBAVCODEC_0_8 AV_VERSION_INT(53,7,0)
#define ICH_LIBAVFORMAT_0_8 AV_VERSION_INT(53,4,0)
#define ICH_LIBAVUTIL_0_8 AV_VERSION_INT(51,9,1)
#define ICH_LIBAVFILTER_0_8 AV_VERSION_INT(2,23,0)

/* ffmpeg 0.9 */
#define ICH_LIBAVCODEC_0_9 AV_VERSION_INT(53,42,0)
#define ICH_LIBAVFORMAT_0_9 AV_VERSION_INT(53,24,0)
#define ICH_LIBAVUTIL_0_9 AV_VERSION_INT(51,32,0)
#define ICH_LIBAVFILTER_0_9 AV_VERSION_INT(2,53,0)

/* ffmpeg 0.10 */
#define ICH_LIBAVCODEC_0_10 AV_VERSION_INT(53,60,100)
#define ICH_LIBAVFORMAT_0_10 AV_VERSION_INT(53,31,100)
#define ICH_LIBAVUTIL_0_10 AV_VERSION_INT(51,34,101)
#define ICH_LIBAVFILTER_0_10 AV_VERSION_INT(2,60,100)

/* ffmpeg 0.11 */
#define ICH_LIBAVCODEC_0_11 AV_VERSION_INT(54,23,100)
#define ICH_LIBAVFORMAT_0_11 AV_VERSION_INT(54,6,100)
#define ICH_LIBAVUTIL_0_11 AV_VERSION_INT(51,54,100)
#define ICH_LIBAVFILTER_0_11 AV_VERSION_INT(2,77,100)

/* ffmpeg 1.0 */
#define ICH_LIBAVCODEC_1_0 AV_VERSION_INT(54,59,100)
#define ICH_LIBAVFORMAT_1_0 AV_VERSION_INT(54,29,104)
#define ICH_LIBAVUTIL_1_0 AV_VERSION_INT(51,73,101)
#define ICH_LIBAVFILTER_1_0 AV_VERSION_INT(3,17,100)

/* ffmpeg 1.1 */
#define ICH_LIBAVCODEC_1_1 AV_VERSION_INT(54,86,100)
#define ICH_LIBAVFORMAT_1_1 AV_VERSION_INT(54,59,106)
#define ICH_LIBAVUTIL_1_1 AV_VERSION_INT(52,13,100)
#define ICH_LIBAVFILTER_1_1 AV_VERSION_INT(3,32,100)

/* ffmpeg 2.0 */
#define ICH_LIBAVCODEC_2_0 AV_VERSION_INT(55,18,102)
#define ICH_LIBAVFORMAT_2_0 AV_VERSION_INT(55,12,100)
#define ICH_LIBAVUTIL_2_0 AV_VERSION_INT(52,38,100)
#define ICH_LIBAVFILTER_2_0 AV_VERSION_INT(3,79,101)

/* ffmpeg 2.1 */
#define ICH_LIBAVCODEC_2_1 AV_VERSION_INT(55,39,100)
#define ICH_LIBAVFORMAT_2_1 AV_VERSION_INT(55,19,104)
#define ICH_LIBAVUTIL_2_1 AV_VERSION_INT(52,48,100)
#define ICH_LIBAVFILTER_2_1 AV_VERSION_INT(3,90,100)

/* ffmpeg 2.2 */
#define ICH_LIBAVCODEC_2_2 AV_VERSION_INT(55,52,102)
#define ICH_LIBAVFORMAT_2_2 AV_VERSION_INT(55,33,100)
#define ICH_LIBAVUTIL_2_2 AV_VERSION_INT(52,66,100)
#define ICH_LIBAVFILTER_2_2 AV_VERSION_INT(4,2,100)

/* ffmpeg 2.3 */
#define ICH_LIBAVCODEC_2_3 AV_VERSION_INT(55,69,100)
#define ICH_LIBAVFORMAT_2_3 AV_VERSION_INT(55,48,100)
#define ICH_LIBAVUTIL_2_3 AV_VERSION_INT(52,92,100)
#define ICH_LIBAVFILTER_2_3 AV_VERSION_INT(4,11,100)

/* ffmpeg 2.4 */
#define ICH_LIBAVCODEC_2_4 AV_VERSION_INT(56,1,100)
#define ICH_LIBAVFORMAT_2_4 AV_VERSION_INT(56,4,101)
#define ICH_LIBAVUTIL_2_4 AV_VERSION_INT(54,7,100)
#define ICH_LIBAVFILTER_2_4 AV_VERSION_INT(5,1,100)

/* ffmpeg 2.5 */
#define ICH_LIBAVCODEC_2_5 AV_VERSION_INT(56,13,100)
#define ICH_LIBAVFORMAT_2_5 AV_VERSION_INT(56,15,102)
#define ICH_LIBAVUTIL_2_5 AV_VERSION_INT(54,15,100)
#define ICH_LIBAVFILTER_2_5 AV_VERSION_INT(5,2,103)

/* ffmpeg 2.6 */
#define ICH_LIBAVCODEC_2_6 AV_VERSION_INT(56,26,100)
#define ICH_LIBAVFORMAT_2_6 AV_VERSION_INT(56,25,101)
#define ICH_LIBAVUTIL_2_6 AV_VERSION_INT(54,20,100)
#define ICH_LIBAVFILTER_2_6 AV_VERSION_INT(5,11,102)

/* ffmpeg 2.7 */
#define ICH_LIBAVCODEC_2_7 AV_VERSION_INT(56,41,100)
#define ICH_LIBAVFORMAT_2_7 AV_VERSION_INT(56,36,100)
#define ICH_LIBAVUTIL_2_7 AV_VERSION_INT(54,27,100)
#define ICH_LIBAVFILTER_2_7 AV_VERSION_INT(5,16,101)

/* ffmpeg 2.8 */
#define ICH_LIBAVCODEC_2_8 AV_VERSION_INT(56,60,100)
#define ICH_LIBAVFORMAT_2_8 AV_VERSION_INT(56,40,101)
#define ICH_LIBAVUTIL_2_8 AV_VERSION_INT(54,31,100)
#define ICH_LIBAVFILTER_2_8 AV_VERSION_INT(5,40,101)

/* ffmpeg 3.0 */
#define ICH_LIBAVCODEC_3_0 AV_VERSION_INT(57,24,102)
#define ICH_LIBAVFORMAT_3_0 AV_VERSION_INT(57,25,100)
#define ICH_LIBAVUTIL_3_0 AV_VERSION_INT(55,17,103)
#define ICH_LIBAVFILTER_3_0 AV_VERSION_INT(6,31,100)

/* ffmpeg 3.1 */
#define ICH_LIBAVCODEC_3_1 AV_VERSION_INT(57,48,101)
#define ICH_LIBAVFORMAT_3_1 AV_VERSION_INT(57,40,101)
#define ICH_LIBAVUTIL_3_1 AV_VERSION_INT(55,27,100)
#define ICH_LIBAVFILTER_3_1 AV_VERSION_INT(6,46,102)

/* ffmpeg 3.2 */
#define ICH_LIBAVCODEC_3_2 AV_VERSION_INT(57,64,100)
#define ICH_LIBAVFORMAT_3_2 AV_VERSION_INT(57,56,100)
#define ICH_LIBAVUTIL_3_2 AV_VERSION_INT(55,34,100)
#define ICH_LIBAVFILTER_3_2 AV_VERSION_INT(6,65,100)

/* ffmpeg 3.3 */
#define ICH_LIBAVCODEC_3_3 AV_VERSION_INT(57,89,100)
#define ICH_LIBAVFORMAT_3_3 AV_VERSION_INT(57,71,100)
#define ICH_LIBAVUTIL_3_3 AV_VERSION_INT(55,58,100)
#define ICH_LIBAVFILTER_3_3 AV_VERSION_INT(6,82,100)

/* ffmpeg 3.4 */
#define ICH_LIBAVCODEC_3_4 AV_VERSION_INT(57,107,100)
#define ICH_LIBAVFORMAT_3_4 AV_VERSION_INT(57,83,100)
#define ICH_LIBAVUTIL_3_4 AV_VERSION_INT(55,78,100)
#define ICH_LIBAVFILTER_3_4 AV_VERSION_INT(6,107,100)

/* ffmpeg 4.0 */
#define ICH_LIBAVCODEC_4_0 AV_VERSION_INT(58,18,100)
#define ICH_LIBAVFORMAT_4_0 AV_VERSION_INT(58,12,100)
#define ICH_LIBAVUTIL_4_0 AV_VERSION_INT(56,14,100)
#define ICH_LIBAVFILTER_4_0 AV_VERSION_INT(7,16,100)

/* ffmpeg 4.1 */
#define ICH_LIBAVCODEC_4_1 AV_VERSION_INT(58,35,100)
#define ICH_LIBAVFORMAT_4_1 AV_VERSION_INT(58,20,100)
#define ICH_LIBAVUTIL_4_1 AV_VERSION_INT(56,22,100)
#define ICH_LIBAVFILTER_4_1 AV_VERSION_INT(7,40,101)

/* ffmpeg 4.2 */
#define ICH_LIBAVCODEC_4_2 AV_VERSION_INT(58,54,100)
#define ICH_LIBAVFORMAT_4_2 AV_VERSION_INT(58,29,100)
#define ICH_LIBAVUTIL_4_2 AV_VERSION_INT(56,31,100)
#define ICH_LIBAVFILTER_4_2 AV_VERSION_INT(7,57,100)

/* ffmpeg 4.3 */
#define ICH_LIBAVCODEC_4_3 AV_VERSION_INT(58,91,100)
#define ICH_LIBAVFORMAT_4_3 AV_VERSION_INT(58,45,100)
#define ICH_LIBAVUTIL_4_3 AV_VERSION_INT(56,51,100)
#define ICH_LIBAVFILTER_4_3 AV_VERSION_INT(7,85,100)

/* ffmpeg 4.4 */
#define ICH_LIBAVCODEC_4_4 AV_VERSION_INT(58,134,100)
#define ICH_LIBAVFORMAT_4_4 AV_VERSION_INT(58,76,100)
#define ICH_LIBAVUTIL_4_4 AV_VERSION_INT(56,70,100)
#define ICH_LIBAVFILTER_4_4 AV_VERSION_INT(7,110,100)

/* ffmpeg 5.0 */
#define ICH_LIBAVCODEC_5_0 AV_VERSION_INT(59,18,100)
#define ICH_LIBAVFORMAT_5_0 AV_VERSION_INT(59,16,100)
#define ICH_LIBAVUTIL_5_0 AV_VERSION_INT(57,17,100)
#define ICH_LIBAVFILTER_5_0 AV_VERSION_INT(8,24,100)

/* ffmpeg 5.1 */
#define ICH_LIBAVCODEC_5_1 AV_VERSION_INT(59,37,100)
#define ICH_LIBAVFORMAT_5_1 AV_VERSION_INT(59,27,100)
#define ICH_LIBAVUTIL_5_1 AV_VERSION_INT(57,28,100)
#define ICH_LIBAVFILTER_5_1 AV_VERSION_INT(8,44,100)

/* ffmpeg 6.0 */
#define ICH_LIBAVCODEC_6_0 AV_VERSION_INT(60,3,100)
#define ICH_LIBAVFORMAT_6_0 AV_VERSION_INT(60,3,100)
#define ICH_LIBAVUTIL_6_0 AV_VERSION_INT(58,2,100)
#define ICH_LIBAVFILTER_6_0 AV_VERSION_INT(9,3,100)

/* ffmpeg 6.1 */
#define ICH_LIBAVCODEC_6_1 AV_VERSION_INT(60,31,102)
#define ICH_LIBAVFORMAT_6_1 AV_VERSION_INT(60,16,100)
#define ICH_LIBAVUTIL_6_1 AV_VERSION_INT(58,29,100)
#define ICH_LIBAVFILTER_6_1 AV_VERSION_INT(9,12,100)

/* ffmpeg 7.0 */
#define ICH_LIBAVCODEC_7_0 AV_VERSION_INT(61,3,100)
#define ICH_LIBAVFORMAT_7_0 AV_VERSION_INT(61,1,100)
#define ICH_LIBAVUTIL_7_0 AV_VERSION_INT(59,8,100)
#define ICH_LIBAVFILTER_7_0 AV_VERSION_INT(10,1,100)

/* ffmpeg 7.1 */
#define ICH_LIBAVCODEC_7_1 AV_VERSION_INT(61,19,100)
#define ICH_LIBAVFORMAT_7_1 AV_VERSION_INT(61,7,100)
#define ICH_LIBAVUTIL_7_1 AV_VERSION_INT(59,39,100)
#define ICH_LIBAVFILTER_7_1 AV_VERSION_INT(10,4,100)

/* now for feature detection */

/* AVCODEC FEATURES */

/* if we need to include bsf.h for bitstream filters */
#define ICH_AVCODEC_BSFH (LIBAVCODEC_VERSION_INT >= ICH_LIBAVCODEC_4_3)

/* whether we need to use the old AVBitStreamFilterContext or new AVBSFContext */
#define ICH_AVCODEC_AVBISTREAMFILTERCONTEXT (LIBAVCODEC_VERSION_INT <= ICH_LIBAVCODEC_3_0)
#define ICH_AVCODEC_AVBSFCONTEXT (LIBAVCODEC_VERSION_INT >= ICH_LIBAVCODEC_3_1)

/* whether we have av_bsf_get_null_filter */
#define ICH_AVCODEC_GET_NULL_FILTER (LIBAVCODEC_VERSION_INT >= ICH_LIBAVCODEC_3_2)

/* whether we have bitstream filter list support */
#define ICH_AVCODEC_AVBSFLIST (LIBAVCODEC_VERSION_INT >= ICH_LIBAVCODEC_3_2)

/* do we have av_bsf_send_packet (else we use av_bitstream_filter_filter) */
#define ICH_AVCODEC_BSF_SEND_PACKET (LIBAVCODEC_VERSION_INT >= ICH_LIBAVCODEC_3_1)

/* do we have av_bsf_init (meaning we need to call av_bsf_get_by_name, av_bsf_alloc, etc),
 * else we use av_bitstream_filter_init and av_bitstream_filter_close */
#define ICH_AVCODEC_BSF_INIT (LIBAVCODEC_VERSION_INT >= ICH_LIBAVCODEC_3_1)

/* do we have av_bsf_flush, else we just... don't flush I guess? */
#define ICH_AVCODEC_BSF_FLUSH (LIBAVCODEC_VERSION_INT >= ICH_LIBAVCODEC_4_1)

/* whether we have av_packet_alloc/av_packet_free (else we allocate however and call av_packet_init) */
#define ICH_AVCODEC_PACKETALLOC (LIBAVCODEC_VERSION_INT >= ICH_LIBAVCODEC_3_0)

#define ICH_AVCODEC_PACKET_MAKE_WRITABLE (LIBAVCODEC_VERSION_INT >= ICH_LIBAVCODEC_4_0)

#define ICH_AVCODEC_PACKET_HAS_TIME_BASE (LIBAVCODEC_VERSION_INT >= ICH_LIBAVCODEC_5_0)

#define ICH_AVCODEC_REGISTER_ALL (LIBAVCODEC_VERSION_INT < ICH_LIBAVCODEC_4_0)

#define ICH_AVCODEC_CTX_HAS_TRAILING_PADDING (LIBAVCODEC_VERSION_INT >= ICH_LIBAVCODEC_3_2)

#define ICH_AVCODEC_CTX_HAS_CH_LAYOUT (LIBAVCODEC_VERSION_INT >= ICH_LIBAVCODEC_5_1)

#define ICH_AVCODEC_CODECPARAMETERS (LIBAVCODEC_VERSION_INT >= ICH_LIBAVCODEC_3_1)

#define ICH_AVCODEC_SENDPACKET (LIBAVCODEC_VERSION_INT >= ICH_LIBAVCODEC_3_1)

#define ICH_AVCODEC_CONVERGENCE (LIBAVCODEC_VERSION_INT < ICH_LIBAVCODEC_3_0)

#define ICH_AVCODEC_SAMPLE_FMTS (LIBAVCODEC_VERSION_INT < ICH_LIBAVCODEC_7_1)

/* AVFORMAT FEATURES */

/* if av_find_best_stream expects a const AVCodec ** */
#define ICH_AVFORMAT_FIND_BEST_STREAM_CONST (LIBAVFORMAT_VERSION_INT >= ICH_LIBAVFORMAT_5_0)

/* if we need to call av_register_all (deprecated in 4.0) */
#define ICH_AVFORMAT_REGISTER_ALL (LIBAVFORMAT_VERSION_INT < ICH_LIBAVFORMAT_4_0)

/* if an AVStream has a codecpar attribute */
#define ICH_AVFORMAT_STREAM_CODECPAR (LIBAVFORMAT_VERSION_INT >= ICH_LIBAVFORMAT_3_1)

/* AVUTIL FEATURES */

/* if we have AVChannelLayout */
#define ICH_AVUTIL_CHANNEL_LAYOUT (LIBAVUTIL_VERSION_INT >= ICH_LIBAVUTIL_5_1)

/* if we have S64 sample formats */
#define ICH_AVUTIL_SAMPLE_FMT_S64 (LIBAVUTIL_VERSION_INT >= ICH_LIBAVUTIL_3_2)

#define ICH_AVUTIL_FRAME_HAS_TIME_BASE (LIBAVUTIL_VERSION_INT >= ICH_LIBAVUTIL_5_0)

/* if av_dict_copy returns int */
#define ICH_AVUTIL_DICT_COPY_INT (LIBAVUTIL_VERSION_INT >= ICH_LIBAVUTIL_3_0)

/* AVFILTER FEATURES */

/* if we need to call av_filter_register_all() */
#define ICH_AVFILTER_REGISTER_ALL (LIBAVFILTER_VERSION_INT < ICH_LIBAVFILTER_4_0)

/* if buffersink_get_* functions exist */
#define ICH_AVFILTER_BUFFERSINK_GET (LIBAVFILTER_VERSION_INT >= ICH_LIBAVFILTER_3_3)

/* if buffersrc_close exists */
#define ICH_AVFILTER_BUFFERSRC_CLOSE (LIBAVFILTER_VERSION_INT >= ICH_LIBAVFILTER_3_4)
