/*
 * Decompiled with CFR 0.152.
 */
package additionaluserinterface;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.Timer;

public class Settings {
    private String filename;
    private String project;
    private ArrayList<Item> items;
    private Properties props;

    public Settings(String project, String filename) {
        this.filename = filename;
        this.project = project;
        this.items = new ArrayList();
        this.props = new Properties();
    }

    public void record(String key, JTextField component, String defaultValue) {
        Item item = new Item(key, component, defaultValue);
        this.items.add(item);
    }

    public void record(String key, JComboBox component, String defaultValue) {
        Item item = new Item(key, component, defaultValue);
        this.items.add(item);
    }

    public void record(String key, JSpinner component, String defaultValue) {
        Item item = new Item(key, component, defaultValue);
        this.items.add(item);
    }

    public void record(String key, JToggleButton component, boolean defaultValue) {
        Item item = new Item(key, component, defaultValue ? "on" : "off");
        this.items.add(item);
    }

    public void record(String key, JCheckBox component, boolean defaultValue) {
        Item item = new Item(key, component, defaultValue ? "on" : "off");
        this.items.add(item);
    }

    public void record(String key, JSlider component, String defaultValue) {
        Item item = new Item(key, component, defaultValue);
        this.items.add(item);
    }

    public String loadValue(String key, String defaultValue) {
        String s = "";
        try {
            FileInputStream in = new FileInputStream(this.filename);
            this.props.load(in);
            s = this.props.getProperty(key, defaultValue);
        }
        catch (Exception e) {
            s = defaultValue;
        }
        return s;
    }

    public double loadValue(String key, double defaultValue) {
        double d = 0.0;
        try {
            FileInputStream in = new FileInputStream(this.filename);
            this.props.load(in);
            String value = this.props.getProperty(key, "" + defaultValue);
            d = new Double(value);
        }
        catch (Exception e) {
            d = defaultValue;
        }
        return d;
    }

    public int loadValue(String key, int defaultValue) {
        int i = 0;
        try {
            FileInputStream in = new FileInputStream(this.filename);
            this.props.load(in);
            String value = this.props.getProperty(key, "" + defaultValue);
            i = new Integer(value);
        }
        catch (Exception e) {
            i = defaultValue;
        }
        return i;
    }

    public boolean loadValue(String key, boolean defaultValue) {
        boolean b = false;
        try {
            FileInputStream in = new FileInputStream(this.filename);
            this.props.load(in);
            String value = this.props.getProperty(key, "" + defaultValue);
            b = new Boolean(value);
        }
        catch (Exception e) {
            b = defaultValue;
        }
        return b;
    }

    public void storeValue(String key, String value) {
        this.props.setProperty(key, value);
        try {
            FileOutputStream out = new FileOutputStream(this.filename);
            this.props.store(out, this.project);
        }
        catch (Exception e) {
            new Msg(this.project, "Impossible to store settings in (" + this.filename + ")");
        }
    }

    public void storeValue(String key, double value) {
        this.props.setProperty(key, "" + value);
        try {
            FileOutputStream out = new FileOutputStream(this.filename);
            this.props.store(out, this.project);
        }
        catch (Exception e) {
            new Msg(this.project, "Impossible to store settings in (" + this.filename + ")");
        }
    }

    public void storeValue(String key, int value) {
        this.props.setProperty(key, "" + value);
        try {
            FileOutputStream out = new FileOutputStream(this.filename);
            this.props.store(out, this.project);
        }
        catch (Exception e) {
            new Msg(this.project, "Impossible to store settings in (" + this.filename + ")");
        }
    }

    public void storeValue(String key, boolean value) {
        this.props.setProperty(key, "" + value);
        try {
            FileOutputStream out = new FileOutputStream(this.filename);
            this.props.store(out, this.project);
        }
        catch (Exception e) {
            new Msg(this.project, "Impossible to store settings in (" + this.filename + ")");
        }
    }

    public void loadRecordedItems() {
        this.loadRecordedItems(this.filename);
    }

    public void loadRecordedItems(String fname) {
        try {
            FileInputStream in = new FileInputStream(fname);
            this.props.load(in);
        }
        catch (Exception e) {
            new Msg(this.project, "Loading default value. No settings file (" + fname + ")");
        }
        int i = 0;
        while (i < this.items.size()) {
            Item item = this.items.get(i);
            String value = this.props.getProperty(item.key, item.defaultValue);
            if (item.component instanceof JTextField) {
                ((JTextField)item.component).setText(value);
            } else if (item.component instanceof JComboBox) {
                ((JComboBox)item.component).setSelectedItem(value);
            } else if (item.component instanceof JCheckBox) {
                ((JCheckBox)item.component).setSelected(value.equals("on"));
            } else if (item.component instanceof JToggleButton) {
                ((JToggleButton)item.component).setSelected(value.equals("on"));
            } else if (item.component instanceof JSpinner) {
                ((JSpinner)item.component).setValue((double)new Double(value));
            } else if (item.component instanceof JSlider) {
                ((JSlider)item.component).setValue(new Integer(value));
            }
            ++i;
        }
    }

    public void storeRecordedItems() {
        this.storeRecordedItems(this.filename);
    }

    public void storeRecordedItems(String fname) {
        int i = 0;
        while (i < this.items.size()) {
            String value;
            Item item = this.items.get(i);
            if (item.component instanceof JTextField) {
                value = ((JTextField)item.component).getText();
                this.props.setProperty(item.key, value);
            } else if (item.component instanceof JComboBox) {
                value = (String)((JComboBox)item.component).getSelectedItem();
                this.props.setProperty(item.key, value);
            } else if (item.component instanceof JCheckBox) {
                value = ((JCheckBox)item.component).isSelected() ? "on" : "off";
                this.props.setProperty(item.key, value);
            } else if (item.component instanceof JToggleButton) {
                value = ((JToggleButton)item.component).isSelected() ? "on" : "off";
                this.props.setProperty(item.key, value);
            } else if (item.component instanceof JSpinner) {
                value = "" + ((JSpinner)item.component).getValue();
                this.props.setProperty(item.key, value);
            } else if (item.component instanceof JSlider) {
                value = "" + ((JSlider)item.component).getValue();
                this.props.setProperty(item.key, value);
            }
            ++i;
        }
        try {
            FileOutputStream out = new FileOutputStream(fname);
            this.props.store(out, this.project);
        }
        catch (Exception e) {
            new Msg(this.project, "Impossible to store settings in (" + fname + ")");
        }
    }

    private class DelayListener
    implements ActionListener {
        private Msg msg;

        public DelayListener(Msg msg) {
            this.msg = msg;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.msg.dispose();
        }
    }

    private class Item {
        public Object component;
        public String defaultValue;
        public String key;

        public Item(String key, Object component, String defaultValue) {
            this.component = component;
            this.defaultValue = defaultValue;
            this.key = key;
        }
    }

    private class Msg
    extends JFrame {
        public Msg(String project, String msg) {
            super(project);
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            Container contentPane = this.getContentPane();
            contentPane.setLayout(layout);
            constraints.weightx = 0.0;
            constraints.weighty = 1.0;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.insets = new Insets(10, 10, 10, 10);
            constraints.anchor = 10;
            JLabel newLabel = new JLabel(msg);
            layout.setConstraints(newLabel, constraints);
            contentPane.add(newLabel);
            this.setResizable(false);
            this.pack();
            this.setVisible(true);
            Dimension dim = this.getToolkit().getScreenSize();
            Rectangle abounds = this.getBounds();
            this.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
            Timer timer = new Timer(1000, new DelayListener(this));
            timer.start();
        }
    }
}

