/*
 * Decompiled with CFR 0.152.
 */
package additionaluserinterface;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.text.DefaultCaret;

public class WalkBar
extends JToolBar
implements ActionListener {
    private JProgressBar progress = new JProgressBar();
    private JButton bnHelp = new JButton("Help");
    private JButton bnAbout = new JButton("About");
    private JButton bnClose = new JButton("Close");
    private String[] about = new String[]{"About", "Version", "Description", "Author", "Biomedical Image Group", "2008", "http://bigwww.epfl.ch"};
    private String help;
    private double chrono;
    private int xSizeAbout = 400;
    private int ySizeAbout = 400;
    private int xSizeHelp = 400;
    private int ySizeHelp = 400;

    public WalkBar(String initialMessage, boolean isAbout, boolean isHelp, boolean isClose) {
        super("Walk Bar");
        this.build(initialMessage, isAbout, isHelp, isClose, 100);
    }

    public WalkBar(String initialMessage, boolean isAbout, boolean isHelp, boolean isClose, int size) {
        super("Walk Bar");
        this.build(initialMessage, isAbout, isHelp, isClose, size);
    }

    private void build(String initialMessage, boolean isAbout, boolean isHelp, boolean isClose, int size) {
        if (isAbout) {
            this.add(this.bnAbout);
        }
        if (isHelp) {
            this.add(this.bnHelp);
        }
        this.addSeparator();
        this.add(this.progress);
        this.addSeparator();
        if (isClose) {
            this.add(this.bnClose);
        }
        this.progress.setStringPainted(true);
        this.progress.setString(initialMessage);
        this.progress.setFont(new Font("Arial", 0, 10));
        this.progress.setMinimum(0);
        this.progress.setMaximum(100);
        this.progress.setPreferredSize(new Dimension(size, 20));
        this.bnAbout.addActionListener(this);
        this.bnHelp.addActionListener(this);
        this.setFloatable(false);
        this.setRollover(true);
        this.setBorderPainted(false);
        this.chrono = System.currentTimeMillis();
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bnHelp) {
            this.showHelp();
        } else if (e.getSource() == this.bnAbout) {
            this.showAbout();
        } else {
            e.getSource();
        }
    }

    public JButton getButtonClose() {
        return this.bnClose;
    }

    public void setValue(int value) {
        this.progress.setValue(value);
    }

    public void setMessage(String msg) {
        this.progress.setString(msg);
    }

    public void progress(String msg, int value) {
        this.progress.setValue(value);
        double elapsedTime = (double)System.currentTimeMillis() - this.chrono;
        String t = " [" + (elapsedTime > 3000.0 ? String.valueOf((double)Math.round(elapsedTime / 10.0) / 100.0) + "s." : String.valueOf(elapsedTime) + "ms") + "]";
        this.progress.setString(String.valueOf(msg) + t);
    }

    public void progress(String msg, double value) {
        this.progress(msg, (int)Math.round(value));
    }

    public void reset() {
        this.chrono = System.currentTimeMillis();
        this.progress.setValue(0);
        this.progress.setString("Starting ...");
    }

    public void finish() {
        this.progress("Terminated", 100);
    }

    public void finish(String msg) {
        this.progress(msg, 100);
    }

    public void fillAbout(String name, String version, String description, String author, String organisation, String date, String info) {
        this.about[0] = name;
        this.about[1] = version;
        this.about[2] = description;
        this.about[3] = author;
        this.about[4] = organisation;
        this.about[5] = date;
        this.about[6] = info;
    }

    public void fillHelp(String help) {
        this.help = help;
    }

    public void showAbout() {
        final JFrame frame = new JFrame("About " + this.about[0]);
        JEditorPane pane = new JEditorPane();
        pane.setEditable(false);
        pane.setContentType("text/html; charset=ISO-8859-1");
        pane.setText("<html><head><title>" + this.about[0] + "</title>" + this.getStyle() + "</head><body>" + (this.about[0] == "" ? "" : "<p class=\"name\">" + this.about[0] + "</p>") + (this.about[1] == "" ? "" : "<p class=\"vers\">" + this.about[1] + "</p>") + (this.about[2] == "" ? "" : "<p class=\"desc\">" + this.about[2] + "</p><hr>") + (this.about[3] == "" ? "" : "<p class=\"auth\">" + this.about[3] + "</p>") + (this.about[4] == "" ? "" : "<p class=\"orga\">" + this.about[4] + "</p>") + (this.about[5] == "" ? "" : "<p class=\"date\">" + this.about[5] + "</p>") + (this.about[6] == "" ? "" : "<p class=\"more\">" + this.about[6] + "</p>") + "</html>");
        JButton bnClose = new JButton("Close");
        bnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });
        pane.setCaret(new DefaultCaret());
        JScrollPane scrollPane = new JScrollPane(pane);
        scrollPane.setPreferredSize(new Dimension(this.xSizeAbout, this.ySizeAbout));
        frame.getContentPane().add((Component)scrollPane, "North");
        frame.getContentPane().add((Component)bnClose, "Center");
        frame.pack();
        frame.setResizable(false);
        frame.setVisible(true);
        this.center(frame);
    }

    public void showHelp() {
        final JFrame frame = new JFrame("Help " + this.about[0]);
        JEditorPane pane = new JEditorPane();
        pane.setEditable(false);
        pane.setContentType("text/html; charset=ISO-8859-1");
        pane.setText("<html><head><title>" + this.about[0] + "</title>" + this.getStyle() + "</head><body>" + (this.about[0] == "" ? "" : "<p class=\"name\">" + this.about[0] + "</p>") + (this.about[1] == "" ? "" : "<p class=\"vers\">" + this.about[1] + "</p>") + (this.about[2] == "" ? "" : "<p class=\"desc\">" + this.about[2] + "</p>") + "<hr><p class=\"help\">" + this.help + "</p>" + "</html>");
        JButton bnClose = new JButton("Close");
        bnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });
        pane.setCaret(new DefaultCaret());
        JScrollPane scrollPane = new JScrollPane(pane);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setPreferredSize(new Dimension(this.xSizeHelp, this.ySizeHelp));
        frame.setPreferredSize(new Dimension(this.xSizeHelp, this.ySizeHelp));
        frame.getContentPane().add((Component)scrollPane, "Center");
        frame.getContentPane().add((Component)bnClose, "South");
        frame.setVisible(true);
        frame.pack();
        this.center(frame);
    }

    private void center(Window w) {
        Dimension screenSize = new Dimension(0, 0);
        boolean isWin = System.getProperty("os.name").startsWith("Windows");
        if (isWin) {
            screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        if (GraphicsEnvironment.isHeadless()) {
            screenSize = new Dimension(0, 0);
        } else {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gd = ge.getScreenDevices();
            GraphicsConfiguration[] gc = gd[0].getConfigurations();
            Rectangle bounds = gc[0].getBounds();
            screenSize = bounds.x == 0 && bounds.y == 0 ? new Dimension(bounds.width, bounds.height) : Toolkit.getDefaultToolkit().getScreenSize();
        }
        Dimension window = w.getSize();
        if (window.width == 0) {
            return;
        }
        int left = screenSize.width / 2 - window.width / 2;
        int top = (screenSize.height - window.height) / 4;
        if (top < 0) {
            top = 0;
        }
        w.setLocation(left, top);
    }

    private String getStyle() {
        return "<style type=text/css>body {backgroud-color:#222277}hr {width:80% color:#333366; padding-top:7px }p, li {margin-left:10px;margin-right:10px; color:#000000; font-size:1em; font-family:Verdana,Helvetica,Arial,Geneva,Swiss,SunSans-Regular,sans-serif}p.name {color:#ffffff; font-size:1.2em; font-weight: bold; background-color: #333366; text-align:center;}p.vers {color:#333333; text-align:center;}p.desc {color:#333333; font-weight: bold; text-align:center;}p.auth {color:#333333; font-style: italic; text-align:center;}p.orga {color:#333333; text-align:center;}p.date {color:#333333; text-align:center;}p.more {color:#333333; text-align:center;}p.help {color:#000000; text-align:left;}</style>";
    }
}

