/*
 * Decompiled with CFR 0.152.
 */
package smlms;

import additionaluserinterface.WalkBar;
import java.util.ArrayList;
import java.util.Collections;
import smlms.CompareLocalization3DDialog;
import smlms.Fluorophore;
import smlms.FluorophorePair;
import smlms.FluorophorePairs;
import smlms.Fluorophores;
import smlms.Wobble;
import smlms.hungarian.MaximumWeightedMatching;
import smlms.hungarian.WeightedEdge;

public class CompareLocalization3D {
    public static final int ALGO_GLOBAL_SORT_NEAREST_NEIGHBORHOOR = 0;
    public static final int ALGO_NEAREST_NEIGHBORHOOR = 1;
    public static final int ALGO_HUNGARIAN = 2;
    private Fluorophores[] setRef;
    private String nameRef = "";

    public static void main(String[] args) {
        new CompareLocalization3DDialog();
    }

    public CompareLocalization3D(String nameRef, Fluorophores[] setRef) {
        this.nameRef = nameRef;
        this.setRef = setRef;
    }

    public String[] run(WalkBar walk, String nameTest, Fluorophores[] setTest, int num, String dataset, int algo, boolean dim3D, Wobble wobble, double minPhotons, double toleranceXY, double toleranceZ) {
        walk.reset();
        int nbframes = Math.min(this.setRef.length, setTest.length);
        double time = System.nanoTime();
        int intersection = 0;
        int union = 0;
        double rmseLateral = 0.0;
        double rmseAxial = 0.0;
        double jaccard = 0.0;
        double fscore = 0.0;
        double deltaX = 0.0;
        double deltaY = 0.0;
        double deltaZ = 0.0;
        double mdIntensity = 0.0;
        int ntest = 0;
        int nref = 0;
        int f2 = nbframes;
        int f = 0;
        while (f < nbframes) {
            walk.progress("Frame " + f, 100.0 * (double)f / (double)f2);
            Fluorophores ref = Fluorophores.correctionWooble(wobble, this.setRef[f]);
            Fluorophores test = setTest[f];
            ntest += test.size();
            nref += ref.size();
            int i = 0;
            while (i < ref.size()) {
                ((Fluorophore)ref.get((int)i)).matching = false;
                ++i;
            }
            i = 0;
            while (i < test.size()) {
                ((Fluorophore)test.get((int)i)).matching = false;
                ++i;
            }
            double tz = toleranceZ;
            if (!dim3D) {
                tz = Double.MAX_VALUE;
            }
            FluorophorePairs pairs = new FluorophorePairs();
            switch (algo) {
                case 1: {
                    pairs = this.matchNNAlgo(ref, test, dim3D, minPhotons, toleranceXY, tz, false);
                    break;
                }
                case 2: {
                    pairs = this.matchHungarianAlgo(ref, test, dim3D, minPhotons, toleranceXY, tz);
                    break;
                }
                case 0: {
                    pairs = this.matchNNAlgo(ref, test, dim3D, minPhotons, toleranceXY, tz, true);
                }
            }
            int i2 = 0;
            while (i2 < pairs.size()) {
                FluorophorePair pair = (FluorophorePair)pairs.get(i2);
                ++intersection;
                deltaX += pair.ref.deltaX(pair.test);
                deltaY += pair.ref.deltaY(pair.test);
                deltaZ += pair.ref.deltaZ(pair.test);
                mdIntensity += pair.ref.differenceIntensity(pair.test);
                rmseLateral += pair.ref.distanceLateral(pair.test) * pair.ref.distanceLateral(pair.test);
                rmseAxial += pair.ref.distanceAxial(pair.test) * pair.ref.distanceAxial(pair.test);
                ++i2;
            }
            ++f;
        }
        time = ((double)System.nanoTime() - time) * 1.0E-8;
        int TP = intersection;
        double FP = ntest - TP;
        double FN = nref - TP;
        double precision = (double)TP / ((double)TP + FP);
        double recall = (double)TP / ((double)TP + FN);
        union = nref + ntest - intersection;
        if (intersection > 0) {
            deltaX /= (double)intersection;
            deltaY /= (double)intersection;
            deltaZ /= (double)intersection;
            mdIntensity /= (double)intersection;
            rmseLateral = Math.sqrt(rmseLateral / (double)intersection);
            rmseAxial = Math.sqrt(rmseAxial / (double)intersection);
            jaccard = 100.0 * (double)intersection / (double)union;
            fscore = 2.0 * (precision * recall) / (precision + recall);
        }
        String[] results = new String[24];
        int i = 0;
        results[i++] = "" + num;
        results[i++] = dataset;
        results[i++] = algo == 0 ? "GS-NN" : (algo == 1 ? "NN" : "Hungarian");
        results[i++] = "" + toleranceXY;
        results[i++] = "" + toleranceZ;
        results[i++] = String.format("%3.3f", time);
        results[i++] = this.nameRef;
        results[i++] = "" + nref;
        results[i++] = nameTest;
        results[i++] = "" + ntest;
        results[i++] = dim3D ? "XYZ (cylinder)" : "XY (disk)";
        results[i++] = wobble == null ? "NO" : wobble.getName();
        results[i++] = "" + minPhotons;
        results[i++] = "" + intersection;
        results[i++] = String.format("%3.3f", jaccard);
        results[i++] = String.format("%3.3f", fscore);
        results[i++] = String.format("%3.3f", precision);
        results[i++] = String.format("%3.3f", recall);
        results[i++] = String.format("%3.3f", rmseLateral);
        results[i++] = dim3D ? String.format("%3.3f", rmseAxial) : "";
        results[i++] = String.format("%3.3f", deltaX);
        results[i++] = String.format("%3.3f", deltaY);
        results[i++] = dim3D ? String.format("%3.3f", deltaZ) : "";
        results[i++] = String.format("%3.3f", mdIntensity);
        return results;
    }

    public static String[] getHeaders() {
        String[] results = new String[24];
        int i = 0;
        results[i++] = "ID";
        results[i++] = "Dataset";
        results[i++] = "Algorithm";
        results[i++] = "Tolerance XY";
        results[i++] = "Tolerance Z";
        results[i++] = "Time";
        results[i++] = "Reference";
        results[i++] = "# fluos";
        results[i++] = "Test";
        results[i++] = "# fluos";
        results[i++] = "Evaluation";
        results[i++] = "Wooble";
        results[i++] = "Min. Photons in Ref";
        results[i++] = "Intersection";
        results[i++] = "Jaccard";
        results[i++] = "Fscore";
        results[i++] = "Precision";
        results[i++] = "Recall";
        results[i++] = "RMSE Lateral";
        results[i++] = "RMSE Axial";
        results[i++] = "DeltaX";
        results[i++] = "DeltaY";
        results[i++] = "DeltaZ";
        results[i++] = "md Intensity";
        return results;
    }

    private FluorophorePairs matchNNAlgo(Fluorophores ref, Fluorophores test, boolean dim3D, double minPhotons, double toleranceXY, double toleranceZ, boolean globalSort) {
        ArrayList<FluorophorePair> candidates = new ArrayList<FluorophorePair>();
        int i = 0;
        while (i < ref.size()) {
            Fluorophore a = (Fluorophore)ref.get(i);
            if (a.getPhotons() >= minPhotons) {
                int j = 0;
                while (j < test.size()) {
                    Fluorophore b = (Fluorophore)test.get(j);
                    double dxy = a.distanceLateral(b);
                    double dz = a.distanceAxial(b);
                    if (dxy <= toleranceXY && dz <= toleranceZ) {
                        candidates.add(new FluorophorePair(a, b, dim3D ? a.distance(b) : dxy));
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (globalSort) {
            Collections.sort(candidates);
        }
        FluorophorePairs pairsFrame = new FluorophorePairs();
        int i2 = 0;
        while (i2 < candidates.size()) {
            FluorophorePair pair = (FluorophorePair)candidates.get(i2);
            if (!pair.ref.matching && !pair.test.matching) {
                pair.ref.matching = true;
                pair.test.matching = true;
                pairsFrame.add(pair);
            }
            ++i2;
        }
        return pairsFrame;
    }

    private FluorophorePairs matchHungarianAlgo(Fluorophores ref, Fluorophores test, boolean dim3D, double minPhotons, double toleranceXY, double toleranceZ) {
        int M = ref.size();
        int N = test.size();
        ArrayList<WeightedEdge> graph = new ArrayList<WeightedEdge>();
        int i = 0;
        while (i < M) {
            Fluorophore a = (Fluorophore)ref.get(i);
            if (a.getPhotons() >= minPhotons) {
                int j = 0;
                while (j < N) {
                    Fluorophore b = (Fluorophore)test.get(j);
                    double dxy = a.distanceLateral(b);
                    double dz = a.distanceAxial(b);
                    if (dxy <= toleranceXY && dz <= toleranceZ) {
                        graph.add(new WeightedEdge(i, M + j, dim3D ? -a.distance(b) : -dxy));
                    }
                    ++j;
                }
            }
            ++i;
        }
        FluorophorePairs pairsFrame = new FluorophorePairs();
        MaximumWeightedMatching maximumWeightedMatching = new MaximumWeightedMatching(graph, M, N);
        ArrayList<WeightedEdge> matching = maximumWeightedMatching.getMaximumWeightMatching();
        int i2 = 0;
        while (i2 < matching.size()) {
            Fluorophore r = (Fluorophore)ref.get(matching.get((int)i2).source);
            Fluorophore d = (Fluorophore)test.get(matching.get((int)i2).destination - M);
            FluorophorePair pair = new FluorophorePair(r, d, dim3D ? r.distance(d) : r.distanceLateral(d));
            pairsFrame.add(pair);
            ++i2;
        }
        return pairsFrame;
    }
}

