/*
 * Decompiled with CFR 0.152.
 */
package smlms;

import additionaluserinterface.WalkBar;
import java.io.File;
import java.util.ArrayList;
import smlms.CompareLocalization3D;
import smlms.CompareTable;
import smlms.Description;
import smlms.Fluorophore;
import smlms.Fluorophores;
import smlms.LocalizationFile;
import smlms.Wobble;

public class CompareLocalization3DBatch {
    private double border = 320.0;
    private double toleranceXY = 320.0;
    private double toleranceZ = 320.0;
    private int algo = 0;
    private String woobleFilename = " ";
    private int nx = 6400;
    private int ny = 6400;
    private WalkBar walk = new WalkBar("(c) Biomedical Imaging Group, EPFL 2016", false, false, false);

    public static void main(String[] args) {
        new CompareLocalization3DBatch();
    }

    public CompareLocalization3DBatch() {
        String[] files;
        String[] softs = new String[]{"QuickPALM", "ThunderSTORM"};
        String path = "/Users/sage/Desktop/test-final/";
        ArrayList<String> datasets = new ArrayList<String>();
        String[] stringArray = files = new File(String.valueOf(path) + "/Reference/").list();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (file.endsWith(".csv")) {
                datasets.add(file.substring(0, file.length() - 4));
            }
            ++n2;
        }
        ArrayList<String[]> results = new ArrayList<String[]>();
        results.add(CompareLocalization3D.getHeaders());
        for (String dataset : datasets) {
            String fileRef = String.valueOf(path) + "/Reference/" + dataset + ".csv";
            System.out.println("\n" + dataset);
            if (!new File(fileRef).exists()) continue;
            String[] stringArray2 = softs;
            int n3 = softs.length;
            int n4 = 0;
            while (n4 < n3) {
                String[] filesTest;
                String soft = stringArray2[n4];
                String pathSoft = String.valueOf(path) + soft + File.separator;
                if (new File(pathSoft).exists() && (filesTest = new File(pathSoft).list()) != null) {
                    String[] stringArray3 = filesTest;
                    int n5 = filesTest.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String fileTest = stringArray3[n6];
                        if (fileTest.contains(dataset)) {
                            this.compare(dataset, fileRef, fileTest, results);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
        }
        CompareTable table = new CompareTable(results, CompareLocalization3D.getHeaders(), false);
        table.show(1200, 200, "Compare");
        this.walk.finish("End");
    }

    private void compare(String dataset, String fileRef, String fileTest, ArrayList<String[]> results) {
        System.out.println(String.valueOf(dataset) + " " + fileRef + "\t vs. \t" + fileTest);
        Wobble wobble = new Wobble(this.woobleFilename);
        Description desca = new Description("Ground-truth", 2, 3, 4, 1, 5, 1.0, 1.0);
        Fluorophores[] ar = new LocalizationFile().read(desca, fileRef);
        Fluorophores[] a = Fluorophores.crop(ar, this.border, (double)this.nx - this.border, this.border, (double)this.ny - this.border);
        Description descb = null;
        if (fileTest.contains("ThunderSTORM")) {
            descb = new Description("ThunderSTORM", 2, 3, 4, 1, 7, 1.0, 1.0);
        }
        if (fileTest.contains("EasyDH")) {
            descb = new Description("EasyDH", 2, 3, 4, 1, 7, 1.0, 1.0);
        }
        if (fileTest.contains("QuickPALM")) {
            descb = new Description("QuickPALM", 2, 3, 4, 1, 7, 1.0, 1.0);
        }
        if (descb == null) {
            System.out.println("No description for " + fileTest);
            return;
        }
        Fluorophores[] b = new LocalizationFile().read(descb, fileTest);
        for (Fluorophore fluo : b[1]) {
            System.out.println("Check Frame 0 " + fluo.toString());
        }
        this.compare2(dataset, wobble, desca, a, descb, b, results, 0.0);
    }

    private void compare2(String dataset, Wobble wobble, Description desca, Fluorophores[] a, Description descb, Fluorophores[] b, ArrayList<String[]> results, double minPhotons) {
        CompareLocalization3D comparator = new CompareLocalization3D(desca.name, a);
        String[] res1 = comparator.run(this.walk, descb.name, b, 1, dataset, this.algo, true, null, minPhotons, this.toleranceXY, this.toleranceZ);
        String[] res2 = comparator.run(this.walk, descb.name, b, 2, dataset, this.algo, false, null, minPhotons, this.toleranceXY, this.toleranceZ);
        results.add(res1);
        results.add(res2);
    }
}

