/*
 * Decompiled with CFR 0.152.
 */
package smlms;

import additionaluserinterface.GridPanel;
import additionaluserinterface.Settings;
import additionaluserinterface.SpinnerDouble;
import additionaluserinterface.SpinnerInteger;
import additionaluserinterface.WalkBar;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import smlms.CompareLocalization3D;
import smlms.CompareTable;
import smlms.Description;
import smlms.Fluorophore;
import smlms.Fluorophores;
import smlms.LocalizationFile;
import smlms.Wobble;

public class CompareLocalization3DDialog
extends JDialog
implements WindowListener,
ActionListener {
    private WalkBar walk = new WalkBar("(c) Biomedical Imaging Group, EPFL 2016", false, false, false);
    private String[] listUnit = new String[]{"pixel", "nm"};
    private Settings settings = new Settings("CompareLocalization", "CompareLocalizationSettings.txt");
    private JButton bnClose = new JButton("Close");
    private JButton bnCompare = new JButton("Run (8 assessments)");
    private JButton bnBrowseWobble = new JButton("Browse");
    private JButton[] bnBrowse = new JButton[]{new JButton("Browse"), new JButton("Browse")};
    private JButton[] bnLoad = new JButton[]{new JButton("Load"), new JButton("Load")};
    private JTextField[] txtFile = new JTextField[]{new JTextField("filename.csv"), new JTextField("filename.csv")};
    private JLabel[] lblFile = new JLabel[]{new JLabel("..."), new JLabel("...")};
    private SpinnerDouble[] shiftX = new SpinnerDouble[]{new SpinnerDouble(0.0, -1000000.0, 100000.0, 1.0), new SpinnerDouble(0.0, -1000000.0, 100000.0, 1.0)};
    private SpinnerDouble[] shiftY = new SpinnerDouble[]{new SpinnerDouble(0.0, -1000000.0, 100000.0, 1.0), new SpinnerDouble(0.0, -1000000.0, 100000.0, 1.0)};
    private SpinnerDouble[] shiftZ = new SpinnerDouble[]{new SpinnerDouble(0.0, -1000000.0, 100000.0, 1.0), new SpinnerDouble(0.0, -1000000.0, 100000.0, 1.0)};
    private SpinnerInteger[] shiftF = new SpinnerInteger[]{new SpinnerInteger(0, -1000000, 100000, 1), new SpinnerInteger(0, -1000000, 100000, 1)};
    private JComboBox[] cmbUnit = new JComboBox[]{new JComboBox<String>(this.listUnit), new JComboBox<String>(this.listUnit)};
    private SpinnerInteger[] colF = new SpinnerInteger[]{new SpinnerInteger(0, -1, 1000, 1), new SpinnerInteger(0, -10, 1000, 1)};
    private SpinnerInteger[] colX = new SpinnerInteger[]{new SpinnerInteger(0, -1, 1000, 1), new SpinnerInteger(0, -10, 1000, 1)};
    private SpinnerInteger[] colY = new SpinnerInteger[]{new SpinnerInteger(0, -1, 1000, 1), new SpinnerInteger(0, -10, 1000, 1)};
    private SpinnerInteger[] colZ = new SpinnerInteger[]{new SpinnerInteger(0, -1, 1000, 1), new SpinnerInteger(0, -10, 1000, 1)};
    private SpinnerInteger[] colI = new SpinnerInteger[]{new SpinnerInteger(0, -1, 1000, 1), new SpinnerInteger(0, -10, 1000, 1)};
    private SpinnerInteger[] firstRow = new SpinnerInteger[]{new SpinnerInteger(1, 0, 1000, 1), new SpinnerInteger(1, 0, 1000, 1)};
    private SpinnerDouble spnToleranceXY = new SpinnerDouble(10.0, 0.0, 10000.0, 10.0);
    private SpinnerDouble spnToleranceZ = new SpinnerDouble(10.0, 0.0, 10000.0, 10.0);
    private SpinnerDouble spnPixelsize = new SpinnerDouble(100.0, 0.0, 10000.0, 10.0);
    private SpinnerDouble spnZStep = new SpinnerDouble(10.0, 0.0, 10000.0, 10.0);
    private SpinnerDouble spnMinPhotons2 = new SpinnerDouble(1000.0, 0.0, 100000.0, 10.0);
    private SpinnerDouble spnFieldOfViewX = new SpinnerDouble(6400.0, 0.0, 100000.0, 10.0);
    private SpinnerDouble spnFieldOfViewY = new SpinnerDouble(6400.0, 0.0, 100000.0, 10.0);
    private SpinnerDouble spnBorderXY = new SpinnerDouble(300.0, 0.0, 10000.0, 10.0);
    private JLabel lblCorrectionX0 = new JLabel("----");
    private JLabel lblCorrectionY0 = new JLabel("----");
    private JTextField txtWooble = new JTextField("no", 10);
    private JTextField[] txtName = new JTextField[]{new JTextField("Ground-truth"), new JTextField("Untitled")};
    private JTextField txtDataset = new JTextField("Dataset name");

    public CompareLocalization3DDialog() {
        super(new Frame(), "Compare Localization 3D (29.06.2016)");
        this.walk.setPreferredSize(new Dimension(250, 20));
        int i = 0;
        while (i < 2) {
            this.settings.record("txtFile" + i, this.txtFile[i], "/Users/dsage/Desktop/samples");
            this.settings.record("shiftX" + i, this.shiftX[i], "0");
            this.settings.record("shiftY" + i, this.shiftY[i], "0");
            this.settings.record("shiftZ" + i, this.shiftZ[i], "0");
            this.settings.record("shiftF" + i, this.shiftF[i], "0");
            this.settings.record("locationUnit" + i, this.cmbUnit[i], "nm");
            this.settings.record("colF" + i, this.colF[i], "1");
            this.settings.record("colX" + i, this.colX[i], "2");
            this.settings.record("colY" + i, this.colY[i], "3");
            this.settings.record("colZ" + i, this.colZ[i], "4");
            this.settings.record("colI" + i, this.colI[i], "5");
            this.settings.record("firstRow" + i, this.firstRow[i], "1");
            ++i;
        }
        this.settings.record("txtWooble", this.txtWooble, "");
        this.settings.record("spnToleranceXY", this.spnToleranceXY, "250");
        this.settings.record("spnToleranceZ", this.spnToleranceZ, "500");
        this.settings.record("spnPixelsize", this.spnPixelsize, "100");
        this.settings.record("spnZStep", this.spnZStep, "10");
        this.settings.record("spnFieldoFViewX", this.spnFieldOfViewX, "6400");
        this.settings.record("spnFieldoFViewY", this.spnFieldOfViewY, "6400");
        this.settings.loadRecordedItems();
        GridPanel[] panels = new GridPanel[]{new GridPanel(false), new GridPanel(false)};
        GridPanel[] cols = new GridPanel[]{new GridPanel("Columns", 2), new GridPanel("Columns", 2)};
        GridPanel[] shift = new GridPanel[]{new GridPanel("Shift", 2), new GridPanel("Shift", 2)};
        this.lblCorrectionX0.setBorder(BorderFactory.createEtchedBorder());
        this.lblCorrectionY0.setBorder(BorderFactory.createEtchedBorder());
        int i2 = 0;
        while (i2 < 2) {
            this.txtFile[i2].setPreferredSize(new Dimension(350, 22));
            this.txtFile[i2].setCaretPosition(this.txtFile[i2].getText().length());
            cols[i2].place(0, 0, "Header row");
            cols[i2].place(0, 1, this.firstRow[i2]);
            cols[i2].place(1, 0, "Frame column");
            cols[i2].place(1, 1, this.colF[i2]);
            cols[i2].place(2, 0, "X column");
            cols[i2].place(2, 1, this.colX[i2]);
            cols[i2].place(3, 0, "Y column");
            cols[i2].place(3, 1, this.colY[i2]);
            cols[i2].place(4, 0, "Z column");
            cols[i2].place(4, 1, this.colZ[i2]);
            cols[i2].place(5, 0, "Intensity column");
            cols[i2].place(5, 1, this.colI[i2]);
            JLabel lbl1 = new JLabel("-1 if not used, col index starts at 0");
            lbl1.setBorder(BorderFactory.createEtchedBorder());
            cols[i2].place(6, 0, 2, 1, lbl1);
            shift[i2].place(0, 0, "Name");
            shift[i2].place(0, 1, this.txtName[i2]);
            shift[i2].place(1, 0, "Frame");
            shift[i2].place(1, 1, this.shiftF[i2]);
            shift[i2].place(2, 0, "X");
            shift[i2].place(2, 1, this.shiftX[i2]);
            shift[i2].place(3, 0, "Y");
            shift[i2].place(3, 1, this.shiftY[i2]);
            shift[i2].place(4, 0, "Z");
            shift[i2].place(4, 1, this.shiftZ[i2]);
            shift[i2].place(5, 0, "Unit");
            shift[i2].place(5, 1, this.cmbUnit[i2]);
            JLabel lbl2 = new JLabel("Origin at the upper-left corner");
            lbl2.setBorder(BorderFactory.createEtchedBorder());
            shift[i2].place(6, 0, 2, 1, lbl2);
            this.lblFile[i2].setBorder(BorderFactory.createEtchedBorder());
            panels[i2].place(1, 0, 4, 1, this.txtFile[i2]);
            panels[i2].place(2, 0, 2, 1, this.lblFile[i2]);
            panels[i2].place(2, 2, this.bnBrowse[i2]);
            panels[i2].place(2, 3, this.bnLoad[i2]);
            panels[i2].place(4, 0, 2, 1, cols[i2]);
            panels[i2].place(4, 2, 2, 1, shift[i2]);
            this.bnLoad[i2].addActionListener(this);
            this.bnBrowse[i2].addActionListener(this);
            ++i2;
        }
        JLabel lblPhotons1 = new JLabel("0 (all points)");
        lblPhotons1.setBorder(BorderFactory.createEtchedBorder());
        GridPanel pnRun = new GridPanel("Settings");
        pnRun.place(0, 0, new JLabel("Pixelsize"));
        pnRun.place(0, 1, this.spnPixelsize);
        pnRun.place(0, 2, new JLabel("nm"));
        pnRun.place(1, 0, new JLabel("Tolerance XY"));
        pnRun.place(1, 1, this.spnToleranceXY);
        pnRun.place(1, 2, new JLabel("nm"));
        pnRun.place(2, 0, new JLabel("Min. Photons 1"));
        pnRun.place(2, 1, lblPhotons1);
        pnRun.place(2, 2, new JLabel("(ref)"));
        pnRun.place(3, 0, new JLabel("Min. Photons 2"));
        pnRun.place(3, 1, this.spnMinPhotons2);
        pnRun.place(3, 2, new JLabel("(ref)"));
        pnRun.place(4, 0, new JLabel("FoV in X"));
        pnRun.place(4, 1, this.spnFieldOfViewX);
        pnRun.place(4, 2, new JLabel("nm"));
        pnRun.place(5, 0, new JLabel("FoV in Y"));
        pnRun.place(5, 1, this.spnFieldOfViewY);
        pnRun.place(5, 2, new JLabel("nm"));
        pnRun.place(6, 0, new JLabel("Excluded Border"));
        pnRun.place(6, 1, this.spnBorderXY);
        pnRun.place(6, 2, new JLabel("nm"));
        GridPanel pn3D = new GridPanel("3D");
        pn3D.place(0, 0, new JLabel("Z-step"));
        pn3D.place(0, 1, this.spnZStep);
        pn3D.place(1, 0, new JLabel("Tolerance Z"));
        pn3D.place(1, 1, this.spnToleranceZ);
        GridPanel pnW = new GridPanel("Wobble Correction");
        pnW.place(2, 0, 1, 1, "Wobble file");
        pnW.place(2, 1, this.bnBrowseWobble);
        pnW.place(3, 0, 2, 1, this.txtWooble);
        JLabel lbl3 = new JLabel("Depth-Dependent Lateral Distorsion ");
        lbl3.setBorder(BorderFactory.createEtchedBorder());
        JLabel lbl4 = new JLabel("Correction is applied only on the reference");
        lbl4.setBorder(BorderFactory.createEtchedBorder());
        pnW.place(4, 0, 2, 1, lbl3);
        pnW.place(5, 0, 2, 1, lbl4);
        GridPanel pnButton = new GridPanel(false, 1);
        pnButton.place(5, 1, this.txtDataset);
        pnButton.place(5, 2, this.bnClose);
        pnButton.place(5, 4, this.bnCompare);
        JTabbedPane tab = new JTabbedPane();
        tab.add("Reference", panels[0]);
        tab.add("Test", panels[1]);
        GridPanel pnMain = new GridPanel(false, 3);
        pnMain.place(2, 0, 2, 1, tab);
        pnMain.place(3, 0, 1, 2, pnRun);
        pnMain.place(3, 1, 1, 1, pn3D);
        pnMain.place(4, 1, 1, 1, pnW);
        pnMain.place(5, 0, 2, 1, pnButton);
        pnMain.place(6, 0, 2, 1, this.walk);
        this.addWindowListener(this);
        this.bnClose.addActionListener(this);
        this.bnCompare.addActionListener(this);
        this.bnBrowseWobble.addActionListener(this);
        this.add(pnMain);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
        Dimension screen = this.getScreenSize();
        Dimension window = this.getSize();
        if (window.width == 0) {
            return;
        }
        int left = screen.width / 2 - window.width / 2;
        int top = (screen.height - window.height) / 4;
        if (top < 0) {
            top = 0;
        }
        this.setLocation(left, top);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bnClose) {
            this.bnLoad[0].removeActionListener(this);
            this.bnBrowse[0].removeActionListener(this);
            this.bnLoad[1].removeActionListener(this);
            this.bnBrowse[1].removeActionListener(this);
            this.bnClose.removeActionListener(this);
            this.bnCompare.removeActionListener(this);
            this.bnBrowseWobble.removeActionListener(this);
            this.settings.storeRecordedItems();
            this.dispose();
            System.exit(0);
        } else if (e.getSource() == this.bnBrowseWobble) {
            this.browseWooble();
        } else if (e.getSource() == this.bnLoad[0]) {
            this.load(0, this.spnBorderXY.get(), this.spnFieldOfViewX.get() - this.spnBorderXY.get(), this.spnBorderXY.get(), this.spnFieldOfViewY.get() - this.spnBorderXY.get());
        } else if (e.getSource() == this.bnBrowse[0]) {
            this.browseFile(0);
        } else if (e.getSource() == this.bnLoad[1]) {
            this.load(1, this.spnBorderXY.get(), this.spnFieldOfViewX.get() - this.spnBorderXY.get(), this.spnBorderXY.get(), this.spnFieldOfViewY.get() - this.spnBorderXY.get());
        } else if (e.getSource() == this.bnBrowse[1]) {
            this.browseFile(1);
        } else if (e.getSource() == this.bnCompare) {
            this.compare();
        }
    }

    public void compare() {
        ArrayList<String[]> results = new ArrayList<String[]>();
        results.add(CompareLocalization3D.getHeaders());
        File fileRef = new File(this.txtFile[0].getText());
        File fileTst = new File(this.txtFile[1].getText());
        Description desca = this.getDescription(0);
        Description descb = this.getDescription(1);
        double minPhotons1 = 0.0;
        double minPhotons2 = this.spnMinPhotons2.get();
        Wobble wobble = new Wobble(this.txtWooble.getText());
        this.lblCorrectionX0.setText("" + wobble.getCorrectionAt0()[0]);
        this.lblCorrectionY0.setText("" + wobble.getCorrectionAt0()[1]);
        if (fileRef.exists() && fileTst.exists()) {
            this.walk.reset();
            String dataset = this.txtDataset.getText();
            double border = this.spnBorderXY.get();
            double txy = this.spnToleranceXY.get();
            double tz = this.spnToleranceZ.get();
            Fluorophores[] ar = this.load(0, border, this.spnFieldOfViewX.get() - border, border, this.spnFieldOfViewY.get() - border);
            Fluorophores[] a = Fluorophores.crop(ar, border, this.spnFieldOfViewX.get() - border, border, this.spnFieldOfViewY.get() - border);
            Fluorophores[] b = this.load(1, border, this.spnFieldOfViewX.get() - border, border, this.spnFieldOfViewY.get() - border);
            int algo = 0;
            CompareLocalization3D comparator = new CompareLocalization3D(desca.name, a);
            results.add(comparator.run(this.walk, descb.name, b, 1, dataset, algo, true, null, minPhotons1, txy, tz));
            results.add(comparator.run(this.walk, descb.name, b, 2, dataset, algo, false, null, minPhotons1, txy, tz));
            results.add(comparator.run(this.walk, descb.name, b, 3, dataset, algo, true, wobble, minPhotons1, txy, tz));
            results.add(comparator.run(this.walk, descb.name, b, 4, dataset, algo, false, wobble, minPhotons1, txy, tz));
            results.add(comparator.run(this.walk, descb.name, b, 5, dataset, algo, true, null, minPhotons2, txy, tz));
            results.add(comparator.run(this.walk, descb.name, b, 6, dataset, algo, false, null, minPhotons2, txy, tz));
            results.add(comparator.run(this.walk, descb.name, b, 7, dataset, algo, true, wobble, minPhotons2, txy, tz));
            results.add(comparator.run(this.walk, descb.name, b, 8, dataset, algo, false, wobble, minPhotons2, txy, tz));
            CompareTable table = new CompareTable(results, CompareLocalization3D.getHeaders(), false);
            table.show(1200, 200, "Compare " + desca.name + " vs. " + descb.name);
            this.walk.finish(desca.name + " vs " + descb.name);
        }
    }

    private Description getDescription(int i) {
        Description desc = new Description();
        desc.name = this.txtName[i].getText();
        desc.pixelsize = this.cmbUnit[i].getSelectedItem().equals("nm") ? 1.0 : this.spnPixelsize.get();
        desc.zstep = this.cmbUnit[i].getSelectedItem().equals("nm") ? 1.0 : this.spnZStep.get();
        desc.shiftX = this.shiftX[i].get();
        desc.shiftY = this.shiftY[i].get();
        desc.shiftZ = this.shiftZ[i].get();
        desc.shiftFrame = this.shiftF[i].get();
        desc.colX = this.colX[i].get();
        desc.colY = this.colY[i].get();
        desc.colZ = this.colZ[i].get();
        desc.colFrame = this.colF[i].get();
        desc.colIntensity = this.colI[i].get();
        desc.firstRow = this.firstRow[i].get();
        return desc;
    }

    private Fluorophores[] load(int i, double x1, double x2, double y1, double y2) {
        Description desc = this.getDescription(i);
        LocalizationFile loc = new LocalizationFile();
        Fluorophores[] fluorophoresRead = loc.read(desc, this.txtFile[i].getText());
        Fluorophores[] fluorophores = Fluorophores.crop(fluorophoresRead, x1, x2, y1, y2);
        int errors = loc.getNbErrors();
        double xmax = -1.7976931348623157E308;
        double ymax = -1.7976931348623157E308;
        double zmax = -1.7976931348623157E308;
        int fmax = -2147483647;
        double imax = -1.7976931348623157E308;
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double zmin = Double.MAX_VALUE;
        int fmin = Integer.MAX_VALUE;
        double imin = Double.MAX_VALUE;
        int count = 0;
        int f = 0;
        while (f < fluorophores.length) {
            for (Fluorophore fluo : fluorophores[f]) {
                xmax = Math.max(xmax, fluo.xnano);
                ymax = Math.max(ymax, fluo.ynano);
                zmax = Math.max(zmax, fluo.znano);
                fmax = Math.max(fmax, fluo.frame);
                imax = Math.max(imax, fluo.photons);
                xmin = Math.min(xmin, fluo.xnano);
                ymin = Math.min(ymin, fluo.ynano);
                zmin = Math.min(zmin, fluo.znano);
                fmin = Math.min(fmin, fluo.frame);
                imin = Math.min(imin, fluo.photons);
                ++count;
            }
            ++f;
        }
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{"X", "" + xmin, "" + xmax});
        data.add(new String[]{"Y", "" + ymin, "" + ymax});
        data.add(new String[]{"Z", "" + zmin, "" + zmax});
        data.add(new String[]{"Frame", "" + fmin, "" + fmax});
        data.add(new String[]{"Intensity", "" + imin, "" + imax});
        CompareTable table = new CompareTable(data, new String[]{"Feature", "Minimum", "Maximum"}, true);
        table.show(200, 200, desc.name);
        this.lblFile[i].setText("Fluos: " + count + " Errors:" + errors);
        return fluorophores;
    }

    private void browseFile(int index) {
        JFileChooser chooser = new JFileChooser(this.txtFile[index].getText());
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle("Open a localization file CSV, TAB, ...");
        int ret = chooser.showOpenDialog(this);
        if (ret == 0) {
            String name = chooser.getSelectedFile().getAbsolutePath();
            this.txtFile[index].setText(name);
            this.txtFile[index].setCaretPosition(name.length());
        }
    }

    private void browseWooble() {
        JFileChooser chooser = new JFileChooser(this.txtWooble.getText());
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle("Open a Wooble correction file *.csv");
        int ret = chooser.showOpenDialog(this);
        if (ret == 0) {
            String name = chooser.getSelectedFile().getAbsolutePath();
            this.txtWooble.setText(name);
            this.txtWooble.setCaretPosition(name.length());
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
        System.exit(0);
    }

    private Dimension getScreenSize() {
        if (GraphicsEnvironment.isHeadless()) {
            return new Dimension(0, 0);
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        GraphicsConfiguration[] gc = gd[0].getConfigurations();
        Rectangle bounds = gc[0].getBounds();
        if (bounds.x == 0 && bounds.y == 0) {
            return new Dimension(bounds.width, bounds.height);
        }
        return Toolkit.getDefaultToolkit().getScreenSize();
    }
}

