/*
 * Decompiled with CFR 0.152.
 */
package smlms;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class CompareTable
extends JTable {
    private Color colorOddRow = new Color(245, 245, 250);
    private Color colorEvenRow = new Color(232, 232, 237);

    public CompareTable(ArrayList<String[]> data, String[] headers, boolean headerVisible) {
        DefaultTableModel model = new DefaultTableModel();
        this.setModel(model);
        String[] h = new String[headers.length];
        model.setColumnIdentifiers(headerVisible ? headers : h);
        int i = 0;
        while (i < headers.length) {
            TableColumn tc = this.getColumnModel().getColumn(i);
            tc.setCellRenderer(new AlternatedRowRenderer());
            ++i;
        }
        this.update(data);
    }

    public String getSelectedAtColumn(int col) {
        int row = this.getSelectedRow();
        if (row >= 0) {
            return (String)this.getModel().getValueAt(row, col);
        }
        return "";
    }

    public void setSelectedAtColumn(int col, String selection) {
        int nrows = this.getRowCount();
        int i = 0;
        while (i < nrows) {
            String name = (String)this.getModel().getValueAt(i, col);
            if (name.equals(selection)) {
                this.setRowSelectionInterval(i, i + 1);
            }
            ++i;
        }
    }

    public void update(ArrayList<String[]> data) {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        model.getDataVector().removeAllElements();
        for (Object[] objectArray : data) {
            model.addRow(objectArray);
        }
        this.repaint();
    }

    public JScrollPane getPane(int width, int height) {
        this.setAutoResizeMode(4);
        this.setPreferredScrollableViewportSize(new Dimension(width, height));
        this.setFillsViewportHeight(true);
        return new JScrollPane(this);
    }

    public void show(int width, int height, String title) {
        JFrame frame = new JFrame(title);
        frame.add(this.getPane(width, height));
        frame.pack();
        frame.setVisible(true);
    }

    public class AlternatedRowRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            if (!isSelected) {
                c.setBackground(row % 2 == 0 ? CompareTable.this.colorEvenRow : CompareTable.this.colorOddRow);
            }
            return c;
        }
    }
}

