/*
 * Decompiled with CFR 0.152.
 */
package smlms;

public class Fluorophore
implements Comparable<Fluorophore> {
    public double xnano;
    public double ynano;
    public double znano;
    public boolean matching = false;
    public int frame;
    public double photons;
    public boolean activation = false;

    public Fluorophore(double xnano, double ynano, double znano, int frame, double photons) {
        this.xnano = xnano;
        this.ynano = ynano;
        this.znano = znano;
        this.frame = frame;
        this.photons = photons;
        this.activation = false;
    }

    public Fluorophore duplicate() {
        Fluorophore fluo = new Fluorophore(this.xnano, this.ynano, this.znano, this.frame, this.photons);
        fluo.activation = this.activation;
        fluo.matching = this.matching;
        return fluo;
    }

    public boolean getActivation() {
        return this.activation;
    }

    public int getFrame() {
        return this.frame;
    }

    public double getPhotons() {
        return this.photons;
    }

    public boolean isSamePosition(Fluorophore fluo) {
        if (fluo.xnano != this.xnano) {
            return false;
        }
        if (fluo.ynano != this.ynano) {
            return false;
        }
        return fluo.znano == this.znano;
    }

    public void resetActivation() {
        this.activation = false;
    }

    public boolean isActivated() {
        return this.activation;
    }

    public double deltaX(Fluorophore fluo) {
        return fluo.xnano - this.xnano;
    }

    public double deltaY(Fluorophore fluo) {
        return fluo.ynano - this.ynano;
    }

    public double deltaZ(Fluorophore fluo) {
        return fluo.znano - this.znano;
    }

    public double differenceIntensity(Fluorophore fluo) {
        return fluo.photons - this.photons;
    }

    public int distanceFrame(Fluorophore fluo) {
        return Math.abs(fluo.frame - this.frame);
    }

    public double distanceLateral(Fluorophore fluo) {
        return Math.sqrt((fluo.xnano - this.xnano) * (fluo.xnano - this.xnano) + (fluo.ynano - this.ynano) * (fluo.ynano - this.ynano));
    }

    public double distanceAxial(Fluorophore fluo) {
        return Math.abs(fluo.znano - this.znano);
    }

    public double distance(Fluorophore fluo) {
        return Math.sqrt((fluo.xnano - this.xnano) * (fluo.xnano - this.xnano) + (fluo.ynano - this.ynano) * (fluo.ynano - this.ynano) + (fluo.znano - this.znano) * (fluo.znano - this.znano));
    }

    public String toString() {
        String s = " (" + this.xnano + ", " + this.ynano + ", " + this.znano + ") [" + this.frame + "] " + this.photons;
        return s;
    }

    public void log() {
        System.out.println(this.toString());
    }

    @Override
    public int compareTo(Fluorophore fluorophore) {
        return fluorophore.frame > this.frame ? 0 : 1;
    }
}

