/*
 * Decompiled with CFR 0.152.
 */
package smlms;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import smlms.Description;
import smlms.Fluorophore;
import smlms.Fluorophores;

public class LocalizationFile {
    private int nbErrors = 0;

    public static Fluorophores[] load(Description desc, String filename) {
        LocalizationFile loc = new LocalizationFile();
        Fluorophores[] fluos = loc.read(desc, filename);
        return fluos;
    }

    public Fluorophores[] read(Description desc, String filename) {
        int firstrow = desc.firstRow;
        int lastFrame = 1;
        ArrayList<Fluorophore> fluos = new ArrayList<Fluorophore>();
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(filename));
            int i = 0;
            while (i < firstrow) {
                this.readLine(buffer);
                ++i;
            }
            int lineNumber = 0;
            Object fluorophore = null;
            String line = this.readLine(buffer);
            this.nbErrors = 0;
            while (line != null) {
                try {
                    String[] items = line.split("[,;\t]");
                    int frame = 0;
                    double xnano = 0.0;
                    double ynano = 0.0;
                    double znano = 0.0;
                    double intensity = 0.0;
                    int col = 0;
                    while (col < items.length) {
                        String field = items[col].trim();
                        if (col == desc.colX) {
                            xnano = (Double.parseDouble(field) + desc.shiftX) * desc.pixelsize;
                        }
                        if (col == desc.colY) {
                            ynano = (Double.parseDouble(field) + desc.shiftY) * desc.pixelsize;
                        }
                        if (col == desc.colZ) {
                            znano = (Double.parseDouble(field) + desc.shiftZ) * desc.zstep;
                        }
                        if (col == desc.colFrame) {
                            frame = (int)Math.round(Double.parseDouble(field) + desc.shiftFrame);
                        }
                        if (col == desc.colIntensity) {
                            intensity = Double.parseDouble(field);
                        }
                        lastFrame = Math.max(frame, lastFrame);
                        ++col;
                    }
                    Fluorophore fluo = new Fluorophore(xnano, ynano, znano, frame, intensity);
                    fluos.add(fluo);
                }
                catch (Exception e) {
                    System.out.println("Error in line number:" + lineNumber + "\n " + line + " at file " + filename);
                    ++this.nbErrors;
                }
                line = this.readLine(buffer);
                ++lineNumber;
            }
        }
        catch (Exception buffer) {
            // empty catch block
        }
        int n = lastFrame + 1;
        Fluorophores[] fluorophores = new Fluorophores[n];
        int t = 0;
        while (t < n) {
            fluorophores[t] = new Fluorophores();
            ++t;
        }
        for (Fluorophore fluo : fluos) {
            if (fluo.frame < 0 || fluo.frame >= n) continue;
            fluorophores[fluo.frame].add(fluo);
        }
        return fluorophores;
    }

    public int getNbErrors() {
        return this.nbErrors;
    }

    private String readLine(BufferedReader buffer) {
        try {
            return buffer.readLine();
        }
        catch (Exception e) {
            return null;
        }
    }
}

