/*
 * Decompiled with CFR 0.152.
 */
package smlms;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import smlms.Fluorophore;
import smlms.FluorophorePair;
import smlms.FluorophorePairs;
import smlms.Fluorophores;

public class Wobble {
    private double[] dx;
    private double[] dy;
    private double[] z;
    private int on = 0;
    private String filename;
    private double dx0 = 0.0;
    private double dy0 = 0.0;

    public Wobble(String filename) {
        this.filename = filename;
        if (filename != null) {
            try {
                BufferedReader buffer = new BufferedReader(new FileReader(filename));
                String line = buffer.readLine();
                ArrayList<double[]> rows = new ArrayList<double[]>();
                while (line != null) {
                    String[] items = line.split("[,;\t]");
                    if (items.length == 3) {
                        try {
                            double x = Double.parseDouble(items[0]);
                            double y = Double.parseDouble(items[1]);
                            double z = Double.parseDouble(items[2]);
                            rows.add(new double[]{x, y, z});
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                    }
                    line = buffer.readLine();
                }
                if (rows.size() >= 2) {
                    this.dx = new double[rows.size()];
                    this.dy = new double[rows.size()];
                    this.z = new double[rows.size()];
                    int index = 0;
                    double min = Double.MAX_VALUE;
                    int i = 0;
                    while (i < rows.size()) {
                        this.dx[i] = ((double[])rows.get(i))[0];
                        this.dy[i] = ((double[])rows.get(i))[1];
                        this.z[i] = ((double[])rows.get(i))[2];
                        if (Math.abs(this.z[i]) < min) {
                            min = Math.abs(this.z[i]);
                            index = i;
                        }
                        ++i;
                    }
                    this.on = 1;
                    this.dx0 = this.dx[index];
                    this.dy0 = this.dy[index];
                    System.out.println("Bias at the focal plane " + this.dx0 + " " + this.dy0);
                } else {
                    this.on = 2;
                }
                buffer.close();
            }
            catch (Exception e) {
                this.on = 2;
            }
        } else {
            this.on = 0;
        }
    }

    public double[] getCorrectionAt0() {
        return new double[]{this.dx0, this.dy0};
    }

    public void bias1(Fluorophores original) {
        if (this.on == 1) {
            for (Fluorophore fluo : original) {
                fluo.xnano -= this.dx0;
                fluo.ynano -= this.dy0;
            }
        }
    }

    public void correctionTest1(FluorophorePairs pairs) {
        if (this.on == 1) {
            for (FluorophorePair pair : pairs) {
                Fluorophore ref = pair.ref;
                int index = -1;
                double min = Double.MAX_VALUE;
                int i = 0;
                while (i < this.z.length) {
                    if (min > Math.abs(ref.znano - this.z[i])) {
                        index = i;
                        min = Math.abs(ref.znano - this.z[i]);
                    }
                    ++i;
                }
                if (index < 0) continue;
                Fluorophore test = pair.test;
                test.xnano = test.xnano + this.dx0 - this.dx[index];
                test.ynano = test.ynano + this.dy0 - this.dy[index];
            }
        }
    }

    public Fluorophore wobble(Fluorophore fluo) {
        if (this.on == 1) {
            Fluorophore fluw = fluo.duplicate();
            int index = -1;
            double min = Double.MAX_VALUE;
            int i = 0;
            while (i < this.z.length) {
                if (min > Math.abs(fluw.znano - this.z[i])) {
                    index = i;
                    min = Math.abs(fluw.znano - this.z[i]);
                }
                ++i;
            }
            if (index >= 0) {
                fluw.xnano += this.dx[index];
                fluw.ynano += this.dy[index];
            }
            return fluw;
        }
        return fluo;
    }

    public boolean on() {
        return this.on == 1;
    }

    public String getName() {
        if (this.on == 0) {
            return "NO";
        }
        if (this.on == 1) {
            return new File(this.filename).getName();
        }
        return "ERR";
    }
}

