/*
 * Decompiled with CFR 0.152.
 */
package smlms.hungarian;

import java.util.ArrayList;
import java.util.Arrays;
import smlms.hungarian.WeightedEdge;

public class BellmanFord {
    public static double NOVAL = Double.POSITIVE_INFINITY;
    private ArrayList<WeightedEdge> cTEdges = null;
    private double[] distance = null;
    private int[] predecessor = null;
    private int numNodes = 0;
    private int sourceNodeIndex = 0;

    public BellmanFord(ArrayList<WeightedEdge> cTEdges, int Nnodes, int source) {
        this.cTEdges = cTEdges;
        this.numNodes = Nnodes;
        this.sourceNodeIndex = source;
    }

    public void computeSpanningTree() {
        this.distance = new double[this.numNodes];
        this.predecessor = new int[this.numNodes];
        Arrays.fill(this.distance, NOVAL);
        Arrays.fill(this.predecessor, -1);
        this.distance[this.sourceNodeIndex] = 0.0;
        int i = 0;
        while (i < this.numNodes) {
            for (WeightedEdge e : this.cTEdges) {
                double newDistance;
                if (this.distance[e.source] == NOVAL || !((newDistance = this.distance[e.source] + e.weight) < this.distance[e.destination])) continue;
                this.distance[e.destination] = newDistance;
                this.predecessor[e.destination] = e.source;
            }
            ++i;
        }
    }

    public int[] getPredecessor() {
        return this.predecessor;
    }

    public double[] getTotalWeight() {
        return this.distance;
    }
}

