/*
 * Decompiled with CFR 0.152.
 */
package smlms.hungarian;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import smlms.hungarian.BellmanFord;
import smlms.hungarian.Matching;
import smlms.hungarian.WeightedEdge;

public class MaximumWeightedMatching
implements Callable {
    private int Unodes;
    private int Nnodes;
    private ArrayList<WeightedEdge> maximumWeightedMatching = new ArrayList();
    private ArrayList<WeightedEdge> G;
    private boolean terminated = false;

    public MaximumWeightedMatching(ArrayList<WeightedEdge> G, int Unodes, int Wnodes) {
        this.Unodes = Unodes;
        this.Nnodes = Unodes + Wnodes;
        this.G = G;
    }

    /*
     * WARNING - void declaration
     */
    public Boolean call() {
        try {
            void var6_13;
            ArrayList<Matching> Mset = new ArrayList<Matching>();
            ArrayList<WeightedEdge> GM = new ArrayList<WeightedEdge>();
            ArrayList<WeightedEdge> M = new ArrayList<WeightedEdge>();
            ArrayList<Object> path = new ArrayList();
            boolean[] matched = new boolean[this.Nnodes];
            Arrays.fill(matched, false);
            do {
                boolean found;
                for (WeightedEdge weightedEdge : this.G) {
                    found = false;
                    for (WeightedEdge e2 : M) {
                        if (weightedEdge.equals(e2)) {
                            found = true;
                            matched[weightedEdge.source] = true;
                            matched[weightedEdge.destination] = true;
                            GM.add(new WeightedEdge(weightedEdge.destination, weightedEdge.source, weightedEdge.weight));
                        }
                        if (found) break;
                    }
                    if (found) continue;
                    GM.add(new WeightedEdge(weightedEdge.source, weightedEdge.destination, -weightedEdge.weight));
                }
                path = this.findBestAugmentingPath(GM, matched);
                GM.clear();
                if (path.size() != 0) {
                    for (WeightedEdge weightedEdge : path) {
                        found = false;
                        WeightedEdge removableEdge = null;
                        for (WeightedEdge e2 : M) {
                            if (!weightedEdge.equals(e2)) continue;
                            found = true;
                            removableEdge = e2;
                            break;
                        }
                        if (removableEdge != null) {
                            M.remove(removableEdge);
                            continue;
                        }
                        M.add(new WeightedEdge(weightedEdge.source, weightedEdge.destination, weightedEdge.weight));
                        matched[weightedEdge.source] = true;
                        matched[weightedEdge.destination] = true;
                    }
                }
                ArrayList<WeightedEdge> arrayList = new ArrayList<WeightedEdge>(M.size());
                for (WeightedEdge e : M) {
                    arrayList.add(e);
                }
                Mset.add(new Matching(arrayList, this.matchingWeight(M)));
            } while (path.size() != 0);
            Matching matching = (Matching)Mset.get(0);
            for (Matching m : Mset) {
                double currentWeight = m.weight;
                if (!(currentWeight > var6_13.weight)) continue;
                Matching matching2 = m;
            }
            this.maximumWeightedMatching = var6_13.cTEdges;
            this.terminated = true;
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public ArrayList<WeightedEdge> getMaximumWeightMatching() {
        return this.maximumWeightedMatching;
    }

    private double matchingWeight(ArrayList<WeightedEdge> M) {
        double w = 0.0;
        for (WeightedEdge e : M) {
            w += Math.abs(e.weight);
        }
        return w;
    }

    private ArrayList<WeightedEdge> findBestAugmentingPath(ArrayList<WeightedEdge> GM, boolean[] matched) {
        int numMatched = 0;
        int i = 0;
        while (i < matched.length) {
            if (matched[i]) {
                ++numMatched;
            }
            ++i;
        }
        ArrayList<WeightedEdge> G = new ArrayList<WeightedEdge>(GM.size() + (matched.length - numMatched + 1));
        for (WeightedEdge e : GM) {
            G.add(e);
        }
        int i2 = 0;
        while (i2 < this.Nnodes) {
            if (!matched[i2]) {
                if (i2 < this.Unodes) {
                    G.add(new WeightedEdge(this.Nnodes, i2, 0.0));
                } else {
                    G.add(new WeightedEdge(i2, this.Nnodes + 1, 0.0));
                }
            }
            ++i2;
        }
        BellmanFord trackerBellmanFord = new BellmanFord(G, this.Nnodes + 2, this.Nnodes);
        trackerBellmanFord.computeSpanningTree();
        int[] predecessor = trackerBellmanFord.getPredecessor();
        double[] weights = trackerBellmanFord.getTotalWeight();
        ArrayList<WeightedEdge> path = new ArrayList<WeightedEdge>();
        int n1 = predecessor[this.Nnodes + 1];
        while (n1 != this.Nnodes && n1 != -1) {
            int n2 = predecessor[n1];
            if (predecessor[n2] != -1) {
                if (n1 < n2) {
                    path.add(new WeightedEdge(n1, n2, Math.abs(weights[n1] - weights[n2])));
                } else {
                    path.add(new WeightedEdge(n2, n1, Math.abs(weights[n1] - weights[n2])));
                }
            }
            n1 = n2;
        }
        return path;
    }
}

