---
name: Bug report
about: Report a bug in OSMnx's code
title: ''
labels: bug
assignees: ''

---

**Read these instructions carefully**

Please don't use the issue tracker to ask "how-to" or usage questions. If asked here, they will be closed automatically. Instead, ask "how-to" and usage questions on [StackOverflow](https://stackoverflow.com/).

Bug reports are for reporting a bug you have found in OSMnx's codebase. Your issue will be closed automatically if you don't provide the requested information that we need in order to help you. Before you proceed, review the contributing guidelines in this repo's CONTRIBUTING.md file. If you installed OSMnx via conda and are experiencing installation problems, please open an issue at its [feedstock](https://github.com/conda-forge/osmnx-feedstock/issues). If you've found a problem in OSMnx itself, first search the open/closed issues and StackOverflow to see if the problem has already been noted. If it hasn't, fill in the bug reporting template below. We need this information to assist you:

**Problem description**
  - What did you do?
  - What did you expect to happen?
  - And what actually happened instead?

**Environment information**
  - What operating system are you using?
  - What Python version are you using?
  - What OSMnx version are you using?
  - Provide a complete list of your environment's packages and their versions (for example, run `conda list` or `pip list` then paste the output between the two "details" tags below)

<details>
# paste the output of your Python packages/versions here between these two "details" tags

</details>

**Provide a complete minimal reproducible example**

Your example code snippet here must be *minimal* so it doesn't contain extraneous code unrelated to your specific problem and it must be *complete* so we can independently run it from top to bottom by copying/pasting it into a Python interpreter. That means all imports and all variables must be defined. If you're unsure how to create a good reproducible example, read [this guide](https://stackoverflow.com/help/minimal-reproducible-example). Do not post a screenshot of your code or error message: provide it as text.

```python
# your code goes here

```
