# Microsoft Team Onboarding

If you are new to Microsoft, you will need to onboard into various GitHub projects in order to get your work done.

## Getting Permissions

You first need to link your GitHub accoount so that you can use Microsoft's GitHub management tools.

* [Link your GitHub account](https://repos.opensource.microsoft.com/link)

There are two main teams to join to get access to Microsoft .NET-related projects.

* [Add yourself to the microsoft team (dotnet org)](https://repos.opensource.microsoft.com/dotnet/teams/microsoft/join/)
* [Add yourself to the dotnet team (microsoft org)](https://repos.opensource.microsoft.com/Microsoft/teams/dotnet/join/)

Once your permission requests are approved, you should have write permissions to [.NET Core Repos](https://github.com/dotnet/core/blob/master/Documentation/core-repos.md). Repo users will be able to @mention you at that point.

## Service Accounts

Service accounts should also be linked. For more details, see [Service accounts for GitHub](https://docs.opensource.microsoft.com/github/service-accounts.html).

## Best Practices

* Use your full name for your account.
* Add a picture to your account.
* Add @dotnet or @microsoft as your Company in your profile.
* Make your Microsoft and dotnet org memberships public. Only do this if you have added a picture to your profile (as opposed to the auto-generated GitHub image).

## Guidelines

* [Contributing to .NET Core](https://github.com/dotnet/coreclr/blob/master/Documentation/project-docs/contributing.md)
* [What you can expect from Maintainers](https://github.com/dotnet/core/blob/master/Documentation/contributing/maintainers.md)

## Tools

* [Corporate GitHub Chrome Extension](https://repos.opensource.microsoft.com/settings/security/tokens/extension)
* [CodeFlow Chrome Extension](https://chrome.google.com/webstore/detail/codeflow/aphnoipocoffpdafmiidfmaiadhilelm)

## Resources

* [.NET Core "Home Repo"](https://github.com/dotnet/core) (links to install daily builds)
* [Introduction to the Common Language Runtime (CLR)](https://github.com/dotnet/coreclr/blob/master/Documentation/botr/intro-to-clr.md)
* [The Book of the Runtime](https://github.com/dotnet/coreclr/blob/master/Documentation/botr/README.md)
* [CoreCLR Docs](https://github.com/dotnet/coreclr/tree/master/Documentation)
