# System.Reflection

``` diff
+namespace System.Reflection {
+    public sealed class AmbiguousMatchException : Exception {
+        public AmbiguousMatchException();
+        public AmbiguousMatchException(string message);
+        public AmbiguousMatchException(string message, Exception inner);
+    }
+    public abstract class Assembly : ICustomAttributeProvider {
+        protected Assembly();
+        public virtual string CodeBase { get; }
+        public virtual IEnumerable<CustomAttributeData> CustomAttributes { get; }
+        public abstract IEnumerable<TypeInfo> DefinedTypes { get; }
+        public virtual MethodInfo EntryPoint { get; }
+        public virtual IEnumerable<Type> ExportedTypes { get; }
+        public virtual string FullName { get; }
+        public virtual string ImageRuntimeVersion { get; }
+        public virtual bool IsDynamic { get; }
+        public virtual string Location { get; }
+        public virtual Module ManifestModule { get; }
+        public abstract IEnumerable<Module> Modules { get; }
+        public object CreateInstance(string typeName);
+        public object CreateInstance(string typeName, bool ignoreCase);
+        public static string CreateQualifiedName(string assemblyName, string typeName);
+        public override bool Equals(object o);
+        [MethodImpl(NoInlining)]public static Assembly GetCallingAssembly();
+        public virtual object[] GetCustomAttributes(bool inherit);
+        public virtual object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public static Assembly GetEntryAssembly();
+        [MethodImpl(NoInlining)]public static Assembly GetExecutingAssembly();
+        public virtual Type[] GetExportedTypes();
+        public override int GetHashCode();
+        public virtual ManifestResourceInfo GetManifestResourceInfo(string resourceName);
+        public virtual string[] GetManifestResourceNames();
+        public virtual Stream GetManifestResourceStream(string name);
+        public virtual Stream GetManifestResourceStream(Type type, string name);
+        public Module[] GetModules();
+        public virtual AssemblyName GetName();
+        public virtual AssemblyName[] GetReferencedAssemblies();
+        public virtual Type GetType(string name);
+        public virtual Type GetType(string name, bool throwOnError);
+        public virtual Type GetType(string name, bool throwOnError, bool ignoreCase);
+        public virtual Type[] GetTypes();
+        public virtual bool IsDefined(Type attributeType, bool inherit);
+        [MethodImpl(NoInlining)]public static Assembly Load(byte[] rawAssembly);
+        [MethodImpl(NoInlining)]public static Assembly Load(byte[] rawAssembly, byte[] rawSymbolStore);
+        public static Assembly Load(AssemblyName assemblyRef);
+        [MethodImpl(NoInlining)]public static Assembly Load(string assemblyString);
+        object[] System.Reflection.ICustomAttributeProvider.GetCustomAttributes(bool inherit);
+        object[] System.Reflection.ICustomAttributeProvider.GetCustomAttributes(Type attributeType, bool inherit);
+        bool System.Reflection.ICustomAttributeProvider.IsDefined(Type attributeType, bool inherit);
+        public override string ToString();
+    }
+    public sealed class AssemblyAlgorithmIdAttribute : Attribute {
+        public AssemblyAlgorithmIdAttribute(AssemblyHashAlgorithm algorithmId);
+        public AssemblyAlgorithmIdAttribute(uint algorithmId);
+        public uint AlgorithmId { get; }
+    }
+    public sealed class AssemblyCompanyAttribute : Attribute {
+        public AssemblyCompanyAttribute(string company);
+        public string Company { get; }
+    }
+    public sealed class AssemblyConfigurationAttribute : Attribute {
+        public AssemblyConfigurationAttribute(string configuration);
+        public string Configuration { get; }
+    }
+    public enum AssemblyContentType {
+        Default = 0,
+        WindowsRuntime = 1,
+    }
+    public sealed class AssemblyCopyrightAttribute : Attribute {
+        public AssemblyCopyrightAttribute(string copyright);
+        public string Copyright { get; }
+    }
+    public sealed class AssemblyCultureAttribute : Attribute {
+        public AssemblyCultureAttribute(string culture);
+        public string Culture { get; }
+    }
+    public sealed class AssemblyDefaultAliasAttribute : Attribute {
+        public AssemblyDefaultAliasAttribute(string defaultAlias);
+        public string DefaultAlias { get; }
+    }
+    public sealed class AssemblyDelaySignAttribute : Attribute {
+        public AssemblyDelaySignAttribute(bool delaySign);
+        public bool DelaySign { get; }
+    }
+    public sealed class AssemblyDescriptionAttribute : Attribute {
+        public AssemblyDescriptionAttribute(string description);
+        public string Description { get; }
+    }
+    public static class AssemblyExtensions {
+        public static Type[] GetExportedTypes(this Assembly assembly);
+        public static Module[] GetModules(this Assembly assembly);
+        public static Type[] GetTypes(this Assembly assembly);
+    }
+    public sealed class AssemblyFileVersionAttribute : Attribute {
+        public AssemblyFileVersionAttribute(string version);
+        public string Version { get; }
+    }
+    public enum AssemblyFlags {
+        ContentTypeMask = 3584,
+        DisableJitCompileOptimizer = 16384,
+        EnableJitCompileTracking = 32768,
+        PublicKey = 1,
+        Retargetable = 256,
+        WindowsRuntime = 512,
+    }
+    public sealed class AssemblyFlagsAttribute : Attribute {
+        public AssemblyFlagsAttribute(AssemblyNameFlags assemblyFlags);
+        public int AssemblyFlags { get; }
+    }
+    public enum AssemblyHashAlgorithm {
+        MD5 = 32771,
+        None = 0,
+        Sha1 = 32772,
+        Sha256 = 32780,
+        Sha384 = 32781,
+        Sha512 = 32782,
+    }
+    public sealed class AssemblyInformationalVersionAttribute : Attribute {
+        public AssemblyInformationalVersionAttribute(string informationalVersion);
+        public string InformationalVersion { get; }
+    }
+    public sealed class AssemblyKeyFileAttribute : Attribute {
+        public AssemblyKeyFileAttribute(string keyFile);
+        public string KeyFile { get; }
+    }
+    public sealed class AssemblyKeyNameAttribute : Attribute {
+        public AssemblyKeyNameAttribute(string keyName);
+        public string KeyName { get; }
+    }
+    public sealed class AssemblyMetadataAttribute : Attribute {
+        public AssemblyMetadataAttribute(string key, string value);
+        public string Key { get; }
+        public string Value { get; }
+    }
+    public sealed class AssemblyName {
+        public AssemblyName();
+        public AssemblyName(string assemblyName);
+        public AssemblyContentType ContentType { get; set; }
+        public CultureInfo CultureInfo { get; set; }
+        public string CultureName { get; set; }
+        public AssemblyNameFlags Flags { get; set; }
+        public string FullName { get; }
+        public AssemblyHashAlgorithm HashAlgorithm { get; set; }
+        public string Name { get; set; }
+        public ProcessorArchitecture ProcessorArchitecture { get; set; }
+        public Version Version { get; set; }
+        public byte[] GetPublicKey();
+        public byte[] GetPublicKeyToken();
+        public void SetPublicKey(byte[] publicKey);
+        public void SetPublicKeyToken(byte[] publicKeyToken);
+        public override string ToString();
+    }
+    public enum AssemblyNameFlags {
+        EnableJITcompileOptimizer = 16384,
+        EnableJITcompileTracking = 32768,
+        None = 0,
+        PublicKey = 1,
+        Retargetable = 256,
+    }
+    public sealed class AssemblyProductAttribute : Attribute {
+        public AssemblyProductAttribute(string product);
+        public string Product { get; }
+    }
+    public sealed class AssemblySignatureKeyAttribute : Attribute {
+        public AssemblySignatureKeyAttribute(string publicKey, string countersignature);
+        public string Countersignature { get; }
+        public string PublicKey { get; }
+    }
+    public sealed class AssemblyTitleAttribute : Attribute {
+        public AssemblyTitleAttribute(string title);
+        public string Title { get; }
+    }
+    public sealed class AssemblyTrademarkAttribute : Attribute {
+        public AssemblyTrademarkAttribute(string trademark);
+        public string Trademark { get; }
+    }
+    public sealed class AssemblyVersionAttribute : Attribute {
+        public AssemblyVersionAttribute(string version);
+        public string Version { get; }
+    }
+    public abstract class Binder {
+        protected Binder();
+        public abstract FieldInfo BindToField(BindingFlags bindingAttr, FieldInfo[] match, object value, CultureInfo culture);
+        public abstract MethodBase BindToMethod(BindingFlags bindingAttr, MethodBase[] match, ref object[] args, ParameterModifier[] modifiers, CultureInfo culture, string[] names, out object state);
+        public abstract object ChangeType(object value, Type type, CultureInfo culture);
+        public abstract void ReorderArgumentArray(ref object[] args, object state);
+        public abstract MethodBase SelectMethod(BindingFlags bindingAttr, MethodBase[] match, Type[] types, ParameterModifier[] modifiers);
+        public abstract PropertyInfo SelectProperty(BindingFlags bindingAttr, PropertyInfo[] match, Type returnType, Type[] indexes, ParameterModifier[] modifiers);
+    }
+    public enum BindingFlags {
+        CreateInstance = 512,
+        DeclaredOnly = 2,
+        Default = 0,
+        ExactBinding = 65536,
+        FlattenHierarchy = 64,
+        GetField = 1024,
+        GetProperty = 4096,
+        IgnoreCase = 1,
+        IgnoreReturn = 16777216,
+        Instance = 4,
+        InvokeMethod = 256,
+        NonPublic = 32,
+        OptionalParamBinding = 262144,
+        Public = 16,
+        PutDispProperty = 16384,
+        PutRefDispProperty = 32768,
+        SetField = 2048,
+        SetProperty = 8192,
+        Static = 8,
+        SuppressChangeType = 131072,
+    }
+    public enum CallingConventions {
+        Any = 3,
+        ExplicitThis = 64,
+        HasThis = 32,
+        Standard = 1,
+        VarArgs = 2,
+    }
+    public abstract class ConstructorInfo : MethodBase {
+        public static readonly string ConstructorName;
+        public static readonly string TypeConstructorName;
+        protected ConstructorInfo();
+        public override MemberTypes MemberType { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public virtual object Invoke(object[] parameters);
+        public abstract object Invoke(BindingFlags invokeAttr, Binder binder, object[] parameters, CultureInfo culture);
+    }
+    public class CustomAttributeData {
+        public virtual Type AttributeType { get; }
+        public virtual ConstructorInfo Constructor { get; }
+        public virtual IList<CustomAttributeTypedArgument> ConstructorArguments { get; }
+        public virtual IList<CustomAttributeNamedArgument> NamedArguments { get; }
+        public override bool Equals(object obj);
+        public static IList<CustomAttributeData> GetCustomAttributes(Assembly target);
+        public static IList<CustomAttributeData> GetCustomAttributes(MemberInfo target);
+        public static IList<CustomAttributeData> GetCustomAttributes(Module target);
+        public static IList<CustomAttributeData> GetCustomAttributes(ParameterInfo target);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public static class CustomAttributeExtensions {
+        public static Attribute GetCustomAttribute(this Assembly element, Type attributeType);
+        public static Attribute GetCustomAttribute(this MemberInfo element, Type attributeType);
+        public static Attribute GetCustomAttribute(this MemberInfo element, Type attributeType, bool inherit);
+        public static Attribute GetCustomAttribute(this Module element, Type attributeType);
+        public static Attribute GetCustomAttribute(this ParameterInfo element, Type attributeType);
+        public static Attribute GetCustomAttribute(this ParameterInfo element, Type attributeType, bool inherit);
+        public static T GetCustomAttribute<T>(this Assembly element) where T : Attribute;
+        public static T GetCustomAttribute<T>(this MemberInfo element) where T : Attribute;
+        public static T GetCustomAttribute<T>(this MemberInfo element, bool inherit) where T : Attribute;
+        public static T GetCustomAttribute<T>(this Module element) where T : Attribute;
+        public static T GetCustomAttribute<T>(this ParameterInfo element) where T : Attribute;
+        public static T GetCustomAttribute<T>(this ParameterInfo element, bool inherit) where T : Attribute;
+        public static IEnumerable<Attribute> GetCustomAttributes(this Assembly element);
+        public static IEnumerable<Attribute> GetCustomAttributes(this Assembly element, Type attributeType);
+        public static IEnumerable<Attribute> GetCustomAttributes(this MemberInfo element);
+        public static IEnumerable<Attribute> GetCustomAttributes(this MemberInfo element, bool inherit);
+        public static IEnumerable<Attribute> GetCustomAttributes(this MemberInfo element, Type attributeType);
+        public static IEnumerable<Attribute> GetCustomAttributes(this MemberInfo element, Type attributeType, bool inherit);
+        public static IEnumerable<Attribute> GetCustomAttributes(this Module element);
+        public static IEnumerable<Attribute> GetCustomAttributes(this Module element, Type attributeType);
+        public static IEnumerable<Attribute> GetCustomAttributes(this ParameterInfo element);
+        public static IEnumerable<Attribute> GetCustomAttributes(this ParameterInfo element, bool inherit);
+        public static IEnumerable<Attribute> GetCustomAttributes(this ParameterInfo element, Type attributeType);
+        public static IEnumerable<Attribute> GetCustomAttributes(this ParameterInfo element, Type attributeType, bool inherit);
+        public static IEnumerable<T> GetCustomAttributes<T>(this Assembly element) where T : Attribute;
+        public static IEnumerable<T> GetCustomAttributes<T>(this MemberInfo element) where T : Attribute;
+        public static IEnumerable<T> GetCustomAttributes<T>(this MemberInfo element, bool inherit) where T : Attribute;
+        public static IEnumerable<T> GetCustomAttributes<T>(this Module element) where T : Attribute;
+        public static IEnumerable<T> GetCustomAttributes<T>(this ParameterInfo element) where T : Attribute;
+        public static IEnumerable<T> GetCustomAttributes<T>(this ParameterInfo element, bool inherit) where T : Attribute;
+        public static bool IsDefined(this Assembly element, Type attributeType);
+        public static bool IsDefined(this MemberInfo element, Type attributeType);
+        public static bool IsDefined(this MemberInfo element, Type attributeType, bool inherit);
+        public static bool IsDefined(this Module element, Type attributeType);
+        public static bool IsDefined(this ParameterInfo element, Type attributeType);
+        public static bool IsDefined(this ParameterInfo element, Type attributeType, bool inherit);
+    }
+    public class CustomAttributeFormatException : FormatException {
+        public CustomAttributeFormatException();
+        public CustomAttributeFormatException(string message);
+        public CustomAttributeFormatException(string message, Exception inner);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct CustomAttributeNamedArgument {
+        public bool IsField { get; }
+        public string MemberName { get; }
+        public CustomAttributeTypedArgument TypedValue { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(CustomAttributeNamedArgument left, CustomAttributeNamedArgument right);
+        public static bool operator !=(CustomAttributeNamedArgument left, CustomAttributeNamedArgument right);
+        public override string ToString();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct CustomAttributeTypedArgument {
+        public Type ArgumentType { get; }
+        public object Value { get; }
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(CustomAttributeTypedArgument left, CustomAttributeTypedArgument right);
+        public static bool operator !=(CustomAttributeTypedArgument left, CustomAttributeTypedArgument right);
+        public override string ToString();
+    }
+    public enum DeclarativeSecurityAction : short {
+        Assert = (short)3,
+        Demand = (short)2,
+        Deny = (short)4,
+        InheritanceDemand = (short)7,
+        LinkDemand = (short)6,
+        None = (short)0,
+        PermitOnly = (short)5,
+        RequestMinimum = (short)8,
+        RequestOptional = (short)9,
+        RequestRefuse = (short)10,
+    }
+    public sealed class DefaultMemberAttribute : Attribute {
+        public DefaultMemberAttribute(string memberName);
+        public string MemberName { get; }
+    }
+    public abstract class DispatchProxy {
+        protected DispatchProxy();
+        public static T Create<T, TProxy>() where TProxy : DispatchProxy;
+        protected abstract object Invoke(MethodInfo targetMethod, object[] args);
+    }
+    public enum EventAttributes {
+        None = 0,
+        ReservedMask = 1024,
+        RTSpecialName = 1024,
+        SpecialName = 512,
+    }
+    public abstract class EventInfo : MemberInfo {
+        protected EventInfo();
+        public virtual MethodInfo AddMethod { get; }
+        public abstract EventAttributes Attributes { get; }
+        public virtual Type EventHandlerType { get; }
+        public virtual bool IsMulticast { get; }
+        public bool IsSpecialName { get; }
+        public override MemberTypes MemberType { get; }
+        public virtual MethodInfo RaiseMethod { get; }
+        public virtual MethodInfo RemoveMethod { get; }
+        public virtual void AddEventHandler(object target, Delegate handler);
+        public override bool Equals(object obj);
+        public MethodInfo GetAddMethod();
+        public abstract MethodInfo GetAddMethod(bool nonPublic);
+        public override int GetHashCode();
+        public MethodInfo GetRaiseMethod();
+        public abstract MethodInfo GetRaiseMethod(bool nonPublic);
+        public MethodInfo GetRemoveMethod();
+        public abstract MethodInfo GetRemoveMethod(bool nonPublic);
+        public virtual void RemoveEventHandler(object target, Delegate handler);
+    }
+    public static class EventInfoExtensions {
+        public static MethodInfo GetAddMethod(this EventInfo eventInfo);
+        public static MethodInfo GetAddMethod(this EventInfo eventInfo, bool nonPublic);
+        public static MethodInfo GetRaiseMethod(this EventInfo eventInfo);
+        public static MethodInfo GetRaiseMethod(this EventInfo eventInfo, bool nonPublic);
+        public static MethodInfo GetRemoveMethod(this EventInfo eventInfo);
+        public static MethodInfo GetRemoveMethod(this EventInfo eventInfo, bool nonPublic);
+    }
+    public enum FieldAttributes {
+        Assembly = 3,
+        FamANDAssem = 2,
+        Family = 4,
+        FamORAssem = 5,
+        FieldAccessMask = 7,
+        HasDefault = 32768,
+        HasFieldMarshal = 4096,
+        HasFieldRVA = 256,
+        InitOnly = 32,
+        Literal = 64,
+        NotSerialized = 128,
+        PinvokeImpl = 8192,
+        Private = 1,
+        PrivateScope = 0,
+        Public = 6,
+        ReservedMask = 38144,
+        RTSpecialName = 1024,
+        SpecialName = 512,
+        Static = 16,
+    }
+    public abstract class FieldInfo : MemberInfo {
+        protected FieldInfo();
+        public abstract FieldAttributes Attributes { get; }
+        public abstract RuntimeFieldHandle FieldHandle { get; }
+        public abstract Type FieldType { get; }
+        public bool IsAssembly { get; }
+        public bool IsFamily { get; }
+        public bool IsFamilyAndAssembly { get; }
+        public bool IsFamilyOrAssembly { get; }
+        public bool IsInitOnly { get; }
+        public bool IsLiteral { get; }
+        public bool IsNotSerialized { get; }
+        public bool IsPinvokeImpl { get; }
+        public bool IsPrivate { get; }
+        public bool IsPublic { get; }
+        public bool IsSpecialName { get; }
+        public bool IsStatic { get; }
+        public override MemberTypes MemberType { get; }
+        public override bool Equals(object obj);
+        public static FieldInfo GetFieldFromHandle(RuntimeFieldHandle handle);
+        public static FieldInfo GetFieldFromHandle(RuntimeFieldHandle handle, RuntimeTypeHandle declaringType);
+        public override int GetHashCode();
+        public virtual Type[] GetOptionalCustomModifiers();
+        public virtual object GetRawConstantValue();
+        public virtual Type[] GetRequiredCustomModifiers();
+        public abstract object GetValue(object obj);
+        public virtual void SetValue(object obj, object value);
+        public abstract void SetValue(object obj, object value, BindingFlags invokeAttr, Binder binder, CultureInfo culture);
+    }
+    public enum GenericParameterAttributes {
+        Contravariant = 2,
+        Covariant = 1,
+        DefaultConstructorConstraint = 16,
+        None = 0,
+        NotNullableValueTypeConstraint = 8,
+        ReferenceTypeConstraint = 4,
+        SpecialConstraintMask = 28,
+        VarianceMask = 3,
+    }
+    public interface ICustomAttributeProvider {
+        object[] GetCustomAttributes(bool inherit);
+        object[] GetCustomAttributes(Type attributeType, bool inherit);
+        bool IsDefined(Type attributeType, bool inherit);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct InterfaceMapping {
+        public MethodInfo[] InterfaceMethods;
+        public MethodInfo[] TargetMethods;
+        public Type InterfaceType;
+        public Type TargetType;
+    }
+    public static class IntrospectionExtensions {
+        public static TypeInfo GetTypeInfo(this Type type);
+    }
+    public class InvalidFilterCriteriaException : Exception {
+        public InvalidFilterCriteriaException();
+        public InvalidFilterCriteriaException(string message);
+        public InvalidFilterCriteriaException(string message, Exception inner);
+    }
+    public interface IReflect {
+        Type UnderlyingSystemType { get; }
+        FieldInfo GetField(string name, BindingFlags bindingAttr);
+        FieldInfo[] GetFields(BindingFlags bindingAttr);
+        MemberInfo[] GetMember(string name, BindingFlags bindingAttr);
+        MemberInfo[] GetMembers(BindingFlags bindingAttr);
+        MethodInfo GetMethod(string name, BindingFlags bindingAttr);
+        MethodInfo GetMethod(string name, BindingFlags bindingAttr, Binder binder, Type[] types, ParameterModifier[] modifiers);
+        MethodInfo[] GetMethods(BindingFlags bindingAttr);
+        PropertyInfo[] GetProperties(BindingFlags bindingAttr);
+        PropertyInfo GetProperty(string name, BindingFlags bindingAttr);
+        PropertyInfo GetProperty(string name, BindingFlags bindingAttr, Binder binder, Type returnType, Type[] types, ParameterModifier[] modifiers);
+        object InvokeMember(string name, BindingFlags invokeAttr, Binder binder, object target, object[] args, ParameterModifier[] modifiers, CultureInfo culture, string[] namedParameters);
+    }
+    public interface IReflectableType {
+        TypeInfo GetTypeInfo();
+    }
+    public class LocalVariableInfo {
+        protected LocalVariableInfo();
+        public virtual bool IsPinned { get; }
+        public virtual int LocalIndex { get; }
+        public virtual Type LocalType { get; }
+        public override string ToString();
+    }
+    public enum ManifestResourceAttributes {
+        Private = 2,
+        Public = 1,
+        VisibilityMask = 7,
+    }
+    public class ManifestResourceInfo {
+        public ManifestResourceInfo(Assembly containingAssembly, string containingFileName, ResourceLocation resourceLocation);
+        public virtual string FileName { get; }
+        public virtual Assembly ReferencedAssembly { get; }
+        public virtual ResourceLocation ResourceLocation { get; }
+    }
+    public delegate bool MemberFilter(MemberInfo m, object filterCriteria);
+    public abstract class MemberInfo : ICustomAttributeProvider {
+        protected MemberInfo();
+        public virtual IEnumerable<CustomAttributeData> CustomAttributes { get; }
+        public abstract Type DeclaringType { get; }
+        public abstract MemberTypes MemberType { get; }
+        public virtual int MetadataToken { get; }
+        public virtual Module Module { get; }
+        public abstract string Name { get; }
+        public abstract Type ReflectedType { get; }
+        public override bool Equals(object obj);
+        public abstract object[] GetCustomAttributes(bool inherit);
+        public abstract object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public override int GetHashCode();
+        public abstract bool IsDefined(Type attributeType, bool inherit);
+        object[] System.Reflection.ICustomAttributeProvider.GetCustomAttributes(bool inherit);
+        object[] System.Reflection.ICustomAttributeProvider.GetCustomAttributes(Type attributeType, bool inherit);
+        bool System.Reflection.ICustomAttributeProvider.IsDefined(Type attributeType, bool inherit);
+    }
+    public static class MemberInfoExtensions {
+        public static int GetMetadataToken(this MemberInfo member);
+        public static bool HasMetadataToken(this MemberInfo member);
+    }
+    public enum MemberTypes {
+        All = 191,
+        Constructor = 1,
+        Custom = 64,
+        Event = 2,
+        Field = 4,
+        Method = 8,
+        NestedType = 128,
+        Property = 16,
+        TypeInfo = 32,
+    }
+    public enum MethodAttributes {
+        Abstract = 1024,
+        Assembly = 3,
+        CheckAccessOnOverride = 512,
+        FamANDAssem = 2,
+        Family = 4,
+        FamORAssem = 5,
+        Final = 32,
+        HasSecurity = 16384,
+        HideBySig = 128,
+        MemberAccessMask = 7,
+        NewSlot = 256,
+        PinvokeImpl = 8192,
+        Private = 1,
+        PrivateScope = 0,
+        Public = 6,
+        RequireSecObject = 32768,
+        ReservedMask = 53248,
+        ReuseSlot = 0,
+        RTSpecialName = 4096,
+        SpecialName = 2048,
+        Static = 16,
+        UnmanagedExport = 8,
+        Virtual = 64,
+        VtableLayoutMask = 256,
+    }
+    public abstract class MethodBase : MemberInfo {
+        protected MethodBase();
+        public abstract MethodAttributes Attributes { get; }
+        public virtual CallingConventions CallingConvention { get; }
+        public virtual bool ContainsGenericParameters { get; }
+        public bool IsAbstract { get; }
+        public bool IsAssembly { get; }
+        public bool IsConstructor { get; }
+        public bool IsFamily { get; }
+        public bool IsFamilyAndAssembly { get; }
+        public bool IsFamilyOrAssembly { get; }
+        public bool IsFinal { get; }
+        public virtual bool IsGenericMethod { get; }
+        public virtual bool IsGenericMethodDefinition { get; }
+        public bool IsHideBySig { get; }
+        public bool IsPrivate { get; }
+        public bool IsPublic { get; }
+        public bool IsSpecialName { get; }
+        public bool IsStatic { get; }
+        public bool IsVirtual { get; }
+        public abstract RuntimeMethodHandle MethodHandle { get; }
+        public abstract MethodImplAttributes MethodImplementationFlags { get; }
+        public override bool Equals(object obj);
+        [MethodImpl(NoInlining)]public static MethodBase GetCurrentMethod();
+        public virtual Type[] GetGenericArguments();
+        public override int GetHashCode();
+        public static MethodBase GetMethodFromHandle(RuntimeMethodHandle handle);
+        public static MethodBase GetMethodFromHandle(RuntimeMethodHandle handle, RuntimeTypeHandle declaringType);
+        public abstract MethodImplAttributes GetMethodImplementationFlags();
+        public abstract ParameterInfo[] GetParameters();
+        public virtual object Invoke(object obj, object[] parameters);
+        public abstract object Invoke(object obj, BindingFlags invokeAttr, Binder binder, object[] parameters, CultureInfo culture);
+    }
+    public enum MethodImplAttributes {
+        AggressiveInlining = 256,
+        CodeTypeMask = 3,
+        ForwardRef = 16,
+        IL = 0,
+        InternalCall = 4096,
+        Managed = 0,
+        ManagedMask = 4,
+        MaxMethodImplVal = 65535,
+        Native = 1,
+        NoInlining = 8,
+        NoOptimization = 64,
+        OPTIL = 2,
+        PreserveSig = 128,
+        Runtime = 3,
+        Synchronized = 32,
+        Unmanaged = 4,
+    }
+    public enum MethodImportAttributes : short {
+        BestFitMappingDisable = (short)32,
+        BestFitMappingEnable = (short)16,
+        BestFitMappingMask = (short)48,
+        CallingConventionCDecl = (short)512,
+        CallingConventionFastCall = (short)1280,
+        CallingConventionMask = (short)1792,
+        CallingConventionStdCall = (short)768,
+        CallingConventionThisCall = (short)1024,
+        CallingConventionWinApi = (short)256,
+        CharSetAnsi = (short)2,
+        CharSetAuto = (short)6,
+        CharSetMask = (short)6,
+        CharSetUnicode = (short)4,
+        ExactSpelling = (short)1,
+        None = (short)0,
+        SetLastError = (short)64,
+        ThrowOnUnmappableCharDisable = (short)8192,
+        ThrowOnUnmappableCharEnable = (short)4096,
+        ThrowOnUnmappableCharMask = (short)12288,
+    }
+    public abstract class MethodInfo : MethodBase {
+        protected MethodInfo();
+        public override MemberTypes MemberType { get; }
+        public virtual ParameterInfo ReturnParameter { get; }
+        public virtual Type ReturnType { get; }
+        public abstract ICustomAttributeProvider ReturnTypeCustomAttributes { get; }
+        public virtual Delegate CreateDelegate(Type delegateType);
+        public virtual Delegate CreateDelegate(Type delegateType, object target);
+        public override bool Equals(object obj);
+        public abstract MethodInfo GetBaseDefinition();
+        public override Type[] GetGenericArguments();
+        public virtual MethodInfo GetGenericMethodDefinition();
+        public override int GetHashCode();
+        public virtual MethodInfo MakeGenericMethod(params Type[] typeArguments);
+    }
+    public static class MethodInfoExtensions {
+        public static MethodInfo GetBaseDefinition(this MethodInfo method);
+    }
+    public enum MethodSemanticsAttributes {
+        Adder = 8,
+        Getter = 2,
+        Other = 4,
+        Raiser = 32,
+        Remover = 16,
+        Setter = 1,
+    }
+    public sealed class Missing {
+        public static readonly Missing Value;
+    }
+    public abstract class Module : ICustomAttributeProvider {
+        public static readonly TypeFilter FilterTypeName;
+        public static readonly TypeFilter FilterTypeNameIgnoreCase;
+        protected Module();
+        public virtual Assembly Assembly { get; }
+        public virtual IEnumerable<CustomAttributeData> CustomAttributes { get; }
+        public virtual string FullyQualifiedName { get; }
+        public virtual int MetadataToken { get; }
+        public virtual Guid ModuleVersionId { get; }
+        public virtual string Name { get; }
+        public virtual string ScopeName { get; }
+        public override bool Equals(object o);
+        public virtual Type[] FindTypes(TypeFilter filter, object filterCriteria);
+        public virtual object[] GetCustomAttributes(bool inherit);
+        public virtual object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public FieldInfo GetField(string name);
+        public virtual FieldInfo GetField(string name, BindingFlags bindingAttr);
+        public FieldInfo[] GetFields();
+        public virtual FieldInfo[] GetFields(BindingFlags bindingFlags);
+        public override int GetHashCode();
+        public MethodInfo GetMethod(string name);
+        public MethodInfo GetMethod(string name, BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public MethodInfo GetMethod(string name, Type[] types);
+        protected virtual MethodInfo GetMethodImpl(string name, BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
+        public MethodInfo[] GetMethods();
+        public virtual MethodInfo[] GetMethods(BindingFlags bindingFlags);
+        public virtual Type GetType(string className);
+        public virtual Type GetType(string className, bool ignoreCase);
+        public virtual Type GetType(string className, bool throwOnError, bool ignoreCase);
+        public virtual Type[] GetTypes();
+        public virtual bool IsDefined(Type attributeType, bool inherit);
+        public FieldInfo ResolveField(int metadataToken);
+        public virtual FieldInfo ResolveField(int metadataToken, Type[] genericTypeArguments, Type[] genericMethodArguments);
+        public MethodBase ResolveMethod(int metadataToken);
+        public virtual MethodBase ResolveMethod(int metadataToken, Type[] genericTypeArguments, Type[] genericMethodArguments);
+        public virtual string ResolveString(int metadataToken);
+        public Type ResolveType(int metadataToken);
+        public virtual Type ResolveType(int metadataToken, Type[] genericTypeArguments, Type[] genericMethodArguments);
+        object[] System.Reflection.ICustomAttributeProvider.GetCustomAttributes(bool inherit);
+        object[] System.Reflection.ICustomAttributeProvider.GetCustomAttributes(Type attributeType, bool inherit);
+        bool System.Reflection.ICustomAttributeProvider.IsDefined(Type attributeType, bool inherit);
+        public override string ToString();
+    }
+    public static class ModuleExtensions {
+        public static Guid GetModuleVersionId(this Module module);
+        public static bool HasModuleVersionId(this Module module);
+    }
+    public enum ParameterAttributes {
+        HasDefault = 4096,
+        HasFieldMarshal = 8192,
+        In = 1,
+        Lcid = 4,
+        None = 0,
+        Optional = 16,
+        Out = 2,
+        Reserved3 = 16384,
+        Reserved4 = 32768,
+        ReservedMask = 61440,
+        Retval = 8,
+    }
+    public class ParameterInfo : ICustomAttributeProvider {
+        protected ParameterInfo();
+        public virtual ParameterAttributes Attributes { get; }
+        public virtual IEnumerable<CustomAttributeData> CustomAttributes { get; }
+        public virtual object DefaultValue { get; }
+        public virtual bool HasDefaultValue { get; }
+        public bool IsIn { get; }
+        public bool IsOptional { get; }
+        public bool IsOut { get; }
+        public bool IsRetval { get; }
+        public virtual MemberInfo Member { get; }
+        public virtual int MetadataToken { get; }
+        public virtual string Name { get; }
+        public virtual Type ParameterType { get; }
+        public virtual int Position { get; }
+        public virtual object RawDefaultValue { get; }
+        public virtual object[] GetCustomAttributes(bool inherit);
+        public virtual object[] GetCustomAttributes(Type attributeType, bool inherit);
+        public virtual Type[] GetOptionalCustomModifiers();
+        public virtual Type[] GetRequiredCustomModifiers();
+        public virtual bool IsDefined(Type attributeType, bool inherit);
+        object[] System.Reflection.ICustomAttributeProvider.GetCustomAttributes(bool inherit);
+        object[] System.Reflection.ICustomAttributeProvider.GetCustomAttributes(Type attributeType, bool inherit);
+        bool System.Reflection.ICustomAttributeProvider.IsDefined(Type attributeType, bool inherit);
+        public override string ToString();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ParameterModifier {
+        public ParameterModifier(int parameterCount);
+        public bool this[int index] { get; set; }
+    }
+    public enum ProcessorArchitecture {
+        Amd64 = 4,
+        Arm = 5,
+        IA64 = 3,
+        MSIL = 1,
+        None = 0,
+        X86 = 2,
+    }
+    public enum PropertyAttributes {
+        HasDefault = 4096,
+        None = 0,
+        Reserved2 = 8192,
+        Reserved3 = 16384,
+        Reserved4 = 32768,
+        ReservedMask = 62464,
+        RTSpecialName = 1024,
+        SpecialName = 512,
+    }
+    public abstract class PropertyInfo : MemberInfo {
+        protected PropertyInfo();
+        public abstract PropertyAttributes Attributes { get; }
+        public abstract bool CanRead { get; }
+        public abstract bool CanWrite { get; }
+        public virtual MethodInfo GetMethod { get; }
+        public bool IsSpecialName { get; }
+        public override MemberTypes MemberType { get; }
+        public abstract Type PropertyType { get; }
+        public virtual MethodInfo SetMethod { get; }
+        public override bool Equals(object obj);
+        public MethodInfo[] GetAccessors();
+        public abstract MethodInfo[] GetAccessors(bool nonPublic);
+        public virtual object GetConstantValue();
+        public MethodInfo GetGetMethod();
+        public abstract MethodInfo GetGetMethod(bool nonPublic);
+        public override int GetHashCode();
+        public abstract ParameterInfo[] GetIndexParameters();
+        public virtual Type[] GetOptionalCustomModifiers();
+        public virtual object GetRawConstantValue();
+        public virtual Type[] GetRequiredCustomModifiers();
+        public MethodInfo GetSetMethod();
+        public abstract MethodInfo GetSetMethod(bool nonPublic);
+        public object GetValue(object obj);
+        public virtual object GetValue(object obj, object[] index);
+        public abstract object GetValue(object obj, BindingFlags invokeAttr, Binder binder, object[] index, CultureInfo culture);
+        public void SetValue(object obj, object value);
+        public virtual void SetValue(object obj, object value, object[] index);
+        public abstract void SetValue(object obj, object value, BindingFlags invokeAttr, Binder binder, object[] index, CultureInfo culture);
+    }
+    public static class PropertyInfoExtensions {
+        public static MethodInfo[] GetAccessors(this PropertyInfo property);
+        public static MethodInfo[] GetAccessors(this PropertyInfo property, bool nonPublic);
+        public static MethodInfo GetGetMethod(this PropertyInfo property);
+        public static MethodInfo GetGetMethod(this PropertyInfo property, bool nonPublic);
+        public static MethodInfo GetSetMethod(this PropertyInfo property);
+        public static MethodInfo GetSetMethod(this PropertyInfo property, bool nonPublic);
+    }
+    public abstract class ReflectionContext {
+        protected ReflectionContext();
+        public virtual TypeInfo GetTypeForObject(object value);
+        public abstract Assembly MapAssembly(Assembly assembly);
+        public abstract TypeInfo MapType(TypeInfo type);
+    }
+    public sealed class ReflectionTypeLoadException : Exception {
+        public ReflectionTypeLoadException(Type[] classes, Exception[] exceptions);
+        public ReflectionTypeLoadException(Type[] classes, Exception[] exceptions, string message);
+        public Exception[] LoaderExceptions { get; }
+        public Type[] Types { get; }
+    }
+    public enum ResourceAttributes {
+        Private = 2,
+        Public = 1,
+    }
+    public enum ResourceLocation {
+        ContainedInAnotherAssembly = 2,
+        ContainedInManifestFile = 4,
+        Embedded = 1,
+    }
+    public static class RuntimeReflectionExtensions {
+        public static MethodInfo GetMethodInfo(this Delegate del);
+        public static MethodInfo GetRuntimeBaseDefinition(this MethodInfo method);
+        public static EventInfo GetRuntimeEvent(this Type type, string name);
+        public static IEnumerable<EventInfo> GetRuntimeEvents(this Type type);
+        public static FieldInfo GetRuntimeField(this Type type, string name);
+        public static IEnumerable<FieldInfo> GetRuntimeFields(this Type type);
+        public static InterfaceMapping GetRuntimeInterfaceMap(this TypeInfo typeInfo, Type interfaceType);
+        public static MethodInfo GetRuntimeMethod(this Type type, string name, Type[] parameters);
+        public static IEnumerable<MethodInfo> GetRuntimeMethods(this Type type);
+        public static IEnumerable<PropertyInfo> GetRuntimeProperties(this Type type);
+        public static PropertyInfo GetRuntimeProperty(this Type type, string name);
+    }
+    public class TargetException : Exception {
+        public TargetException();
+        public TargetException(string message);
+        public TargetException(string message, Exception inner);
+    }
+    public sealed class TargetInvocationException : Exception {
+        public TargetInvocationException(Exception inner);
+        public TargetInvocationException(string message, Exception inner);
+    }
+    public sealed class TargetParameterCountException : Exception {
+        public TargetParameterCountException();
+        public TargetParameterCountException(string message);
+        public TargetParameterCountException(string message, Exception inner);
+    }
+    public enum TypeAttributes {
+        Abstract = 128,
+        AnsiClass = 0,
+        AutoClass = 131072,
+        AutoLayout = 0,
+        BeforeFieldInit = 1048576,
+        Class = 0,
+        ClassSemanticsMask = 32,
+        CustomFormatClass = 196608,
+        CustomFormatMask = 12582912,
+        ExplicitLayout = 16,
+        HasSecurity = 262144,
+        Import = 4096,
+        Interface = 32,
+        LayoutMask = 24,
+        NestedAssembly = 5,
+        NestedFamANDAssem = 6,
+        NestedFamily = 4,
+        NestedFamORAssem = 7,
+        NestedPrivate = 3,
+        NestedPublic = 2,
+        NotPublic = 0,
+        Public = 1,
+        ReservedMask = 264192,
+        RTSpecialName = 2048,
+        Sealed = 256,
+        SequentialLayout = 8,
+        Serializable = 8192,
+        SpecialName = 1024,
+        StringFormatMask = 196608,
+        UnicodeClass = 65536,
+        VisibilityMask = 7,
+        WindowsRuntime = 16384,
+    }
+    public static class TypeExtensions {
+        public static ConstructorInfo GetConstructor(this Type type, Type[] types);
+        public static ConstructorInfo[] GetConstructors(this Type type);
+        public static ConstructorInfo[] GetConstructors(this Type type, BindingFlags bindingAttr);
+        public static MemberInfo[] GetDefaultMembers(this Type type);
+        public static EventInfo GetEvent(this Type type, string name);
+        public static EventInfo GetEvent(this Type type, string name, BindingFlags bindingAttr);
+        public static EventInfo[] GetEvents(this Type type);
+        public static EventInfo[] GetEvents(this Type type, BindingFlags bindingAttr);
+        public static FieldInfo GetField(this Type type, string name);
+        public static FieldInfo GetField(this Type type, string name, BindingFlags bindingAttr);
+        public static FieldInfo[] GetFields(this Type type);
+        public static FieldInfo[] GetFields(this Type type, BindingFlags bindingAttr);
+        public static Type[] GetGenericArguments(this Type type);
+        public static Type[] GetInterfaces(this Type type);
+        public static MemberInfo[] GetMember(this Type type, string name);
+        public static MemberInfo[] GetMember(this Type type, string name, BindingFlags bindingAttr);
+        public static MemberInfo[] GetMembers(this Type type);
+        public static MemberInfo[] GetMembers(this Type type, BindingFlags bindingAttr);
+        public static MethodInfo GetMethod(this Type type, string name);
+        public static MethodInfo GetMethod(this Type type, string name, BindingFlags bindingAttr);
+        public static MethodInfo GetMethod(this Type type, string name, Type[] types);
+        public static MethodInfo[] GetMethods(this Type type);
+        public static MethodInfo[] GetMethods(this Type type, BindingFlags bindingAttr);
+        public static Type GetNestedType(this Type type, string name, BindingFlags bindingAttr);
+        public static Type[] GetNestedTypes(this Type type, BindingFlags bindingAttr);
+        public static PropertyInfo[] GetProperties(this Type type);
+        public static PropertyInfo[] GetProperties(this Type type, BindingFlags bindingAttr);
+        public static PropertyInfo GetProperty(this Type type, string name);
+        public static PropertyInfo GetProperty(this Type type, string name, BindingFlags bindingAttr);
+        public static PropertyInfo GetProperty(this Type type, string name, Type returnType);
+        public static PropertyInfo GetProperty(this Type type, string name, Type returnType, Type[] types);
+        public static bool IsAssignableFrom(this Type type, Type c);
+        public static bool IsInstanceOfType(this Type type, object o);
+    }
+    public delegate bool TypeFilter(Type m, object filterCriteria);
+    public abstract class TypeInfo : MemberInfo, IReflectableType {
+        public abstract Assembly Assembly { get; }
+        public abstract string AssemblyQualifiedName { get; }
+        public abstract TypeAttributes Attributes { get; }
+        public abstract Type BaseType { get; }
+        public abstract bool ContainsGenericParameters { get; }
+        public virtual IEnumerable<ConstructorInfo> DeclaredConstructors { get; }
+        public virtual IEnumerable<EventInfo> DeclaredEvents { get; }
+        public virtual IEnumerable<FieldInfo> DeclaredFields { get; }
+        public virtual IEnumerable<MemberInfo> DeclaredMembers { get; }
+        public virtual IEnumerable<MethodInfo> DeclaredMethods { get; }
+        public virtual IEnumerable<TypeInfo> DeclaredNestedTypes { get; }
+        public virtual IEnumerable<PropertyInfo> DeclaredProperties { get; }
+        public abstract MethodBase DeclaringMethod { get; }
+        public abstract string FullName { get; }
+        public abstract GenericParameterAttributes GenericParameterAttributes { get; }
+        public abstract int GenericParameterPosition { get; }
+        public abstract Type[] GenericTypeArguments { get; }
+        public virtual Type[] GenericTypeParameters { get; }
+        public abstract Guid GUID { get; }
+        public bool HasElementType { get; }
+        public virtual IEnumerable<Type> ImplementedInterfaces { get; }
+        public bool IsAbstract { get; }
+        public bool IsAnsiClass { get; }
+        public bool IsArray { get; }
+        public bool IsAutoClass { get; }
+        public bool IsAutoLayout { get; }
+        public bool IsByRef { get; }
+        public bool IsClass { get; }
+        public virtual bool IsCOMObject { get; }
+        public abstract bool IsEnum { get; }
+        public bool IsExplicitLayout { get; }
+        public abstract bool IsGenericParameter { get; }
+        public abstract bool IsGenericType { get; }
+        public abstract bool IsGenericTypeDefinition { get; }
+        public bool IsImport { get; }
+        public bool IsInterface { get; }
+        public bool IsLayoutSequential { get; }
+        public bool IsMarshalByRef { get; }
+        public bool IsNested { get; }
+        public bool IsNestedAssembly { get; }
+        public bool IsNestedFamANDAssem { get; }
+        public bool IsNestedFamily { get; }
+        public bool IsNestedFamORAssem { get; }
+        public bool IsNestedPrivate { get; }
+        public bool IsNestedPublic { get; }
+        public bool IsNotPublic { get; }
+        public bool IsPointer { get; }
+        public virtual bool IsPrimitive { get; }
+        public bool IsPublic { get; }
+        public bool IsSealed { get; }
+        public abstract bool IsSerializable { get; }
+        public bool IsSpecialName { get; }
+        public bool IsUnicodeClass { get; }
+        public virtual bool IsValueType { get; }
+        public bool IsVisible { get; }
+        public override MemberTypes MemberType { get; }
+        public abstract string Namespace { get; }
+        public virtual StructLayoutAttribute StructLayoutAttribute { get; }
+        public ConstructorInfo TypeInitializer { get; }
+        public virtual Type UnderlyingSystemType { get; }
+        public virtual Type AsType();
+        public virtual Type[] FindInterfaces(TypeFilter filter, object filterCriteria);
+        public virtual MemberInfo[] FindMembers(MemberTypes memberType, BindingFlags bindingAttr, MemberFilter filter, object filterCriteria);
+        public abstract int GetArrayRank();
+        public ConstructorInfo GetConstructor(Type[] types);
+        public ConstructorInfo[] GetConstructors();
+        public virtual ConstructorInfo[] GetConstructors(BindingFlags bindingAttr);
+        public virtual EventInfo GetDeclaredEvent(string name);
+        public virtual FieldInfo GetDeclaredField(string name);
+        public virtual MethodInfo GetDeclaredMethod(string name);
+        public virtual IEnumerable<MethodInfo> GetDeclaredMethods(string name);
+        public virtual TypeInfo GetDeclaredNestedType(string name);
+        public virtual PropertyInfo GetDeclaredProperty(string name);
+        public virtual MemberInfo[] GetDefaultMembers();
+        public abstract Type GetElementType();
+        public virtual string GetEnumName(object value);
+        public virtual string[] GetEnumNames();
+        public virtual Type GetEnumUnderlyingType();
+        public virtual Array GetEnumValues();
+        public EventInfo GetEvent(string name);
+        public virtual EventInfo GetEvent(string name, BindingFlags bindingAttr);
+        public virtual EventInfo[] GetEvents();
+        public virtual EventInfo[] GetEvents(BindingFlags bindingAttr);
+        public FieldInfo GetField(string name);
+        public virtual FieldInfo GetField(string name, BindingFlags bindingAttr);
+        public FieldInfo[] GetFields();
+        public virtual FieldInfo[] GetFields(BindingFlags bindingAttr);
+        public virtual Type[] GetGenericArguments();
+        public abstract Type[] GetGenericParameterConstraints();
+        public abstract Type GetGenericTypeDefinition();
+        public Type GetInterface(string name);
+        public virtual Type GetInterface(string name, bool ignoreCase);
+        public virtual Type[] GetInterfaces();
+        public MemberInfo[] GetMember(string name);
+        public virtual MemberInfo[] GetMember(string name, BindingFlags bindingAttr);
+        public virtual MemberInfo[] GetMember(string name, MemberTypes type, BindingFlags bindingAttr);
+        public MemberInfo[] GetMembers();
+        public virtual MemberInfo[] GetMembers(BindingFlags bindingAttr);
+        public MethodInfo GetMethod(string name);
+        public MethodInfo GetMethod(string name, BindingFlags bindingAttr);
+        public MethodInfo GetMethod(string name, Type[] types);
+        public MethodInfo GetMethod(string name, Type[] types, ParameterModifier[] modifiers);
+        public MethodInfo[] GetMethods();
+        public virtual MethodInfo[] GetMethods(BindingFlags bindingAttr);
+        public Type GetNestedType(string name);
+        public virtual Type GetNestedType(string name, BindingFlags bindingAttr);
+        public Type[] GetNestedTypes();
+        public virtual Type[] GetNestedTypes(BindingFlags bindingAttr);
+        public PropertyInfo[] GetProperties();
+        public virtual PropertyInfo[] GetProperties(BindingFlags bindingAttr);
+        public PropertyInfo GetProperty(string name);
+        public PropertyInfo GetProperty(string name, BindingFlags bindingAttr);
+        public PropertyInfo GetProperty(string name, Type returnType);
+        public PropertyInfo GetProperty(string name, Type returnType, Type[] types);
+        public PropertyInfo GetProperty(string name, Type returnType, Type[] types, ParameterModifier[] modifiers);
+        public PropertyInfo GetProperty(string name, Type[] types);
+        public virtual bool IsAssignableFrom(TypeInfo typeInfo);
+        public virtual bool IsAssignableFrom(Type c);
+        public virtual bool IsEnumDefined(object value);
+        public virtual bool IsEquivalentTo(Type other);
+        public virtual bool IsInstanceOfType(object o);
+        public virtual bool IsSubclassOf(Type c);
+        public abstract Type MakeArrayType();
+        public abstract Type MakeArrayType(int rank);
+        public abstract Type MakeByRefType();
+        public abstract Type MakeGenericType(params Type[] typeArguments);
+        public abstract Type MakePointerType();
+        TypeInfo System.Reflection.IReflectableType.GetTypeInfo();
+    }
+}
```

