# System.Runtime.CompilerServices

``` diff
 namespace System.Runtime.CompilerServices {
+    public struct AsyncValueTaskMethodBuilder {
+        public ValueTask Task { get; }
+        public void AwaitOnCompleted<TAwaiter, TStateMachine>(ref TAwaiter awaiter, ref TStateMachine stateMachine) where TAwaiter : INotifyCompletion where TStateMachine : IAsyncStateMachine;
+        public void AwaitUnsafeOnCompleted<TAwaiter, TStateMachine>(ref TAwaiter awaiter, ref TStateMachine stateMachine) where TAwaiter : ICriticalNotifyCompletion where TStateMachine : IAsyncStateMachine;
+        public static AsyncValueTaskMethodBuilder Create();
+        public void SetException(Exception exception);
+        public void SetResult();
+        public void SetStateMachine(IAsyncStateMachine stateMachine);
+        public void Start<TStateMachine>(ref TStateMachine stateMachine) where TStateMachine : IAsyncStateMachine;
+    }
-    public struct ConfiguredTaskAwaitable {
+    public readonly struct ConfiguredTaskAwaitable {
-        public struct ConfiguredTaskAwaiter : ICriticalNotifyCompletion, INotifyCompletion
+        public readonly struct ConfiguredTaskAwaiter : ICriticalNotifyCompletion, INotifyCompletion
     }
-    public struct ConfiguredTaskAwaitable<TResult> {
+    public readonly struct ConfiguredTaskAwaitable<TResult> {
-        public struct ConfiguredTaskAwaiter : ICriticalNotifyCompletion, INotifyCompletion
+        public readonly struct ConfiguredTaskAwaiter : ICriticalNotifyCompletion, INotifyCompletion
     }
+    public readonly struct ConfiguredValueTaskAwaitable {
+        public ConfiguredValueTaskAwaitable.ConfiguredValueTaskAwaiter GetAwaiter();
+        public readonly struct ConfiguredValueTaskAwaiter : ICriticalNotifyCompletion, INotifyCompletion {
+            public bool IsCompleted { get; }
+            public void GetResult();
+            public void OnCompleted(Action continuation);
+            public void UnsafeOnCompleted(Action continuation);
+        }
+    }
-    public struct ConfiguredValueTaskAwaitable<TResult> {
+    public readonly struct ConfiguredValueTaskAwaitable<TResult> {
-        public struct ConfiguredValueTaskAwaiter : ICriticalNotifyCompletion, INotifyCompletion
+        public readonly struct ConfiguredValueTaskAwaiter : ICriticalNotifyCompletion, INotifyCompletion
     }
     public static class RuntimeFeature {
+        public const string PortablePdb = "PortablePdb";
     }
     public sealed class RuntimeWrappedException : Exception {
+        public RuntimeWrappedException(object thrownObject);
     }
-    public struct TaskAwaiter : ICriticalNotifyCompletion, INotifyCompletion
+    public readonly struct TaskAwaiter : ICriticalNotifyCompletion, INotifyCompletion
-    public struct TaskAwaiter<TResult> : ICriticalNotifyCompletion, INotifyCompletion
+    public readonly struct TaskAwaiter<TResult> : ICriticalNotifyCompletion, INotifyCompletion
+    public readonly struct ValueTaskAwaiter : ICriticalNotifyCompletion, INotifyCompletion {
+        public bool IsCompleted { get; }
+        public void GetResult();
+        public void OnCompleted(Action continuation);
+        public void UnsafeOnCompleted(Action continuation);
+    }
-    public struct ValueTaskAwaiter<TResult> : ICriticalNotifyCompletion, INotifyCompletion
+    public readonly struct ValueTaskAwaiter<TResult> : ICriticalNotifyCompletion, INotifyCompletion
-    public struct YieldAwaitable {
+    public readonly struct YieldAwaitable {
-        public struct YieldAwaiter : ICriticalNotifyCompletion, INotifyCompletion
+        public readonly struct YieldAwaiter : ICriticalNotifyCompletion, INotifyCompletion
     }
 }
```

