# .NET Core 2.1.0-rc1

.NET Core 2.1.0-rc1 comprises:

* .NET Core Runtime 2.1.0-rc1
* .NET Core SDK 2.1.300-rc1-008673

|         | SDK Installer                                         | SDK Binaries                                                         | Runtime Installer                                                  | Runtime Binaries                                                   | ASP.NET Core Rutime |
| ------- | :---------------------------------------------------: | :-------------------------------------------------------------------:| :----------------------------------------------------------------: | :----------------------------------------------------------------: | :---: |
| Windows | [32-bit](https://download.microsoft.com/download/B/1/9/B19A2F87-F00F-420C-B4B9-A0BA4403F754/dotnet-sdk-2.1.300-rc1-008673-win-x86.exe) / [64-bit](https://download.microsoft.com/download/B/1/9/B19A2F87-F00F-420C-B4B9-A0BA4403F754/dotnet-sdk-2.1.300-rc1-008673-win-x64.exe)  | [32-bit](https://download.microsoft.com/download/B/1/9/B19A2F87-F00F-420C-B4B9-A0BA4403F754/dotnet-sdk-2.1.300-rc1-008673-win-x86.zip) / [64-bit](https://download.microsoft.com/download/B/1/9/B19A2F87-F00F-420C-B4B9-A0BA4403F754/dotnet-sdk-2.1.300-rc1-008673-win-x64.zip) | [32-bit](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/dotnet-runtime-2.1.0-rc1-win-x86.exe) / [64-bit](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/dotnet-runtime-2.1.0-rc1-win-x64.exe) | [32-bit](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/dotnet-runtime-2.1.0-rc1-win-x86.zip) / [64-bit](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/dotnet-runtime-2.1.0-rc1-win-x64.zip) | - |
| macOS   | [64-bit](https://download.microsoft.com/download/B/1/9/B19A2F87-F00F-420C-B4B9-A0BA4403F754/dotnet-sdk-2.1.300-rc1-008673-osx-x64.pkg)  | [64-bit](https://download.microsoft.com/download/B/1/9/B19A2F87-F00F-420C-B4B9-A0BA4403F754/dotnet-sdk-2.1.300-rc1-008673-osx-x64.tar.gz)| [64-bit](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/dotnet-runtime-2.1.0-rc1-osx-x64.pkg)      | [64-bit](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/dotnet-runtime-2.1.0-rc1-osx-x64.tar.gz)   | - |
| Linux * | See installations steps below                         | [64-bit](https://download.microsoft.com/download/B/1/9/B19A2F87-F00F-420C-B4B9-A0BA4403F754/dotnet-sdk-2.1.300-rc1-008673-linux-x64.tar.gz)     | See installations steps below   | [64-bit](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/dotnet-runtime-2.1.0-rc1-linux-x64.tar.gz) | - |
| RHEL6   | -                         | [64-bit](http://download.microsoft.com/download/B/1/9/B19A2F87-F00F-420C-B4B9-A0BA4403F754/dotnet-sdk-2.1.300-rc1-008673-rhel.6-x64.tar.gz)     | -   | [64-bit](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/dotnet-runtime-2.1.0-rc1-rhel.6-x64.tar.gz) | - |
| Linux ARM (glibc) | -                         | [32-bit](https://download.microsoft.com/download/B/1/9/B19A2F87-F00F-420C-B4B9-A0BA4403F754/dotnet-sdk-2.1.300-rc1-008673-linux-arm.tar.gz) / [64-bit](https://download.microsoft.com/download/B/1/9/B19A2F87-F00F-420C-B4B9-A0BA4403F754/dotnet-sdk-2.1.300-rc1-008673-linux-arm64.tar.gz) | - | [32-bit](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/dotnet-runtime-2.1.0-rc1-linux-arm.tar.gz) / [64-bit](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/dotnet-runtime-2.1.0-rc1-linux-arm64.tar.gz) | [32-bit](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/aspnetcore-runtime-2.1.0-rc1-final-linux-arm.tar.gz) |
| Linux ARM (musl) | -                         | [64-bit](https://download.microsoft.com/download/B/1/9/B19A2F87-F00F-420C-B4B9-A0BA4403F754/dotnet-sdk-2.1.300-rc1-008673-linux-musl-x64.tar.gz)     | - | [64-bit](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/dotnet-runtime-2.1.0-rc1-linux-musl-x64.tar.gz) | [64-bit](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/aspnetcore-runtime-2.1.0-rc1-final-linux-musl-x64.tar.gz) |
| Windows ARM | -                         | - | - | [32-bit](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/dotnet-runtime-2.1.0-rc1-win-arm.zip) / [64-bit](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/dotnet-runtime-2.1.0-rc1-win-arm64.zip) | - |

**Checksum** files to verify downloads are available as follows:
* [Checksums_Runtime](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1-rc1-runtime-sha.txt)
* [Checksums_SDK](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1-rc1-sdk-sha.txt)

**Debug Symbols**
* [Runtime](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/coreclr-2.1-rc1-symbols.zip)
* [Shared Framework](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/corefx-2.1-rc1-symbols.zip)
* [Core-Setup](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/core-setup-2.1-rc1-symbols.zip)

## Docker

Images for .NET Core 2.1.0-rc1 are available on [Docker](https://hub.docker.com/r/microsoft/dotnet/).
## Installing .NET Core on Linux

### Uninstall any Preview versions

If you have previous .NET Core Previews or daily builds installed, these to be removed before attempting to install .NET Core 2.1. This can be done by running a command such as the following.

`sudo apt remove 2.1.300-preview2-008530`

### Ubuntu and Debian based systems

Register the Microsoft key, the product repository for your distro and install required system dependencies with the following scripts.

#### Ubuntu 18.04

```bash
wget -qO- https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor > microsoft.asc.gpg
sudo mv microsoft.asc.gpg /etc/apt/trusted.gpg.d/
wget -q https://packages.microsoft.com/config/ubuntu/18.04/prod.list
sudo mv prod.list /etc/apt/sources.list.d/microsoft-prod.list
```

#### Ubuntu 17.10

```bash
wget -q packages-microsoft-prod.deb https://packages.microsoft.com/config/ubuntu/17.10/packages-microsoft-prod.deb
sudo dpkg -i packages-microsoft-prod.deb
```

#### Ubuntu 16.04

```bash
wget -q packages-microsoft-prod.deb https://packages.microsoft.com/config/ubuntu/16.04/packages-microsoft-prod.deb
sudo dpkg -i packages-microsoft-prod.deb
```

#### Ubuntu 14.04

```bash
wget -q packages-microsoft-prod.deb https://packages.microsoft.com/config/ubuntu/14.04/packages-microsoft-prod.deb
sudo dpkg -i packages-microsoft-prod.deb
```

#### Debian 9

```bash
wget -qO- https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor > microsoft.asc.gpg
sudo mv microsoft.asc.gpg /etc/apt/trusted.gpg.d/
wget -q https://packages.microsoft.com/config/debian/9/prod.list
sudo mv prod.list /etc/apt/sources.list.d/microsoft-prod.list
```

#### Debian 8

```bash
wget -qO- https://packages.microsoft.com/keys/microsoft.asc | gpg --dearmor > microsoft.asc.gpg
sudo mv microsoft.asc.gpg /etc/apt/trusted.gpg.d/
wget -q https://packages.microsoft.com/config/debian/8/prod.list
sudo mv prod.list /etc/apt/sources.list.d/microsoft-prod.list
 ```

Then, update the package cache and install .NET Core

```bash
sudo apt-get install apt-transport-https
sudo apt-get update
sudo apt-get install dotnet-sdk-2.1.300-rc1-008673
```

### RHEL and Fedora based systems

Register the Microsoft key, the product repository for your distro and install required system dependencies with the following scripts.

#### Red Hat, CentOS, Oracle Linux

```bash
sudo rpm -Uvh https://packages.microsoft.com/config/rhel/7/packages-microsoft-prod.rpm
```

#### Fedora 27
 
```bash
sudo rpm --import https://packages.microsoft.com/keys/microsoft.asc
wget -q https://packages.microsoft.com/config/fedora/27/prod.repo
sudo mv prod.repo /etc/yum.repos.d/microsoft-prod.repo
```
 
Then, update the package cache and install .NET Core
 
#### Fedora 26
 
```bash
sudo rpm --import https://packages.microsoft.com/keys/microsoft.asc
wget -q https://packages.microsoft.com/config/fedora/26/prod.repo
sudo mv prod.repo /etc/yum.repos.d/microsoft-prod.repo
```
 
Then, update the package cache and install .NET Core
 
### SUSE Enterprise Linux, OpenSUSE
 
#### SUSE Enterprise Linux
 
```bash
sudo rpm -Uvh https://packages.microsoft.com/config/sles/12/packages-microsoft-prod.rpm
```
 
#### OpenSUSE
 
```bash
sudo rpm --import https://packages.microsoft.com/keys/microsoft.asc
wget -q https://packages.microsoft.com/config/opensuse/42.2/prod.repo
sudo mv prod.repo /etc/zypp/repos.d/microsoft-prod.repo
```
 
Then, update the package cache and install .NET Core
 
#### Fedora, CentOS and Oracle Linux

```bash
sudo yum update
sudo yum install dotnet-sdk-2.1.300-rc1-008673
```

#### SUSE Enterprise Linux and OpenSUSE

```bash
sudo zypper update
sudo zypper install dotnet-sdk-2.1.300-rc1-008673
```

## Installation from a binary archive

Installing from the packages detailed above is recommended and you can also install from binary archive. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet` and a symbolic link created for `dotnet`.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.1.0-rc1` using your package manager.

## Server Hosting

If you are looking to host stand-alone apps on Servers, the following installers can be used on Windows and Linx systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:
[dotnet-hosting-2.1.0-rc1-final-win.exe](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/dotnet-hosting-2.1.0-rc1-final-win.exe)
This will install the ASP.NET Core Module for IIS

### Linux

On supported Linux systems, register the Microsoft Product feed as described above and install `dotnet-hosting-2.1.0-rc1-final` using your package manager.
This will also install the .NET Core Runtime and other required packages.

### ASP.NET Core Runtime

The ASP.NET Core Runtime is installed by the .NET Core SDK and the Windows Server Hosting installer. If you need to install the ASP.NET Runtime separately, the following can be used.

* [aspnetcore-runtime-2.1.0-rc1-final-win-x64.exe](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/aspnetcore-runtime-2.1.0-rc1-final-win-x64.exe)
* [aspnetcore-runtime-2.1.0-rc1-final-win-x86.exe](https://download.microsoft.com/download/D/0/B/D0B7F62D-9C5D-4CF3-AB6C-88F56B4FC1A9/aspnetcore-runtime-2.1.0-rc1-final-win-x86.exe)

On Linux systems install `aspnetcore-runtime-2.1.0-rc1-final` using your package manager. This will install both the ASP.NET Core and .NET Core runtime components.
