% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autocut.R
\name{Autocut}
\alias{Autocut}
\title{Autocut}
\description{
An algorithm to determine grass cut dates if none are provided.
This is an abstract class and not intended for direct use. Instead, use
its subclasses that implement a \code{determine_cut()} method.

The expected number of cuts is estimated from management intensity and
site altitude based on data for Swiss grasslands by Huguenin et al.
}
\references{
\insertRef{huguenin2017GrundlagenDuengung}{growR}
}
\seealso{
\link{management_parameters}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{MVS}}{The \link{ModvegeSite} object for which to take the cut decision.}

\item{\code{n_cuts}}{Number of cuts expected for this altitude and management
intensity.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Autocut-new}{\code{Autocut$new()}}
\item \href{#method-Autocut-get_expected_n_cuts}{\code{Autocut$get_expected_n_cuts()}}
\item \href{#method-Autocut-determine_cut}{\code{Autocut$determine_cut()}}
\item \href{#method-Autocut-clone}{\code{Autocut$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Autocut-new"></a>}}
\if{latex}{\out{\hypertarget{method-Autocut-new}{}}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Autocut$new(MVS)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{MVS}}{The \link{ModvegeSite} object for which cuts shall be
determined.

Get number of expected cuts

Return the number of expected cuts for a site at a given \emph{elevation} and
management \emph{intensity}.

This uses data.frame \code{management_parameters} as a lookup table and
interpolates linearly in between the specified values.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Autocut-get_expected_n_cuts"></a>}}
\if{latex}{\out{\hypertarget{method-Autocut-get_expected_n_cuts}{}}}
\subsection{Method \code{get_expected_n_cuts()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Autocut$get_expected_n_cuts(elevation, intensity = "high")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{elevation}}{The elevation of the considered site in meters above sea
level.}

\item{\code{intensity}}{One of ("high", "middle", "low", "extensive"). Management
intensity for considered site.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Number of expected cuts per season.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Autocut-determine_cut"></a>}}
\if{latex}{\out{\hypertarget{method-Autocut-determine_cut}{}}}
\subsection{Method \code{determine_cut()}}{
Empty method stub intended for overriding by inheriting subclasses.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Autocut$determine_cut(DOY)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{DOY}}{Integer day-of-the-year.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Autocut-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Autocut-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Autocut$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
