% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modvegesite.R
\name{ModvegeSite}
\alias{ModvegeSite}
\title{ModvegeSite}
\description{
Implements the ModVege grass growth model based off of Jouven et al. (2006).

This class contains model and site parameters and state variables as
attributes and has methods for running ModVege with weather and management
input.

Use the \code{run()} method to carry out a simulation for a given year. The
results are stored in the state variables in this instance and can be written
to file using \code{write_output()}.
}
\section{Model variables}{
See Jouven et al. (2006) for a thorough description of all model variables.
\subsection{State Variables}{
\itemize{
\item \code{BM}
Standing biomass in kg DM per ha.
\item \code{BMG}
Standing green biomass (kg DM / ha).
\item \code{cBM}
Cumulativeley grown biomass (kg DM / ha).
\item \code{dBM}
Daily grown biomass (kg DM / ha).
\item \code{hvBM}
Cumulative harvested biomass (kg DM / ha).
\item \code{OMD}
Organic matter digestibility (kg / kg).
\item \code{OMDG}
OMD of green matter (kg / kg).
\item \code{ST}
Temperature sum in degree Celsius days.
\item \code{REP} Reproductive function. Gives the fraction of growth that is
assigned to reproductive growth. The remainder goes into vegetative growth.
Dimensionless.
\item \code{PGRO}
Potential growth in kg DM / ha.
\item \code{GRO}
Effective growth in kg DM / ha.
\item \code{LAI}
Leaf area index, accounting for the proportion of light intercepted by the
sward. Dimensionless.
\item \code{LAIGV}
LAI of green vegetative biomass. Dimensionless.
\item \code{AET}
Actual evapotranspiration in mm.
\item \code{WR}
Water reserves in mm.
\item \code{ENV}
Function representing environmental effects on growth. Acts as a
multiplicative factor. Dimensionless.
\item \code{ENVfPAR}
Part of ENV due to strength of incident radiation. Dimensionless.
\item \code{ENVfT}
Part of ENV due to temperature. Dimensionless.
\item \code{ENVfW}
Part of ENV due to water limitation. Dimensionless.
}
}

\subsection{Initial conditions}{
\itemize{
\item \code{AgeGV} Age of green vegetative matter in degree Celsius days.
\item \code{AgeGR} Age of green reproductive matter in degree Celsius days.
\item \code{AgeDV} Age of dead vegetative matter in degree Celsius days.
\item \code{AgeDR} Age of dead reproductive matter in degree Celsius days.
\item \code{BMGV} biomass of GV (kg DM per ha).
\item \code{BMGR} biomass of GR (kg DM per ha).
\item \code{BMDV} biomass of DV (kg DM per ha).
\item \code{BMDR} biomass of DR (kg DM per ha).
\item \code{BMDR} biomass of DR (kg DM per ha).
\item \code{SENG} senescence of GV (kg DM per ha).
\item \code{SENG} senescence of GR (kg DM per ha).
\item \code{ABSG} abscission of DV (kg DM per ha).
\item \code{ABSG} abscission of DR (kg DM per ha).
\item \code{ST} thermal time (degree days).
\item \code{cBM} cumulative total biomass (kg per ha).
}
}
}

\references{
\insertRef{jouven2006ModelPredictingDynamics}{growR}
}
\seealso{
\link[=Autocut]{Autocut}

\code{\link[=start_of_growing_season_mtd]{start_of_growing_season_mtd()}}, \code{\link[=start_of_growing_season]{start_of_growing_season()}}

\code{ModvegeParameters$set_parameters()}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{time_step}}{Used time step in the model in days (untested).}

\item{\code{state_variable_names}}{Vector containing the names of the model's
state variables.}

\item{\code{n_state_variables}}{Number of state variables.}

\item{\code{version}}{Version number of the growR package. Is written into
output files.}

\item{\code{site_name}}{Name of the site to be simulated.}

\item{\code{run_name}}{Name of the simulation run. Used to distinguish between
different runs at the same site.}

\item{\code{year}}{Year to be simulated.}

\item{\code{days_per_year}}{Number of days in this year.}

\item{\code{j_start_of_growing_season}}{Index (DOY) of the day the growing season
was determined to begin.}

\item{\code{cut_height}}{Height of remaining grass after cut in m.}

\item{\code{parameters}}{A \link{ModvegeParameters} object.}

\item{\code{determine_cut}}{Function used to decide whether a cut occurs on a
given DOY. Is overloaded depending on whether management data is
provided or not.}

\item{\code{cut_DOYs}}{List of DOYs on which a cut occurred.}

\item{\code{cut_during_growth_preriod}}{Boolean to indicate whether a cut
occurred during the growth period, in which case reproductive growth is
stopped.}

\item{\code{BM_after_cut}}{Amount of biomass that remains after a cut #'
(determined through cut_height and biomass densities BDGV, BDDV, BDGR,
BDDR).}

\item{\code{weather}}{A list created by a \link{WeatherData} object's
\code{get_weather_for_year()} method.}

\item{\code{management}}{A list containing management data as returned by
\link{ModvegeEnvironment}'s \code{get_environment_for_year()} method. If its
\code{is_empty} field is \code{TRUE}, the \link{Autocut} routine will be employed.}

\item{\code{Autocut}}{A subclass of \link{Autocut}. The algorithm used to determine
cut events.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ModvegeSite-new}{\code{ModvegeSite$new()}}
\item \href{#method-ModvegeSite-get_weather}{\code{ModvegeSite$get_weather()}}
\item \href{#method-ModvegeSite-get_management}{\code{ModvegeSite$get_management()}}
\item \href{#method-ModvegeSite-set_SGS_method}{\code{ModvegeSite$set_SGS_method()}}
\item \href{#method-ModvegeSite-determine_cut_from_input}{\code{ModvegeSite$determine_cut_from_input()}}
\item \href{#method-ModvegeSite-run}{\code{ModvegeSite$run()}}
\item \href{#method-ModvegeSite-write_output}{\code{ModvegeSite$write_output()}}
\item \href{#method-ModvegeSite-set_parameters}{\code{ModvegeSite$set_parameters()}}
\item \href{#method-ModvegeSite-plot}{\code{ModvegeSite$plot()}}
\item \href{#method-ModvegeSite-plot_bm}{\code{ModvegeSite$plot_bm()}}
\item \href{#method-ModvegeSite-plot_limitations}{\code{ModvegeSite$plot_limitations()}}
\item \href{#method-ModvegeSite-plot_water}{\code{ModvegeSite$plot_water()}}
\item \href{#method-ModvegeSite-plot_growth}{\code{ModvegeSite$plot_growth()}}
\item \href{#method-ModvegeSite-plot_var}{\code{ModvegeSite$plot_var()}}
\item \href{#method-ModvegeSite-clone}{\code{ModvegeSite$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeSite-new"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeSite-new}{}}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeSite$new(parameters, site_name = "-", run_name = "-")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parameters}}{A \link{ModvegeParameters} object.}

\item{\code{site_name}}{string Name of the simulated site.}

\item{\code{run_name}}{string Name of the simulation run. Used to
differentiate between different simulation conditions at the same site.
Defaults to "-", which indicates no specific run name.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeSite-get_weather"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeSite-get_weather}{}}}
\subsection{Method \code{get_weather()}}{
Return weather data if it exists
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeSite$get_weather()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The WeatherData object, if it exists.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeSite-get_management"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeSite-get_management}{}}}
\subsection{Method \code{get_management()}}{
Return management data if it exists
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeSite$get_management()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The ManagementData object, if it exists.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeSite-set_SGS_method"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeSite-set_SGS_method}{}}}
\subsection{Method \code{set_SGS_method()}}{
Choose which method to be used for determination of SGS

Options for the determination of the start of growing season (SGS) are:
\describe{
\item{MTD}{Multicriterial thermal definition,
\code{\link[=start_of_growing_season_mtd]{start_of_growing_season_mtd()}}}
\item{simple}{Commonly used, simple SGS definition based on
temperature sum, \code{\link[=start_of_growing_season]{start_of_growing_season()}}}
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeSite$set_SGS_method(method)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{str Name of the method to use. Options: "MTD", "simple".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
none
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeSite-determine_cut_from_input"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeSite-determine_cut_from_input}{}}}
\subsection{Method \code{determine_cut_from_input()}}{
Read from the input whether a cut occurs on day \emph{DOY}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeSite$determine_cut_from_input(DOY)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{DOY}}{Integer day of the year for which to check.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Boolean \code{TRUE} if a cut happens on day \emph{DOY}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeSite-run"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeSite-run}{}}}
\subsection{Method \code{run()}}{
Carry out a ModVege simulation for one year.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeSite$run(year, weather, management)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{year}}{Integer specifying the year to consider.}

\item{\code{weather}}{Weather list for given year as returned by
\link{WeatherData}\verb{$get_weather_for_year}.}

\item{\code{management}}{Management list for given year as provided by
\link{ModvegeEnvironment}\verb{$get_environment_for_year()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None Fills the state variables of this instance with the
simulated values. Access them programmatically or write them to
file using \code{write_output()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeSite-write_output"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeSite-write_output}{}}}
\subsection{Method \code{write_output()}}{
Write values of ModVege results into given file.

A header with metadata is prepended to the actual data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeSite$write_output(filename, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{Path or name of filename to be created or overwritten.}

\item{\code{force}}{Boolean If \code{TRUE}, do not prompt user before writing.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None Writes simulation results to file \emph{filename}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeSite-set_parameters"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeSite-set_parameters}{}}}
\subsection{Method \code{set_parameters()}}{
Savely update the values in \code{self$parameters}.

This is just a shorthand to the underlying \code{ModvegeParameters}
object's \code{set_parameters()} function. Special care is taken to
account for potential changes to functional group weights.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeSite$set_parameters(params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{List of name-value pairs of the parameters to update.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None Updates this object's parameter values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeSite-plot"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeSite-plot}{}}}
\subsection{Method \code{plot()}}{
Create an overview plot for 16 state variables.

Creates a simple base R plot showing the temporal evolution of 16
modeled state variables.

Can only be sensibly run \emph{after} a simulation has been carried out,
i.e. after this instance's \code{run()} method has been called.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeSite$plot(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Further arguments are discarded.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL Creates a plot of the result in the active device.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeSite-plot_bm"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeSite-plot_bm}{}}}
\subsection{Method \code{plot_bm()}}{
Create an overview plot for biomass.

Creates a simple base R plot showing the BM with cutting events and,
if applicable, target biomass, dBM, cBM and hvBM.
Can only be sensibly run \emph{after} a simulation has been carried out,
i.e. after this instance's \code{run()} method has been called.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeSite$plot_bm(smooth_interval = 28, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{smooth_interval}}{Int. Number of days over which the variable
\code{dBM} is smoothened.}

\item{\code{...}}{Further arguments are discarded.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL Creates a plot of the result in the active device.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeSite-plot_limitations"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeSite-plot_limitations}{}}}
\subsection{Method \code{plot_limitations()}}{
Create an overview plot of limiting factors.

Creates a simple base R plot showing the different environmental
limitation functions over time.
Can only be sensibly run \emph{after} a simulation has been carried out,
i.e. after this instance's \code{run()} method has been called.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeSite$plot_limitations(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Further arguments are discarded.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL Creates a plot of the result in the active device.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeSite-plot_water"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeSite-plot_water}{}}}
\subsection{Method \code{plot_water()}}{
Create an overview plot of the water balance.

Creates a simple base R plot showing different variables pertaining to
the water balance, namely water reserves \emph{WR}, actual
evapotranspiration \emph{AET}, leaf area index \emph{LAI} and LAI of the green
vegetative compartment \emph{LAIGV}.

Can only be sensibly run \emph{after} a simulation has been carried out,
i.e. after this instance's \code{run()} method has been called.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeSite$plot_water(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Further arguments are discarded.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL Creates a plot of the result in the active device.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeSite-plot_growth"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeSite-plot_growth}{}}}
\subsection{Method \code{plot_growth()}}{
Create an overview plot of growth dynamics.

Creates a simple base R plot showing different variables pertaining to
the growth dynamics, namely potential growth \emph{PGRO}, effective
growth \emph{GRO}, the reproductive function \emph{REP} and the temperature
sum \emph{ST}.

Can only be sensibly run \emph{after} a simulation has been carried out,
i.e. after this instance's \code{run()} method has been called.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeSite$plot_growth(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Further arguments are discarded.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL Creates a plot of the result in the active device.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeSite-plot_var"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeSite-plot_var}{}}}
\subsection{Method \code{plot_var()}}{
Plot the temporal evolution of a modeled state variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeSite$plot_var(var, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{var}}{String. Name of the state variable to plot.}

\item{\code{...}}{Further arguments are passed to the base \code{\link[=plot]{plot()}} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None, but plots to the current device.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeSite-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeSite-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeSite$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
