% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autocut.R
\name{PetersenAutocut}
\alias{PetersenAutocut}
\title{Petersen autocut algorithm}
\description{
Simulation routine to realistically predict grass cutting events.
This follows an implementation described in Petersen et al. (2021).
}
\details{
The decision to cut is made based on two criteria.
First, it is checked whether a \emph{target biomass} is reached on given
DOY. The defined target depends on the DOY and is given through
:func:\code{get_target_biomass}. If said biomass is present, return \code{TRUE}.

Otherwise, it is checked whether a given amount of time has passed
since the last cut. Depending on whether this is the first cut of
the season or not, the relevant parameters are
:int:\code{last_DOY_for_initial_cut} and :int:\code{max_cut_period}.
If that amount of time has passed, return \code{TRUE}, otherwise return
\code{FALSE}.

The target biomass for a given day is determined following the principles
described in Petersen et al.

The exact regression for the target biomass is based on Fig. S2 in the
supplementary material of Petersen et al.

A refinement to expected yield as function of altitude has been
implemented according to Table 1a in Huguenin et al. (2017).
}
\references{
\insertRef{huguenin2017GrundlagenDuengung}{growR}
\insertRef{petersen2021DynamicSimulationManagement}{growR}

\insertRef{huguenin2017GrundlagenDuengung}{growR}

\insertRef{petersen2021DynamicSimulationManagement}{growR}
}
\seealso{
\link{PhenologicalAutocut}

\code{get_relative_cut_contribution()}

\code{get_target_biomass()}
}
\section{Super class}{
\code{growR::Autocut} -> \code{PetersenAutocut}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{last_DOY_for_initial_cut}}{Start cutting after this DOY,
even if yield target is not reached.}

\item{\code{max_cut_period}}{Maximum period to wait between
subsequent cuts.}

\item{\code{dry_precipitation_limit}}{Maximum amount of allowed
precipitation (mm) to consider a day.}

\item{\code{dry_days_before_cut}}{Number of days that shold be dry
before a cut is made.}

\item{\code{dry_days_after_cut}}{Number of days that shold be dry
after a cut is made.}

\item{\code{max_cut_delay}}{Number of days a farmer is willing to
wait for dry conditions before a cut is made anyways.}

\item{\code{cut_delays}}{Vector to keep track of cut delay times.}

\item{\code{dry_window}}{Logical that indicates if DOY at index is
considered dry enough to cut.}

\item{\code{target_biomass}}{Biomass amount that should to be reached
by given DOY for a cut to be made.}

\item{\code{end_of_cutting_season}}{Determined DOY after which no
more cuts are made.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PetersenAutocut-new}{\code{PetersenAutocut$new()}}
\item \href{#method-PetersenAutocut-get_annual_gross_yield}{\code{PetersenAutocut$get_annual_gross_yield()}}
\item \href{#method-PetersenAutocut-get_target_biomass}{\code{PetersenAutocut$get_target_biomass()}}
\item \href{#method-PetersenAutocut-get_relative_cut_contribution}{\code{PetersenAutocut$get_relative_cut_contribution()}}
\item \href{#method-PetersenAutocut-get_end_of_cutting_season}{\code{PetersenAutocut$get_end_of_cutting_season()}}
\item \href{#method-PetersenAutocut-determine_cut}{\code{PetersenAutocut$determine_cut()}}
\item \href{#method-PetersenAutocut-clone}{\code{PetersenAutocut$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="growR" data-topic="Autocut" data-id="get_expected_n_cuts"><a href='../../growR/html/Autocut.html#method-Autocut-get_expected_n_cuts'><code>growR::Autocut$get_expected_n_cuts()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetersenAutocut-new"></a>}}
\if{latex}{\out{\hypertarget{method-PetersenAutocut-new}{}}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetersenAutocut$new(MVS)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{MVS}}{The \link{ModvegeSite} object for which cuts shall be
determined.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetersenAutocut-get_annual_gross_yield"></a>}}
\if{latex}{\out{\hypertarget{method-PetersenAutocut-get_annual_gross_yield}{}}}
\subsection{Method \code{get_annual_gross_yield()}}{
Lookup table returning expected annual gross yields as function of
elevation and management intensity.

Based on data from Table 1a in
Lookup Table of expected yield as functions of height and management
intensity after Olivier Huguenin et al. (2017).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetersenAutocut$get_annual_gross_yield(elevation, intensity = "high")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{elevation}}{The elevation of the considered site in meters above sea
level.}

\item{\code{intensity}}{One of ("high", "middle", "low", "extensive"). Management
intensity for considered site.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Annual gross yield in t / ha (metric tons per hectare). Note that
1 t/ha = 0.1 kg/m^2.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetersenAutocut-get_target_biomass"></a>}}
\if{latex}{\out{\hypertarget{method-PetersenAutocut-get_target_biomass}{}}}
\subsection{Method \code{get_target_biomass()}}{
Get target value of biomass on given \emph{DOY}, which determines whether
a cut is to occur.

The regression for the target biomass is based on Fig. S2 in the
supplementary material of
Petersen, Krischan, David Kraus, Pierluigi Calanca, Mikhail A.
Semenov, Klaus Butterbach-Bahl, and Ralf Kiese. “Dynamic Simulation
of Management Events for Assessing Impacts of Climate Change on
Pre-Alpine Grassland Productivity.” European Journal of Agronomy
128 (August 1, 2021): 126306.
https://doi.org/10.1016/j.eja.2021.126306.

A refinement to expected yield as function of altitude has been
implemented according to Table 1a in
Huguenen-Elie et al. "Düngung von Grasland", Agrarforschung Schweiz,
8, (6), 2017,
https://www.agrarforschungschweiz.ch/2017/06/9-duengung-von-grasland-grud-2017/
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetersenAutocut$get_target_biomass(DOY, intensity = "high")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{DOY}}{Integer day of the year to consider.}

\item{\code{intensity}}{One of ("high", "middle", "low") specifying
management intensity.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
target Biomass (kg / ha) that should be reached on day \emph{DOY}
for this management \emph{intensity}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetersenAutocut-get_relative_cut_contribution"></a>}}
\if{latex}{\out{\hypertarget{method-PetersenAutocut-get_relative_cut_contribution}{}}}
\subsection{Method \code{get_relative_cut_contribution()}}{
Relative cut contribution

Get the fraction of the total annual harvested biomass that a cut at given
\emph{DOY} is expected to contribute.

The regression for the target biomass is based on Fig. S2 in the
supplementary material of Petersen et al. (2021).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetersenAutocut$get_relative_cut_contribution(DOY)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{DOY}}{Integer representing the day of the year on which a cut occurs.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The fraction (between 0 and 1) of biomass harvested at the cut at
given \emph{DOY} divided by the total annual biomass.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetersenAutocut-get_end_of_cutting_season"></a>}}
\if{latex}{\out{\hypertarget{method-PetersenAutocut-get_end_of_cutting_season}{}}}
\subsection{Method \code{get_end_of_cutting_season()}}{
Last day of cutting season

Estimate the last day on which it still makes sense to cut. This is done
by checking at which point the expected target biomass (see
\code{self$get_relative_cut_contribution()}) goes below the minimally harvestable
standing biomass.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetersenAutocut$get_end_of_cutting_season(
  min_biomass,
  elevation,
  intensity = "high"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{min_biomass}}{float A standing biomass below this value cannot even
be harvested,}

\item{\code{elevation}}{float Altitude in m.a.s.l.}

\item{\code{intensity}}{string Management intensity. One of "high", "middle", "low"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
float Last (fractional) day of the year on which a cut still makes
sense.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetersenAutocut-determine_cut"></a>}}
\if{latex}{\out{\hypertarget{method-PetersenAutocut-determine_cut}{}}}
\subsection{Method \code{determine_cut()}}{
Decide based on simple criteria whether day of year \emph{DOY} would be a
good day to cut.

This follows an implementation described in
Petersen, Krischan, David Kraus, Pierluigi Calanca, Mikhail A.
Semenov, Klaus Butterbach-Bahl, and Ralf Kiese. “Dynamic Simulation
of Management Events for Assessing Impacts of Climate Change on
Pre-Alpine Grassland Productivity.” European Journal of Agronomy
128 (August 1, 2021): 126306.
https://doi.org/10.1016/j.eja.2021.126306.

The decision to cut is made based on two criteria.
First, it is checked whether a \emph{target biomass} is reached on given
DOY. The defined target depends on the DOY and is given through
:func:\code{get_target_biomass}. If said biomass is present, return \code{TRUE}.

Otherwise, it is checked whether a given amount of time has passed
since the last cut. Depending on whether this is the first cut of
the season or not, the relevant parameters are
:int:\code{last_DOY_for_initial_cut} and :int:\code{max_cut_period}.
If that amount of time has passed, return \code{TRUE}, otherwise return
\code{FALSE}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetersenAutocut$determine_cut(DOY)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{DOY}}{Integer day of the year for which to make a cut decision.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Boolean \code{TRUE} if a cut happens on day \emph{DOY}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetersenAutocut-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PetersenAutocut-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetersenAutocut$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
