/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.tasks;

import com.android.builder.tasks.BooleanLatch;
import com.android.builder.tasks.JobContext;
import com.android.builder.tasks.Task;
import com.google.common.base.Objects;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class Job<T> {
    private final String mJobTitle;
    private final Task<T> mTask;
    private final BooleanLatch mBooleanLatch;
    private final AtomicBoolean mResult = new AtomicBoolean(false);
    private final AtomicReference<Exception> mException;

    public Job(String jobTile, Task<T> task) {
        this.mJobTitle = jobTile;
        this.mTask = task;
        this.mBooleanLatch = new BooleanLatch();
        this.mException = new AtomicReference<Object>(null);
    }

    public String getJobTitle() {
        return this.mJobTitle;
    }

    public void runTask(JobContext<T> jobContext) throws IOException {
        this.mTask.run(this, jobContext);
    }

    public void finished() {
        this.mResult.set(true);
        this.mBooleanLatch.signal();
    }

    public void error(Exception e) {
        this.mResult.set(false);
        this.mException.set(e);
        this.mBooleanLatch.signal();
    }

    public Exception getFailureReason() {
        return this.mException.get();
    }

    public boolean await() throws InterruptedException {
        this.mBooleanLatch.await();
        return this.mResult.get();
    }

    public boolean awaitRethrowExceptions() throws InterruptedException, RuntimeException {
        boolean result = this.await();
        if (!result && this.mException.get() != null) {
            throw new RuntimeException(this.mException.get());
        }
        return result;
    }

    public boolean failed() {
        return !this.mResult.get();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("\ntitle", (Object)this.mJobTitle).add("\ntask", this.mTask).add("\nlatch", (Object)this.mBooleanLatch).add("\nresult", this.mResult.get()).toString();
    }
}

