    /* fxcm file compressor is based on paq8 model.

    Copyright (C) 2023 Kaido Orav

    LICENSE

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details at
    Visit <http://www.gnu.org/copyleft/gpl.html>.


To compress:   fxcm c input output
To decompress: fxcm d input output

This compressor contains changed parts (mostly marked with comments) from fallowing open source programs:
paq8hp12
paq8px_v208
paq8pxv
cmix

*/

#define TEXTMODE             // comment this to get version 8 for dictionary proccessed input (ex. drt, paq8hp -0)

#ifdef TEXTMODE
#define VERSION 13
#else 
#define VERSION 14
#endif

#include <stdio.h>
#include <time.h>
#include <mem.h>
#define NDEBUG  // remove for debugging (turns on Array bound checks)
#include <assert.h>

#ifdef UNIX  // not tested
#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <memory.h>
#include <cstdio>
#include <ctype.h>
#include <sys/cdefs.h>
#include <dirent.h>
#include <errno.h>
#endif

// 8, 16, 32 bit unsigned types (adjust as appropriate)
typedef unsigned char  U8;
typedef unsigned short U16;
typedef unsigned int   U32;
typedef unsigned long long int U64;


// min, max functions
#if  !defined(WINDOWS) || !defined (min)
inline int min(int a, int b) {return a<b?a:b;}
inline int max(int a, int b) {return a<b?b:a;}
#endif

#define ispowerof2(x) ((x&(x-1))==0)
#include <math.h>
#include <windows.h>
// print message if any, and exit
/*void quit(const char* message=0) {
    #ifdef  ERRMSG 
    printf("%s",message);
    #endif
    exit(1);
}*/
//////////////////////////// Array ////////////////////////////

template <class T> void alloc(T*&ptr, int c) {
  ptr=(T*)calloc(c, sizeof(T));
  if (!ptr) exit(1);//quit("Out of memory.\n");
}
 
// for aligned data
template <class T> void alloc1(T*&data, int c,T*&ptr,const int align=16) {
  ptr=(T*)calloc(c, sizeof(T));
  if (!ptr) exit(1);//quit("Out of memory.\n");
  data=(T*)(((uintptr_t)ptr+(align-1)) & ~(uintptr_t)(align-1));
  
}

struct BlockData {
    int y;        // Last bit, 0 or 1, set by encoder
    int c0;       // Last 0-7 bits of the partial byte with a leading 1 bit (1-255)
    U32 c4;       // Last 4 whole bytes, packed.
    int bpos;     // bits in c0 (0 to 7)
    int blpos;    // Relative position in block
    int bposshift;
    int c0shift_bpos;
    struct Inputs{
        int ncount;     // mixer input count
        short *n,*ptr;
        void add(int p){ n[ncount++]=p; }
    };
    Inputs mxInputs[2]; // array of inputs, for two layers

    void Init(){
        y=0 ,c0=1, c4=0,bpos=0,blpos=0,bposshift=0,c0shift_bpos=0 ;
    }
};

BlockData x; //maintains current global data block

// ilog(x) = round(log2(x) * 16), 0 <= x < 256
U8 ilog[256];
// Compute lookup table by numerical integration of 1/x
void InitIlog() {
  U32 x=14155776;
  for (int i=2; i<257; ++i) {
    x+=774541002/(i*2-1);  // numerator is 2^29/ln 2
    ilog[i-1]=x>>24;
  }
}

// State table
//   nex(state, 0) = next state if bit y is 0, 0 <= state < 256
//   nex(state, 1) = next state if bit y is 1
//   nex(state, 2) = number of zeros in bit history represented by state
//   nex(state, 3) = number of ones represented
//
// States represent a bit history within some context.

// Original table in paq8
//Statetable:
/*static const U8 STA0[256][4]={    
  {  1,  2, 0, 0},{  3,  5, 1, 0},{  4,  6, 0, 1},{  7, 10, 2, 0}, // 0-3
  {  8, 12, 1, 1},{  9, 13, 1, 1},{ 11, 14, 0, 2},{ 15, 19, 3, 0}, // 4-7
  { 16, 23, 2, 1},{ 17, 24, 2, 1},{ 18, 25, 2, 1},{ 20, 27, 1, 2}, // 8-11
  { 21, 28, 1, 2},{ 22, 29, 1, 2},{ 26, 30, 0, 3},{ 31, 33, 4, 0}, // 12-15
  { 32, 35, 3, 1},{ 32, 35, 3, 1},{ 32, 35, 3, 1},{ 32, 35, 3, 1}, // 16-19
  { 34, 37, 2, 2},{ 34, 37, 2, 2},{ 34, 37, 2, 2},{ 34, 37, 2, 2}, // 20-23
  { 34, 37, 2, 2},{ 34, 37, 2, 2},{ 36, 39, 1, 3},{ 36, 39, 1, 3}, // 24-27
  { 36, 39, 1, 3},{ 36, 39, 1, 3},{ 38, 40, 0, 4},{ 41, 43, 5, 0}, // 28-31
  { 42, 45, 4, 1},{ 42, 45, 4, 1},{ 44, 47, 3, 2},{ 44, 47, 3, 2}, // 32-35
  { 46, 49, 2, 3},{ 46, 49, 2, 3},{ 48, 51, 1, 4},{ 48, 51, 1, 4}, // 36-39
  { 50, 52, 0, 5},{ 53, 43, 6, 0},{ 54, 57, 5, 1},{ 54, 57, 5, 1}, // 40-43
  { 56, 59, 4, 2},{ 56, 59, 4, 2},{ 58, 61, 3, 3},{ 58, 61, 3, 3}, // 44-47
  { 60, 63, 2, 4},{ 60, 63, 2, 4},{ 62, 65, 1, 5},{ 62, 65, 1, 5}, // 48-51
  { 50, 66, 0, 6},{ 67, 55, 7, 0},{ 68, 57, 6, 1},{ 68, 57, 6, 1}, // 52-55
  { 70, 73, 5, 2},{ 70, 73, 5, 2},{ 72, 75, 4, 3},{ 72, 75, 4, 3}, // 56-59
  { 74, 77, 3, 4},{ 74, 77, 3, 4},{ 76, 79, 2, 5},{ 76, 79, 2, 5}, // 60-63
  { 62, 81, 1, 6},{ 62, 81, 1, 6},{ 64, 82, 0, 7},{ 83, 69, 8, 0}, // 64-67
  { 84, 71, 7, 1},{ 84, 71, 7, 1},{ 86, 73, 6, 2},{ 86, 73, 6, 2}, // 68-71
  { 44, 59, 5, 3},{ 44, 59, 5, 3},{ 58, 61, 4, 4},{ 58, 61, 4, 4}, // 72-75
  { 60, 49, 3, 5},{ 60, 49, 3, 5},{ 76, 89, 2, 6},{ 76, 89, 2, 6}, // 76-79
  { 78, 91, 1, 7},{ 78, 91, 1, 7},{ 80, 92, 0, 8},{ 93, 69, 9, 0}, // 80-83
  { 94, 87, 8, 1},{ 94, 87, 8, 1},{ 96, 45, 7, 2},{ 96, 45, 7, 2}, // 84-87
  { 48, 99, 2, 7},{ 48, 99, 2, 7},{ 88,101, 1, 8},{ 88,101, 1, 8}, // 88-91
  { 80,102, 0, 9},{103, 69,10, 0},{104, 87, 9, 1},{104, 87, 9, 1}, // 92-95
  {106, 57, 8, 2},{106, 57, 8, 2},{ 62,109, 2, 8},{ 62,109, 2, 8}, // 96-99
  { 88,111, 1, 9},{ 88,111, 1, 9},{ 80,112, 0,10},{113, 85,11, 0}, // 100-103
  {114, 87,10, 1},{114, 87,10, 1},{116, 57, 9, 2},{116, 57, 9, 2}, // 104-107
  { 62,119, 2, 9},{ 62,119, 2, 9},{ 88,121, 1,10},{ 88,121, 1,10}, // 108-111
  { 90,122, 0,11},{123, 85,12, 0},{124, 97,11, 1},{124, 97,11, 1}, // 112-115
  {126, 57,10, 2},{126, 57,10, 2},{ 62,129, 2,10},{ 62,129, 2,10}, // 116-119
  { 98,131, 1,11},{ 98,131, 1,11},{ 90,132, 0,12},{133, 85,13, 0}, // 120-123
  {134, 97,12, 1},{134, 97,12, 1},{136, 57,11, 2},{136, 57,11, 2}, // 124-127
  { 62,139, 2,11},{ 62,139, 2,11},{ 98,141, 1,12},{ 98,141, 1,12}, // 128-131
  { 90,142, 0,13},{143, 95,14, 0},{144, 97,13, 1},{144, 97,13, 1}, // 132-135
  { 68, 57,12, 2},{ 68, 57,12, 2},{ 62, 81, 2,12},{ 62, 81, 2,12}, // 136-139
  { 98,147, 1,13},{ 98,147, 1,13},{100,148, 0,14},{149, 95,15, 0}, // 140-143
  {150,107,14, 1},{150,107,14, 1},{108,151, 1,14},{108,151, 1,14}, // 144-147
  {100,152, 0,15},{153, 95,16, 0},{154,107,15, 1},{108,155, 1,15}, // 148-151
  {100,156, 0,16},{157, 95,17, 0},{158,107,16, 1},{108,159, 1,16}, // 152-155
  {100,160, 0,17},{161,105,18, 0},{162,107,17, 1},{108,163, 1,17}, // 156-159
  {110,164, 0,18},{165,105,19, 0},{166,117,18, 1},{118,167, 1,18}, // 160-163
  {110,168, 0,19},{169,105,20, 0},{170,117,19, 1},{118,171, 1,19}, // 164-167
  {110,172, 0,20},{173,105,21, 0},{174,117,20, 1},{118,175, 1,20}, // 168-171
  {110,176, 0,21},{177,105,22, 0},{178,117,21, 1},{118,179, 1,21}, // 172-175
  {110,180, 0,22},{181,115,23, 0},{182,117,22, 1},{118,183, 1,22}, // 176-179
  {120,184, 0,23},{185,115,24, 0},{186,127,23, 1},{128,187, 1,23}, // 180-183
  {120,188, 0,24},{189,115,25, 0},{190,127,24, 1},{128,191, 1,24}, // 184-187
  {120,192, 0,25},{193,115,26, 0},{194,127,25, 1},{128,195, 1,25}, // 188-191
  {120,196, 0,26},{197,115,27, 0},{198,127,26, 1},{128,199, 1,26}, // 192-195
  {120,200, 0,27},{201,115,28, 0},{202,127,27, 1},{128,203, 1,27}, // 196-199
  {120,204, 0,28},{205,115,29, 0},{206,127,28, 1},{128,207, 1,28}, // 200-203
  {120,208, 0,29},{209,125,30, 0},{210,127,29, 1},{128,211, 1,29}, // 204-207
  {130,212, 0,30},{213,125,31, 0},{214,137,30, 1},{138,215, 1,30}, // 208-211
  {130,216, 0,31},{217,125,32, 0},{218,137,31, 1},{138,219, 1,31}, // 212-215
  {130,220, 0,32},{221,125,33, 0},{222,137,32, 1},{138,223, 1,32}, // 216-219
  {130,224, 0,33},{225,125,34, 0},{226,137,33, 1},{138,227, 1,33}, // 220-223
  {130,228, 0,34},{229,125,35, 0},{230,137,34, 1},{138,231, 1,34}, // 224-227
  {130,232, 0,35},{233,125,36, 0},{234,137,35, 1},{138,235, 1,35}, // 228-231
  {130,236, 0,36},{237,125,37, 0},{238,137,36, 1},{138,239, 1,36}, // 232-235
  {130,240, 0,37},{241,125,38, 0},{242,137,37, 1},{138,243, 1,37}, // 236-239
  {130,244, 0,38},{245,135,39, 0},{246,137,38, 1},{138,247, 1,38}, // 240-243
  {140,248, 0,39},{249,135,40, 0},{250, 69,39, 1},{ 80,251, 1,39}, // 244-247
  {140,252, 0,40},{249,135,41, 0},{250, 69,40, 1},{ 80,251, 1,40}, // 248-251
  {140,252, 0,41}};  // 252, 253-255 are reserved
*/

// Generatimg with state parameters p1 28,p2 28,p3 31,p4 29,p5 23,p6 4,p7 17
//Statetable:
static const U8 STA1[256][4]={
{  1,  2, 0, 0},{  3,  5, 1, 0},{  4,  6, 0, 1},{  7,  9, 2, 0}, // 0-3
{  8, 11, 1, 1},{  8, 11, 1, 1},{ 10, 12, 0, 2},{ 13, 14, 3, 0}, // 4-7
{ 14, 15, 2, 1},{ 14, 15, 2, 1},{ 15, 16, 1, 2},{ 15, 16, 1, 2}, // 8-11
{ 16, 17, 0, 3},{ 18, 19, 4, 0},{ 19, 20, 3, 1},{ 20, 21, 2, 2}, // 12-15
{ 21, 22, 1, 3},{ 22, 23, 0, 4},{ 24, 25, 5, 0},{ 25, 26, 4, 1}, // 16-19
{ 26, 27, 3, 2},{ 27, 28, 2, 3},{ 28, 29, 1, 4},{ 29, 30, 0, 5}, // 20-23
{ 31, 32, 6, 0},{ 32, 33, 5, 1},{ 33, 34, 4, 2},{ 34, 35, 3, 3}, // 24-27
{ 35, 36, 2, 4},{ 36, 37, 1, 5},{ 37, 38, 0, 6},{ 39, 40, 7, 0}, // 28-31
{ 40, 41, 6, 1},{ 41, 42, 5, 2},{ 42, 43, 4, 3},{ 43, 44, 3, 4}, // 32-35
{ 44, 45, 2, 5},{ 45, 46, 1, 6},{ 46, 47, 0, 7},{ 48, 49, 8, 0}, // 36-39
{ 49, 50, 7, 1},{ 50, 51, 6, 2},{ 51, 52, 5, 3},{ 52, 53, 4, 4}, // 40-43
{ 53, 54, 3, 5},{ 54, 55, 2, 6},{ 55, 56, 1, 7},{ 56, 57, 0, 8}, // 44-47
{ 58, 59, 9, 0},{ 59, 60, 8, 1},{ 60, 61, 7, 2},{ 61, 62, 6, 3}, // 48-51
{ 62, 43, 5, 4},{ 43, 63, 4, 5},{ 63, 64, 3, 6},{ 64, 65, 2, 7}, // 52-55
{ 65, 66, 1, 8},{ 66, 67, 0, 9},{ 68, 69,10, 0},{ 69, 70, 9, 1}, // 56-59
{ 70, 71, 8, 2},{ 71, 72, 7, 3},{ 72, 52, 6, 4},{ 53, 73, 4, 6}, // 60-63
{ 73, 74, 3, 7},{ 74, 75, 2, 8},{ 75, 76, 1, 9},{ 76, 77, 0,10}, // 64-67
{ 78, 79,11, 0},{ 79, 80,10, 1},{ 80, 81, 9, 2},{ 81, 82, 8, 3}, // 68-71
{ 82, 62, 7, 4},{ 63, 83, 4, 7},{ 83, 84, 3, 8},{ 84, 85, 2, 9}, // 72-75
{ 85, 86, 1,10},{ 86, 87, 0,11},{ 88, 89,12, 0},{ 89, 90,11, 1}, // 76-79
{ 90, 91,10, 2},{ 91, 92, 9, 3},{ 92, 62, 8, 4},{ 63, 93, 4, 8}, // 80-83
{ 93, 94, 3, 9},{ 94, 95, 2,10},{ 95, 96, 1,11},{ 96, 97, 0,12}, // 84-87
{ 98, 99,13, 0},{ 99,100,12, 1},{100,101,11, 2},{101,102,10, 3}, // 88-91
{102, 72, 9, 4},{ 73,103, 4, 9},{103,104, 3,10},{104,105, 2,11}, // 92-95
{105,106, 1,12},{106,107, 0,13},{108,109,14, 0},{109,110,13, 1}, // 96-99
{110,111,12, 2},{111,112,11, 3},{112, 82,10, 4},{ 83,113, 4,10}, // 100-103
{113,114, 3,11},{114,115, 2,12},{115,116, 1,13},{116,117, 0,14}, // 104-107
{118,119,15, 0},{119,120,14, 1},{120,121,13, 2},{121,122,12, 3}, // 108-111
{122, 92,11, 4},{ 93,123, 4,11},{123,124, 3,12},{124,125, 2,13}, // 112-115
{125,126, 1,14},{126,127, 0,15},{128,129,16, 0},{129,130,15, 1}, // 116-119
{130,131,14, 2},{131,132,13, 3},{132,102,12, 4},{103,133, 4,12}, // 120-123
{133,134, 3,13},{134,135, 2,14},{135,136, 1,15},{136,137, 0,16}, // 124-127
{138,129,17, 0},{139,140,16, 1},{140,141,15, 2},{141,142,14, 3}, // 128-131
{142,102,13, 4},{103,143, 4,13},{143,144, 3,14},{144,145, 2,15}, // 132-135
{145,146, 1,16},{136,147, 0,17},{148,129,18, 0},{149,140,17, 1}, // 136-139
{150,151,16, 2},{151,152,15, 3},{152,112,14, 4},{113,153, 4,14}, // 140-143
{153,154, 3,15},{154,155, 2,16},{145,156, 1,17},{136,157, 0,18}, // 144-147
{158,129,19, 0},{159,140,18, 1},{160,151,17, 2},{161,162,16, 3}, // 148-151
{162,122,15, 4},{123,163, 4,15},{163,164, 3,16},{154,165, 2,17}, // 152-155
{145,166, 1,18},{136,167, 0,19},{168,129,20, 0},{169,140,19, 1}, // 156-159
{170,151,18, 2},{171,162,17, 3},{172,132,16, 4},{133,173, 4,16}, // 160-163
{163,174, 3,17},{154,175, 2,18},{145,176, 1,19},{136,177, 0,20}, // 164-167
{178,129,21, 0},{179,140,20, 1},{180,151,19, 2},{181,162,18, 3}, // 168-171
{182,132,17, 4},{133,183, 4,17},{163,184, 3,18},{154,185, 2,19}, // 172-175
{145,186, 1,20},{136,187, 0,21},{188,129,22, 0},{189,140,21, 1}, // 176-179
{190,151,20, 2},{191,162,19, 3},{192,132,18, 4},{133,193, 4,18}, // 180-183
{163,194, 3,19},{154,195, 2,20},{145,196, 1,21},{136,197, 0,22}, // 184-187
{198,129,23, 0},{199,140,22, 1},{200,151,21, 2},{201,162,20, 3}, // 188-191
{202,132,19, 4},{133,203, 4,19},{163,204, 3,20},{154,205, 2,21}, // 192-195
{145,206, 1,22},{136,207, 0,23},{208,129,24, 0},{209,140,23, 1}, // 196-199
{210,151,22, 2},{211,162,21, 3},{212,132,20, 4},{133,213, 4,20}, // 200-203
{163,214, 3,21},{154,215, 2,22},{145,216, 1,23},{136,217, 0,24}, // 204-207
{218,129,25, 0},{219,140,24, 1},{220,151,23, 2},{221,162,22, 3}, // 208-211
{222,132,21, 4},{133,223, 4,21},{163,224, 3,22},{154,225, 2,23}, // 212-215
{145,226, 1,24},{136,227, 0,25},{228,129,26, 0},{229,140,25, 1}, // 216-219
{230,151,24, 2},{231,162,23, 3},{161,132,22, 4},{133,164, 4,22}, // 220-223
{163,232, 3,23},{154,233, 2,24},{145,234, 1,25},{136,235, 0,26}, // 224-227
{228,129,27, 0},{236,140,26, 1},{237,151,25, 2},{238,162,24, 3}, // 228-231
{163,239, 3,24},{154,240, 2,25},{145,241, 1,26},{136,235, 0,27}, // 232-235
{236,140,27, 1},{242,151,26, 2},{243,162,25, 3},{163,244, 3,25}, // 236-239
{154,245, 2,26},{145,241, 1,27},{246,151,27, 2},{247,162,26, 3}, // 240-243
{163,248, 3,26},{154,249, 2,27},{250,151,28, 2},{251,162,27, 3}, // 244-247
{163,252, 3,27},{154,253, 2,28},{254,151,29, 2},{170,162,28, 3}, // 248-251
{163,175, 3,28},{154,255, 2,29},{129,151,30, 2},{154,136, 2,30}, // 252-255
};

// Generating with state parameters p1 32,p2 28,p3 31,p4 28,p5 21,p6 5,p7 6
//Statetable:
static const U8 STA2[256][4]={    
{  1,  2, 0, 0},{  3,  5, 1, 0},{  4,  6, 0, 1},{  7,  9, 2, 0}, // 0-3
{  8, 11, 1, 1},{  8, 11, 1, 1},{ 10, 12, 0, 2},{ 13, 15, 3, 0}, // 4-7
{ 14, 17, 2, 1},{ 14, 17, 2, 1},{ 16, 19, 1, 2},{ 16, 19, 1, 2}, // 8-11
{ 18, 20, 0, 3},{ 21, 22, 4, 0},{ 22, 23, 3, 1},{ 22, 23, 3, 1}, // 12-15
{ 23, 24, 2, 2},{ 23, 24, 2, 2},{ 24, 25, 1, 3},{ 24, 25, 1, 3}, // 16-19
{ 25, 26, 0, 4},{ 27, 28, 5, 0},{ 28, 29, 4, 1},{ 29, 30, 3, 2}, // 20-23
{ 30, 31, 2, 3},{ 31, 32, 1, 4},{ 32, 33, 0, 5},{ 34, 28, 6, 0}, // 24-27
{ 35, 36, 5, 1},{ 36, 37, 4, 2},{ 37, 38, 3, 3},{ 38, 39, 2, 4}, // 28-31
{ 39, 40, 1, 5},{ 32, 41, 0, 6},{ 42, 28, 7, 0},{ 43, 36, 6, 1}, // 32-35
{ 44, 45, 5, 2},{ 45, 46, 4, 3},{ 46, 47, 3, 4},{ 47, 48, 2, 5}, // 36-39
{ 39, 49, 1, 6},{ 32, 50, 0, 7},{ 51, 28, 8, 0},{ 52, 36, 7, 1}, // 40-43
{ 53, 45, 6, 2},{ 54, 55, 5, 3},{ 55, 56, 4, 4},{ 56, 57, 3, 5}, // 44-47
{ 47, 58, 2, 6},{ 39, 59, 1, 7},{ 32, 60, 0, 8},{ 61, 28, 9, 0}, // 48-51
{ 62, 36, 8, 1},{ 63, 45, 7, 2},{ 64, 55, 6, 3},{ 65, 46, 5, 4}, // 52-55
{ 46, 66, 4, 5},{ 56, 67, 3, 6},{ 47, 68, 2, 7},{ 39, 69, 1, 8}, // 56-59
{ 32, 70, 0, 9},{ 71, 28,10, 0},{ 72, 36, 9, 1},{ 73, 45, 8, 2}, // 60-63
{ 74, 55, 7, 3},{ 75, 46, 6, 4},{ 46, 76, 4, 6},{ 56, 77, 3, 7}, // 64-67
{ 47, 78, 2, 8},{ 39, 79, 1, 9},{ 32, 80, 0,10},{ 81, 28,11, 0}, // 68-71
{ 82, 36,10, 1},{ 83, 45, 9, 2},{ 84, 55, 8, 3},{ 85, 46, 7, 4}, // 72-75
{ 46, 86, 4, 7},{ 56, 87, 3, 8},{ 47, 88, 2, 9},{ 39, 89, 1,10}, // 76-79
{ 32, 90, 0,11},{ 91, 28,12, 0},{ 92, 36,11, 1},{ 93, 45,10, 2}, // 80-83
{ 94, 55, 9, 3},{ 95, 46, 8, 4},{ 46, 96, 4, 8},{ 56, 97, 3, 9}, // 84-87
{ 47, 98, 2,10},{ 39, 99, 1,11},{ 32,100, 0,12},{101, 28,13, 0}, // 88-91
{102, 36,12, 1},{103, 45,11, 2},{104, 55,10, 3},{105, 46, 9, 4}, // 92-95
{ 46,106, 4, 9},{ 56,107, 3,10},{ 47,108, 2,11},{ 39,109, 1,12}, // 96-99
{ 32,110, 0,13},{111, 28,14, 0},{112, 36,13, 1},{113, 45,12, 2}, // 100-103
{114, 55,11, 3},{115, 46,10, 4},{ 46,116, 4,10},{ 56,117, 3,11}, // 104-107
{ 47,118, 2,12},{ 39,119, 1,13},{ 32,120, 0,14},{121, 28,15, 0}, // 108-111
{122, 36,14, 1},{123, 45,13, 2},{124, 55,12, 3},{125, 46,11, 4}, // 112-115
{ 46,126, 4,11},{ 56,127, 3,12},{ 47,128, 2,13},{ 39,129, 1,14}, // 116-119
{ 32,130, 0,15},{131, 28,16, 0},{132, 36,15, 1},{133, 45,14, 2}, // 120-123
{134, 55,13, 3},{135, 46,12, 4},{ 46,136, 4,12},{ 56,137, 3,13}, // 124-127
{ 47,138, 2,14},{ 39,139, 1,15},{ 32,140, 0,16},{141, 28,17, 0}, // 128-131
{142, 36,16, 1},{143, 45,15, 2},{144, 55,14, 3},{145, 46,13, 4}, // 132-135
{ 46,146, 4,13},{ 56,147, 3,14},{ 47,148, 2,15},{ 39,149, 1,16}, // 136-139
{ 32,150, 0,17},{151, 28,18, 0},{152, 36,17, 1},{153, 45,16, 2}, // 140-143
{154, 55,15, 3},{155, 46,14, 4},{ 46,156, 4,14},{ 56,157, 3,15}, // 144-147
{ 47,158, 2,16},{ 39,159, 1,17},{ 32,160, 0,18},{161, 28,19, 0}, // 148-151
{162, 36,18, 1},{163, 45,17, 2},{164, 55,16, 3},{165, 46,15, 4}, // 152-155
{ 46,166, 4,15},{ 56,167, 3,16},{ 47,168, 2,17},{ 39,169, 1,18}, // 156-159
{ 32,170, 0,19},{171, 28,20, 0},{172, 36,19, 1},{173, 45,18, 2}, // 160-163
{174, 55,17, 3},{175, 46,16, 4},{ 46,176, 4,16},{ 56,177, 3,17}, // 164-167
{ 47,178, 2,18},{ 39,179, 1,19},{ 32,180, 0,20},{181, 28,21, 0}, // 168-171
{182, 36,20, 1},{183, 45,19, 2},{184, 55,18, 3},{185, 46,17, 4}, // 172-175
{ 46,186, 4,17},{ 56,187, 3,18},{ 47,188, 2,19},{ 39,189, 1,20}, // 176-179
{ 32,190, 0,21},{191, 28,22, 0},{192, 36,21, 1},{193, 45,20, 2}, // 180-183
{194, 55,19, 3},{195, 46,18, 4},{ 46,196, 4,18},{ 56,197, 3,19}, // 184-187
{ 47,198, 2,20},{ 39,199, 1,21},{ 32,200, 0,22},{201, 28,23, 0}, // 188-191
{202, 36,22, 1},{203, 45,21, 2},{204, 55,20, 3},{205, 46,19, 4}, // 192-195
{ 46,206, 4,19},{ 56,207, 3,20},{ 47,208, 2,21},{ 39,209, 1,22}, // 196-199
{ 32,210, 0,23},{211, 28,24, 0},{212, 36,23, 1},{213, 45,22, 2}, // 200-203
{214, 55,21, 3},{154, 46,20, 4},{ 46,157, 4,20},{ 56,215, 3,21}, // 204-207
{ 47,216, 2,22},{ 39,217, 1,23},{ 32,218, 0,24},{219, 28,25, 0}, // 208-211
{220, 36,24, 1},{221, 45,23, 2},{222, 55,22, 3},{ 56,223, 3,22}, // 212-215
{ 47,224, 2,23},{ 39,225, 1,24},{ 32,226, 0,25},{227, 28,26, 0}, // 216-219
{228, 36,25, 1},{229, 45,24, 2},{230, 55,23, 3},{ 56,231, 3,23}, // 220-223
{ 47,232, 2,24},{ 39,233, 1,25},{ 32,234, 0,26},{235, 28,27, 0}, // 224-227
{236, 36,26, 1},{237, 45,25, 2},{238, 55,24, 3},{ 56,239, 3,24}, // 228-231
{ 47,240, 2,25},{ 39,241, 1,26},{ 32,242, 0,27},{243, 28,28, 0}, // 232-235
{236, 36,27, 1},{244, 45,26, 2},{245, 55,25, 3},{ 56,246, 3,25}, // 236-239
{ 47,247, 2,26},{ 39,241, 1,27},{ 32,248, 0,28},{249, 28,29, 0}, // 240-243
{250, 45,27, 2},{251, 55,26, 3},{ 56,252, 3,26},{ 47,253, 2,27}, // 244-247
{ 32,254, 0,29},{255, 28,30, 0},{  0, 45,28, 2},{173, 55,27, 3}, // 248-251
{ 56,178, 3,27},{ 47,  1, 2,28},{ 32,  2, 0,30},{255, 28,31, 0}, // 252-255
};

// Generating with state parameters p1 29,p2 30,p3 28,p4 23,p5 29,p6 4,p7 22
//Statetable:
static const U8 STA3[256][4]={    
{  1,  2, 0, 0},{  3,  5, 1, 0},{  4,  6, 0, 1},{  7,  9, 2, 0}, // 0-3
{  8, 11, 1, 1},{  8, 11, 1, 1},{ 10, 12, 0, 2},{ 13, 14, 3, 0}, // 4-7
{ 14, 15, 2, 1},{ 14, 15, 2, 1},{ 15, 16, 1, 2},{ 15, 16, 1, 2}, // 8-11
{ 16, 17, 0, 3},{ 18, 19, 4, 0},{ 19, 20, 3, 1},{ 20, 21, 2, 2}, // 12-15
{ 21, 22, 1, 3},{ 22, 23, 0, 4},{ 24, 25, 5, 0},{ 25, 26, 4, 1}, // 16-19
{ 26, 27, 3, 2},{ 27, 28, 2, 3},{ 28, 29, 1, 4},{ 29, 30, 0, 5}, // 20-23
{ 31, 32, 6, 0},{ 32, 33, 5, 1},{ 33, 34, 4, 2},{ 34, 35, 3, 3}, // 24-27
{ 35, 36, 2, 4},{ 36, 37, 1, 5},{ 37, 38, 0, 6},{ 39, 40, 7, 0}, // 28-31
{ 40, 41, 6, 1},{ 41, 42, 5, 2},{ 42, 43, 4, 3},{ 43, 44, 3, 4}, // 32-35
{ 44, 45, 2, 5},{ 45, 46, 1, 6},{ 46, 47, 0, 7},{ 48, 49, 8, 0}, // 36-39
{ 49, 50, 7, 1},{ 50, 51, 6, 2},{ 51, 52, 5, 3},{ 52, 53, 4, 4}, // 40-43
{ 53, 54, 3, 5},{ 54, 55, 2, 6},{ 55, 56, 1, 7},{ 56, 57, 0, 8}, // 44-47
{ 58, 59, 9, 0},{ 59, 60, 8, 1},{ 60, 61, 7, 2},{ 61, 62, 6, 3}, // 48-51
{ 62, 43, 5, 4},{ 43, 63, 4, 5},{ 63, 64, 3, 6},{ 64, 65, 2, 7}, // 52-55
{ 65, 66, 1, 8},{ 66, 67, 0, 9},{ 68, 69,10, 0},{ 69, 70, 9, 1}, // 56-59
{ 70, 71, 8, 2},{ 71, 72, 7, 3},{ 72, 52, 6, 4},{ 53, 73, 4, 6}, // 60-63
{ 73, 74, 3, 7},{ 74, 75, 2, 8},{ 75, 76, 1, 9},{ 76, 77, 0,10}, // 64-67
{ 78, 79,11, 0},{ 79, 80,10, 1},{ 80, 81, 9, 2},{ 81, 82, 8, 3}, // 68-71
{ 82, 62, 7, 4},{ 63, 83, 4, 7},{ 83, 84, 3, 8},{ 84, 85, 2, 9}, // 72-75
{ 85, 86, 1,10},{ 86, 87, 0,11},{ 88, 89,12, 0},{ 89, 90,11, 1}, // 76-79
{ 90, 91,10, 2},{ 91, 92, 9, 3},{ 92, 62, 8, 4},{ 63, 93, 4, 8}, // 80-83
{ 93, 94, 3, 9},{ 94, 95, 2,10},{ 95, 96, 1,11},{ 96, 97, 0,12}, // 84-87
{ 98, 99,13, 0},{ 99,100,12, 1},{100,101,11, 2},{101,102,10, 3}, // 88-91
{102, 72, 9, 4},{ 73,103, 4, 9},{103,104, 3,10},{104,105, 2,11}, // 92-95
{105,106, 1,12},{106,107, 0,13},{108,109,14, 0},{109,110,13, 1}, // 96-99
{110,111,12, 2},{111,112,11, 3},{112, 82,10, 4},{ 83,113, 4,10}, // 100-103
{113,114, 3,11},{114,115, 2,12},{115,116, 1,13},{116,117, 0,14}, // 104-107
{118,119,15, 0},{119,120,14, 1},{120,121,13, 2},{121,122,12, 3}, // 108-111
{122, 92,11, 4},{ 93,123, 4,11},{123,124, 3,12},{124,125, 2,13}, // 112-115
{125,126, 1,14},{126,127, 0,15},{128,129,16, 0},{129,130,15, 1}, // 116-119
{130,131,14, 2},{131,132,13, 3},{132,102,12, 4},{103,133, 4,12}, // 120-123
{133,134, 3,13},{134,135, 2,14},{135,136, 1,15},{136,137, 0,16}, // 124-127
{138,139,17, 0},{139,140,16, 1},{140,141,15, 2},{141,142,14, 3}, // 128-131
{142,102,13, 4},{103,143, 4,13},{143,144, 3,14},{144,145, 2,15}, // 132-135
{145,146, 1,16},{146,147, 0,17},{148,149,18, 0},{149,150,17, 1}, // 136-139
{150,151,16, 2},{151,152,15, 3},{152,112,14, 4},{113,153, 4,14}, // 140-143
{153,154, 3,15},{154,155, 2,16},{155,156, 1,17},{156,157, 0,18}, // 144-147
{158,159,19, 0},{159,160,18, 1},{160,161,17, 2},{161,162,16, 3}, // 148-151
{162,122,15, 4},{123,163, 4,15},{163,164, 3,16},{164,165, 2,17}, // 152-155
{165,166, 1,18},{166,167, 0,19},{168,169,20, 0},{169,170,19, 1}, // 156-159
{170,171,18, 2},{171,172,17, 3},{172,132,16, 4},{133,173, 4,16}, // 160-163
{173,174, 3,17},{174,175, 2,18},{175,176, 1,19},{176,177, 0,20}, // 164-167
{178,179,21, 0},{179,180,20, 1},{180,181,19, 2},{181,182,18, 3}, // 168-171
{182,142,17, 4},{143,183, 4,17},{183,184, 3,18},{184,185, 2,19}, // 172-175
{185,186, 1,20},{186,187, 0,21},{188,179,22, 0},{189,190,21, 1}, // 176-179
{190,191,20, 2},{191,192,19, 3},{192,142,18, 4},{143,193, 4,18}, // 180-183
{193,194, 3,19},{194,195, 2,20},{195,196, 1,21},{186,197, 0,22}, // 184-187
{198,179,23, 0},{199,190,22, 1},{200,201,21, 2},{201,202,20, 3}, // 188-191
{202,152,19, 4},{153,203, 4,19},{203,204, 3,20},{204,205, 2,21}, // 192-195
{195,206, 1,22},{186,207, 0,23},{208,179,24, 0},{209,190,23, 1}, // 196-199
{210,201,22, 2},{211,212,21, 3},{212,162,20, 4},{163,213, 4,20}, // 200-203
{213,214, 3,21},{204,215, 2,22},{195,216, 1,23},{186,217, 0,24}, // 204-207
{218,179,25, 0},{219,190,24, 1},{220,201,23, 2},{130,212,22, 3}, // 208-211
{221,172,21, 4},{173,222, 4,21},{213,135, 3,22},{204,223, 2,23}, // 212-215
{195,224, 1,24},{186,225, 0,25},{226,179,26, 0},{227,190,25, 1}, // 216-219
{228,201,24, 2},{229,172,22, 4},{173,230, 4,22},{204,231, 2,24}, // 220-223
{195,232, 1,25},{186,233, 0,26},{234,179,27, 0},{235,190,26, 1}, // 224-227
{236,201,25, 2},{237,172,23, 4},{173,238, 4,23},{204,239, 2,25}, // 228-231
{195,240, 1,26},{186,241, 0,27},{234,179,28, 0},{242,190,27, 1}, // 232-235
{243,201,26, 2},{244,172,24, 4},{173,245, 4,24},{204,246, 2,26}, // 236-239
{195,247, 1,27},{186,241, 0,28},{248,190,28, 1},{109,201,27, 2}, // 240-243
{249,172,25, 4},{173,250, 4,25},{204,116, 2,27},{195,251, 1,28}, // 244-247
{248,190,29, 1},{252,172,26, 4},{173,253, 4,26},{195,251, 1,29}, // 248-251
{254,172,27, 4},{173,255, 4,27},{211,172,28, 4},{173,214, 4,28}, // 252-255
}; 

// Generating with state parameters p1 31,p2 27,p3 30,p4 27,p5 24,p6 4,p7 27
//Statetable:
static const U8 STA4[256][4]={    
{  1,  2, 0, 0},{  3,  5, 1, 0},{  4,  6, 0, 1},{  7,  9, 2, 0}, // 0-3
{  8, 11, 1, 1},{  8, 11, 1, 1},{ 10, 12, 0, 2},{ 13, 14, 3, 0}, // 4-7
{ 14, 15, 2, 1},{ 14, 15, 2, 1},{ 15, 16, 1, 2},{ 15, 16, 1, 2}, // 8-11
{ 16, 17, 0, 3},{ 18, 19, 4, 0},{ 19, 20, 3, 1},{ 20, 21, 2, 2}, // 12-15
{ 21, 22, 1, 3},{ 22, 23, 0, 4},{ 24, 25, 5, 0},{ 25, 26, 4, 1}, // 16-19
{ 26, 27, 3, 2},{ 27, 28, 2, 3},{ 28, 29, 1, 4},{ 29, 30, 0, 5}, // 20-23
{ 31, 32, 6, 0},{ 32, 33, 5, 1},{ 33, 34, 4, 2},{ 34, 35, 3, 3}, // 24-27
{ 35, 36, 2, 4},{ 36, 37, 1, 5},{ 37, 38, 0, 6},{ 39, 40, 7, 0}, // 28-31
{ 40, 41, 6, 1},{ 41, 42, 5, 2},{ 42, 43, 4, 3},{ 43, 44, 3, 4}, // 32-35
{ 44, 45, 2, 5},{ 45, 46, 1, 6},{ 46, 47, 0, 7},{ 48, 49, 8, 0}, // 36-39
{ 49, 50, 7, 1},{ 50, 51, 6, 2},{ 51, 52, 5, 3},{ 52, 53, 4, 4}, // 40-43
{ 53, 54, 3, 5},{ 54, 55, 2, 6},{ 55, 56, 1, 7},{ 56, 57, 0, 8}, // 44-47
{ 58, 59, 9, 0},{ 59, 60, 8, 1},{ 60, 61, 7, 2},{ 61, 62, 6, 3}, // 48-51
{ 62, 43, 5, 4},{ 43, 63, 4, 5},{ 63, 64, 3, 6},{ 64, 65, 2, 7}, // 52-55
{ 65, 66, 1, 8},{ 66, 67, 0, 9},{ 68, 69,10, 0},{ 69, 70, 9, 1}, // 56-59
{ 70, 71, 8, 2},{ 71, 72, 7, 3},{ 72, 52, 6, 4},{ 53, 73, 4, 6}, // 60-63
{ 73, 74, 3, 7},{ 74, 75, 2, 8},{ 75, 76, 1, 9},{ 76, 77, 0,10}, // 64-67
{ 78, 79,11, 0},{ 79, 80,10, 1},{ 80, 81, 9, 2},{ 81, 82, 8, 3}, // 68-71
{ 82, 62, 7, 4},{ 63, 83, 4, 7},{ 83, 84, 3, 8},{ 84, 85, 2, 9}, // 72-75
{ 85, 86, 1,10},{ 86, 87, 0,11},{ 88, 89,12, 0},{ 89, 90,11, 1}, // 76-79
{ 90, 91,10, 2},{ 91, 92, 9, 3},{ 92, 62, 8, 4},{ 63, 93, 4, 8}, // 80-83
{ 93, 94, 3, 9},{ 94, 95, 2,10},{ 95, 96, 1,11},{ 96, 97, 0,12}, // 84-87
{ 98, 99,13, 0},{ 99,100,12, 1},{100,101,11, 2},{101,102,10, 3}, // 88-91
{102, 72, 9, 4},{ 73,103, 4, 9},{103,104, 3,10},{104,105, 2,11}, // 92-95
{105,106, 1,12},{106,107, 0,13},{108,109,14, 0},{109,110,13, 1}, // 96-99
{110,111,12, 2},{111,112,11, 3},{112, 82,10, 4},{ 83,113, 4,10}, // 100-103
{113,114, 3,11},{114,115, 2,12},{115,116, 1,13},{116,117, 0,14}, // 104-107
{118,119,15, 0},{119,120,14, 1},{120,121,13, 2},{121,122,12, 3}, // 108-111
{122, 92,11, 4},{ 93,123, 4,11},{123,124, 3,12},{124,125, 2,13}, // 112-115
{125,126, 1,14},{126,127, 0,15},{128,129,16, 0},{129,130,15, 1}, // 116-119
{130,131,14, 2},{131,132,13, 3},{132,102,12, 4},{103,133, 4,12}, // 120-123
{133,134, 3,13},{134,135, 2,14},{135,136, 1,15},{136,137, 0,16}, // 124-127
{138,139,17, 0},{139,140,16, 1},{140,141,15, 2},{141,142,14, 3}, // 128-131
{142,102,13, 4},{103,143, 4,13},{143,144, 3,14},{144,145, 2,15}, // 132-135
{145,146, 1,16},{146,147, 0,17},{148,149,18, 0},{149,150,17, 1}, // 136-139
{150,151,16, 2},{151,152,15, 3},{152,112,14, 4},{113,153, 4,14}, // 140-143
{153,154, 3,15},{154,155, 2,16},{155,156, 1,17},{156,157, 0,18}, // 144-147
{158,159,19, 0},{159,160,18, 1},{160,161,17, 2},{161,162,16, 3}, // 148-151
{162,122,15, 4},{123,163, 4,15},{163,164, 3,16},{164,165, 2,17}, // 152-155
{165,166, 1,18},{166,167, 0,19},{168,169,20, 0},{169,170,19, 1}, // 156-159
{170,171,18, 2},{171,172,17, 3},{172,132,16, 4},{133,173, 4,16}, // 160-163
{173,174, 3,17},{174,175, 2,18},{175,176, 1,19},{176,177, 0,20}, // 164-167
{178,179,21, 0},{179,180,20, 1},{180,181,19, 2},{181,182,18, 3}, // 168-171
{182,142,17, 4},{143,183, 4,17},{183,184, 3,18},{184,185, 2,19}, // 172-175
{185,186, 1,20},{186,187, 0,21},{188,189,22, 0},{189,190,21, 1}, // 176-179
{190,191,20, 2},{191,192,19, 3},{192,142,18, 4},{143,193, 4,18}, // 180-183
{193,194, 3,19},{194,195, 2,20},{195,196, 1,21},{196,197, 0,22}, // 184-187
{198,199,23, 0},{199,200,22, 1},{200,201,21, 2},{201,202,20, 3}, // 188-191
{202,152,19, 4},{153,203, 4,19},{203,204, 3,20},{204,205, 2,21}, // 192-195
{205,206, 1,22},{206,207, 0,23},{208,209,24, 0},{209,210,23, 1}, // 196-199
{210,211,22, 2},{211,212,21, 3},{212,162,20, 4},{163,213, 4,20}, // 200-203
{213,214, 3,21},{214,215, 2,22},{215,216, 1,23},{216,217, 0,24}, // 204-207
{218,219,25, 0},{219,220,24, 1},{220,221,23, 2},{221,222,22, 3}, // 208-211
{222,172,21, 4},{173,223, 4,21},{223,224, 3,22},{224,225, 2,23}, // 212-215
{225,226, 1,24},{226,227, 0,25},{228,229,26, 0},{229,230,25, 1}, // 216-219
{230,231,24, 2},{231,232,23, 3},{232,182,22, 4},{183,233, 4,22}, // 220-223
{233,234, 3,23},{234,235, 2,24},{235,236, 1,25},{236,237, 0,26}, // 224-227
{238,229,27, 0},{229,239,26, 1},{239,240,25, 2},{240,171,24, 3}, // 228-231
{171,182,23, 4},{183,174, 4,23},{174,241, 3,24},{241,242, 2,25}, // 232-235
{242,236, 1,26},{236,243, 0,27},{244,229,28, 0},{245,246,26, 2}, // 236-239
{246,181,25, 3},{184,247, 3,25},{247,248, 2,26},{236,249, 0,28}, // 240-243
{250,229,29, 0},{251,246,27, 2},{160,191,26, 3},{194,165, 3,26}, // 244-247
{247,252, 2,27},{236,253, 0,29},{250,229,30, 0},{254,246,28, 2}, // 248-251
{247,255, 2,28},{236,253, 0,30},{119,246,29, 2},{247,126, 2,29}, // 252-255
};

// Generating with state parameters p1 33,p2 31,p3 31,p4 24,p5 20,p6 4,p7 33
//Statetable:
static const U8 STA5[256][4]={   
{  1,  2, 0, 0},{  3,  5, 1, 0},{  4,  6, 0, 1},{  7,  9, 2, 0}, // 0-3
{  8, 11, 1, 1},{  8, 11, 1, 1},{ 10, 12, 0, 2},{ 13, 14, 3, 0}, // 4-7
{ 14, 15, 2, 1},{ 14, 15, 2, 1},{ 15, 16, 1, 2},{ 15, 16, 1, 2}, // 8-11
{ 16, 17, 0, 3},{ 18, 19, 4, 0},{ 19, 20, 3, 1},{ 20, 21, 2, 2}, // 12-15
{ 21, 22, 1, 3},{ 22, 23, 0, 4},{ 24, 25, 5, 0},{ 25, 26, 4, 1}, // 16-19
{ 26, 27, 3, 2},{ 27, 28, 2, 3},{ 28, 29, 1, 4},{ 29, 30, 0, 5}, // 20-23
{ 31, 32, 6, 0},{ 32, 33, 5, 1},{ 33, 34, 4, 2},{ 34, 35, 3, 3}, // 24-27
{ 35, 36, 2, 4},{ 36, 37, 1, 5},{ 37, 38, 0, 6},{ 39, 40, 7, 0}, // 28-31
{ 40, 41, 6, 1},{ 41, 42, 5, 2},{ 42, 43, 4, 3},{ 43, 44, 3, 4}, // 32-35
{ 44, 45, 2, 5},{ 45, 46, 1, 6},{ 46, 47, 0, 7},{ 48, 49, 8, 0}, // 36-39
{ 49, 50, 7, 1},{ 50, 51, 6, 2},{ 51, 52, 5, 3},{ 52, 53, 4, 4}, // 40-43
{ 53, 54, 3, 5},{ 54, 55, 2, 6},{ 55, 56, 1, 7},{ 56, 57, 0, 8}, // 44-47
{ 58, 59, 9, 0},{ 59, 60, 8, 1},{ 60, 61, 7, 2},{ 61, 62, 6, 3}, // 48-51
{ 62, 43, 5, 4},{ 43, 63, 4, 5},{ 63, 64, 3, 6},{ 64, 65, 2, 7}, // 52-55
{ 65, 66, 1, 8},{ 66, 67, 0, 9},{ 68, 69,10, 0},{ 69, 70, 9, 1}, // 56-59
{ 70, 71, 8, 2},{ 71, 72, 7, 3},{ 72, 52, 6, 4},{ 53, 73, 4, 6}, // 60-63
{ 73, 74, 3, 7},{ 74, 75, 2, 8},{ 75, 76, 1, 9},{ 76, 77, 0,10}, // 64-67
{ 78, 79,11, 0},{ 79, 80,10, 1},{ 80, 81, 9, 2},{ 81, 82, 8, 3}, // 68-71
{ 82, 62, 7, 4},{ 63, 83, 4, 7},{ 83, 84, 3, 8},{ 84, 85, 2, 9}, // 72-75
{ 85, 86, 1,10},{ 86, 87, 0,11},{ 88, 89,12, 0},{ 89, 90,11, 1}, // 76-79
{ 90, 91,10, 2},{ 91, 92, 9, 3},{ 92, 62, 8, 4},{ 63, 93, 4, 8}, // 80-83
{ 93, 94, 3, 9},{ 94, 95, 2,10},{ 95, 96, 1,11},{ 96, 97, 0,12}, // 84-87
{ 98, 99,13, 0},{ 99,100,12, 1},{100,101,11, 2},{101,102,10, 3}, // 88-91
{102, 72, 9, 4},{ 73,103, 4, 9},{103,104, 3,10},{104,105, 2,11}, // 92-95
{105,106, 1,12},{106,107, 0,13},{108,109,14, 0},{109,110,13, 1}, // 96-99
{110,111,12, 2},{111,112,11, 3},{112, 82,10, 4},{ 83,113, 4,10}, // 100-103
{113,114, 3,11},{114,115, 2,12},{115,116, 1,13},{116,117, 0,14}, // 104-107
{118,119,15, 0},{119,120,14, 1},{120,121,13, 2},{121,122,12, 3}, // 108-111
{122, 92,11, 4},{ 93,123, 4,11},{123,124, 3,12},{124,125, 2,13}, // 112-115
{125,126, 1,14},{126,127, 0,15},{128,129,16, 0},{129,130,15, 1}, // 116-119
{130,131,14, 2},{131,132,13, 3},{132,102,12, 4},{103,133, 4,12}, // 120-123
{133,134, 3,13},{134,135, 2,14},{135,136, 1,15},{136,137, 0,16}, // 124-127
{138,139,17, 0},{139,140,16, 1},{140,141,15, 2},{141,142,14, 3}, // 128-131
{142,102,13, 4},{103,143, 4,13},{143,144, 3,14},{144,145, 2,15}, // 132-135
{145,146, 1,16},{146,147, 0,17},{148,149,18, 0},{149,150,17, 1}, // 136-139
{150,151,16, 2},{151,152,15, 3},{152,112,14, 4},{113,153, 4,14}, // 140-143
{153,154, 3,15},{154,155, 2,16},{155,156, 1,17},{156,157, 0,18}, // 144-147
{158,159,19, 0},{159,160,18, 1},{160,161,17, 2},{161,162,16, 3}, // 148-151
{162,122,15, 4},{123,163, 4,15},{163,164, 3,16},{164,165, 2,17}, // 152-155
{165,166, 1,18},{166,167, 0,19},{168,169,20, 0},{169,170,19, 1}, // 156-159
{170,171,18, 2},{171,172,17, 3},{172,132,16, 4},{133,173, 4,16}, // 160-163
{173,174, 3,17},{174,175, 2,18},{175,176, 1,19},{176,177, 0,20}, // 164-167
{178,179,21, 0},{179,180,20, 1},{180,181,19, 2},{181,182,18, 3}, // 168-171
{182,142,17, 4},{143,183, 4,17},{183,184, 3,18},{184,185, 2,19}, // 172-175
{185,186, 1,20},{186,187, 0,21},{188,189,22, 0},{189,190,21, 1}, // 176-179
{190,191,20, 2},{191,192,19, 3},{192,142,18, 4},{143,193, 4,18}, // 180-183
{193,194, 3,19},{194,195, 2,20},{195,196, 1,21},{196,197, 0,22}, // 184-187
{198,199,23, 0},{199,200,22, 1},{200,201,21, 2},{201,141,20, 3}, // 188-191
{141,152,19, 4},{153,144, 4,19},{144,202, 3,20},{202,203, 2,21}, // 192-195
{203,204, 1,22},{204,205, 0,23},{206,207,24, 0},{207,208,23, 1}, // 196-199
{208,209,22, 2},{209,151,21, 3},{154,210, 3,21},{210,211, 2,22}, // 200-203
{211,212, 1,23},{212,213, 0,24},{214,215,25, 0},{215,216,24, 1}, // 204-207
{216,217,23, 2},{217,161,22, 3},{164,218, 3,22},{218,219, 2,23}, // 208-211
{219,220, 1,24},{220,221, 0,25},{222,223,26, 0},{223,224,25, 1}, // 212-215
{224,140,24, 2},{140,161,23, 3},{164,145, 3,23},{145,225, 2,24}, // 216-219
{225,226, 1,25},{226,227, 0,26},{228,229,27, 0},{229,230,26, 1}, // 220-223
{230,150,25, 2},{155,231, 2,25},{231,232, 1,26},{232,233, 0,27}, // 224-227
{234,235,28, 0},{235,236,27, 1},{236,150,26, 2},{155,237, 2,26}, // 228-231
{237,238, 1,27},{238,239, 0,28},{240,241,29, 0},{241,242,28, 1}, // 232-235
{242,160,27, 2},{165,243, 2,27},{243,244, 1,28},{244,245, 0,29}, // 236-239
{246,247,30, 0},{247,248,29, 1},{248,170,28, 2},{175,249, 2,28}, // 240-243
{249,250, 1,29},{250,251, 0,30},{252,247,31, 0},{247,253,30, 1}, // 244-247
{253,170,29, 2},{175,254, 2,29},{254,250, 1,30},{250,255, 0,31}, // 248-251
{252,247,32, 0},{129,180,30, 2},{185,136, 2,30},{250,255, 0,32}  // 252-255
};

// Squash returns p = 1/(1 + exp(-d)), d scaled by 8 bits, p scaled by 12 bits
short sqt[4095];

int squashc(int d ) {
    if (d < -2047)return 1;
    if (d > 2047)return 4095;
    float p = 1.0f / (1.0f + exp(-d / 256.0));
    p *= 4096.0;
    U32 pi = (U32)round(p);
    if (pi > 4095)pi = 4095;
    if (pi < 1)pi = 1;
    return pi;
}

inline int squash(int d) {
  if (d < -2047)return 1;
  if (d > 2047)return 4095;
  return sqt[d + 2047];
}

// Stretch is inverse of squash. d = ln(p/(1-p)), d scaled by 8 bits, p by 12 bits.
// d has range -2047 to 2047 representing -8 to 8. p has range 0 to 4095.
short strt[4096];

int stretchc(int p) {
    assert(p >= 0 && p <= 4095);
    if (p == 0)p = 1;
    float f = p / 4096.0f;
    float d = log(f / (1.0f - f)) * 256.0f;
    int di = (int)round(d);
    if (di > 2047)di = 2047;
    if (di < -2047)di = -2047;
    return di;
}

inline short stretch(int p) {
    return strt[p];
}

// Mixer m(N, M, S=1, w=0) combines models using M neural networks with
//   N inputs each, of which up to S may be selected.  If S > 1 then
//   the outputs of these neural networks are combined using another
//   neural network (with parameters S, 1, 1).  If S = 1 then the
//   output is direct.  The weights are initially w (+-32K).
//   It is used as follows:
// m.update() trains the network where the expected output is the
//   last bit (in the global variable y).
// m.add(stretch(p)) inputs prediction from one of N models.  The
//   prediction should be positive to predict a 1 bit, negative for 0,
//   nominally +-256 to +-2K.  The maximum allowed value is +-32K but
//   using such large values may cause overflow if N is large.
// m.set(cxt, range) selects cxt as one of 'range' neural networks to
//   use.  0 <= cxt < range.  Should be called up to S times such
//   that the total of the ranges is <= M.
// m.p() returns the output prediction that the next bit is 1 as a
//   12 bit number (0 to 4095).

#if !defined(__GNUC__)

#if (2 == _M_IX86_FP) // 2 if /arch:SSE2 was used.
# define __SSE2__
#elif (1 == _M_IX86_FP) // 1 if /arch:SSE was used.
# define __SSE__
#endif

#endif /* __GNUC__ */

#if defined(__AVX2__)
#include <immintrin.h>
#define OPTIMIZE "AVX2-"
#elif defined(__SSE4_1__)   
#include<smmintrin.h>
#elif   defined(__SSSE3__)
#include<tmmintrin.h>
#elif defined(__SSE2__) 
#include <emmintrin.h>
#define OPTIMIZE "SSE2-"

#elif defined(__SSE__)
#include <xmmintrin.h>
#define OPTIMIZE "SSE-"
#endif

// Vector product a*b of n signed words, returning signed integer scaled down by 8 bits.
// n is rounded up to a multiple of 8.

//static int dot_product (const short* const t, const short* const w, int n);

// Train n neural network weights w[n] on inputs t[n] and err.
// w[i] += ((t[i]*2*err)+(1<<16))>>17 bounded to +- 32K.
// n is rounded up to a multiple of 8.

//static void train (const short* const t, short* const w, int n, const int e);

#if defined(__MMX__)
typedef __m128i XMM;
#endif

struct Mixer1 { 
  int N, M;   // max inputs, max contexts, max context sets
  short*tx; // N inputs from add()  
  short* wx ; // N*M weights
  short *ptr;
  int cxt;  // S contexts
  int pr;   // last result (scaled 12 bits)
  int shift1; 
  int elim;
  int uperr;
  int err;
#if defined(__AVX2__)
 int dot_product (const short* const t, const short* const w, int n) {
  assert(n == ((n + 15) & -16));
  __m256i sum = _mm256_setzero_si256 ();
  while ((n -= 16) >= 0) { // Each loop sums 16 products
    __m256i tmp = _mm256_madd_epi16 (*(__m256i *) &t[n], *(__m256i *) &w[n]); // t[n] * w[n] + t[n+1] * w[n+1]
    tmp = _mm256_srai_epi32 (tmp, 8); //                                        (t[n] * w[n] + t[n+1] * w[n+1]) >> 8
    sum = _mm256_add_epi32 (sum, tmp); //                                sum += (t[n] * w[n] + t[n+1] * w[n+1]) >> 8
  } 
   sum =_mm256_hadd_epi32(sum,_mm256_setzero_si256 ());       //add [1]=[1]+[2], [2]=[3]+[4], [3]=0, [4]=0, [5]=[5]+[6], [6]=[7]+[8], [7]=0, [8]=0
   sum =_mm256_hadd_epi32(sum,_mm256_setzero_si256 ());       //add [1]=[1]+[2], [2]=0,       [3]=0, [4]=0, [5]=[5]+[6], [6]=0,       [7]=0, [8]=0
   __m128i lo = _mm256_extractf128_si256(sum, 0);
   __m128i hi = _mm256_extractf128_si256(sum, 1);
   __m128i newsum = _mm_add_epi32(lo, hi);                    //sum last two
   return _mm_cvtsi128_si32(newsum);
}

 void train (const short* const t, short* const w, int n, const int e) {
  assert(n == ((n + 15) & -16));
  if (e) {
    const __m256i one = _mm256_set1_epi16 (1);
    const __m256i err = _mm256_set1_epi16 (short(e));
    while ((n -= 16) >= 0) { // Each iteration adjusts 16 weights
      __m256i tmp = _mm256_adds_epi16 (*(__m256i *) &t[n], *(__m256i *) &t[n]); // t[n] * 2
      tmp = _mm256_mulhi_epi16 (tmp, err); //                                     (t[n] * 2 * err) >> 16
      tmp = _mm256_adds_epi16 (tmp, one); //                                     ((t[n] * 2 * err) >> 16) + 1
      tmp = _mm256_srai_epi16 (tmp, 1); //                                      (((t[n] * 2 * err) >> 16) + 1) >> 1
      tmp = _mm256_adds_epi16 (tmp, *(__m256i *) &w[n]); //                    ((((t[n] * 2 * err) >> 16) + 1) >> 1) + w[n]
      *(__m256i *) &w[n] = tmp; //                                          save the new eight weights, bounded to +- 32K
    }
  }
}

#elif defined(__SSE2__) || defined(__SSSE3__)
 int dot_product (const short* const t, const short* const w, int n) {
  assert(n == ((n + 15) & -16));
  XMM sum = _mm_setzero_si128 ();
  while ((n -= 8) >= 0) { // Each loop sums eight products
    XMM tmp = _mm_madd_epi16 (*(XMM *) &t[n], *(XMM *) &w[n]); // t[n] * w[n] + t[n+1] * w[n+1]
    tmp = _mm_srai_epi32 (tmp, 8); //                                        (t[n] * w[n] + t[n+1] * w[n+1]) >> 8
    sum = _mm_add_epi32 (sum, tmp); //                                sum += (t[n] * w[n] + t[n+1] * w[n+1]) >> 8
  }
  #if  defined(__SSSE3__)
  sum=_mm_hadd_epi32 (sum,sum);
  sum=_mm_hadd_epi32 (sum,sum);
 #else
  sum = _mm_add_epi32(sum, _mm_srli_si128 (sum, 8));
  sum = _mm_add_epi32(sum, _mm_srli_si128 (sum, 4));
  #endif

  return _mm_cvtsi128_si32 (sum); //                     ...  and scale back to integer
}

 void train (const short* const t, short* const w, int n, const int e) {
  assert(n == ((n + 15) & -16));
  if (e) {
    const XMM one = _mm_set1_epi16 (1);
    const XMM err = _mm_set1_epi16 (short(e));
    while ((n -= 8) >= 0) { // Each iteration adjusts eight weights
      XMM tmp = _mm_adds_epi16 (*(XMM *) &t[n], *(XMM *) &t[n]); // t[n] * 2
      tmp = _mm_mulhi_epi16 (tmp, err); //                                     (t[n] * 2 * err) >> 16
      tmp = _mm_adds_epi16 (tmp, one); //                                     ((t[n] * 2 * err) >> 16) + 1
      tmp = _mm_srai_epi16 (tmp, 1); //                                      (((t[n] * 2 * err) >> 16) + 1) >> 1
      tmp = _mm_adds_epi16 (tmp, *(XMM *) &w[n]); //                    ((((t[n] * 2 * err) >> 16) + 1) >> 1) + w[n]
      *(XMM *) &w[n] = tmp; //                                          save the new eight weights, bounded to +- 32K
    }
  }
}

#elif defined(__SSE__)
 int dot_product (const short* const t, const short* const w, int n) {
  assert(n == ((n + 15) & -16));
  __m64 sum = _mm_setzero_si64 ();
  while ((n -= 8) >= 0) { // Each loop sums eight products
    __m64 tmp = _mm_madd_pi16 (*(__m64 *) &t[n], *(__m64 *) &w[n]); //   t[n] * w[n] + t[n+1] * w[n+1]
    tmp = _mm_srai_pi32 (tmp, 8); //                                    (t[n] * w[n] + t[n+1] * w[n+1]) >> 8
    sum = _mm_add_pi32 (sum, tmp); //                            sum += (t[n] * w[n] + t[n+1] * w[n+1]) >> 8

    tmp = _mm_madd_pi16 (*(__m64 *) &t[n + 4], *(__m64 *) &w[n + 4]); // t[n+4] * w[n+4] + t[n+5] * w[n+5]
    tmp = _mm_srai_pi32 (tmp, 8); //                                    (t[n+4] * w[n+4] + t[n+5] * w[n+5]) >> 8
    sum = _mm_add_pi32 (sum, tmp); //                            sum += (t[n+4] * w[n+4] + t[n+5] * w[n+5]) >> 8
  }
  sum = _mm_add_pi32 (sum, _mm_srli_si64 (sum, 32)); // Add eight sums together ...
  const int retval = _mm_cvtsi64_si32 (sum); //                     ...  and scale back to integer
  _mm_empty(); // Empty the multimedia state
  return retval;
}

 void train (const short* const t, short* const w, int n, const int e) {
  assert(n == ((n + 15) & -16));
  if (e) {
    const __m64 one = _mm_set1_pi16 (1);
    const __m64 err = _mm_set1_pi16 (short(e));
    while ((n -= 8) >= 0) { // Each iteration adjusts eight weights
      __m64 tmp = _mm_adds_pi16 (*(__m64 *) &t[n], *(__m64 *) &t[n]); //   t[n] * 2
      tmp = _mm_mulhi_pi16 (tmp, err); //                                 (t[n] * 2 * err) >> 16
      tmp = _mm_adds_pi16 (tmp, one); //                                 ((t[n] * 2 * err) >> 16) + 1
      tmp = _mm_srai_pi16 (tmp, 1); //                                  (((t[n] * 2 * err) >> 16) + 1) >> 1
      tmp = _mm_adds_pi16 (tmp, *(__m64 *) &w[n]); //                  ((((t[n] * 2 * err) >> 16) + 1) >> 1) + w[n]
      *(__m64 *) &w[n] = tmp; //                                       save the new four weights, bounded to +- 32K

      tmp = _mm_adds_pi16 (*(__m64 *) &t[n + 4], *(__m64 *) &t[n + 4]); // t[n+4] * 2
      tmp = _mm_mulhi_pi16 (tmp, err); //                                 (t[n+4] * 2 * err) >> 16
      tmp = _mm_adds_pi16 (tmp, one); //                                 ((t[n+4] * 2 * err) >> 16) + 1
      tmp = _mm_srai_pi16 (tmp, 1); //                                  (((t[n+4] * 2 * err) >> 16) + 1) >> 1
      tmp = _mm_adds_pi16 (tmp, *(__m64 *) &w[n + 4]); //              ((((t[n+4] * 2 * err) >> 16) + 1) >> 1) + w[n]
      *(__m64 *) &w[n + 4] = tmp; //                                   save the new four weights, bounded to +- 32K
    }
    _mm_empty(); // Empty the multimedia state
  }
}
#else

// dot_product returns dot product t*w of n elements.  n is rounded
// up to a multiple of 8.  Result is scaled down by 8 bits.
int dot_product(short *t, short *w, int n) {
  int sum=0;
  n=(n+15)&-16;
  for (int i=0; i<n; i+=2)
    sum+=(t[i]*w[i]+t[i+1]*w[i+1]) >> 8;
  return sum;
}

// Train neural network weights w[n] given inputs t[n] and err.
// w[i] += t[i]*err, i=0..n-1.  t, w, err are signed 16 bits (+- 32K).
// err is scaled 16 bits (representing +- 1/2).  w[i] is clamped to +- 32K
// and rounded.  n is rounded up to a multiple of 8.

void train(short *t, short *w, int n, int err) {
  n=(n+15)&-16;
  for (int i=0; i<n; ++i) {
    int wt=w[i]+(((t[i]*err*2>>16)+1)>>1);
    if (wt<-32768) wt=-32768;
    if (wt>32767) wt=32767;
    w[i]=wt;
  }
}
#endif 

  // Adjust weights to minimize coding cost of last prediction
  void update(int y) {
       err=((y<<12)-pr)*uperr/4;
      if (err>32767)
          err=32767;
      if (err<-32768)
          err=-32768;
      if(err>=-elim && err<=elim) err=0;
      train(&tx[0], &wx[cxt*N], N, err);
  }
 
  // predict next bit
  int p( ) {
    assert(cxt<M);
    int dp=dot_product(&tx[0], &wx[cxt*N], N)*shift1>>11;
    return pr=squash(dp);
  }
    int p1( ) {
    assert(cxt<M);
    int dp=dot_product(&tx[0], &wx[cxt*N], N)*shift1>>11;
    if (dp<-2047) {
            dp=-2047;
        }
        else if (dp>2047) {
            dp=2047;
        }
        pr=squash(dp);
    return dp;
  }
  void setTxWx(int n,short* mn){
    N=n;
    alloc1(wx,(N*M)+32,ptr,32);
    tx=mn; 
  }
  void Init(int m,  U32 s,U32 e,U32 ue){
    M=m,  cxt=0, shift1=s,elim=e,uperr=ue;err=0;
    pr=2048; //initial p=0.5
  }
  void Free(){
    free(ptr);
  }
 /* void Print(){
      // print N weights averaged over context
  printf("Mixer(%d,%d): ", N, M);
  for (int i=0; i<N; ++i) {
    int w=0;
    for (int j=0; j<M; ++j)
      w+=wx[j*N+i],printf("%d ",wx[j*N+i]);;
    printf("%d ", w/M);
  }
  printf("\n");
  }*/
};

// A StateMap maps a context to a probability.  Methods:

// Statemap sm(n) creates a StateMap with n contexts using 4*n bytes memory.
// sm.p(y, cx, limit) converts state cx (0..n-1) to a probability (0..4095).
//     that the next y=1, updating the previous prediction with y (0..1).
//     limit (1..1023, default 1023) is the maximum count for computing a
//     prediction.  Larger values are better for stationary sources.

static int dt[1024];  // i -> 16K/(i+i+3)

struct StateMap {
  int N;        // Number of contexts
  int cxt;      // Context of last prediction
  U32 *t;       // cxt -> prediction in high 22 bits, count in low 10 bits
  int pr;
  int mask;
  int limit; 
  const U8 *nn;
  int next(int i, int y){
      return nn[ y + i*4];
  }
  void Init(int n, int lim,const U8 *nn1){nn=nn1;
    N=n, cxt=0, pr=2048, mask=n-1,limit=lim;
    assert(ispowerof2(n));
    alloc(t,n);
    assert(limit>0 && limit<1024);
    if (N==256){
        for (int i=0; i<N; ++i){
            U32 n0=next(i, 2)*3+1;
            U32 n1=next(i, 3)*3+1;
            t[i]=(((n1<<20) / (n0+n1)) << 12);
        }
    }else{
        for (int i=0; i<N; ++i)
            t[i]=1<<31;
    }
  }
  void Free(){
    free(t);
  }
  inline void update(const int y) {    
    assert(y==0 || y==1);
    U32 *p=&t[cxt], p0=p[0];
    int n=p0&1023, pr1=p0>>12;  // count, prediction
    p0+=(n<limit);
    p0+=(((((y<<20)-pr1)))*dt[n]+512)&0xfffffc00;
    p[0]=p0;
  }
  // update bit y (0..1), predict next bit in context cx
  void set(const int c,const int y) {  
    assert(cxt>=0 && cxt<N);
    update(y);
    pr=t[cxt=(c&mask)]>>20;
  } 
  /*void print(){
      for (int i=0;i<N;i++){
          printf("%d\n",t[i]>>20);
      }
  }*/
}; 

inline short clp(int z){
    if (z<-2047){
        z=-2047;
    }else if (z>2047){
        z=2047;
    }
    return z;
}
inline short clp1(int z){
    if (z<0){
        z=0;
    }else if (z>4095){
        z=4095;
    }
    return z;
}
// A RunContextMap maps a context into the next byte and a repeat
// count up to M.  Size should be a power of 2.  Memory usage is 3M/4.
struct RunContextMap {
  enum {B=4,M=4}; 
  U8 *t;   // hash t
  U8 *ptr;
  U8* cp;
  short rc[512];
  U8 tmp[B];
  U32 n;
  void Init(int m,int rcm_ml=8){ 
    alloc1(t,m,ptr,64);  
    n=(m/B-1);
    for (int r=0;r<B;r++) tmp[r]=0;
    cp=&t[0]+1;
    for (int r=0;r<256;r++) {
        int c=ilog[r]*8;
        if ((r&1)==0) c=c*rcm_ml/4;
	    rc[r+256]=clp(c);
	    rc[r]=clp(-c);
     }
  
  }
  void Free(){
    free(ptr);
  }
  void __attribute__ ((noinline)) set(U32 cx,U8 c1) {  // update count
    if (cp[0]==0) cp[0]=2, cp[1]=c1;
    else if (cp[1]!=c1) cp[0]=1, cp[1]=c1;
    else if (cp[0]<254) cp[0]=cp[0]+2;
    cp=find(cx)+1;
  }
  int p() {  // predict next bit
    int b=x.c0shift_bpos ^ (cp[1] >> x.bposshift);
    if (b<=1)
      return rc[b*256+cp[0]];
    else
      return 0;
  }
  int mix(int m) {  // return run length
    x.mxInputs[m].add(p());
    return cp[0]!=0;
  }
  
  inline  U8* find(U32 i) {
    U16 chk=(i>>16^i)&0xffff;
    i=i*M&n;
    U8 *p;
    U16 *cp1;
    int j;
    for (j=0; j<M; ++j) {
      p=&t[(i+j)*B];
      cp1=(U16*)p;
      if (p[2]==0) {*cp1=chk;break;}
      if (*cp1==chk) break;  // found
    }
    if (j==0) return p+1;  // front
    if (j==M) {
      --j;
      memset(&tmp, 0, B);
      memmove(&tmp, &chk, 2);
      if (M>2 && t[(i+j)*B+2]>t[(i+j-1)*B+2]) --j;
    }
    else memcpy(&tmp, cp1, B);
    memmove(&t[(i+1)*B], &t[i*B], j*B);
    memcpy(&t[i*B], &tmp, B);
    return &t[i*B+1];
  }
};

// Map for modelling contexts of (nearly-)stationary data.
// The context is looked up directly. For each bit modelled, a 16bit prediction is stored.
// The adaptation rate is controlled by the caller, see mix().

// - BitsOfContext: How many bits to use for each context. Higher bits are discarded.
// - InputBits: How many bits [1..8] of input are to be modelled for each context.
// New contexts must be set at those intervals.

// Uses (2^(BitsOfContext+1))*((2^InputBits)-1) bytes of memory.

struct SmallStationaryContextMap {
  U16 *Data;
  int Context, Mask, Stride, bCount, bTotal, B,N;
  U16 *cp;

  void Init(int BitsOfContext,  int InputBits = 8)     {
    assert(InputBits>0 && InputBits<=8);
    Context=0, Mask=((1<<BitsOfContext)-1), 
    Stride=((1<<InputBits)-1), bCount=(0), bTotal=(InputBits), B=(0)  ;
    N=(1ull<<BitsOfContext)*((1ull<<InputBits)-1);
    alloc(Data,N);
    for (int i=0; i<N; ++i)
      Data[i]=0x7FFF;
    cp=&Data[0];
  }
  void Free(){
    free(Data);
  }
  void set(U32 ctx) {
    Context = (ctx&Mask)*Stride;
    bCount=B=0;
  }
  void __attribute__ ((noinline)) mix(int m ) {
  const int rate = 7; const int Multiplier = 1;const int Divisor = 4;
    *cp+=((x.y<<16)-(*cp)+(1<<(rate-1)))>>rate;
    B+=(x.y && B>0);
    cp = &Data[Context+B];
    int Prediction = (*cp)>>4;
    x.mxInputs[m].add((stretch(Prediction)*Multiplier)/Divisor);
    x.mxInputs[m].add(((Prediction-2048)*Multiplier)/(Divisor*2));
    bCount++; B+=B+1;
    if (bCount==bTotal)
      bCount=B=0;
  }
};



// Context map for large contexts.  Most modeling uses this type of context
// map.  It includes a built in RunContextMap to predict the last byte seen
// in the same context, and also bit-level contexts that map to a bit
// history state.
//
// Bit histories are stored in a hash table.  The table is organized into
// 64-byte buckets alinged on cache page boundaries.  Each bucket contains
// a hash chain of 7 elements, plus a 2 element queue (packed into 1 byte)
// of the last 2 elements accessed for LRU replacement.  Each element has
// a 2 byte checksum for detecting collisions, and an array of 7 bit history
// states indexed by the last 0 to 2 bits of context.  The buckets are indexed
// by a context ending after 0, 2, or 5 bits of the current byte.  Thus, each
// byte modeled results in 3 main memory accesses per context, with all other
// accesses to cache.
//
// On bits 0, 2 and 5, the context is updated and a new bucket is selected.
// The most recently accessed element is tried first, by comparing the
// 16 bit checksum, then the 7 elements are searched linearly.  If no match
// is found, then the element with the lowest priority among the 5 elements
// not in the LRU queue is replaced.  After a replacement, the queue is
// emptied (so that consecutive misses favor a LFU replacement policy).
// In all cases, the found/replaced element is put in the front of the queue.
//
// The priority is the state number of the first element (the one with 0
// additional bits of context).  The states are sorted by increasing n0+n1
// (number of bits seen), implementing a LFU replacement policy.
//
// When the context ends on a byte boundary (bit 0), only 3 of the 7 bit
// history states are used.  The remaining 4 bytes implement a run model
// as follows: <count:7,d:1> <b1> <unused> <unused> where <b1> is the last byte
// seen, possibly repeated.  <count:7,d:1> is a 7 bit count and a 1 bit
// flag (represented by count * 2 + d).  If d=0 then <count> = 1..127 is the
// number of repeats of <b1> and no other bytes have been seen.  If d is 1 then
// other byte values have been seen in this context prior to the last <count>
// copies of <b1>.
//
// As an optimization, the last two hash elements of each byte (representing
// contexts with 2-7 bits) are not updated until a context is seen for
// a second time.  This is indicated by <count,d> = <1,0> (2).  After update,
// <count,d> is updated to <2,0> or <1,1> (4 or 3).

inline int sc(int p){
    if (p>0) return p>>7;
    return (p+127)>>7;// p+((1<<s)-1);
}

// A BH maps a 32 bit hash to an array of B bytes (checksum and B-2 values)
//
// BH bh(N); creates N element table with B bytes each.
//   N must be a power of 2.  The first byte of each element is
//   reserved for a checksum to detect collisions.  The remaining
//   B-1 bytes are values, prioritized by the first value.  This
//   byte is 0 to mark an unused element.
//
// bh[i] returns a pointer to the i'th element, such that
//   bh[i][0] is a checksum of i, bh[i][1] is the priority, and
//   bh[i][2..B-1] are other values (0-255).
//   The low lg(n) bits as an index into the table.
//   If a collision is detected, up to M nearby locations in the same
//   cache line are tested and the first matching checksum or
//   empty element is returned.
//   If no match or empty element is found, then the lowest priority
//   element is replaced.

// 2 byte checksum with LRU replacement (except last 2 by priority)
struct E {  // hash element, 64 bytes
    U16 chk[7];  // byte context checksums
    U8 last;     // last 2 accesses (0-6) in low, high nibble
    U8 bh[7][7]; // byte context, 3-bit context -> bit history state
      // bh[][0] = 1st bit, bh[][1,2] = 2nd bit, bh[][3..6] = 3rd bit
      // bh[][0] is also a replacement priority, 0 = empty
  //  U8* get(U16 chk);  // Find element (0-6) matching checksum.
      // If not found, insert or replace lowest priority (not last).
      inline U8* get(U16 ch,int keep) {
    
  if (chk[last&15]==ch) return &bh[last&15][0];
  int b=0xffff, bi=0;
 
  for (int i=0; i<7; ++i) {
    if (chk[i]==ch) return last=last<<4|i, (U8*)&bh[i][0];
    int pri=bh[i][0];
    if (pri<b && (last&15)!=i && last>>4!=i) b=pri, bi=i;
  }
  return last=last<<4|bi|keep, chk[bi]=ch, (U8*)memset(&bh[bi][0], 0, 7);
}
    
};

inline U32 getStateByteLocation(const int bpos, const int c0) {
  U32 pis = 0; //state byte position in slot
  const U32 smask = (U32(0x31031010) >> (bpos << 2)) & 0x0F;
  pis = smask + (c0 & smask);
  return pis;
}

#define MAXCXT 7

struct ContextMap {
  int C;  // max number of contexts
  U8* cp[MAXCXT];   // C pointers to current bit history
  U8* cp0[MAXCXT];  // First element of 7 element array containing cp[i]
  U32 cxt[MAXCXT];  // C whole byte contexts (hashes)
  U8* runp[MAXCXT]; // C [0..3] = count, value, unused, unused
  StateMap *sm;    // C maps of state -> p
  int cn;          // Next context to set by set()
  int result;
  short rc1[512];
  short st1[4096];
  short st2[4096];
  short st32[256];
  short st8[256]; 
  int cms,cms2,cms3,cms4;
  int bias;
  int kep;
  const U8 *nn;
  E *ptr,*t;
  U32 tmask;
  
  const inline U8  next(int i, int y){
      return nn[ y + i*4];
  }

  int __attribute__ ((noinline)) mix(const int m) {return mix1(m,  x.c0,  x.bpos, (U8) x.c4,  x.y);}
  inline int pre(const int state) {
    assert(state>=0 && state<256);
    U32 n0=next(state, 2)*3+1;
    U32 n1=next(state, 3)*3+1;
    return (n1<<12) / (n0+n1);
  }

// Construct using m bytes of memory for c contexts(c+7)&-8
void __attribute__ ((noinline)) Init(U32 m, int c, int s3,const U8 *nn1,int cs4,const int Bias,int k){
    C=c&255;
    tmask=((m>>6)-1); 
    cn=0;
    result=0;
    bias=Bias;
    kep=k;
    alloc1(t,(m>>6)+64,ptr,64);  
    nn=nn1;        
    int cmul=(c>>8)&255;          // run context mul value
    cms=(c>>16)&255;              // mix prediction mul value
    cms2=(U32(c)>>24)&255;
    cms4=cs4;
    cms3=s3;
    assert(m>=64 && (m&m-1)==0);  // power of 2?
    assert(sizeof(E)==64);
    alloc(sm,C);
    for (int i=0; i<C; i++) 
        sm[i].Init(256,1023,nn1);
    for (int i=0; i<C; ++i) {
        cp0[i]=cp[i]=&t[0].bh[0][0];
        runp[i]=cp[i]+3;
    }
    // precalc int c=ilog(rc+1)<<(2+(~rc&1));
    for (int rc=0;rc<256;rc++) {
        int c=ilog[rc];
        c=c<<(2+(~rc&1));
        if ((rc&1)==0) c=c*cmul/4;
        rc1[rc+256]=clp(c);
        rc1[rc]=clp(-c);
    }

    // precalc mix3 mixer inputs
    for (int i=0;i<4096;i++) {
        st1[i]=clp(sc(cms*stretch(i)));
        st2[i]=clp(sc(cms2*(i - 2048)));
    } 

    for (int s=0;s<256;s++) {
        int n0=-!next(s,2);
        int n1=-!next(s,3);
        int r=0;
        int sp0=0;
        if ((n1-n0)==1 ) sp0=0,r=1;
        if ((n1-n0)==-1 ) sp0=4095,r=1;
        if (r) {
            st8[s] =clp(sc((cms4)*(pre(s)-sp0)));
            st32[s]=clp(sc((cms3)*stretch(pre(s))));
            if (s<8) st32[s]=0;
        }else{
            st8[s] =0;
            st32[s]=0;
        }
    }
}

void Free() {
    for (int i=0; i<C; i++) {
        sm[i].Free();
    }
    free(sm);
    free(ptr);
}

// Set the i'th context to cx
inline void set(U32 cx) {
  int i=cn++;
  assert(i>=0 && i<C);
  cx=cx*987654323+i;  // permute (don't hash) cx to spread the distribution
  cx=cx<<16|cx>>16;
  cxt[i]=cx*123456791+i;
}
// Predict to mixer m from bit history state s, using sm to map s to
// a probability.

inline int mix3(const int y,const int m,const int s, StateMap& sm) {
  if (s==0){
    x.mxInputs[m].add(0); 
    x.mxInputs[m].add(0);
    x.mxInputs[m].add(0);
    x.mxInputs[m].add(0);
    x.mxInputs[m].add(32*bias);
    return 0;
  }else{
    sm.set(s,y);
    const int p1=sm.pr;
    x.mxInputs[m].add(st1[p1]); // From StateMap
    x.mxInputs[m].add(st2[p1]);
    x.mxInputs[m].add(st8[s]);  // From state
    x.mxInputs[m].add(st32[s]);
    x.mxInputs[m].add(0);
    return 1;
  }
}

// Update the model with bit y1, and predict next bit to mixer m.
// Context: cc=c0, bp=bpos, c1=buf(1), y1=y.
int mix1(const int m,const int cc,const int bp,const int c1,const int y1) {
  // Update model with y
   result=0;

  for (int i=0; i<cn; ++i) {
    if (cp[i]) {
      assert(cp[i]>=&t[0].bh[0][0] && cp[i]<=&t[tmask].bh[6][6]);
      assert(((long long)(cp[i])&63)>=15);
      *cp[i]=next(*cp[i], y1);
    }

    // Update context pointers
    int s = 0;
    if (bp>1 && runp[i][0]==0) {
     cp[i]=0;
    } else {
     U16 chksum=(cxt[i]>>16)^i;
     
     if (bp){     
       if (bp==2 || bp==5)cp0[i]=cp[i]=t[(cxt[i]+cc)&tmask].get(chksum,kep);
       else cp[i]=cp0[i]+getStateByteLocation(bp,cc);
    } else {// default
       cp0[i]=cp[i]=t[(cxt[i]+cc)&tmask].get(chksum,kep);
       // Update pending bit histories for bits 2-7
       if (cp0[i][3]==2) {
         const int c=cp0[i][4]+256;
         U8 *p=t[(cxt[i]+(c>>6))&tmask].get(chksum,kep);
         p[0]=1+((c>>5)&1);
         p[1+((c>>5)&1)]=1+((c>>4)&1);
         p[3+((c>>4)&3)]=1+((c>>3)&1);
         p=t[(cxt[i]+(c>>3))&tmask].get(chksum,kep);
         p[0]=1+((c>>2)&1);
         p[1+((c>>2)&1)]=1+((c>>1)&1);
         p[3+((c>>1)&3)]=1+(c&1);
         cp0[i][6]=0;
       }
       // Update run count of previous context
       if (runp[i][0]==0)  // new context
         runp[i][0]=2, runp[i][1]=c1;
       else if (runp[i][1]!=c1)  // different byte in context
         runp[i][0]=1, runp[i][1]=c1;
       else if (runp[i][0]<254)  // same byte in context
         runp[i][0]+=2;
       runp[i]=cp0[i]+3;
      }
     s = *cp[i];
    }
    // predict from bit context

    result=result+mix3(y1,m, s, sm[i]);
    // predict from last byte in context
    int b=x.c0shift_bpos ^ (runp[i][1] >> x.bposshift);
    if (b<=1) {
       b=b*256;   // predicted bit + for 1, - for 0
       // count*2, +1 if 2 different bytes seen
	   x.mxInputs[m].add(rc1[runp[i][0]+b]);
    }
    else
      x.mxInputs[m].add(0);
  }
  if (bp==7) cn=0;
  return result;
}
};

// APM maps a probability and a context into a new probability
// that bit y will next be 1.  After each guess it updates
// its state to improve future guesses.  Methods:
//
// APM a(N) creates with N contexts, uses 66*N bytes memory.
// a.p(pr, cx, rate=8) returned adjusted probability in context cx (0 to
//   N-1).  rate determines the learning rate (smaller = faster, default 8).
//   Probabilities are scaled 16 bits (0-65535).

struct  APM {
    int index;     // last p, context
    U16 *t;        // [N][33]:  p, context -> p

    int p(int pr=2048, int cxt=0, int rate=8, int y=0) {
        pr=stretch(pr);
        int g=(y<<16)+(y<<rate)-y*2;
        t[index]   += (g-t[index])   >> rate;
        t[index+1] += (g-t[index+1]) >> rate;
        const int w=pr&127;  // interpolation weight (33 points)
        index=((pr+2048)>>7)+cxt*33;
        return (t[index]*(128-w)+t[index+1]*w) >> 11;
    }

    // maps p, cxt -> p initially
    void Init(int n){
        index=0;
        alloc(t,n*33);
        for (int j=0; j<33; ++j) t[j]=squash((j-16)*128)*16;
        for (int i=33; i<n*33; ++i) t[i]=t[i-33];
    }
    void Free(){
        free(t);
   }
};

#ifdef TEXTMODE
//text
#define COLON         58 // :
#define SEMICOLON     59 // ;
#define LESSTHAN      60 // <
#define EQUALS        61 // =
#define GREATERTHAN   62 // >
#define QUESTION      63 // ?
#define ATSIGN        64 // @
#define SQUAREOPEN    91 // [
#define BACKSLASH     92 // '\'
#define SQUARECLOSE   93 // ]
#define CURLYOPENING 123 // {
#define VERTICALBAR  124 // |
#define CURLYCLOSE   125 // }
#else
//wrt
#define COLON         'J' // :
#define SEMICOLON     'K' // ;
#define LESSTHAN      'L' // <
#define EQUALS        'M' // =
#define GREATERTHAN   'N' // >
#define QUESTION      'O' // ?
#define ATSIGN         64 // @
#define SQUAREOPEN     91 // [
#define BACKSLASH      92 // '\'
#define SQUARECLOSE    93 // ]
#define CURLYOPENING  'P' // {
#define VERTICALBAR   'Q' // |
#define CURLYCLOSE    'R' // }
#define CHARSWAP
#endif

#define APOSTROPHE    39  // '
#define QUOTATION     34  // "
#define SPACE         32  // ' '

// Vector for different contexts
static const int charSize = 32;
template <typename T = int>
struct vec {
    T* cxt;
    int capacity;
    int size;
};

template <typename T = int>
void vec_new(vec<T>* o){
    o->cxt=static_cast<T*>( calloc(charSize, sizeof(T)));
    o->capacity=charSize;
    o->size=0;
}
template <typename T = int>
void vec_free(vec<T>* o){
    free(o->cxt);
}
template <typename T = int>
int vec_size(vec<T> *o){
    return o->size;
}
template <typename T  = int>
void vec_push(struct vec<T> *o, const T element){
    if(o->size>0 && o->size%o->capacity==0) {
        o->capacity=(o->size/charSize+1)*charSize;
        o->cxt=static_cast<T*>(realloc(o->cxt, o->capacity*sizeof(T)));
    }
    o->cxt[o->size++]=element;
}
template <typename T  = int>
int vec_at(vec<T> *o, const int index){
    return o->cxt[index];
}
template <typename T  = int>
void vec_i(vec<T> *o, const int index){
    o->cxt[index]++;
}
template <typename T  = int>
void vec_pop(vec<T> *o){
    o->cxt[o->size-1]=0;
    o->size--;
}
template <typename T  = int>
void vec_reset(vec<T> *o){
    o->cxt[0]=0;
    o->size=0;
}
template <typename T  = int>
bool vec_empty(vec<T> *o){
    return (o->size==0)?true:false;
}
template <typename T  = int>
int vec_prev(vec<T> *o){
    return (o->size>1)?(o->cxt[o->size-2]):0;
}
// This part is based on cmix BracketContext
struct BracketContext {
    U32 context;           // bracket byte and distance
    vec<int> active;            // vector for brackets
    vec<int> distance;          // vector for distance
    const U8 *element;           
    int elementCount;
    bool doPop;            // set true for quotes
    int limit;
    void Init(const U8*d,const int e,int pop=false,int l=255) {
        elementCount=e;
        element=d;
        context = 0;
        doPop=pop;
        limit=l;
        vec_new(&active);
        vec_new(&distance);
    }
    void Reset(){
          vec_reset(&active);
    vec_reset(&distance);
    context=0;
 
    }
    bool Find(int b){
        bool found=false;
        for (int i=0;i<elementCount;i=i+2) if (element[i]==b) {
            found=true;
            break;
        }
        return found;
    }
    bool FindEnd(int b,int c){
        bool found=false;
        for (int i=0;i<elementCount;i=i+2) if (element[i]==b&&element[i+1]==c) found=true;
        return found;
    }
    int last(){
        return vec_prev(&active);
    }
    void __attribute__ ((noinline)) Update(int byte) {
        bool pop=false;
        if (!vec_empty(&active)) {
            if (FindEnd(vec_at(&active,vec_size(&active)-1) , byte) || vec_at(&distance,vec_size(&distance)-1) >= limit) {
                vec_pop(&active);
                vec_pop(&distance);
                pop=doPop;
            } else {
                vec_i(&distance,vec_size(&distance)-1);
            }
        }
        if (pop==false && Find(byte)) {
            vec_push( &active,byte);
            vec_push( &distance,0);
        }
        if (!vec_empty(&active)) {
            context = 256 * vec_at(&active,vec_size(&active)-1)+min(vec_at(&distance,vec_size(&distance)-1),255);
        } else {
            context = 0;
        }
    }
    void Free(){
        vec_free(&active);
        vec_free(&distance);
    }
};

// Table/row & column context
struct Column {
    U32 linepos;
    U8 fc;
    vec<U8> bytes;
};

struct ColumnContext {
    Column col[4];         // Content of last 3 + current row
    vec<U32> cell[4];      // Content of table row cell positions, max 4 rows
    int rows;
    int cellCount,cells,abovecellpos,abovecellpos1;
    bool NL;
    int limit;  // column lenght limit
    U8 nlChar;
    void Init( int l=31) {
        rows=abovecellpos=cellCount=abovecellpos1=0;
        nlChar=10;
        limit=l;
        for (int i=0;i<4;i++) vec_new(&col[i].bytes);
        for (int i=0;i<4;i++) vec_new(&cell[i]);
    }
   
    U8 lastfc(int i=0){
        return col[(rows-i)&3].fc;
    }
    bool isNewLine(){
        return NL;
    }
    int collen(int i=0,int l=0){
        return min((l?l:limit), vec_size(&col[(rows-i)&3].bytes)+1);
    }
    int nlpos(int i=0){
        return col[(rows-i)&3].linepos;
    }
    U8 colb(int i=1,int j=0,int l=0){
        if (collen(0,l)<collen(i,l))
      return  vec_at(&col[(rows-i)&3].bytes,collen()-(1+j));
      else return 0;
    }
    void __attribute__ ((noinline)) Update(int byte,int b2=0) {
        // Start and end of table
        if ( b2==((CURLYOPENING<<16)+ (CURLYOPENING<<8)+ VERTICALBAR) ) nlChar='-';
        if ( b2==((VERTICALBAR<<16)+ (CURLYCLOSE<<8)+CURLYCLOSE ) ) nlChar=10,resetCells();
        // Column
        NL=false;
        if (byte==10){
            vec_push( &col[rows].bytes,U8(byte));
            rows++;
            rows=rows&3;
            vec_reset(&col[rows].bytes); // reset new line.
            col[rows].fc=0;
            col[rows].linepos=x.blpos-1;
        }else{
            vec_push( &col[rows].bytes,U8(byte)); // set new byte to line
            if (collen()==2) {
                col[rows].fc=min(byte,96);
                NL=true;
            }
        }
        /*
        {|  Table start	It opens a table (and is required)
        |+  Table caption	It adds a caption
        |-  Table row	It adds a new row (but it is optional for the first row)
        !   Header cell	It adds a header cell, whose content can optionally be placed on a new line
        !!  Header cell (on the same line)	It adds a header cell on the same line
        |   Data cell	It adds a data cell, whose content can optionally be placed on a new line (see also the attribute separator)
        ||  Data cell (on the same line)	It adds a data cell on the same line
        |   Attribute separator	It separates a HTML attribute from cell or caption contents
        |}  Table end	It closes a table (and is required)
        */
        // Only  {| |- | || |} are implemented
        if (nlChar=='-'){
            if ((b2&0xffff)==('-'+VERTICALBAR*256)){
                cells++;
                cells=cells&3;
                vec_reset(&cell[cells]); // reset new row.
                vec_push( &cell[cells],U32(x.blpos));
                cellCount=abovecellpos=abovecellpos1=0;
            }
            bool newcell=false;
            // Cells
            if ( (b2&0xffff)==(VERTICALBAR+VERTICALBAR*256) ||                // || 
             (b2&0xffff00)==((VERTICALBAR+10*256)*256) ||                     // \n|x
            ((b2&0xffff00)==((VERTICALBAR+10*256)*256) && byte!=VERTICALBAR)  // \n|yx  where y!=|
            ) vec_push( &cell[cells],U32(x.blpos)),cellCount++,newcell=true;
            // Advence above cell pos
            if (abovecellpos ) {
                abovecellpos++;
                // When above cell is shorter reset
                if (abovecellpos>abovecellpos1) abovecellpos=abovecellpos1=0;
            }
            // If more then one cell get above cell based on current row cell
            if(newcell==true && cellsCount() >0){
                // Get current above cell pos
                abovecellpos=cellPos(cellCount-1);
                abovecellpos1=cellPos(cellCount);
            }
        }
        #ifndef TEXTMODE
        if (nlChar==GREATERTHAN){
            if ((b2&0xffff)==(GREATERTHAN+10*256)){
                //printf("%d %d\n",vec_size(&cell[cells]),vec_at(&cell[cells],vec_size(&cell[cells])-1));
                cells++;
                cells=cells&3;
                vec_reset(&cell[cells]); // reset new row.
                vec_push( &cell[cells],U32(x.blpos));
                cellCount=abovecellpos=abovecellpos1=0;
                //printf("\n");
            }else{
            
            bool newcell=false;
            // Cells
            if ( (b2&0xff)==(GREATERTHAN) ) vec_push( &cell[cells],U32(x.blpos)),cellCount++,newcell=true;
            // Advence above cell pos
            if (abovecellpos ) {
                abovecellpos++;
                // When above cell is shorter reset
                if (abovecellpos>abovecellpos1) abovecellpos=abovecellpos1=0;
            }
            // If more then one cell get above cell based on current row cell
            if(newcell==true && cellsCount() >0){
                //printf("%d  ",cellPos(cellCount-1));
                // Get current above cell pos
                abovecellpos=cellPos(cellCount-1);
                abovecellpos1=cellPos(cellCount);
            }
            }
        }
        #endif
    }
    int cellsCount(int row=1){
        return vec_size(&cell[(cells-row)&3]);
    }
    int cellPos(int cellID,int row=1){
        int total=cellsCount(row)-1;
        total=min(total,cellID);
        return vec_at(&cell[(cells-row)&3],total);
    }
    void resetCells(){
        for (int i=0;i<4;i++) vec_reset(&cell[i]);
    }
    void Free(){
        for (int i=0;i<4;i++) vec_free(&col[i].bytes);
        for (int i=0;i<4;i++) vec_reset(&cell[i]);
    }
};
// Keep track of main brackets
const U8 brackets[8]={'(',')', CURLYOPENING,CURLYCLOSE, '[',']', LESSTHAN,GREATERTHAN};
// Keep track of ' and " as quotes
const U8 quotes[4]={APOSTROPHE,APOSTROPHE,QUOTATION,QUOTATION};
// Keep track of first char including some brackets
const U8 fchar[20]={ATSIGN,10, 96,10, COLON,10, LESSTHAN,GREATERTHAN,EQUALS,10,SQUAREOPEN,SQUARECLOSE,CURLYOPENING,CURLYCLOSE,'*',10,VERTICALBAR,10,31,10};

// Sentence & words context
struct WordsContext {
    vec<U32> awords; // List of words
    vec<U16> sbytes; // List of bytes surrounded by a current word
    U32 fword;       // First word
    U8 pbyte;        // Current byte before word
    void Init() {
        vec_new(&awords);
        vec_new(&sbytes);
    }
    void Reset(){
        vec_reset(&awords);
        vec_reset(&sbytes);
        fword=pbyte=0;
    }
    void Set(U8 b){
        pbyte=b;
    }
    void Update(U32 w,U8 b) {
        if (fword==0) fword=w;
        vec_push(&awords,w);
        vec_push(&sbytes,U16(pbyte*256+b));  // Surrounding bytes
    }
    void Remove(){
        int num=vec_size(&awords);
        if (num) vec_pop(&awords),vec_pop(&sbytes);
    }
    U32 Word(int i=1){
        int num=vec_size(&awords);
        if (num>=i) return vec_at(&awords,num-(i));
        else return 0;
    }
    U16 sBytes(int i=1){
        int num=vec_size(&sbytes);
        if (num>=i) return vec_at(&sbytes,num-(i));
        else return 0;
    }
    void Free(){
        vec_free(&awords);
        vec_free(&sbytes);
    }
};

inline U32 hash(U32 a, U32 b, U32 c=0xffffffff) {
    U32 h=a*110002499u+b*30005491u+c*50004239u; 
    return h^h>>9^a>>3^b>>3^c>>4;
}

inline int charSwap(int c){
    if (c>='{' && c<127) c+='P'-'{';
    else if (c>='P' && c<'T') c-='P'-'{';
    else if ( (c>=':' && c<='?') || (c>='J' && c<='O') ) c^=0x70;
    if (c=='X' || c=='`') c^='X'^'`';
    return c;
}
//////////////////////////// Predictor /////////////////////////

static const U8 wrt_w[256]={
2, 3, 1, 3, 3, 0, 1, 2, 3, 3, 0, 0, 1, 3, 3, 3, 
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 
3, 2, 0, 2, 1, 3, 2, 1, 3, 3, 3, 3, 2, 3, 0, 2, // _!"#$%&'()*+,-./
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2, 2, 3, 2, 2, // 0123456789:;<=>?
2, 2, 0, 0, 2, 3, 1, 2, 1, 2, 2, 2, 2, 2, 0, 0, // @ABCDEFGHIJKLMNO
2, 2, 2, 2, 2, 2, 2, 2, 3, 0, 2, 3, 2, 0, 2, 3, // PQRSTUVWXYZ[\]^_

1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, //  abcdefghijklmno
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, // pqrstuvwxyz{|}~
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

static const U8 wrt_t[256]={
0, 0, 2, 0, 5, 6, 0, 6, 0, 2, 0, 4, 3, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
2, 4, 1, 4, 4, 7, 4, 7, 3, 7, 2, 2, 3, 5, 3, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 5, 3, 3, 5, 5, 
0, 5, 5, 7, 5, 0, 1, 5, 4, 5, 0, 0, 6, 0, 7, 1, 
3, 3, 7, 4, 5, 5, 7, 0, 2, 2, 5, 4, 4, 7, 4, 6, 

5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};

static const U32 primes[14]={0, 257,251,241,239,233,229,227,223,211,199,197,193,191};
static const U32 tri[4]={0,4,3,7}, trj[4]={0,6,6,12};

// Parameters
// These parameters were tuned befor version 1 and may be bad.
const U32 m_e[10]={8,8,8,1,1,1,1,1,1,0}; // mixer error
const U32 m_s[10]={194, 237, 204, 70, 54, 55,55, 70,55, 6};// mixer shift
const U32 m_m[10]={36,   69,  19, 34, 23, 24,24, 34,24,4};// mixer error mul

const U32 c_r[22]= { 3,  4,  6,  4,  6,  6,  2,  3,  3,  3,  6,  4,  3,  4,  5,  6,  2,  6,  4,  4,  4,  4};  // contextmap run mul
const U32 c_s[22]= {28, 26, 28, 31, 34, 31, 33, 33, 35, 35, 29, 32, 33, 34, 30, 36, 31, 32, 32, 32, 32, 32};  // contextmap pr mul
const U32 c_s2[22]={12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};  // ...
const U32 c_s3[22]={43, 33, 34, 28, 34, 29, 32, 33, 37, 35, 33, 28, 31, 35, 28, 30, 33, 34, 32, 32, 32, 32};
const U32 c_s4[22]={ 9,  8,  9,  5,  8, 12, 15,  8,  8, 12, 10,  7,  7,  8, 12, 13, 13, 14, 12, 12, 12, 12};
const U32 c_s5[22]={ 6,  3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2};
 
int e_l[8]={1830, 1997, 1973, 1851, 1897, 1690, 1998, 1842};

const int MAXLEN=62; // longest allowed match + 1
U32 t[14]; 

int c1,c2,c3;
U32 word0,word1,word2,word3,words,spaces,wshift,w4,w4r,w4br,x4,x5,ismatch,firstWord,number0,number1,numbers,numlen0,numlen1,mybenum;
U32 fqcxt=0;
U32 AH1=0,AH2=0x765BA55C;
U32 fails=0, failz=0, failcount=0;
int nl,col,fc,fc1,nl1;
U32 t1[0x100];
U32 t2[0x10000];
int wp[0x10000];

U32 oState, wtype, ttype;
U32 nState;
U32 oStatew4,nStatew4; 

int ord,ord2;
U8 buffer[0x1000000];
enum {BMASK=0xffffff};
int pos;
int pr; 

StateMap smA[3];
SmallStationaryContextMap scmA[8];   
Mixer1 mxA[10]; 
ContextMap cmC[27]; 
APM apmA[6];
RunContextMap rcmA[1];  
BracketContext brcxt;
BracketContext qocxt;
BracketContext fccxt;
ColumnContext colcxt;
WordsContext worcxt;

void PredictorInit() { 
    nState=nStatew4=0xffffffff;
    pr=2048;
    smA[0].Init(1<<9,1023,&STA1[0][0]);//match
    smA[1].Init(1<<19,1023,&STA1[0][0]);//match
    smA[2].Init(1<<16,1023,&STA1[0][0]);//match

    for (int i=0;i<8;i++){ 
        scmA[i].Init(8); 
    }
    //mxA[0].Init(   64,m_s[0],m_e[0],m_m[0]);
    mxA[1].Init(2*256,m_s[1],m_e[1],m_m[1]);
    mxA[2].Init(6*256,m_s[2],m_e[2],m_m[2]);
    mxA[3].Init(6*256,m_s[3],m_e[3],m_m[3]);
    mxA[4].Init(8*256,m_s[4],m_e[4],m_m[4]);
    mxA[5].Init(6*256,m_s[5],m_e[5],m_m[5]);
    mxA[6].Init(7*256*4,m_s[6],m_e[6],m_m[6]);
    mxA[7].Init(8*256,m_s[7],m_e[7],m_m[7]);
    mxA[8].Init(8*256,m_s[8],m_e[8],m_m[8]);
    mxA[9].Init(8*7*2,m_s[9],m_e[9],m_m[9]);
    
    apmA[0].Init(256);
    apmA[1].Init(0x8000*2);
    apmA[2].Init(0x8000*2);
    apmA[3].Init(0x20000*2);
    apmA[4].Init(0x10000*2);
    apmA[5].Init(0x10000*2);
    rcmA[0].Init(1*4096*4096,6);

    x.mxInputs[0].ncount=414;
    x.mxInputs[1].ncount=9;
    
    for (int j=0;j<2;j++)  {
        x.mxInputs[j].ncount=(x.mxInputs[j].ncount+15)&-16;
        alloc1(x.mxInputs[j].n,x.mxInputs[j].ncount+32,x.mxInputs[j].ptr,32);
    }     
    // Provide inputs array info to mixers
    for (int i=1;i<9;i++)
         mxA[i].setTxWx(x.mxInputs[0].ncount,&x.mxInputs[0].n[0]);
    // Final mixer
    mxA[9].setTxWx(x.mxInputs[1].ncount,&x.mxInputs[1].n[0]);

    cmC[0].Init( 16*4096*4096,3|(c_r[0]<<8)|(c_s[0]<<16)|(c_s2[0]<<24),c_s3[0],&STA5[0][0],c_s4[0],c_s5[0],0xf0);
    cmC[1].Init( 16*4096*4096,1|(c_r[1]<<8)|(c_s[1]<<16)|(c_s2[1]<<24),c_s3[1],&STA1[0][0],c_s4[1],c_s5[1],0xf0);
    cmC[2].Init( 16*4096*4096,1|(c_r[2]<<8)|(c_s[2]<<16)|(c_s2[2]<<24),c_s3[2],&STA1[0][0],c_s4[2],c_s5[2],0xf0);
    cmC[3].Init( 16*4096*4096,1|(c_r[3]<<8)|(c_s[3]<<16)|(c_s2[3]<<24),c_s3[3],&STA1[0][0],c_s4[3],c_s5[3],0xf0);
    cmC[4].Init( 16*4096*4096,2|(c_r[4]<<8)|(c_s[4]<<16)|(c_s2[4]<<24),c_s3[4],&STA1[0][0],c_s4[4],c_s5[4],0xf0);
    cmC[5].Init(  8*4096*4096,1|(c_r[5]<<8)|(c_s[5]<<16)|(c_s2[5]<<24),c_s3[5],&STA3[0][0],c_s4[5],c_s5[5],0xf0);//mem 16-8 
    cmC[6].Init(  1*4096*4096,1|(c_r[6]<<8)|(c_s[6]<<16)|(c_s2[6]<<24),c_s3[6],&STA1[0][0],c_s4[6],c_s5[6],0xf0);
    cmC[7].Init(  2*4096*4096,1|(c_r[7]<<8)|(c_s[7]<<16)|(c_s2[7]<<24),c_s3[7],&STA5[0][0],c_s4[7],c_s5[7],0xf0);
    cmC[8].Init(  1*4096*4096,3|(c_r[8]<<8)|(c_s[8]<<16)|(c_s2[8]<<24),c_s3[8],&STA4[0][0],c_s4[8],c_s5[8],0);
    cmC[9].Init(      32*4096,2|(c_r[9]<<8)|(c_s[9]<<16)|(c_s2[9]<<24),c_s3[9],&STA1[0][0],c_s4[9],c_s5[9],0xf0);
    cmC[10].Init(     32*4096,3|(c_r[10]<<8)|(c_s[10]<<16)|(c_s2[10]<<24),c_s3[10],&STA2[0][0],c_s4[10],c_s5[10],0);
    cmC[11].Init(     32*4096,4|(c_r[11]<<8)|(c_s[11]<<16)|(c_s2[11]<<24),c_s3[11],&STA2[0][0],c_s4[11],c_s5[11],0);
    cmC[12].Init(     16*4096,4|(c_r[12]<<8)|(c_s[12]<<16)|(c_s2[12]<<24),c_s3[12],&STA2[0][0],c_s4[12],c_s5[12],0);
    cmC[13].Init(     16*4096,7|(c_r[13]<<8)|(c_s[13]<<16)|(c_s2[13]<<24),c_s3[13],&STA2[0][0],c_s4[13],c_s5[13],0);
    cmC[14].Init(   64*2*4096,3|(c_r[14]<<8)|(c_s[14]<<16)|(c_s2[14]<<24),c_s3[14],&STA1[0][0],c_s4[14],c_s5[14],0xf0);
    cmC[15].Init(      2*4096,2|(c_r[15]<<8)|(c_s[15]<<16)|(c_s2[15]<<24),c_s3[15],&STA2[0][0],c_s4[15],c_s5[15],0xf0);
    cmC[16].Init(    128*4096,2|(c_r[16]<<8)|(c_s[16]<<16)|(c_s2[16]<<24),c_s3[16],&STA1[0][0],c_s4[16],c_s5[16],0);
    cmC[17].Init( 4*4096*4096,3|(c_r[17]<<8)|(c_s[17]<<16)|(c_s2[17]<<24),c_s3[17],&STA1[0][0],c_s4[17],c_s5[17],0xf0);
    cmC[18].Init( 4*4096*4096,6|(c_r[18]<<8)|(c_s[18]<<16)|(c_s2[18]<<24),c_s3[18],&STA5[0][0],c_s4[18],c_s5[18],0xf0);
    cmC[19].Init( 4*4096*4096,5|(c_r[19]<<8)|(c_s[19]<<16)|(c_s2[19]<<24),c_s3[19],&STA5[0][0],c_s4[19],c_s5[19],0xf0);
    cmC[20].Init(   4096*4096,3|(c_r[20]<<8)|(c_s[20]<<16)|(c_s2[20]<<24),c_s3[20],&STA1[0][0],c_s4[20],c_s5[20],0xf0);
    cmC[21].Init( 1*4096*4096,1|(c_r[21]<<8)|(c_s[21]<<16)|(c_s2[21]<<24),c_s3[21],&STA3[0][0],c_s4[21],c_s5[21],0xf0);
    cmC[22].Init(     32*4096,2|(c_r[21]<<8)|(c_s[21]<<16)|(c_s2[21]<<24),c_s3[21],&STA2[0][0],c_s4[21],c_s5[21],0xf0);
    cmC[23].Init(  1*4096*4096/2,1|(c_r[21]<<8)|(c_s[21]<<16)|(c_s2[21]<<24),c_s3[21],&STA3[0][0],c_s4[21],c_s5[21],0xf0);
    cmC[24].Init(   8*64*4096,1|(c_r[21]<<8)|(c_s[21]<<16)|(c_s2[21]<<24),c_s3[21],&STA1[0][0],c_s4[21],c_s5[21],0);
    cmC[25].Init(    512*4096,1|(c_r[21]<<8)|(c_s[21]<<16)|(c_s2[21]<<24),c_s3[21],&STA1[0][0],c_s4[21],c_s5[21],0xf0);
    cmC[26].Init(    512*4096,1|(c_r[21]<<8)|(c_s[21]<<16)|(c_s2[21]<<24),c_s3[21],&STA1[0][0],c_s4[21],c_s5[21],0xf0);

    #if defined(TEXTMODE)
    brcxt.Init(&brackets[0],8,false,512);
    #else
    brcxt.Init(&brackets[0],8);
    #endif
    qocxt.Init(&quotes[0],4,true);
    #if defined(TEXTMODE)
    fccxt.Init(&fchar[0],20,false,512*2);
    #else
    fccxt.Init(&fchar[0],20);
    #endif
    colcxt.Init();
    worcxt.Init();
}
  
void PredictorFree(){
    smA[0].Free(); 
    for (int i=0;i<8;i++) scmA[i].Free();
    for (int i=1;i<10;i++) mxA[i].Free();
    for (int i=0;i<27;i++) cmC[i].Free();
    for (int i=0;i<6;i++) apmA[i].Free();
    rcmA[1].Free();
    free(x.mxInputs[0].ptr);
    free(x.mxInputs[1].ptr);    
    brcxt.Free();
    qocxt.Free();
    fccxt.Free();
    colcxt.Free();
    worcxt.Free();
}
  
int buf(int i){
    return buffer[(pos-i)&BMASK];
}
int bufr(int i){
    return buffer[i&BMASK];
}

//---------------- Match model 2---------------------
// based on paq8px v208
struct HashElementForMatchPositions { // sizeof(HashElementForMatchPositions) = 3*4 = 12
  #define mHashN   3
  U32 matchPositions[mHashN];
  void Add(int pos) {
    if (mHashN > 1) {
      memmove(&matchPositions[1], &matchPositions[0], (mHashN - 1) * sizeof(matchPositions[0]));
    }
    matchPositions[0] = pos;
  }
};

const int MINLEN_RM = 3; //minimum length in recovery mode before we "fully recover"
const int LEN1 = 5;      // order x
const int LEN2 = 7;      //
const int LEN3 = 9;
 
struct MatchInfo {
    U32 length;      // rebased length of match (length=1 represents the smallest accepted match length), or 0 if no match
    U32 index;       // points to next byte of match in buf, 0 when there is no match
    U32 lengthBak;   // allows match recovery after a 1-byte mismatch
    U32 indexBak;
    U8 expectedByte; // prediction is based on this byte (buf[index]), valid only when length>0
    bool delta;      // indicates that a match has just failed (delta mode)
    void Init(){
        length=0;
        index=0;
        lengthBak=0;
        indexBak=0;
        expectedByte=0;
        delta=false;
    }
    bool isInNoMatchMode() const {
      return length == 0 && !delta && lengthBak == 0;
    }

    bool isInPreRecoveryMode() const {
      return length == 0 && !delta && lengthBak != 0;
    }

    bool isInRecoveryMode() const {
      return length != 0 && lengthBak != 0;
    }

    U32 recoveryModePos() const {
      assert(isInRecoveryMode()); //must be in recovery mode
      return length - lengthBak;
    }

    U32 prio() {
      return
        (length != 0) << 31 | //normal mode (match)
        (delta) << 30 | //delta mode
        (delta ? (lengthBak>>1) : (length>>1)) << 24 | //the longer wins, halve
        (index&0x00ffffff); //the more recent wins
    }
    bool isBetterThan(MatchInfo* other) {
      return this->prio() > other->prio();
    }

    void update() {
      //printf("- pos %d %d  index %d  length %d  lengthBak %d  delta %d\n", x.blpos, x.bpos, index, length, lengthBak, delta ? 1 : 0);
      if (length != 0) {
        const int expectedBit = (expectedByte >> ((8 - x.bpos) & 7)) & 1;
        if (x.y != expectedBit) {
          if (isInRecoveryMode()) { // another mismatch in recovery mode -> give up
            lengthBak = 0;
            indexBak = 0;
          }
          else { //backup match information: maybe we can recover it just after this mismatch
            lengthBak = length;
            indexBak = index;
            delta = true; //enter into delta mode - for the remaining bits in this byte length will be 0; we will exit delta mode and enter into recovery mode on bpos==0
          }
          length = 0;
        }
      }

      if (x.bpos == 0) {
        // recover match after a 1-byte mismatch
        if (isInPreRecoveryMode()) { // just exited delta mode, so we have a backup
          //the match failed 2 bytes ago, we must increase indexBak by 2:
          indexBak++;
          if (lengthBak < MAXLEN) {
            lengthBak++;
          }
          if (bufr(indexBak) == c1) { //                     match continues -> recover 
            length = lengthBak;
            index = indexBak;
          }
          else { // still mismatch
            lengthBak = indexBak = 0; // purge backup (give up)
          }
        }
        // extend current match
        if (length != 0) {
          index++;
          if (length < MAXLEN) {
            length++;
          }
          if (isInRecoveryMode() && recoveryModePos() >= MINLEN_RM) { // recovery seems to be successful and stable -> exit recovery mode
            lengthBak = indexBak = 0; // purge backup
          }
        }
        delta = false;
      }
        //printf("  pos %d %d  index %d  length %d  lengthBak %d  delta %d\n", x.blpos, x.bpos, index, length, lengthBak, delta ? 1 : 0);
    }

    void registerMatch(const U32 pos, const U32 LEN) {
      assert(pos != 0);
      length = LEN - LEN1 + 1; // rebase
      index = pos;
      lengthBak = indexBak = 0;
      expectedByte = 0;
      delta = false;
    }
};

const int matchN=4; // maximum number of match candidates
MatchInfo matchCandidates[matchN];
U32 numberOfActiveCandidates=0;
HashElementForMatchPositions *mhashtable,*mhptr;
U32 mhashtablemask;
const int nST=3;
U32 ctx[nST];

bool isMatch(const U32 pos, const int MINLEN) {
    for (int length = 1; length <= MINLEN; length++) {
      if (buf(length) != bufr(pos - length))
        return false;
    }
    return true;
}

void AddCandidates(HashElementForMatchPositions* matches, U32 LEN) {
    U32 i = 0;
    while (numberOfActiveCandidates < matchN && i < mHashN) {
      U32 matchpos = matches->matchPositions[i];
      if (matchpos == 0)
        break;
      if (isMatch(matchpos, LEN)) {
        bool isSame = false;
        //is this position already registered?
        for (U32 j = 0; j < numberOfActiveCandidates; j++) {
          MatchInfo* oldcandidate = &matchCandidates[j];
          isSame = (oldcandidate->index == matchpos);
          if (isSame)
            break;
        }
        if (!isSame) { //don't register an already registered sequence
          matchCandidates[numberOfActiveCandidates].registerMatch(matchpos, LEN);
          numberOfActiveCandidates++;
        }
      }
      i++;
    }
  }
  
void MatchModel2update() {
  //update active candidates, remove dead candidates
  U32 n = max(numberOfActiveCandidates, 1);
  for (U32 i = 0; i < n; i++) {
    MatchInfo* matchInfo = &matchCandidates[i];
    matchInfo->update();
    if (numberOfActiveCandidates != 0 && matchInfo->isInNoMatchMode()) {
      numberOfActiveCandidates--;
      if (numberOfActiveCandidates == i)
        break;
      memmove(&matchCandidates[i], &matchCandidates[i + 1], (numberOfActiveCandidates - i) * sizeof(MatchInfo));
      i--;
    }
  }

  if( x.bpos == 0 ) {    
    U32 hash;
    HashElementForMatchPositions* matches;

    hash = t[LEN3];
    matches = &mhashtable[(hash& mhashtablemask)];
    if (numberOfActiveCandidates < matchN)
      AddCandidates(matches, LEN3); //longest
    matches->Add(pos);

    hash = t[LEN2];
    matches = &mhashtable[(hash& mhashtablemask)];
    if (numberOfActiveCandidates < matchN)
      AddCandidates(matches, LEN2); //middle
    matches->Add(pos);

    hash = t[LEN1];
    matches = &mhashtable[(hash& mhashtablemask)];
    if (numberOfActiveCandidates < matchN)
      AddCandidates(matches, LEN1); //shortest
    matches->Add(pos);

    for (U32 i = 0; i < numberOfActiveCandidates; i++) {
      matchCandidates[i].expectedByte = bufr(matchCandidates[i].index);
    }
  }
}

int MatchModel2mix(int m) {
  MatchModel2update();

  for( int i = 0; i < nST; i++ ) { // reset contexts
    ctx[i] = 0;
  }
  
  int bestCandidateIdx = 0; //default item is the first candidate, let's see if any other candidate is better
  for (U32 i = 1; i < numberOfActiveCandidates; i++) {
    if (matchCandidates[i].isBetterThan(&matchCandidates[bestCandidateIdx]))
      bestCandidateIdx = i;
  }

  const U32 length = matchCandidates[bestCandidateIdx].length;
  const U8 expectedByte = matchCandidates[bestCandidateIdx].expectedByte;
  const bool isInDeltaMode = matchCandidates[bestCandidateIdx].delta;
  const int expectedBit = length != 0 ? (expectedByte >> (7 - x.bpos)) & 1 : 0;

  U32 denselength = 0; // 0..27
  if (length != 0) {
    if (length <= 16) {
      denselength = length - 1; // 0..15
    } else {
      denselength = 12 + ((length ) >> 2); // 16..27
    }
    ctx[0] = (denselength << 4) | (expectedBit << 3) | x.bpos; // 1..28*2*8
    ctx[1] = ((expectedByte << 11) | (x.bpos << 8) | c1) ;//+ 1;
    const int sign = 2 * expectedBit - 1;
    x.mxInputs[m].add(sign * (length << 5));
  } else { // no match at all or delta mode
    x.mxInputs[m].add(0);
  }

  if( isInDeltaMode ) { // delta mode: helps predicting the remaining bits of a character when a mismatch occurs
    ctx[2] = (expectedByte << 8) | x.c0;
  }

  for( int i = 0; i < nST; i++ ) {
    const U32 c = ctx[i];
    if( c != 0 ) {
         smA[i].set(c,x.y);
      const int p1 = smA[i].pr;
      const int st = stretch(p1);
      x.mxInputs[m].add(st >> 2);
      x.mxInputs[m].add((p1 - 2048) >> 3);
    } else {
      x.mxInputs[m].add(0);
      x.mxInputs[m].add(0);
    }
  }
  return length;
}

// Find bracket or quotes index.
U8 qy[6]={'(',CURLYOPENING, '[', LESSTHAN,QUOTATION,APOSTROPHE};
int FindQy(int b){
    int found=-1;
    for (int i=0;i<6;i++) {
        if (qy[i]==b) {
            found=i;
            break;
        }
    }
    return found;
}
// In first char context find
U8 qy1[10]= {ATSIGN, 96, COLON, LESSTHAN,EQUALS,'*',VERTICALBAR,CURLYOPENING,SQUAREOPEN,31};
int FindQy2(int b){
    int found=-1;
    for (int i=0;i<9;i++) {
        if (qy1[i]==b) {
            found=i;
            break;
        }
    }
    if (found==8) found=1; //SQUAREOPEN as 96
    return min(7,found+1);
}

int modelPrediction(int c0,int bpos,int c4){
    int i,c;
    U32 h,j;
    
    if (bpos== 0){
        wshift=0;
        c3=c2;
        c2=c1;
        c1=c4&0xff;
        #ifndef TEXTMODE
        if (colcxt.lastfc()==GREATERTHAN) colcxt.nlChar=GREATERTHAN;
        if (colcxt.lastfc()==SQUAREOPEN && colcxt.nlChar==GREATERTHAN) colcxt.nlChar=10;
        #endif
        colcxt.Update(c1,c4&0xffffff);
        // if TEXTMODE swap cars
        #ifdef TEXTMODE
        i=wrt_w[charSwap(c1)];
        #else
        i=wrt_w[c1];
        #endif
        nStatew4=i;
        w4=w4*4+i;
        buffer[pos&BMASK]=c1;
        pos++;    
        #ifdef TEXTMODE
        if (c1<128)brcxt.Update( c1 );
        #else
        if (c1<'a')brcxt.Update( c1 );               // advance bracket context only if no letters, so we do not get out of range
        #endif
        cmC[25].set((brcxt.context<<8)+c1);
        qocxt.Update(c1); 

        if ( c1!=SPACE)
            if (c1=='$' || c1==SQUARECLOSE|| c1==VERTICALBAR|| c1==')'|| c1==SQUAREOPEN){
                if ( c1!=c2) 
                    for (i=13; i>0; --i)  // update order X context hashes
                        t[i]=t[i-1]*primes[i];
                x4=(x4<<8)+c2;
            }

        x4=(x4<<8)+c1;
        for (i=13; i>0; --i)  // update order X context hashes
            t[i]=t[i-1]*primes[i]+c1+i*256;

        for (i=3; i<6; ++i)
            cmC[0].set(t[i]);
        cmC[1].set(t[6]);
        cmC[2].set(t[8]);
        cmC[3].set(t[13]);

        j=c1;
        // if TEXTMODE swap cars
        #ifdef TEXTMODE
        nState=wrt_t[charSwap(c1)];
        #else
        nState=wrt_t[c1];
        #endif
        words=words<<1;
        spaces=spaces<<1;
        numbers=numbers<<1;
        #ifdef TEXTMODE
        bool isUpper=false;
        bool isLetter=false;
        if ( ((j-'A') <= ('Z'-'A'))) j =j+32,isUpper=true;
        #endif
        if (((j-'a') <= ('z'-'a')) || (c1>127 && c2!=12)) {
            if (word0==0){
                if (c2==ATSIGN)worcxt.Set(c3); else worcxt.Set(c2);
            }
            #ifdef TEXTMODE
            isLetter=true;
            #endif
            words=words|1;
            word0=word0*2104+j; //263*8
            
            // ' or 0x27 is used for quotes, sometimes it has other meaning
            // remove quote content if any of the fallowing is true
            const int word3bit=(words&7);
            if (((word3bit==5) && (c2==APOSTROPHE))||                    // "x'x" where x is any letter in word
             ((word3bit==1) && (c3==SQUARECLOSE) && (c2==APOSTROPHE))||  // "]'x" where x is any letter in word
             ((word3bit==1) && (numbers&4)&&(c2==APOSTROPHE))            // "y'x" where y is number and x is any letter in word //(c3>='0' && c3<='9') 
             )qocxt.Update(qocxt.context>>8); 
        } else {
            // ' or 0x27 is used for quotes, sometimes it has other meaning
            // remove quote content if any of the fallowing is true
            const int word3bit=(words&7);
            if ( ((word3bit==4)&& (c1==SPACE) && (c2==APOSTROPHE))||            // "x' " where x is any letter in word
             ((c1==ATSIGN) && (numbers&4) && (c2==APOSTROPHE)) ||               // "x'@" where x is number               // this is somehow semi good-bad //(c3>='0' && c3<='9')
             ((word3bit==4) && (c1==ATSIGN) && (c2==APOSTROPHE))                // "x'@" where x is any letter in word   // this is somehow semi good-bad
              )qocxt.Update(qocxt.context>>8); 
            if (word0){
                word3=word2*47;
                word2=word1*53;
                word1=word0*83;
                worcxt.Update(word0,c1);
                if(firstWord==0) {
                    firstWord=word0;
                }
            }
            wp[word0&0xffff]=pos;
            word0=0;
            if ((c1>='0' && c1<='9') ) {
                numbers=numbers+1;
                if(numbers&4 && c2==',') number0=number1,number1=0,numlen0=numlen1,numlen1=0;
                if (mybenum && numlen1<=2) number0=number1,number1=0,numlen0=numlen1,numlen1=0;
                number0=number0*10+(c1&0x0f);
                numlen0=min(19,numlen0+1);mybenum=0;
            }else{
            
                if (numlen0 ||((numbers&0xf)==0)){
                    number1=number0,numlen1=numlen0,number0=numlen0=0;
                }
                if (numlen1<=2 &&numlen1&&((numbers&5)==5) && numlen0==0 && c2=='.') mybenum=2;
                else if (numlen1<=2&&numlen1&&(numbers&2) && numlen0==0 && c1=='.') mybenum=1;
                else if (mybenum==1  && c1!='.') mybenum=0;
            }
            
            if (c1==SPACE) {
                spaces++;
            }
            else if (c1==10 ) {
                fc=fc1=firstWord=0;
                nl1=nl;
                nl=pos-1;
                wtype=(wtype<<3);
                w4=w4|0x3fc;
                words=0xfffffffc;
                worcxt.Reset();
                w4r= w4r<<2;
            }
            else if ((c1=='.') || c1==')' || c1==QUESTION) {
                wtype= wtype&0xffffffc0;
                ttype= ttype<<7;//&0xffffffc0;  ????
                words= words|0xfffffffe;
                x5=(x5<<8)+(c4&0xff);
                w4=w4|204;
                w4r= w4r&0xffffffc0;
            }
            else if (c1==',') {
                words=words|0xfffffffc;
            }   
            else if (c1==COLON) {
                ttype= (ttype&0xfffffff8)+4;
                w4=w4|12;//      1100
                x5=(x5<<8)+(c4&0xff);
            }   
            else if (c1==CURLYCLOSE || c1==CURLYOPENING) {
                words = words | 0xfffffffc;
                wtype= wtype&0xffffffc0;
                x5=(x5<<8)+(c4&0xff);
                ttype= (ttype&0xfffffff8)+3;
            }   
            else if (c1==LESSTHAN || c2=='&') {
                words=words|0xfffffffc;
            }   
            else if (c1==EQUALS) {
                ttype=(ttype&0xfffffff8)+4;
                c2='.'; // ok
            }  
            if (c1=='!' && c2=='&')  {// '&nbsp;' to '&!'  to ' '
                c1=SPACE;
                c4=(c4&0xffffff00)+SPACE;//needs testing
                w4=(w4&0xfffffffc)+wrt_w[SPACE];
                ttype=(ttype&0xfffffff8)+wrt_t[SPACE];
            }
            if (c1=='.' ) wshift=1,worcxt.Reset();
            else if (c1==SEMICOLON)  worcxt.Reset();
        }
        
        x5=(x5<<8)+(c4&0xff);
        // switch state if it is new
        if (oStatew4!=nStatew4){
            w4r=(w4r<<2)+nStatew4;
            oStatew4=nStatew4;
        }
        // switch state if it is new
        if (oState!=nState){
            wtype=(wtype<<3)+nState;
            oState=nState;
        }
        ttype=(ttype<<3)+nState;
     
        const U8 brcontext=(brcxt.context>>8);
        
        rcmA[0].set(word3*53+c1+193 * (ttype & 0x7fff),c1);
        //Retrun index of bracket or quote in array, if found add 1 to result. value is in range 1-7, 0 if not found
        w4br=0;
        if(brcxt.context)w4br=FindQy(brcontext)+1;
        if(brcxt.context==0 &&qocxt.context)w4br=FindQy(qocxt.context>>8)+1;
        // Column and first char 
        col=colcxt.collen();
        int above=buffer[(nl1+col)&BMASK];
        int above1=buffer[(nl1+col-1)&BMASK];
        #ifndef TEXTMODE
        if (colcxt.nlChar==GREATERTHAN) {
           above=colcxt.colb(1,0);
           above1=colcxt.colb(1,1); 
           //col=colcxt.collen(0,64);
        }
        #endif
        if (colcxt.isNewLine()) {
                // Reset contexts when there are two empty lines
                if((colcxt.nlpos(0)+2-colcxt.nlpos(1))< 4){ 
                    fccxt.Reset();
                    brcxt.Reset();
                    qocxt.Reset();
                }
                fc=colcxt.lastfc();//min(c1,96);
                #ifdef TEXTMODE
                if (isUpper==true && isLetter==true) fc=ATSIGN;
                #else
                // Reset first char context when there is >. For filtered wiki.
                if(fc==GREATERTHAN) fccxt.Reset();//?
                #endif
                if (fc==ATSIGN) fc1=1;
                else fc1=0;
                // Set new first char
                fccxt.Update(fc);
        }

        #ifdef TEXTMODE
        if (col>2 && c1>ATSIGN  ||col>2 && !(c1>='a' && c1<='z') ) {
        #else
        if (col>2 && c1>ATSIGN ){ 
        #endif
            // Befor updateing first char context look:
            // if link or template ended and remove any vertical bars |.  [xx|xx] {xx|xx}
            if ((fccxt.context>>8)==VERTICALBAR && (c1==SQUARECLOSE || c1==CURLYCLOSE)) while( (fccxt.context>>8)==VERTICALBAR) fccxt.Update(10);
            // if html link ends with space or ]
            if (((fccxt.context>>8)==COLON || (fccxt.context>>8)==31 ) && (c1==SPACE || c1==SQUARECLOSE)) while( (fccxt.context>>8)==COLON || (fccxt.context>>8)==31) fccxt.Update(10);
           
            fccxt.Update(c1);
        }
        // switch from possible category link to http link
        if ((fccxt.context>>8)==COLON && c2=='/' && c1=='/') fccxt.Update(10),fccxt.Update(31);
        
        if (fc==SQUAREOPEN && c1==SPACE) { 
            if(c2==SQUARECLOSE || c3==SQUARECLOSE) {
                fc=ATSIGN;fc1=0;
            }
        }
        if (fc==SPACE  && c1!=SPACE) { 
            fc=min(c1,96);
            #ifdef TEXTMODE
            if (isUpper==true && isLetter==true) fc=ATSIGN;
            #endif
            if (fc==ATSIGN) fc1=1;
            else fc1=0;
            // Set new first char, we keep space from previous update
            fccxt.Update(fc);
        }
        const U8 fccontext =fccxt.context>>8;
        if(w4br==0 &&fccxt.context)w4br=FindQy(fccontext)+1;
        fqcxt=FindQy2(fccontext);
        cmC[26].set((fccxt.context&0xff00)+c1+(w4&12)*256+((brcontext+ brcxt.last())<<24));
        if (fc=='*' && c1!=SPACE) {
            fc=min(c1,96);
        } 
        if (fc=='&' && c1==LESSTHAN) fc=31; 
        if (fc==APOSTROPHE && (c1==SPACE)) { 
            if(c2==APOSTROPHE || c3==APOSTROPHE )  fc=ATSIGN;fc1=0;
        }
        if ((/*fc=='*' || fc==SQUAREOPEN*/ fc!=ATSIGN) && ((c4&0xffffff)==0x4a2f2f)) {//http link
            fc=31;
        }
        // Words surrounded by ()
        if ((worcxt.sBytes(1)&0xff)==')' ){
            bool isC=false;
            for (int i=1; i<8; i++) if ((worcxt.sBytes(i)>>8)=='(') isC=true;
            if (isC){
                while( (worcxt.sBytes(1)>>8)!='(' ) worcxt.Remove();
                worcxt.Remove();
            }
        }
        // Words surrounded by [|  as wiki internal link: word [word word|word] word.
        if ((worcxt.sBytes(1)&0xff)==VERTICALBAR ){
            bool isC=false;
            for (int i=1; i<8; i++) if ((worcxt.sBytes(i)>>8)==SQUAREOPEN) isC=true;
            if (isC){
                while( (worcxt.sBytes(1)>>8)!=SQUAREOPEN ) worcxt.Remove();
                worcxt.Remove();
            }
        } 
        // Contexts
        if (word0) {
            h=word0*271+(c4&0xff);}
        else
            h=word0*271+c1;
        if (c1==12)cmC[4].set(0);else cmC[4].set(word0+(number0*191+numlen0));
        if (c1==12)cmC[4].set(0);
        else cmC[4].set(h+word1);
    
        cmC[5].set(h+ word2*71);
   
        cmC[6].set(((ttype&0x3f)<<16)+(c4&0xffff));
   
        cmC[8].set((c4 & 0xffffff) + ((w4 << 18) & 0xff000000));
        cmC[8].set(wtype&0x3fffffff);
        cmC[8].set((fccontext) + ((wtype & 0x3ffff) << 8 ));
    
        cmC[9].set(colcxt.lastfc(0) | (fccontext << 15) | ((ttype & 63) << 7)|(brcontext << 24) );
        cmC[9].set((fc | ((c4 & 0xffffff) << 7)));
    
        cmC[10].set( (w4 & 3) +word0*11);
        cmC[10].set(c4 & 0xffff);
        cmC[10].set(((fc << 11) | c1)+((w4 & 3)<< 18));
    
        cmC[11].set((w4 & 15)+((ttype & 7) << 6 ));
        cmC[11].set(c1 | ((col * (c1 == SPACE)) << 8)|((w4 & 15) << 16));
 
        cmC[11].set(fc1?firstWord:(fc<< 11));
        if (c1==12 )cmC[11].set(0);
        else cmC[11].set((91 * 83* worcxt.Word(1) + 89 * word0));
        cmC[12].set((c1 + ((ttype & 0x38) << 6)));
        cmC[12].set(c1+word0+number0*191 );
        cmC[12].set(((c4 & 0xffff) << 16) | (fccontext  << 8) |fc);
        cmC[12].set(((wtype & 0xfff)<< 8)+((w4 & 0xfc)));
        if (fc1==1){
            // word
            cmC[13].set(worcxt.fword*3191+(w4 & 3));
            cmC[13].set(h+firstWord*89);
            cmC[13].set(word0*53+c1+w4br);
        }else{
            // column
            cmC[13].set(above | ((ttype & 0x3f) << 9) | (colcxt.collen() << 19)| ((w4 & 3) << 16) );
            cmC[13].set(h+firstWord*89);
            cmC[13].set(above | (c1 << 16)| ((col+numlen0+w4br) << 8)| (above1<< 24)  );
        }
        // Table
        cmC[13].set(wrt_w[bufr(colcxt.abovecellpos)]|( ( fccontext) << 8)  | ((w4br & 0xff) << 16));
        cmC[13].set(bufr(colcxt.abovecellpos)|( ( c1) << 8) );
        cmC[13].set( word0+wrt_w[bufr(colcxt.abovecellpos)] );

        cmC[14].set((x4 & 0xff00ff) );
        cmC[14].set((x4 & 0xff0000ff) | ((ttype & 0xe07) << 8));

        // Indirect
        U32   f=(c4>>8)&0xffff;
        t2[f]=(t2[f]<<8)|c1;
        f=c4&0xffff;
        f=f|(t2[f]<<16);
        U32   d=(c4>>8)&0xff;
        t1[d]=(t1[d]<<8)|c1;
        d=c1|(t1[c1]<<8);
        
        t1[brcontext]=(t1[brcontext]<<2)|(w4&3); // this is wierd, also end is bad
        U32   d4=(ttype&7)|(t1[brcontext]<<3);
        
        cmC[7].set(d4);
        
        cmC[14].set((d4& 0xffff) | ((ttype & 0x38) << 16));
        cmC[13].set((f& 0xffffff));
    
        cmC[15].set((c1 << 8) | (d >> 2)| (fc << 16));  // fixme
        cmC[15].set((c4 & 0xffff)+(c2==c3?1:0));
   
        cmC[16].set((ttype & 0x3ffff) | ((w4 & 255) << 24));
        cmC[16].set(x4);
  
        cmC[17].set(257 * word1+fccontext + 193 * (ttype & 0x7fff));
        cmC[17].set(fc|((w4r & 0xfff) << 9) | ((c1  ) << 24));//end is good
        cmC[17].set((x4 & 0xffff00)+ brcontext+(fccontext<< 24)); //end bad (last)

        cmC[18].set(d);
        cmC[18].set(((d& 0xffff00)>>4) | ((w4 & 0xf) )| ((ttype & 0xfff) << 20));
        cmC[18].set((x4 >>16) | ((w4 & 255) << 24));
        #ifdef TEXTMODE
        cmC[18].set((c1 << 11) | ((f & 0xffffff)>>16) );
        #else
        if (c1>127)cmC[18].set(( (((w4 & 12)*256)+c1) << 11) | ((f & 0xffffff)>>16) );
        else cmC[18].set((c1 << 11) | ((f & 0xffffff)>>16) );
        #endif
        cmC[18].set((fccontext*4+w4br) | ((c4 & 0xffff)<< 9)| ((w4 & 0xff) << 24)); 
        cmC[18].set(((f >> 16) )| ((w4 & 0x3c)<< 25 )| (((ttype & 0x1ff))<< 16 ));

        cmC[19].set(((words& 0xff) )+((( spaces & 0xff))<< 8)+((w4&15)<< 16)+(((wtype>>3)&511)<< 21)+(fc1<<30));
        cmC[19].set(c1 + ((ttype<< 5) & 0x1fffff00));
        #ifdef TEXTMODE
        cmC[19].set(ttype);
        #else
        cmC[19].set(w4r*16+w4br );
        #endif
        cmC[19].set(((d& 0xffff)>>8) + ((64 * w4r) & 0x3ffff00)+(brcontext<< 25)); // end good

        int dd=pos-wp[word0&0xffff];
        if (dd>255)
            dd=256 + (c1<<16);
        else dd=dd + (buf(dd)<< 8)+(c1 << 16);
        cmC[19].set((dd )| (fc << 24));

        cmC[20].set((x4&0x80f00000)+((x4&0x0000f0ff) << 12) );
        cmC[20].set(worcxt.Word(1)*83*1471-word0*53+worcxt.Word(2));
        if (fc1==1){
            // word
            if (c1==12 || fccontext==31 ) 
                cmC[20].set(0);
            else
                cmC[20].set(h+worcxt.Word(1) *53 *79+worcxt.Word(3) *53*47 *71);
        }else{
            //column
            if (col==31) 
                cmC[20].set( ((c4 &0xffff)<< 16));
            else
                cmC[20].set(above | ((c4 &0xffff)<< 16)| (above1<< 8));
        }
        if (c1==12 || fccontext==CURLYOPENING|| fccontext==31 ) 
            cmC[21].set(0);
        else
            cmC[21].set(h+worcxt.Word(2) *53 *79+worcxt.Word(3) *53*47 *71);

        cmC[22].set(((wtype&7)<< 10) + (w4&3)+fc*4+ (w4br<< 24));
        cmC[22].set( (word0*3301+number0*3191 ));//3191
    
        cmC[23].set(w4br+ worcxt.Word(2) * (wtype & 0x7fff));
   
        scmA[0].set(c1);
        scmA[1].set(c2*(fc1));
        scmA[2].set((f&0xffffff)>>16);
        scmA[3].set(ttype&0x3f);
        scmA[4].set(w4&0xff);
        scmA[5].set(brcontext);
        scmA[6].set(fc1+ 2*((wtype&0x3f)) );
        scmA[7].set(fc);

        if (wshift||c1==10)  {
            word3=word3*47, word2=word2*53, word1=word1*83;
        }

        
        cmC[24].set((w4br*256)+fc+(((wtype>>0)&0xFFF)<< 16));
        // Some APM context
        AH1=hash((x5>>0)&255, (x5>>8)&255, (x5>>16)&0x80ff);
        AH2=hash(19,     x5&0x80ffff);
    }
    const int c0b=c0<<(8-bpos);
    ismatch=MatchModel2mix(0);

    scmA[0].mix(0);
    scmA[1].mix(0);
    scmA[2].mix(0);
    scmA[3].mix(0);
    scmA[4].mix(0);
    scmA[5].mix(0);
    scmA[6].mix(0);
    if ((fccxt.context>>8)==COLON && fccxt.last()==SQUAREOPEN) {
      x.mxInputs[0].add(0);
      x.mxInputs[0].add(0);
    }
    else
    scmA[7].mix(0);

    // order X
    ord=cmC[0].mix(0);
    if (ord==3) ord=2; // low max 2
    ord=ord+cmC[1].mix(0);
    ord=ord+cmC[2].mix(0);
    ord=ord+cmC[3].mix(0);
    ord2=cmC[4].mix(0);
    ord2=ord2+cmC[5].mix(0);
    cmC[6].mix(0);
    cmC[7].mix(0);
    cmC[8].mix(0);
    cmC[9].mix(0);
    cmC[10].mix(0);
    cmC[11].mix(0);
    cmC[12].mix(0);
    cmC[13].mix(0);
    cmC[14].mix(0);
    cmC[15].mix(0);
    cmC[16].mix(0);
    cmC[17].mix(0);
    cmC[18].mix(0);
    cmC[19].mix(0);
    cmC[20].mix(0);
    // order Word
    ord2=ord2+cmC[21].mix(0);  
    cmC[22].mix(0);  
    ord2=ord2+cmC[23].mix(0);   
    ord2=ord2+cmC[24].mix(0);
    cmC[25].mix(0);
    cmC[26].mix(0);
    rcmA[0].mix(0);
    
    // Mixer
    
    // mixer 0
    // context is sum of context order(3-5,6,8) isState counts (max 6) and bit pos
    //mxA[0].cxt=(ord<<3) + bpos;

    // reference
    // if(bpos){	
    //   c=c0<<(8-bpos); if(bpos==1)c=c+c3/2;
    //   c=(min(bpos,5))*256+c1/32+8*(c2/32)+(c&192);
    // }
    // else c=c3/128+(c4>>31)*2+4*(c2/64)+(c1&240);
    
    
    // mixer 1
    // at bpos=0   context is last 2 bit2word and 1 bit3word
    // at bpos=1-3 context is last 2 bit2word and 1 bit3word of current bracket or quote
    // at bpos=4-7 context is last 1 bit2word, current bit2word from c0 and bit3word of current bracket or quote
    if (bpos==0)  mxA[1].cxt=(w4&63)*8 + (ttype&7);
    else if (bpos>3) {
        c=wrt_w[c0b&255];
        mxA[1].cxt=(((w4<<2)&63)+c)*8+w4br;
    } else    
        mxA[1].cxt=(w4&63)*8 +w4br;
    
    // mixer 2
    // at bpos=0   context is was byte(3,4) a word and 2 bit3word
    // at bpos=1   context is bit 1xxxxxxx from c0, was byte(2) a word, bit pos max 5,last 1 bit3word and 1 bit3word of current bracket or quote
    // at bpos=2   context is bit 11xxxxxx (bit pos 2) from c0, was byte(2) a word, bit pos max 5,last 1 bit3word and 1 bit3word of current bracket or quote
    // at bpos=3   context is bit 111xxxxx (bit pos 3) from c0, was byte(2) a word, bit pos max 5,last 1 bit3word and 1 bit3word of current bracket or quote
    // at bpos=4-7 context is bit current bit2word from c0, bit pos max 5,last 1 bit3word and 1 bit3word of current bracket or quote
    if (bpos){
         c=c0b; 
         if (bpos==1) c=c+16 * (words*2& 4);
         else if (bpos>3)  c=wrt_w[c0b&255]*64;
         c=(min(bpos,5))*256+(wtype&7)+w4br*8+(c&192);//w4br end is bad, add case
    }
    else c=((words>>0)&12)*16+(wtype&7)+w4br*8;
    mxA[2].cxt=c;
    
    // mixer 3
    // at bpos=0-7   context is was byte(3,4) a word, sum of context order(3-5,6,8) isState counts (max 5) and last 2 bit2word
    mxA[3].cxt=((4 * words) & 0xf0) + ord*256 + (w4 & 15);
    
    // mixer 7
    // at bpos=0-7   context is non-repeating 2 bit3word of byte(2,3), was byte(1-3) a word and last 1 bit2word
    mxA[7].cxt=((wtype) & 0x1f8)*4 + ((2 * words) & 0x1c) + (w4 & 3);
    c=c0b;
    // mixer 4
    // at bpos=0   context is bit xxxxxxxx from c0, was byte(1-8) a word or space and bit pos
    // at bpos=1   context is bit 1xxxxxxx from c0, was byte(1-7) a word or space and bit pos
    // at bpos=2   context is bit 11xxxxxx from c0, was byte(1-6) a word or space and bit pos
    // at bpos=3   context is bit 111xxxxx from c0, was byte(1-5) a word or space and bit pos
    // at bpos=4   context is bit 1111xxxx from c0, was byte(1-4) a word or space and bit pos
    // at bpos=5   context is bit 11111xxx from c0, was byte(1-3) a word or space and bit pos
    // at bpos=6   context is bit 111111xx from c0, was byte(1-2) a word or space and bit pos
    // at bpos=7   context is bit 1111111x from c0, was byte(1)   a word or space and bit pos
    mxA[4].cxt=bpos*256 + (((( (numbers|words)<< bpos)&255)>> bpos) | (c&255));
    // mixer 9 - final mixer
    // at bpos=0-7   context is sum of context order(3-5,6,8) isState counts (max 5), bracket or quote state(0,1) and last 1 bit2word
    mxA[9].cxt=(ord*8 + (w4br?1:0)*4 + (w4&3));
    
    // mixer 5 
    // at bpos=0   context is bit xxxxxxxx from c0, first char type state(0,1) xxxx1xxx, 2 bit2word            1111xxxx
    // at bpos=1   context is bit 1xxxxxxx from c0, first char type state(0,1) xxxx1xxx, 1 bit3word            x111xxxx, bit pos xxxxx111
    // at bpos=2   context is bit 11xxxxxx from c0, first char type state(0,1) xxxx1xxx, 1 bit2word            xx11xxxx, bit pos xxxxx111
    // at bpos=3   context is bit 111xxxxx from c0, first char type state(0,1) xxxx1xxx, was byte(1) a word    xxx1xxxx, bit pos xxxxx111
    // at bpos=4   context is bit 1111xxxx from c0, first char type state(0,1) xxxx1xxx,                                 bit pos xxxxx111
    // at bpos=5   context is bit 11111xxx from c0, first char type state(0,1) xxxx1xxx (overflow, ok!)
    // at bpos=6   context is bit 111111xx from c0, first char type state(0,1) xxxx1xxx
    // at bpos=7   context is bit 1111111x from c0, first char type state(0,1) xxxx1xxx
    // at bpos=0-7 sum of context order(3-5,6,8) isState counts (max 5) and is match(0,1) 111 xxxxxxxx
    
    if (bpos) {
        if (bpos==1) {
            c=c + 16*(ttype&7);
        }
        else if (bpos==2) {
            c=c + 16*(w4&3);
        }
        else if (bpos==3) {
            c=c + 16*(words&1);
        } else  {
            c=bpos + (c&0xf0);
        }
        if (bpos<5)
            c=bpos + (c&0xf0); 
    }else   c=16 * (w4&0xf);
    ord=ord-1;
    if (ord<0)
       ord=0;
    if (ismatch)
        ord=ord+1;
    mxA[5].cxt=c + ord*256+ 8*fc1;
    
    // mixer 6
    // at bpos=0-7   context is sum of context words isState counts (max 6), first char type state(0,1), 2 bit2word of byte(3,4) and 1 bit3word of byte(2)
    mxA[6].cxt=(ord2*256 + (w4&0xf0) + ((ttype&0x38) >> 2))*4 + fqcxt;
    
    // mixer 8 
    // at bpos 0-2 bit3word, 1 bit3word of current bracket or quote, was byte(1,2,3) a word, first char flag, is a match
    // at bpos 3-7 bit3word from c0, 1 bit3word of current bracket or quote, was byte(1,2,3) a word, first char flag, is a match
    if (bpos>2) 
        mxA[8].cxt= wrt_t[c0b&255]*256 +(w4br)*32 + (words&7)*4 + fc1+(ismatch?2:0);
    else
        mxA[8].cxt= (ttype&3)*256 +(w4br)*16 + (words&7)*2 + fc1+(ismatch?128:0);  // fixme
    //x.mxInputs[1].add(mxA[0].p1());
    x.mxInputs[1].add(mxA[1].p1());
    x.mxInputs[1].add(mxA[2].p1());
    x.mxInputs[1].add(mxA[3].p1());
    x.mxInputs[1].add(mxA[4].p1());
    x.mxInputs[1].add(mxA[5].p1());
    x.mxInputs[1].add(mxA[6].p1());
    x.mxInputs[1].add(mxA[7].p1());
    x.mxInputs[1].add(mxA[8].p1());
    return mxA[9].p();
}

/*
int fcolors[8]={15,7,8,3,9,1,4,12};
HANDLE  hConsole;
*/
int rate=6;
void update() {
    x.c0+=x.c0+x.y;
    if (x.c0>=256) {
        x.c4=(x.c4<<8)+(x.c0&0xff);	
        x.c0=1;
        ++x.blpos;
        if ((fails&255)==0) {
            for (int i=1;i<9;i++) if (i!=7)mxA[i].elim=max(256,mxA[i].elim+1);
        }else{ 
            for (int i=1;i<9;i++) if (i!=7)mxA[i].elim=min(16,mxA[i].elim-1);
        }
       rate=6 + (x.blpos>14*256*1024) + (x.blpos>28*512*1024);
    }
    x.bpos=(x.bpos+1)&7;
    x.bposshift=7-x.bpos;
    x.c0shift_bpos=(x.c0<<1)^(256>>(x.bposshift));
    //mxA[0].update(x.y);
    mxA[1].update(x.y);
    mxA[2].update(x.y);
    mxA[3].update(x.y);
    mxA[4].update(x.y);
    mxA[5].update(x.y);
    mxA[6].update(x.y);
    mxA[7].update(x.y);
    mxA[8].update(x.y);
    mxA[9].update(x.y);
    //printf("mixer 0 predictor count %d\n",x.mxInputs[0].ncount);
    x.mxInputs[0].ncount=0;
    //printf("mixer 1 predictor count %d\n",x.mxInputs[1].ncount);
    x.mxInputs[1].ncount=0;
    // This part is from paq8hp12
    if (fails&0x00000080) --failcount;
    fails=fails*2;
    failz=failz*2;
    
    if (x.y) pr=4095-pr;
    if (pr>=e_l[x.bpos]) ++fails, ++failcount;
    if (pr>=848) ++failz;
  
    pr=modelPrediction(x.c0,x.bpos,x.c4);
   /* if (x.bpos==0) {
        hConsole = GetStdHandle(STD_OUTPUT_HANDLE); 
        int color1=fcolors[(fccxt.context&0xff)?FindQy2(fccxt.context>>8):1];
        SetConsoleTextAttribute(hConsole, color1);
     
        if( (x.c4&0xff)<=32 ) {
           if( (x.c4&0xff)==10 ) printf("\n");else
          printf(" ");
        } else
          printf("%c",(x.c4&0xff));
        
    }
    */
    int pt, pu=(apmA[0].p(pr, x.c0, 3,x.y)+7*pr+4)>>3, pv, pz=failcount+1;

    pz+=tri[(fails>>5)&3];
    pz+=trj[(fails>>3)&3];
    pz+=trj[(fails>>1)&3];
    if (fails&1) pz+=8;
    pz=pz/2;

    pu=apmA[3].p(pu,   ((x.c0*2)^AH1)&0x3ffff, rate,x.y);
    pv=apmA[1].p(pr,   ((x.c0*8)^hash(29,failz&2047))&0xffff, rate+1,x.y);
    pv=apmA[4].p(pv,          hash(x.c0,w4 & 0xfffc,(wtype & 0x1ff))&0x1ffff, rate,x.y);
    pt=apmA[2].p(pr, ( (x.c0*32)^AH2)&0xffff, rate,x.y);
    pz=apmA[5].p(pu,   ((x.c0*4)^hash(min(9,pz),x5&0x80ff))&0x1ffff, rate,x.y);
    
    if (fails&255) pr=(pt*6+pu  +pv*11+pz*14 +31)>>5;
    else           pr=(pt*4+pu*5+pv*12+pz*11 +31)>>5;

}

//////////////////////////// Encoder ////////////////////////////

void put32(U32 x,FILE *f){
    fputc((x >> 24) & 255, f); 
    fputc((x >> 16) & 255, f); 
    fputc((x >> 8) & 255, f); 
    fputc(x & 255, f);
}

void put64(U64 x,FILE *out){
    putc((x >> 56) & 255,out);
    putc((x >> 48) & 255,out);
    putc((x >> 40) & 255,out);
    putc((x >> 32) & 255,out);
    putc((x >> 24) & 255,out); 
    putc((x >> 16) & 255,out); 
    putc((x >> 8) & 255,out); 
    putc(x & 255,out);
}

U64 get64(FILE *in) {
    return ((U64)getc(in) << 56) | ((U64)getc(in) << 48) | ((U64)getc(in) << 40) | ((U64)getc(in) << 32) | (getc(in) << 24) | (getc(in) << 16) | (getc(in) << 8) | (getc(in));
}

typedef enum {COMPRESS, DECOMPRESS} Mode;
class Encoder {
private:
  const Mode mode;       // Compress or decompress?
  FILE* archive;         // Compressed data file
  U32 x1, x2;            // Range, initially [0, 1), scaled by 2^32
  U32 x0;                // Decompress mode: last 4 input bytes of archive
  FILE*alt;              // decompress() source in COMPRESS mode
 U32 scompsize;
  // Compress bit y or return decompressed bit
  void code(int i=0) {
    int p=pr;
    p+=p==0;
    assert(p>0 && p<4096);
    U32 xmid=x1 + ((x2-x1)>>12)*p + (((x2-x1)&0xfff)*p>>12);
    assert(xmid>=x1 && xmid<x2);
    x.y=i;
    i ? (x2=xmid) : (x1=xmid+1);
    update();
    while (((x1^x2)&0xff000000)==0) {  // pass equal leading bytes of range
       fputc(x2>>24, archive);
      x1<<=8;
      x2=(x2<<8)+255;
    }
  }
  int decode() {
    int p=pr;
    p+=p==0;
    assert(p>0 && p<4096);
    U32 xmid=x1 + ((x2-x1)>>12)*p + (((x2-x1)&0xfff)*p>>12);
    assert(xmid>=x1 && xmid<x2);
    x0<=xmid ? (x2=xmid,x.y=1) : (x1=xmid+1,x.y=0);
    update();
    while (((x1^x2)&0xff000000)==0) {  // pass equal leading bytes of range
      x1<<=8;
      x2=(x2<<8)+255;
      x0=(x0<<8)+(fgetc(archive)&255);  // EOF is OK
    }
    return x.y;
  }

public:
  Encoder(Mode m, FILE* f);
  Mode getMode() const {return mode;}
  U32 size() const {return  ftell (archive);}  // length of archive so far archive->curpos()
  void flush();  // call this when compression is finished
  void setFile(FILE* f) {alt=f;}

  // Compress one byte
  void compress(int c) {
    assert(mode==COMPRESS);
    #ifdef CHARSWAP
      c=charSwap(c);
    #endif
      for (int i=7; i>=0; --i)
        code((c>>i)&1);
        if (!(x.blpos&0x3ffff))  printf("%d  %d\n",x.blpos,size()-scompsize), scompsize=size();
  }

  // Decompress and return one byte
  int decompress() {
      int c=0;
      for (int i=0; i<8; ++i)
        c+=c+decode();
        #ifdef CHARSWAP
        c=charSwap(c);
        #endif
      return c;
  }
  
  ~Encoder(){ }
};

Encoder::Encoder(Mode m, FILE* f):
    mode(m), archive(f), x1(0), x2(0xffffffff), x0(0), alt(0) {        
    PredictorInit();
    scompsize=0;
    // x0 = first 4 bytes of archive
    if (mode==DECOMPRESS) {
        for (int i=0; i<4; ++i)
            x0=(x0<<8)+(fgetc (archive)&255);
    }
}

void Encoder::flush() {
    if (mode==COMPRESS)
        put32(x1,archive);  // Flush first unequal byte of range
}

#include <psapi.h>
size_t getPeakMemory(){
#if defined(_WIN32)
    PROCESS_MEMORY_COUNTERS info;
    GetProcessMemoryInfo( GetCurrentProcess( ), &info, sizeof(info) );
    return (size_t)info.PeakPagefileUsage; // recuested peak memory /PeakWorkingSetSize used memory
#elif defined(UNIX) 
    return (size_t)0L; //not tested
#else
    return (size_t)0L;
#endif // -lpsapi
}
  
int main(int argc, char** argv) {   
    // Check arguments
    if (argc!=4 || (argv[1][0]!='c' && argv[1][0]!='d')) {
        printf(
        "fxcm v%d file compressor (C)  2023, Kaido Orav.\n"
        "Licensed under GPL, http://www.gnu.org/copyleft/gpl.html\n"
        "\n"
        "To compress:   fxcm c input output \n"
        "To decompress: fxcm d input output \n",VERSION);
        return 1;
    }

    // Get start time
    clock_t start=clock();

    // Open input file
    FILE *in=fopen(argv[2], "rb");
    if (!in) exit(1);
    FILE *out=0;
  
    // Precalculate tabeles
    int o=2;
    for (int i=0; i<1024; ++i)
        dt[i]=4096/(o),o++;
    dt[1023]=1;

    // Stretch table
    for (int i=0; i<=4095; i++) {
        strt[i]=stretchc(i);
    }

    // Squash table
    for (int i=-2047; i<=2047; i++) {
        sqt[i+2047]=squashc(i);
    }
  
    InitIlog();
    x.Init();
    
    // Match model
    mhashtablemask=0x200000*1-1;
    alloc1(mhashtable,0x200000*1+32,mhptr,32);  
    
    if (argv[1][0]=='c') {        
        // Compress
        // Encode header: signature, version, file size
        fseeko(in, 0, SEEK_END);
        U64 size=ftello(in);
        //if (size<0 || size>=0x7FFFFFFF) printf("File to large."),exit(1);
        fseeko(in, 0, SEEK_SET);
        out=fopen(argv[3], "wb");
        if (!out) exit(1);
        fprintf(out, "xF%c", VERSION);
        put64(size,out);

        Encoder e(COMPRESS, out);
        int c;
        while ((c=getc(in))!=EOF)
            e.compress(c);
        e.flush();
    } else {
        // Decompress
        // Check header signature, version, file size
        if (getc(in)!='x' || getc(in)!='F' || getc(in)!=VERSION)
            printf("Not a fx file."),exit(1);
        U64 size=get64(in);
        if (size==0) printf("Bad file size."),exit(1);
        out=fopen(argv[3], "wb");
        if (!out) exit(1);
        
        Encoder e(DECOMPRESS, in);
        while (size-->0)
            putc(e.decompress(), out);
    }
    
    PredictorFree();
    free(mhptr);
    printf("%ld -> %ld in %1.2f sec. %d MB memory.\n", 
    ftello(in), ftello(out), double(clock()-start)/CLOCKS_PER_SEC, U32(getPeakMemory()/1024)/1024);
    fclose(in);
    fclose(out);
    return 0;
}


