/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.base.Optional;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_GuardedByUtils_GuardedByValidationResult;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByBinder;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByExpression;
import com.google.errorprone.bugpatterns.threadsafety.GuardedBySymbolResolver;
import com.google.errorprone.bugpatterns.threadsafety.IllegalGuardedBy;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import javax.annotation.concurrent.GuardedBy;

public class GuardedByUtils {
    static String getGuardValue(Tree tree) {
        net.jcip.annotations.GuardedBy guardedBy = (net.jcip.annotations.GuardedBy)ASTHelpers.getAnnotation((Tree)tree, net.jcip.annotations.GuardedBy.class);
        if (guardedBy != null) {
            return guardedBy.value();
        }
        guardedBy = (GuardedBy)ASTHelpers.getAnnotation((Tree)tree, GuardedBy.class);
        if (guardedBy != null) {
            return guardedBy.value();
        }
        return null;
    }

    public static JCTree.JCExpression parseString(String guardedByString, Context context) {
        JCTree.JCExpression exp;
        JavacParser parser = ParserFactory.instance(context).newParser(guardedByString, false, true, false);
        try {
            exp = parser.parseExpression();
        }
        catch (Throwable e) {
            throw new IllegalGuardedBy(e.getMessage());
        }
        int len = parser.getEndPos(exp) - exp.getStartPosition();
        if (len != guardedByString.length()) {
            throw new IllegalGuardedBy("Didn't parse entire string.");
        }
        return exp;
    }

    public static GuardedByValidationResult isGuardedByValid(Tree tree, VisitorState state) {
        boolean staticGuard;
        String guard = GuardedByUtils.getGuardValue(tree);
        if (guard == null) {
            return GuardedByValidationResult.ok();
        }
        Optional<GuardedByExpression> boundGuard = GuardedByBinder.bindString(guard, GuardedBySymbolResolver.from(tree, state));
        if (!boundGuard.isPresent()) {
            return GuardedByValidationResult.invalid("could not resolve guard");
        }
        Symbol treeSym = ASTHelpers.getSymbol((Tree)tree);
        if (treeSym == null) {
            return GuardedByValidationResult.ok();
        }
        boolean bl = staticGuard = ((GuardedByExpression)boundGuard.get()).kind() == GuardedByExpression.Kind.CLASS_LITERAL || ((GuardedByExpression)boundGuard.get()).sym() != null && ((GuardedByExpression)boundGuard.get()).sym().isStatic();
        if (treeSym.isStatic() && !staticGuard) {
            return GuardedByValidationResult.invalid("static member guarded by instance");
        }
        return GuardedByValidationResult.ok();
    }

    static abstract class GuardedByValidationResult {
        GuardedByValidationResult() {
        }

        abstract String message();

        abstract Boolean isValid();

        static GuardedByValidationResult invalid(String message) {
            return new AutoValue_GuardedByUtils_GuardedByValidationResult(message, false);
        }

        static GuardedByValidationResult ok() {
            return new AutoValue_GuardedByUtils_GuardedByValidationResult("", true);
        }
    }
}

