/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.scanner;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.BugCheckerInfo;
import com.google.errorprone.BugPattern;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.scanner.ErrorProneScanner;
import com.google.errorprone.scanner.ScannerSupplier;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

class ScannerSupplierImpl
extends ScannerSupplier
implements Serializable {
    private final ImmutableBiMap<String, BugCheckerInfo> checks;
    private final ImmutableMap<String, BugPattern.SeverityLevel> severities;
    private final ImmutableSet<String> disabled;
    private static final Function<BugCheckerInfo, BugChecker> INSTANTIATE_CHECKER = new Function<BugCheckerInfo, BugChecker>(){

        public BugChecker apply(BugCheckerInfo checkerClass) {
            try {
                return checkerClass.checkerClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new LinkageError("Could not instantiate BugChecker.", e);
            }
        }
    };

    ScannerSupplierImpl(ImmutableBiMap<String, BugCheckerInfo> checks, ImmutableMap<String, BugPattern.SeverityLevel> severities, ImmutableSet<String> disabled) {
        Preconditions.checkArgument((boolean)Sets.difference((Set)severities.keySet(), (Set)checks.keySet()).isEmpty(), (Object)"enabledChecks must be a subset of allChecks");
        Preconditions.checkArgument((boolean)Sets.difference(disabled, (Set)checks.keySet()).isEmpty(), (Object)"disabled must be a subset of allChecks");
        this.checks = checks;
        this.severities = severities;
        this.disabled = disabled;
    }

    public ErrorProneScanner get() {
        return new ErrorProneScanner(Iterables.transform(this.getEnabledChecks(), INSTANTIATE_CHECKER), (Map<String, BugPattern.SeverityLevel>)this.severities);
    }

    @Override
    public ImmutableBiMap<String, BugCheckerInfo> getAllChecks() {
        return this.checks;
    }

    @Override
    public ImmutableMap<String, BugPattern.SeverityLevel> severities() {
        return this.severities;
    }

    @Override
    protected ImmutableSet<String> disabled() {
        return this.disabled;
    }

    @Override
    public ImmutableSet<BugCheckerInfo> getEnabledChecks() {
        return FluentIterable.from((Iterable)this.getAllChecks().values()).filter((Predicate)new Predicate<BugCheckerInfo>(){

            public boolean apply(BugCheckerInfo input) {
                return !ScannerSupplierImpl.this.disabled.contains((Object)input.canonicalName());
            }
        }).toSet();
    }

    public String toString() {
        return (String)Iterables.getFirst((Iterable)this.getAllChecks().keySet(), null);
    }
}

