<?php
/**
 * Applicative event that raised by the developer when indexed object is ready for indexing in the index server
 */
class kObjectReadyForIndexEvent extends kApplicativeEvent
{
	const EVENT_CONSUMER = 'kObjectReadyForIndexEventConsumer';
	
	public function getConsumerInterface()
	{
		return self::EVENT_CONSUMER;
	}
	
	/**
	 * @param kObjectAddedEventConsumer $consumer
	 * @return bool true if should continue to the next consumer
	 */
	protected function doConsume(KalturaEventConsumer $consumer)
	{
		if(!$consumer->shouldConsumeReadyForIndexEvent($this->object))
			return true;
			
		$additionalLog = '';
		if(method_exists($this->object, 'getId'))
			$additionalLog .= 'id [' . $this->object->getId() . ']';
			
		KalturaLog::debug('consumer [' . get_class($consumer) . '] started handling [' . get_class($this) . '] object type [' . get_class($this->object) . '] ' . $additionalLog);
		$origExecutionScope = kCurrentContext::$executionScope;
		kCurrentContext::$executionScope = executionScope::INDEXING;
		$result = $consumer->objectReadyForIndex($this->object, $this->raisedJob);
		kCurrentContext::$executionScope = $origExecutionScope;
		KalturaLog::debug('consumer [' . get_class($consumer) . '] finished handling [' . get_class($this) . '] object type [' . get_class($this->object) . '] ' . $additionalLog);
		return $result;
	}

}