<?php
/**
 * @package server-infra
 * @subpackage propel
 */
require_once 'propel/engine/builder/om/php5/PHP5ExtensionPeerBuilder.php';

/**
 * Generates the empty PHP5 stub peer class for user object model (OM).
 *
 * This class produces the empty stub class that can be customized with application
 * business logic, custom behavior, etc.
 *
 * This class replaces the ExtensionPeer.tpl, with the intent of being easier for users
 * to customize (through extending & overriding).
 *
 * @package server-infra
 * @subpackage propel
 */
class KalturaExtensionPeerBuilder extends PHP5ExtensionPeerBuilder
{
	/* (non-PHPdoc)
	 * @see PHP5ExtensionPeerBuilder::addClassOpen()
	 */
	protected function addClassOpen(&$script)
	{
		$table = $this->getTable();
		$tableName = $table->getName();
		$tableDesc = $table->getDescription();

		switch($table->treeMode()) {
			case 'NestedSet':
				$baseClassname = $this->getNestedSetPeerBuilder()->getClassname();
			break;

			case 'MaterializedPath':
			case 'AdjacencyList':
			default:
				$baseClassname = $this->getPeerBuilder()->getClassname();
			break;
		}

		$script .= "

/**
 * Skeleton subclass for performing query and update operations on the '$tableName' table.
 *
 * $tableDesc
 *";
		if ($this->getBuildProperty('addTimeStamp')) {
			$now = strftime('%c');
			$script .= "
 * This class was autogenerated by Propel " . $this->getBuildProperty('version') . " on:
 *
 * $now
 *";
		}
		$script .= "
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package ".$this->getPackage()."
 * @subpackage ".$this->getSubpackage()."
 */
class ".$this->getClassname()." extends $baseClassname {
";
	}

	/* (non-PHPdoc)
	 * @see OMBuilder::getClassFilePath()
	 */
	public function getClassFilePath()
	{
		return ClassTools::getFilePath('lib.model', $this->getClassname());
	}

	/* (non-PHPdoc)
	 * @see OMBuilder::getPackage()
	 */
	public function getPackage()
	{
		$pkg = ($this->getTable()->getPackage() ? $this->getTable()->getPackage() : $this->getDatabase()->getPackage());
		if (!$pkg) {
			$pkg = $this->getBuildProperty('targetPackage');
		}
		return $pkg;
	}
	
	public function getSubpackage()
	{
		return $this->getBuildProperty('subpackage');
	}
}
