<?php
/**
 * @package server-infra
 * @subpackage propel
 */
require_once 'propel/engine/builder/om/php5/PHP5TableMapBuilder.php';

/**
 * Generates the PHP5 table map class for user object model (OM).
 *
 * @package server-infra
 * @subpackage propel
 */
class KalturaMapBuilderBuilder extends PHP5TableMapBuilder
{
	/* (non-PHPdoc)
	 * @see PHP5TableMapBuilder::addClassOpen()
	 */
	protected function addClassOpen(&$script)
	{
		$table = $this->getTable();
		$script .= "

/**
 * This class defines the structure of the '".$table->getName()."' table.
 *
 *";
		if ($this->getBuildProperty('addTimeStamp')) {
			$now = strftime('%c');
			$script .= "
 * This class was autogenerated by Propel " . $this->getBuildProperty('version') . " on:
 *
 * $now
 *";
		}
		$script .= "
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package ".$this->getPackage()."
 * @subpackage ".$this->getSubpackage()."
 */
class ".$this->getClassname()." extends TableMap {
";
	}

	/* (non-PHPdoc)
	 * @see OMBuilder::getClassFilePath()
	 */
	public function getClassFilePath()
	{
		return ClassTools::getFilePath('lib.model.map', $this->getClassname());
	}

	/* (non-PHPdoc)
	 * @see PHP5TableMapBuilder::getPackage()
	 */
	public function getPackage()
	{
		$pkg = ($this->getTable()->getPackage() ? $this->getTable()->getPackage() : $this->getDatabase()->getPackage());
		if (!$pkg) {
			$pkg = $this->getBuildProperty('targetPackage');
		}
		return $pkg;
	}
	
	public function getSubpackage()
	{
		$pkg = $this->getBuildProperty('subpackage');
		return "$pkg.map";
	}
}
