<?php

class kKavaNoResultsException extends kException
{
}

class kKavaBase extends kDruidBase
{
	// data sources
	const DATASOURCE_REALTIME = 'player-events-realtime';
	const DATASOURCE_HISTORICAL = 'player-events-historical';
	const DATASOURCE_ENTRY_LIFECYCLE = 'entry-lifecycle';
	const DATASOURCE_USER_LIFECYCLE = 'user-lifecycle';
	const DATASOURCE_BANDWIDTH_USAGE = 'bandwidth-usage';
	const DATASOURCE_STORAGE_USAGE = 'storage-usage';
	const DATASOURCE_TRANSCODING_USAGE = 'transcoding-usage';
	const DATASOURCE_REACH_USAGE = 'reach-usage';
	const DATASOURCE_API_USAGE = 'api-usage';
	const DATASOURCE_VE_REGISTRATION = 'virtual-events-registration';
	const DATASOURCE_MEETING_HISTORICAL = 'meeting-events-historical';
	const DATASOURCE_MEETING_REALTIME = 'meeting-events-realtime';
	const DATASOURCE_CNC_EVENTS = 'cnc-events';
	const DATASOURCE_APPLICATION_EVENTS = 'application-events';

	// dimensions
	const DIMENSION_PARTNER_ID = 'partnerId';
	const DIMENSION_PARTNER_PARENT_ID = 'partnerParentId';
	const DIMENSION_ENTRY_ID = 'entryId';
	const DIMENSION_LOCATION_COUNTRY = 'location.country';
	const DIMENSION_LOCATION_REGION = 'location.region';
	const DIMENSION_LOCATION_CITY = 'location.city';
	const DIMENSION_LOCATION_ISP = 'location.isp';
	const DIMENSION_LOCATION_WORLD_REGION = 'worldRegion';
	const DIMENSION_DOMAIN = 'urlParts.domain';
	const DIMENSION_URL = 'urlParts.canonicalUrl';
	const DIMENSION_KUSER_ID = 'kuserId';
	const DIMENSION_USER_TYPE = 'userType';
	const DIMENSION_APPLICATION = 'application';
	const DIMENSION_DEVICE = 'userAgent.device';
	const DIMENSION_OS = 'userAgent.operatingSystem';
	const DIMENSION_OS_FAMILY = 'userAgent.operatingSystemFamily';
	const DIMENSION_BROWSER = 'userAgent.browser';
	const DIMENSION_BROWSER_FAMILY = 'userAgent.browserFamily';
	const DIMENSION_PLAYBACK_CONTEXT = 'playbackContext';
	const DIMENSION_PLAYBACK_TYPE = 'playbackType';
	const DIMENSION_SERVER_NODE_IDS = 'serverNodeIds';
	const DIMENSION_CATEGORIES = 'categories';
	const DIMENSION_EVENT_TYPE = 'eventType';
	const DIMENSION_HAS_BITRATE = 'hasBitrate';
	const DIMENSION_MEDIA_TYPE = 'mediaType';
	const DIMENSION_SOURCE_TYPE = 'sourceType';
	const DIMENSION_STATUS = 'status';
	const DIMENSION_SERVICE_TYPE = 'serviceType';
	const DIMENSION_SERVICE_FEATURE = 'serviceFeature';
	const DIMENSION_TURNAROUND_TIME = 'turnaroundTime';
	const DIMENSION_REACH_PROFILE_ID = 'reachProfileId';
	const DIMENSION_CUSTOM_VAR1 = 'customVar1';
	const DIMENSION_CUSTOM_VAR2 = 'customVar2';
	const DIMENSION_CUSTOM_VAR3 = 'customVar3';
	const DIMENSION_TYPE = 'type';
	const DIMENSION_ENTRY_OWNER_ID = 'entryKuserId';
	const DIMENSION_ENTRY_CREATOR_ID = 'entryCreatorId';
	const DIMENSION_ENTRY_CREATED_AT = 'entryCreatedAt';
	const DIMENSION_PERCENTILES = 'percentiles';
	const DIMENSION_EVENT_VAR1 = 'eventVar1';
	const DIMENSION_EVENT_VAR2 = 'eventVar2';
	const DIMENSION_EVENT_VAR3 = 'eventVar3';
	const DIMENSION_EVENT_VAR4 = 'eventVar4';
	const DIMENSION_USER_ENGAGEMENT = 'userEngagement';
	const DIMENSION_EVENT_PROPERTIES = 'eventProperties';
	const DIMENSION_FLAVOR_PARAMS_ID = 'flavorParamsId';
	const DIMENSION_PLAYER_VERSION = 'playerVersion';
	const DIMENSION_POSITION = 'position';
	const DIMENSION_EXTRACT_TIME = 'extract_time';
	const DIMENSION_ROOT_ENTRY_ID = 'rootEntryId';
	const DIMENSION_NODE_ID = 'nodeId';
	const DIMENSION_APPLICATION_VER = 'applicationVer';
	const DIMENSION_PARTNER_CRM_ID = 'partnerCrmId';
	const DIMENSION_PLAYLIST_ID = 'playlistId';
	const DIMENSION_VIRTUAL_EVENT_ID = 'virtualEventId';
	const DIMENSION_INDUSTRY = 'industry';
	const DIMENSION_ROLE = 'role';
	const DIMENSION_ORIGIN = 'origin';
	const DIMENSION_UI_CONF_ID = 'uiConfId';
	const DIMENSION_CATALOG_ITEM_ID = 'catalogItemId';
	const DIMENSION_REACH_PROFILE_TYPE = 'reachProfileType';
	const DIMENSION_CUE_POINT_ID = 'cuePointId';
	const DIMENSION_CONTEXT_ID = 'contextId';
	const DIMENSION_EVENT_SESSION_CONTEXT_ID = 'eventSessionContextId';
	const DIMENSION_PLAYBACK_MODE = 'playbackMode';
	const DIMENSION_COMPANY = 'company';
	const DIMENSION_FLAVOR_ID = 'flavorId';
	const DIMENSION_VIDEO_CODEC = 'videoCodec';

	// metrics
	const METRIC_COUNT = 'count';
	const METRIC_BUFFER_TIME_SUM = 'bufferTimeSum';
	const METRIC_BITRATE_SUM = 'bitrateSum';
	const METRIC_EVENT_DOUBLE_SUM1 = 'eventDoubleSum1';
	const METRIC_USER_CPU = 'userCpu';

	// playback types
	const PLAYBACK_TYPE_VOD = 'vod';
	const PLAYBACK_TYPE_LIVE = 'live';
	const PLAYBACK_TYPE_DVR = 'dvr';
	const PLAYBACK_TYPE_OFFLINE = 'offline';

	// event types - player events
	const EVENT_TYPE_PLAYER_IMPRESSION = 'playerImpression';
	const EVENT_TYPE_PLAY_REQUESTED = 'playRequested';
	const EVENT_TYPE_PLAY = 'play';
	const EVENT_TYPE_RESUME = 'resume';
	const EVENT_TYPE_PLAYTHROUGH_25 = 'playThrough25';
	const EVENT_TYPE_PLAYTHROUGH_50 = 'playThrough50';
	const EVENT_TYPE_PLAYTHROUGH_75 = 'playThrough75';
	const EVENT_TYPE_PLAYTHROUGH_100 = 'playThrough100';
	const EVENT_TYPE_EDIT_CLICKED = 'editClicked';
	const EVENT_TYPE_SHARE_CLICKED = 'shareClicked';
	const EVENT_TYPE_SHARED = 'shared';
	const EVENT_TYPE_DOWNLOAD_CLICKED = 'downloadClicked';
	const EVENT_TYPE_REPORT_CLICKED = 'reportClicked';
	const EVENT_TYPE_PLAY_END = 'playEnd';
	const EVENT_TYPE_REPORT_SUBMITTED = 'reportSubmitted';
	const EVENT_TYPE_ENTER_FULL_SCREEN = 'enterFullscreen';
	const EVENT_TYPE_EXIT_FULL_SCREEN = 'exitFullscreen';
	const EVENT_TYPE_PAUSE = 'pauseClicked';
	const EVENT_TYPE_REPLAY = 'replay';
	const EVENT_TYPE_SEEK = 'seek';
	const EVENT_TYPE_RELATED_CLICKED = 'relatedClicked';
	const EVENT_TYPE_RELATED_SELECTED = 'relatedSelected';
	const EVENT_TYPE_CAPTIONS = 'captions';
	const EVENT_TYPE_SOURCE_SELECTED = 'sourceSelected';
	const EVENT_TYPE_INFO = 'info';
	const EVENT_TYPE_SPEED = 'speed';
	const EVENT_TYPE_FLAVOR_SWITCH = 'flavorSwitch';
	const EVENT_TYPE_BUFFER_START = 'bufferStart';
	const EVENT_TYPE_ERROR = 'error';
	const EVENT_TYPE_VIEW = 'view';
	const EVENT_TYPE_VIEW_PERIOD = 'viewPeriod';
	const EVENT_TYPE_NODE_PLAY = 'nodePlay';
	const EVENT_TYPE_PLAYMANIFEST = 'playManifest';
	const EVENT_TYPE_REGISTERED = 'registered';
	const EVENT_TYPE_REGISTRATION_IMPRESSION = 'registrationImpression';
	const EVENT_TYPE_HOTSPOT_CLICKED = 'hotspotClicked';
	const EVENT_TYPE_NODE_SWITCH = 'nodeSwitch';
	const EVENT_TYPE_ADD_TO_CALENDAR_CLICKED = 'addToCalendarClicked';
	const EVENT_TYPE_DOWNLOAD_ATTACHMENT_CLICKED = 'downloadAttachmentClicked';
	const EVENT_TYPE_REACTION_CLICKED = 'reactionClicked';
	const EVENT_TYPE_POLL_ANSWERED = 'pollAnswered';

	// event types - storage / entry lifecycle
	const EVENT_TYPE_STATUS = 'status';
	const EVENT_TYPE_PHYSICAL_ADD = 'physicalAdd';
	const EVENT_TYPE_PHYSICAL_DELETE = 'physicalDelete';
	const EVENT_TYPE_LOGICAL_ADD = 'logicalAdd'; 
	const EVENT_TYPE_LOGICAL_DELETE = 'logicalDelete';

	// event types - virtual event registration
	const EVENT_TYPE_VE_REGISTERED = 'registered';
	const EVENT_TYPE_VE_CONFIRMED = 'confirmed';
	const EVENT_TYPE_VE_ATTENDED = 'attended';
	const EVENT_TYPE_VE_PARTICIPATED = 'participated';
	const EVENT_TYPE_VE_BLOCKED = 'blocked';
	const EVENT_TYPE_VE_UNREGISTERED = 'unregistered';
	const EVENT_TYPE_VE_INVITED = 'invited';
	const EVENT_TYPE_VE_CREATED = 'created';
	const EVENT_TYPE_VE_AUTO_CONFIRMED = 'autoConfirmed';
	const EVENT_TYPE_VE_PARTICIPATED_POST_EVENT = 'participatedPostEvent';
	const EVENT_TYPE_VE_INVITED_PENDING_REGISTRATION = 'invitedPendingRegistration';

	// event types - cnc events
	const EVENT_TYPE_LOG_IN = 'loggedIn';
	const EVENT_TYPE_NOTIFICATION_SENT = 'notificationSent';
	const EVENT_TYPE_NOTIFICATION_BUTTON_CLICKED = 'notificationButtonClicked';
	const EVENT_TYPE_POLL_LAUNCHED = 'pollLaunched';
	const EVENT_TYPE_POLL_ENDED = 'pollEnded';
	const EVENT_TYPE_POLL_RECEIVED = 'pollReceived';
	const EVENT_TYPE_GROUP_MESSAGE_SENT = 'groupMessageSent';
	const EVENT_TYPE_MESSAGE_PINNED = 'messagePinned';
	const EVENT_TYPE_MESSAGE_UNPINNED = 'messageUnPinned';
	const EVENT_TYPE_MESSAGE_LIKED = 'messageLiked';
	const EVENT_TYPE_USER_BLOCKED = 'userBlocked';
	const EVENT_TYPE_PRIVATE_MESSAGE_SENT = 'privateMessageSent';
	const EVENT_TYPE_Q_AND_A_MESSAGE_SENT = 'questionAnswerMessageSent';
	const EVENT_TYPE_GROUP_MESSAGE_DELETED = 'groupMessageDeleted';
	const EVENT_TYPE_PRIVATE_CHAT_CONNECTION_REQUEST_SENT = 'privateChatConnectionRequestSent';
	const EVENT_TYPE_PRIVATE_CHAT_CONNECTION_REQUEST_APPROVED = 'privateChatConnectionRequestApproved';
	const EVENT_TYPE_PRIVATE_CHAT_CONNECTION_REQUEST_CANCELED = 'privateChatConnectionRequestCanceled';

	// event types - meeting events
	const EVENT_TYPE_MEETING_JOIN_SESSION = 'joinSession';
	const EVENT_TYPE_MEETING_RAISE_HAND = 'raiseHand';

	// event types - application events
	const EVENT_TYPE_PAGE_LOAD = 'pageLoad';
	const EVENT_TYPE_BUTTON_CLICKED = 'buttonClicked';
	const EVENT_TYPE_QR_CODE_SCANNED = 'qrCodeScanned';

	// view events
	const VIEW_EVENT_INTERVAL = 10;
	const VIEW_EVENT_PERIOD = 'PT10S';	
	
	// params
	const VOD_DISABLED_PARTNERS = "disabled_kava_vod_partners";
	const LIVE_DISABLED_PARTNERS = "disabled_kava_live_partners";

	// media types
	const MEDIA_TYPE_VIDEO = 'Video';
	const MEDIA_TYPE_AUDIO = 'Audio';
	const MEDIA_TYPE_IMAGE = 'Image';
	const MEDIA_TYPE_SHOW = 'Show';		// mix
	const MEDIA_TYPE_LIVE_STREAM = 'Live stream';
	const MEDIA_TYPE_LIVE_WIN_MEDIA = 'Live stream windows media';
	const MEDIA_TYPE_LIVE_REAL_MEDIA = 'Live stream real media';
	const MEDIA_TYPE_LIVE_QUICKTIME = 'Live stream quicktime';

	// source type
	const SOURCE_INTERACTIVE_VIDEO = 'Interactive Video';
	const SOURCE_MEETING = 'Kaltura Meeting';

	// Entry vendor task statuses
	const TASK_READY = "Ready";

	// event properties
	const PROPERTY_HAS_BITRATE = 'hasBitrate';
	const PROPERTY_IS_BUFFERING = 'isBuffering';
	const PROPERTY_HAS_BANDWIDTH = 'hasBandwidth';
	const PROPERTY_HAS_LATENCY = 'hasLatency';
	const PROPERTY_HAS_DROPPED_FRAMES_RATIO = 'hasDroppedFramesRatio';
	const PROPERTY_HAS_JOIN_TIME = 'hasJoinTime';
	const PROPERTY_HAS_SEGMENT_DOWNLOAD_TIME = 'hasSegmentDownloadTime';
	const PROPERTY_HAS_MANIFEST_DOWNLOAD_TIME = 'hasManifestDownloadTime';

	//user engagement values
	const USER_SOUND_ON_TAB_FOCUSED = 'SoundOnTabFocused';
	const USER_SOUND_ON_TAB_FOCUSED_FULL_SCREEN = 'SoundOnTabFocusedFullScreen';
	const USER_SOUND_ON_TAB_FOCUSED_FULL_SCREEN_OFF = 'SoundOnTabFocusedFullScreenOff';
	const USER_SOUND_ON_TAB_NOT_FOCUSED = 'SoundOnTabNotFocused';
	const USER_SOUND_ON_TAB_NOT_FOCUSED_FULL_SCREEN = 'SoundOnTabNotFocusedFullScreen';
	const USER_SOUND_ON_TAB_NOT_FOCUSED_FULL_SCREEN_OFF = 'SoundOnTabNotFocusedFullScreenOff';
	const USER_SOUND_OFF_TAB_FOCUSED = 'SoundOffTabFocused';
	const USER_SOUND_OFF_TAB_FOCUSED_FULL_SCREEN = 'SoundOffTabFocusedFullScreen';
	const USER_SOUND_OFF_TAB_FOCUSED_FULL_SCREEN_OFF = 'SoundOffTabFocusedFullScreenOff';
	const USER_SOUND_OFF_TAB_NOT_FOCUSED = 'SoundOffTabNotFocused';
	const USER_SOUND_OFF_TAB_NOT_FOCUSED_FULL_SCREEN = 'SoundOffTabNotFocusedFullScreen';
	const USER_SOUND_OFF_TAB_NOT_FOCUSED_FULL_SCREEN_OFF = 'SoundOffTabNotFocusedFullScreenOff';

	// user engagement meeting values
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON = 'TabFocusedMicUnmutedFullScreenCameraOnSoundOn';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_ON_STAGE = 'TabFocusedMicUnmutedFullScreenCameraOnSoundOnOnStage';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_OFF_STAGE = 'TabFocusedMicUnmutedFullScreenCameraOnSoundOnOffStage';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON = 'TabFocusedMicMutedFullScreenCameraOnSoundOn';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_ON_STAGE = 'TabFocusedMicMutedFullScreenCameraOnSoundOnOnStage';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_OFF_STAGE = 'TabFocusedMicMutedFullScreenCameraOnSoundOnOffStage';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON = 'TabFocusedMicUnmutedFullScreenOffCameraOnSoundOn';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_ON_STAGE = 'TabFocusedMicUnmutedFullScreenOffCameraOnSoundOnOnStage';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_OFF_STAGE = 'TabFocusedMicUnmutedFullScreenOffCameraOnSoundOnOffStage';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON = 'TabFocusedMicMutedFullScreenOffCameraOnSoundOn';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_ON_STAGE = 'TabFocusedMicMutedFullScreenOffCameraOnSoundOnOnStage';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_OFF_STAGE = 'TabFocusedMicMutedFullScreenOffCameraOnSoundOnOffStage';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON = 'TabFocusedMicUnmutedFullScreenCameraOffSoundOn';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_ON_STAGE = 'TabFocusedMicUnmutedFullScreenCameraOffSoundOnOnStage';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_OFF_STAGE = 'TabFocusedMicUnmutedFullScreenCameraOffSoundOnOffStage';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON = 'TabFocusedMicMutedFullScreenCameraOffSoundOn';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_ON_STAGE = 'TabFocusedMicMutedFullScreenCameraOffSoundOnOnStage';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_OFF_STAGE = 'TabFocusedMicMutedFullScreenCameraOffSoundOnOffStage';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON = 'TabFocusedMicUnmutedFullScreenOffCameraOffSoundOn';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_ON_STAGE = 'TabFocusedMicUnmutedFullScreenOffCameraOffSoundOnOnStage';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_OFF_STAGE = 'TabFocusedMicUnmutedFullScreenOffCameraOffSoundOnOffStage';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON = 'TabFocusedMicMutedFullScreenOffCameraOffSoundOn';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_ON_STAGE = 'TabFocusedMicMutedFullScreenOffCameraOffSoundOnOnStage';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_OFF_STAGE = 'TabFocusedMicMutedFullScreenOffCameraOffSoundOnOffStage';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF = 'TabFocusedMicUnmutedFullScreenCameraOffSoundOff';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_ON_STAGE = 'TabFocusedMicUnmutedFullScreenCameraOffSoundOffOnStage';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_OFF_STAGE = 'TabFocusedMicUnmutedFullScreenCameraOffSoundOffOffStage';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF = 'TabFocusedMicMutedFullScreenCameraOffSoundOff';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_ON_STAGE = 'TabFocusedMicMutedFullScreenCameraOffSoundOffOnStage';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_OFF_STAGE = 'TabFocusedMicMutedFullScreenCameraOffSoundOffOffStage';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF = 'TabFocusedMicUnmutedFullScreenOffCameraOffSoundOff';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_ON_STAGE = 'TabFocusedMicUnmutedFullScreenOffCameraOffSoundOffOnStage';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_OFF_STAGE = 'TabFocusedMicUnmutedFullScreenOffCameraOffSoundOffOffStage';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF = 'TabFocusedMicMutedFullScreenOffCameraOffSoundOff';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_ON_STAGE = 'TabFocusedMicMutedFullScreenOffCameraOffSoundOffOnStage';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_OFF_STAGE = 'TabFocusedMicMutedFullScreenOffCameraOffSoundOffOffStage';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF = 'TabFocusedMicMutedFullScreenOffCameraOnSoundOff';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_ON_STAGE = 'TabFocusedMicMutedFullScreenOffCameraOnSoundOffOnStage';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_OFF_STAGE = 'TabFocusedMicMutedFullScreenOffCameraOnSoundOffOffStage';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF = 'TabFocusedMicUnmutedFullScreenOffCameraOnSoundOff';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_ON_STAGE = 'TabFocusedMicUnmutedFullScreenOffCameraOnSoundOffOnStage';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_OFF_STAGE = 'TabFocusedMicUnmutedFullScreenOffCameraOnSoundOffOffStage';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF = 'TabFocusedMicMutedFullScreenCameraOnSoundOff';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_ON_STAGE = 'TabFocusedMicMutedFullScreenCameraOnSoundOffOnStage';
	const USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_OFF_STAGE = 'TabFocusedMicMutedFullScreenCameraOnSoundOffOffStage';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF = 'TabFocusedMicUnmutedFullScreenCameraOnSoundOff';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_ON_STAGE = 'TabFocusedMicUnmutedFullScreenCameraOnSoundOffOnStage';
	const USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_OFF_STAGE = 'TabFocusedMicUnmutedFullScreenCameraOnSoundOffOffStage';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON = 'TabNotFocusedMicMutedFullScreenCameraOffSoundOn';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_ON_STAGE = 'TabNotFocusedMicMutedFullScreenCameraOffSoundOnOnStage';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_OFF_STAGE = 'TabNotFocusedMicMutedFullScreenCameraOffSoundOnOffStage';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON = 'TabNotFocusedMicUnmutedFullScreenCameraOffSoundOn';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_ON_STAGE = 'TabNotFocusedMicUnmutedFullScreenCameraOffSoundOnOnStage';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_OFF_STAGE = 'TabNotFocusedMicUnmutedFullScreenCameraOffSoundOnOffStage';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON = 'TabNotFocusedMicMutedFullScreenOffCameraOffSoundOn';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_ON_STAGE = 'TabNotFocusedMicMutedFullScreenOffCameraOffSoundOnOnStage';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_OFF_STAGE = 'TabNotFocusedMicMutedFullScreenOffCameraOffSoundOnOffStage';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON = 'TabNotFocusedMicUnmutedFullScreenOffCameraOffSoundOn';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_ON_STAGE = 'TabNotFocusedMicUnmutedFullScreenOffCameraOffSoundOnOnStage';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_OFF_STAGE = 'TabNotFocusedMicUnmutedFullScreenOffCameraOffSoundOnOffStage';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF = 'TabNotFocusedMicUnmutedFullScreenCameraOffSoundOff';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_ON_STAGE = 'TabNotFocusedMicUnmutedFullScreenCameraOffSoundOffOnStage';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_OFF_STAGE = 'TabNotFocusedMicUnmutedFullScreenCameraOffSoundOffOffStage';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF = 'TabNotFocusedMicMutedFullScreenCameraOffSoundOff';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_ON_STAGE = 'TabNotFocusedMicMutedFullScreenCameraOffSoundOffOnStage';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_OFF_STAGE = 'TabNotFocusedMicMutedFullScreenCameraOffSoundOffOffStage';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF = 'TabNotFocusedMicUnmutedFullScreenOffCameraOffSoundOff';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_ON_STAGE = 'TabNotFocusedMicUnmutedFullScreenOffCameraOffSoundOffOnStage';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_OFF_STAGE = 'TabNotFocusedMicUnmutedFullScreenOffCameraOffSoundOffOffStage';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF = 'TabNotFocusedMicMutedFullScreenOffCameraOffSoundOff';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_ON_STAGE = 'TabNotFocusedMicMutedFullScreenOffCameraOffSoundOffOnStage';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_OFF_STAGE = 'TabNotFocusedMicMutedFullScreenOffCameraOffSoundOffOffStage';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON = 'TabNotFocusedMicMutedFullScreenCameraOnSoundOn';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_ON_STAGE = 'TabNotFocusedMicMutedFullScreenCameraOnSoundOnOnStage';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_OFF_STAGE = 'TabNotFocusedMicMutedFullScreenCameraOnSoundOnOffStage';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON = 'TabNotFocusedMicUnmutedFullScreenCameraOnSoundOn';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_ON_STAGE = 'TabNotFocusedMicUnmutedFullScreenCameraOnSoundOnOnStage';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_OFF_STAGE = 'TabNotFocusedMicUnmutedFullScreenCameraOnSoundOnOffStage';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON = 'TabNotFocusedMicMutedFullScreenOffCameraOnSoundOn';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_ON_STAGE = 'TabNotFocusedMicMutedFullScreenOffCameraOnSoundOnOnStage';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_OFF_STAGE = 'TabNotFocusedMicMutedFullScreenOffCameraOnSoundOnOffStage';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON = 'TabNotFocusedMicUnmutedFullScreenOffCameraOnSoundOn';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_ON_STAGE = 'TabNotFocusedMicUnmutedFullScreenOffCameraOnSoundOnOnStage';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_OFF_STAGE = 'TabNotFocusedMicUnmutedFullScreenOffCameraOnSoundOnOffStage';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF = 'TabNotFocusedMicUnmutedFullScreenCameraOnSoundOff';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_ON_STAGE = 'TabNotFocusedMicUnmutedFullScreenCameraOnSoundOffOnStage';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_OFF_STAGE = 'TabNotFocusedMicUnmutedFullScreenCameraOnSoundOffOffStage';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF = 'TabNotFocusedMicMutedFullScreenCameraOnSoundOff';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_ON_STAGE = 'TabNotFocusedMicMutedFullScreenCameraOnSoundOffOnStage';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_OFF_STAGE = 'TabNotFocusedMicMutedFullScreenCameraOnSoundOffOffStage';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF = 'TabNotFocusedMicUnmutedFullScreenOffCameraOnSoundOff';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_ON_STAGE = 'TabNotFocusedMicUnmutedFullScreenOffCameraOnSoundOffOnStage';
	const USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_OFF_STAGE = 'TabNotFocusedMicUnmutedFullScreenOffCameraOnSoundOffOffStage';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF = 'TabNotFocusedMicMutedFullScreenOffCameraOnSoundOff';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_ON_STAGE = 'TabNotFocusedMicMutedFullScreenOffCameraOnSoundOffOnStage';
	const USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_OFF_STAGE = 'TabNotFocusedMicMutedFullScreenOffCameraOnSoundOffOffStage';

	protected static $realtime_engagement = array(
		self::USER_SOUND_ON_TAB_FOCUSED,
		self::USER_SOUND_ON_TAB_FOCUSED_FULL_SCREEN,
		self::USER_SOUND_ON_TAB_FOCUSED_FULL_SCREEN_OFF,
	);

	protected static $good_engagement = array(
		self::USER_SOUND_ON_TAB_FOCUSED,
		self::USER_SOUND_ON_TAB_FOCUSED_FULL_SCREEN_OFF,
	);

	protected static $fair_engagement = array(
		self::USER_SOUND_ON_TAB_NOT_FOCUSED,
		self::USER_SOUND_ON_TAB_NOT_FOCUSED_FULL_SCREEN_OFF,
		self::USER_SOUND_ON_TAB_NOT_FOCUSED_FULL_SCREEN,
	);

	protected static $low_engagement = array(
		self::USER_SOUND_OFF_TAB_FOCUSED,
		self::USER_SOUND_OFF_TAB_FOCUSED_FULL_SCREEN_OFF,
		self::USER_SOUND_OFF_TAB_FOCUSED_FULL_SCREEN,
	);

	protected static $non_engagement = array(
		self::USER_SOUND_OFF_TAB_NOT_FOCUSED,
		self::USER_SOUND_OFF_TAB_NOT_FOCUSED_FULL_SCREEN_OFF,
		self::USER_SOUND_OFF_TAB_NOT_FOCUSED_FULL_SCREEN,
	);

	protected static $meeting_engagement = array(
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_ON_STAGE,
	);

	protected static $meeting_non_engagement = array(
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_OFF_STAGE,
	);

	protected static $mic_unmuted_engagement = array(
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_ON_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_OFF_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_OFF_SOUND_ON_OFF_STAGE,
	);

	protected static $camera_on_engagement = array(
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_ON_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_UNMUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_OFF_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_ON_STAGE,
		self::USER_TAB_NOT_FOCUSED_MIC_MUTED_FULL_SCREEN_OFF_CAMERA_ON_SOUND_OFF_OFF_STAGE,
	);

	protected static $attendees_event_types = array(
		self::EVENT_TYPE_VIEW_PERIOD,
		self::EVENT_TYPE_PAGE_LOAD,
		self::EVENT_TYPE_LOG_IN,
		self::EVENT_TYPE_REACTION_CLICKED,
		self::EVENT_TYPE_POLL_ANSWERED,
		self::EVENT_TYPE_NOTIFICATION_SENT,
		self::EVENT_TYPE_NOTIFICATION_BUTTON_CLICKED,
		self::EVENT_TYPE_POLL_LAUNCHED,
		self::EVENT_TYPE_POLL_ENDED,
		self::EVENT_TYPE_POLL_RECEIVED,
		self::EVENT_TYPE_GROUP_MESSAGE_SENT,
		self::EVENT_TYPE_MESSAGE_PINNED,
		self::EVENT_TYPE_MESSAGE_UNPINNED,
		self::EVENT_TYPE_MESSAGE_LIKED,
		self::EVENT_TYPE_USER_BLOCKED,
		self::EVENT_TYPE_PRIVATE_MESSAGE_SENT,
		self::EVENT_TYPE_Q_AND_A_MESSAGE_SENT,
		self::EVENT_TYPE_GROUP_MESSAGE_DELETED,
		self::EVENT_TYPE_PRIVATE_CHAT_CONNECTION_REQUEST_SENT,
		self::EVENT_TYPE_PRIVATE_CHAT_CONNECTION_REQUEST_APPROVED,
		self::EVENT_TYPE_PRIVATE_CHAT_CONNECTION_REQUEST_CANCELED,
	);

	protected static $ve_attended_event_types = array(
		self::EVENT_TYPE_VE_ATTENDED,
		self::EVENT_TYPE_VE_PARTICIPATED,
		self::EVENT_TYPE_VE_PARTICIPATED_POST_EVENT,
	);

	//general values
	const VALUE_UNKNOWN = 'Unknown';
	const VALUE_ZERO = '0';

	protected static $datasources_dimensions = array(
		self::DATASOURCE_HISTORICAL => array(
			self::DIMENSION_EVENT_TYPE => 1,
			self::DIMENSION_PARTNER_ID => 1,
			self::DIMENSION_PARTNER_PARENT_ID => 1,
			self::DIMENSION_KUSER_ID => 1,
			self::DIMENSION_PLAYLIST_ID => 1,
			self::DIMENSION_ENTRY_ID => 1,
			self::DIMENSION_CATEGORIES => 1,
			self::DIMENSION_ENTRY_OWNER_ID => 1,
			self::DIMENSION_ENTRY_CREATOR_ID => 1,
			self::DIMENSION_ENTRY_CREATED_AT => 1,
			self::DIMENSION_MEDIA_TYPE => 1,
			self::DIMENSION_SOURCE_TYPE => 1,
			self::DIMENSION_LOCATION_COUNTRY => 1,
			self::DIMENSION_LOCATION_REGION => 1,
			self::DIMENSION_LOCATION_CITY => 1,
			self::DIMENSION_LOCATION_ISP => 1,
			self::DIMENSION_BROWSER_FAMILY => 1,
			self::DIMENSION_BROWSER => 1,
			self::DIMENSION_OS_FAMILY => 1,
			self::DIMENSION_OS => 1,
			self::DIMENSION_DEVICE => 1,
			self::DIMENSION_DOMAIN => 1,
			self::DIMENSION_URL => 1,
			self::DIMENSION_APPLICATION => 1,
			self::DIMENSION_PLAYBACK_CONTEXT => 1,
			self::DIMENSION_PLAYBACK_TYPE => 1,
			self::DIMENSION_CUSTOM_VAR1 => 1,
			self::DIMENSION_CUSTOM_VAR2 => 1,
			self::DIMENSION_CUSTOM_VAR3 => 1,
			self::DIMENSION_EVENT_PROPERTIES => 1,
			self::DIMENSION_PLAYER_VERSION => 1,
			self::DIMENSION_ROOT_ENTRY_ID => 1,
			self::DIMENSION_NODE_ID => 1,
			self::DIMENSION_EVENT_VAR1 => 1,
			self::DIMENSION_EVENT_VAR2 => 1,
			self::DIMENSION_EVENT_VAR3 => 1,
			self::DIMENSION_APPLICATION_VER => 1,
			self::DIMENSION_USER_ENGAGEMENT => 1,
			self::DIMENSION_POSITION => 1,
			self::DIMENSION_VIRTUAL_EVENT_ID => 1,
			self::DIMENSION_UI_CONF_ID => 1,
			self::DIMENSION_EVENT_SESSION_CONTEXT_ID => 1,
			self::DIMENSION_PLAYBACK_MODE => 1,
		),
		self::DATASOURCE_ENTRY_LIFECYCLE => array(
			self::DIMENSION_EVENT_TYPE => 1,
			self::DIMENSION_PARTNER_ID => 1,
			self::DIMENSION_PARTNER_PARENT_ID => 1,
			self::DIMENSION_CATEGORIES => 1,
			self::DIMENSION_ENTRY_ID => 1,
			self::DIMENSION_KUSER_ID => 1,
			self::DIMENSION_USER_TYPE => 1,
			self::DIMENSION_MEDIA_TYPE => 1,
			self::DIMENSION_SOURCE_TYPE => 1,
		),
		self::DATASOURCE_STORAGE_USAGE => array(
			self::DIMENSION_EVENT_TYPE => 1,
			self::DIMENSION_PARTNER_ID => 1,
			self::DIMENSION_PARTNER_PARENT_ID => 1,
			self::DIMENSION_ENTRY_ID => 1,
			self::DIMENSION_CATEGORIES => 1,
			self::DIMENSION_KUSER_ID => 1,
			self::DIMENSION_MEDIA_TYPE => 1,
			self::DIMENSION_SOURCE_TYPE => 1,
			self::DIMENSION_VIDEO_CODEC => 1,
		),
		self::DATASOURCE_BANDWIDTH_USAGE => array(
			self::DIMENSION_PARTNER_ID => 1,
			self::DIMENSION_PARTNER_PARENT_ID => 1,
			self::DIMENSION_ENTRY_ID => 1,
			self::DIMENSION_CATEGORIES => 1,
			self::DIMENSION_ENTRY_OWNER_ID => 1,
			self::DIMENSION_MEDIA_TYPE => 1,
			self::DIMENSION_SOURCE_TYPE => 1,
			self::DIMENSION_LOCATION_COUNTRY => 1,
			self::DIMENSION_LOCATION_REGION => 1,
			self::DIMENSION_LOCATION_CITY => 1,
			self::DIMENSION_LOCATION_ISP => 1,
			self::DIMENSION_BROWSER_FAMILY => 1,
			self::DIMENSION_BROWSER => 1,
			self::DIMENSION_OS_FAMILY => 1,
			self::DIMENSION_OS => 1,
			self::DIMENSION_DEVICE => 1,
			self::DIMENSION_PLAYBACK_TYPE => 1,
			self::DIMENSION_STATUS => 1,
			self::DIMENSION_TYPE => 1,
			self::DIMENSION_VIDEO_CODEC => 1,
		),
		self::DATASOURCE_TRANSCODING_USAGE => array(
			self::DIMENSION_PARTNER_ID => 1,
			self::DIMENSION_PARTNER_PARENT_ID => 1,
			self::DIMENSION_ENTRY_ID => 1,
			self::DIMENSION_CATEGORIES => 1,
			self::DIMENSION_KUSER_ID => 1,
			self::DIMENSION_MEDIA_TYPE => 1,
			self::DIMENSION_SOURCE_TYPE => 1,
			self::DIMENSION_STATUS => 1,
			self::DIMENSION_FLAVOR_PARAMS_ID => 1,
			self::DIMENSION_VIDEO_CODEC => 1,
		),
		self::DATASOURCE_USER_LIFECYCLE => array(
			self::DIMENSION_EVENT_TYPE => 1,
			self::DIMENSION_PARTNER_ID => 1,
			self::DIMENSION_PARTNER_PARENT_ID => 1,
			self::DIMENSION_KUSER_ID => 1,
			self::DIMENSION_USER_TYPE => 1,
		),
		self::DATASOURCE_API_USAGE => array(
			self::DIMENSION_PARTNER_ID => 1,
			self::DIMENSION_PARTNER_CRM_ID => 1,
			self::DIMENSION_PARTNER_PARENT_ID => 1,
			self::DIMENSION_APPLICATION => 1,
			self::DIMENSION_DOMAIN => 1,
			self::DIMENSION_LOCATION_COUNTRY => 1,
			self::DIMENSION_LOCATION_REGION => 1,
			self::DIMENSION_LOCATION_CITY => 1,
			self::DIMENSION_LOCATION_ISP => 1,
		),
		self::DATASOURCE_REACH_USAGE => array(
			self::DIMENSION_PARTNER_ID => 1,
			self::DIMENSION_PARTNER_PARENT_ID => 1,
			self::DIMENSION_ENTRY_ID => 1,
			self::DIMENSION_CATEGORIES => 1,
			self::DIMENSION_ENTRY_OWNER_ID => 1,
			self::DIMENSION_MEDIA_TYPE => 1,
			self::DIMENSION_SOURCE_TYPE => 1,
			self::DIMENSION_REACH_PROFILE_ID => 1,
			self::DIMENSION_STATUS => 1,
			self::DIMENSION_KUSER_ID => 1,
			self::DIMENSION_SERVICE_TYPE => 1,
			self::DIMENSION_SERVICE_FEATURE => 1,
			self::DIMENSION_TURNAROUND_TIME  => 1,
		),
		self::DATASOURCE_REALTIME => array(
			self::DIMENSION_EVENT_TYPE => 1,
			self::DIMENSION_PARTNER_ID => 1,
			self::DIMENSION_PARTNER_PARENT_ID => 1,
			self::DIMENSION_KUSER_ID => 1,
			self::DIMENSION_ENTRY_ID => 1,
			self::DIMENSION_CATEGORIES => 1,
			self::DIMENSION_ENTRY_OWNER_ID => 1,
			self::DIMENSION_MEDIA_TYPE => 1,
			self::DIMENSION_SOURCE_TYPE => 1,
			self::DIMENSION_LOCATION_COUNTRY => 1,
			self::DIMENSION_LOCATION_REGION => 1,
			self::DIMENSION_LOCATION_CITY => 1,
			self::DIMENSION_LOCATION_ISP => 1,
			self::DIMENSION_BROWSER_FAMILY => 1,
			self::DIMENSION_BROWSER => 1,
			self::DIMENSION_OS_FAMILY => 1,
			self::DIMENSION_OS => 1,
			self::DIMENSION_DEVICE => 1,
			self::DIMENSION_DOMAIN => 1,
			self::DIMENSION_URL => 1,
			self::DIMENSION_APPLICATION => 1,
			self::DIMENSION_PLAYBACK_CONTEXT => 1,
			self::DIMENSION_PLAYBACK_TYPE => 1,
			self::DIMENSION_SERVER_NODE_IDS => 1,
			self::DIMENSION_CUSTOM_VAR1 => 1,
			self::DIMENSION_CUSTOM_VAR2 => 1,
			self::DIMENSION_CUSTOM_VAR3 => 1,
			self::DIMENSION_EVENT_PROPERTIES => 1,
			self::DIMENSION_PLAYER_VERSION => 1,
			self::DIMENSION_POSITION => 1,
			self::DIMENSION_EVENT_VAR1 => 1,
			self::DIMENSION_APPLICATION_VER => 1,
			self::DIMENSION_VIRTUAL_EVENT_ID => 1,
			self::DIMENSION_EVENT_SESSION_CONTEXT_ID => 1,
			self::DIMENSION_PLAYBACK_MODE => 1,
		),
		self::DATASOURCE_VE_REGISTRATION => array(
			self::DIMENSION_EVENT_TYPE => 1,
			self::DIMENSION_PARTNER_ID => 1,
			self::DIMENSION_PARTNER_PARENT_ID => 1,
			self::DIMENSION_KUSER_ID => 1,
			self::DIMENSION_VIRTUAL_EVENT_ID => 1,
			self::DIMENSION_LOCATION_COUNTRY => 1,
			self::DIMENSION_BROWSER_FAMILY => 1,
			self::DIMENSION_BROWSER => 1,
			self::DIMENSION_OS_FAMILY => 1,
			self::DIMENSION_OS => 1,
			self::DIMENSION_DEVICE => 1,
			self::DIMENSION_ORIGIN => 1,
			self::DIMENSION_ROLE => 1,
			self::DIMENSION_INDUSTRY => 1,
			self::DIMENSION_COMPANY => 1,
		),
		self::DATASOURCE_MEETING_HISTORICAL => array(
			self::DIMENSION_EVENT_TYPE => 1,
			self::DIMENSION_PARTNER_ID => 1,
			self::DIMENSION_PARTNER_PARENT_ID => 1,
			self::DIMENSION_ENTRY_ID => 1,
			self::DIMENSION_KUSER_ID => 1,
			self::DIMENSION_VIRTUAL_EVENT_ID => 1,
			self::DIMENSION_LOCATION_COUNTRY => 1,
			self::DIMENSION_LOCATION_REGION => 1,
			self::DIMENSION_LOCATION_CITY => 1,
			self::DIMENSION_LOCATION_ISP => 1,
			self::DIMENSION_BROWSER_FAMILY => 1,
			self::DIMENSION_BROWSER => 1,
			self::DIMENSION_OS_FAMILY => 1,
			self::DIMENSION_OS => 1,
			self::DIMENSION_DEVICE => 1,
			self::DIMENSION_USER_ENGAGEMENT => 1,
			self::DIMENSION_CUE_POINT_ID => 1,
			self::DIMENSION_EVENT_SESSION_CONTEXT_ID => 1,
			self::DIMENSION_POSITION => 1,
		),
		self::DATASOURCE_MEETING_REALTIME => array(
			self::DIMENSION_EVENT_TYPE => 1,
			self::DIMENSION_PARTNER_ID => 1,
			self::DIMENSION_PARTNER_PARENT_ID => 1,
			self::DIMENSION_ENTRY_ID => 1,
			self::DIMENSION_KUSER_ID => 1,
			self::DIMENSION_LOCATION_COUNTRY => 1,
			self::DIMENSION_LOCATION_REGION => 1,
			self::DIMENSION_LOCATION_CITY => 1,
			self::DIMENSION_LOCATION_ISP => 1,
			self::DIMENSION_BROWSER_FAMILY => 1,
			self::DIMENSION_BROWSER => 1,
			self::DIMENSION_OS_FAMILY => 1,
			self::DIMENSION_OS => 1,
			self::DIMENSION_DEVICE => 1,
			self::DIMENSION_USER_ENGAGEMENT => 1,
			self::DIMENSION_CUE_POINT_ID => 1,
			self::DIMENSION_EVENT_SESSION_CONTEXT_ID => 1,
		),
		self::DATASOURCE_CNC_EVENTS => array(
			self::DIMENSION_EVENT_TYPE => 1,
			self::DIMENSION_PARTNER_ID => 1,
			self::DIMENSION_PARTNER_PARENT_ID => 1,
			self::DIMENSION_VIRTUAL_EVENT_ID => 1,
			self::DIMENSION_CONTEXT_ID => 1,
			self::DIMENSION_KUSER_ID => 1,
			self::DIMENSION_LOCATION_COUNTRY => 1,
			self::DIMENSION_LOCATION_REGION => 1,
			self::DIMENSION_LOCATION_CITY => 1,
			self::DIMENSION_BROWSER_FAMILY => 1,
			self::DIMENSION_BROWSER => 1,
			self::DIMENSION_OS_FAMILY => 1,
			self::DIMENSION_OS => 1,
			self::DIMENSION_DEVICE => 1,
			self::DIMENSION_EVENT_VAR1 => 1,
			self::DIMENSION_EVENT_VAR2 => 1,
			self::DIMENSION_EVENT_VAR3 => 1,
			self::DIMENSION_EVENT_VAR4 => 1,
			self::DIMENSION_EVENT_SESSION_CONTEXT_ID => 1,
			self::DIMENSION_POSITION => 1,
		),
		self::DATASOURCE_APPLICATION_EVENTS => array(
			self::DIMENSION_EVENT_TYPE => 1,
			self::DIMENSION_PARTNER_ID => 1,
			self::DIMENSION_PARTNER_PARENT_ID => 1,
			self::DIMENSION_ENTRY_ID => 1,
			self::DIMENSION_KUSER_ID => 1,
			self::DIMENSION_LOCATION_COUNTRY => 1,
			self::DIMENSION_LOCATION_REGION => 1,
			self::DIMENSION_LOCATION_CITY => 1,
			self::DIMENSION_BROWSER_FAMILY => 1,
			self::DIMENSION_BROWSER => 1,
			self::DIMENSION_OS_FAMILY => 1,
			self::DIMENSION_OS => 1,
			self::DIMENSION_DEVICE => 1,
			self::DIMENSION_EVENT_VAR1 => 1,
			self::DIMENSION_EVENT_VAR2 => 1,
			self::DIMENSION_EVENT_VAR3 => 1,
			self::DIMENSION_EVENT_VAR4 => 1,
			self::DIMENSION_VIRTUAL_EVENT_ID => 1,
		)
	);

	protected static $datasources_hash_dimensions = array(
		self::DATASOURCE_HISTORICAL => array(
			self::DIMENSION_KUSER_ID => 1,
		),
		self::DATASOURCE_REALTIME => array(
			self::DIMENSION_KUSER_ID => 1,
		),
		self::DATASOURCE_MEETING_HISTORICAL => array(
			self::DIMENSION_KUSER_ID => 1,
		),
		self::DATASOURCE_MEETING_REALTIME => array(
			self::DIMENSION_KUSER_ID => 1,
		),
	);

	protected static $sourceFromAdminTag = array(
		'kalturaclassroom' => 'Classroom Capture',
		'kalturacapture' => 'Kaltura Capture',
		'videomessage' => 'Kaltura Pitch',
		'kms-webcast-event' => 'Kaltura Webcast',
		'raptentry' => 'Interactive Video',
		'webexentry' => 'Webex',
		'zoomentry' => 'Zoom',
		'expressrecorder' => 'Express Recorder',
		'kmsnativeandroid' => 'KMS GO Android',
		'kmsnativeios' => 'KMS GO iOS',
		'kalturameeting' => 'Kaltura Meeting',
		'onedrive' => 'OneDrive',
		'webexapi' => 'Webex API',
		'teamsentry' => 'Teams Entry',
	);

	protected static $sourceTypes = array(
		0 => 'Other',
		1 => 'Upload',
		2 => 'Webcam',
		3 => 'Flickr',
		4 => 'Youtube',
		5 => 'Url',
		6 => 'Text',
		7 => 'Myspace',
		8 => 'Photobucket',
		9 => 'Jamendo',
		10 => 'Ccmixter',
		11 => 'Nypl',
		12 => 'Current',
		13 => 'Commons',
		20 => 'Kaltura',
		21 => 'Kaltura user clips',
		22 => 'Archive org',
		23 => 'Kaltura partner',
		24 => 'Metacafe',
		29 => 'Live stream akamai legacy',
		30 => 'Live stream manual',
		31 => 'Live stream akamai universal',
		32 => 'Live stream',
		33 => 'Live channel',
		34 => 'Recorded live stream',
		35 => 'Clip',
		36 => 'Recorded live stream',
		37 => 'Classroom Capture',
	);

	protected static $externalSources = array(
		'YouTube' => 'External Youtube',
	);

	public static function getEntrySourceType($sourceType, $adminTags, $customData)
	{
		// check for specific admin tags
		$adminTags = !is_null($adminTags) ? explode(',', strtolower($adminTags)) : array();
		foreach ($adminTags as $adminTag)
		{
			$adminTag = trim($adminTag);
			if (isset(self::$sourceFromAdminTag[$adminTag]))
			{
				return self::$sourceFromAdminTag[$adminTag];
			}
		}

		// check for external source
		if (!is_null($customData))
		{
			$externalSource = self::getExternalSourceType($customData);
			if (isset($externalSource) && isset(self::$externalSources[$externalSource]))
			{
				return self::$externalSources[$externalSource];
			}
		}

		// use the source type
		return self::$sourceTypes[$sourceType];
	}

	protected static function getExternalSourceType($customData)
	{
		$pattern = '/"externalSource";s:\d+:"(\w+)";/';
		if (preg_match($pattern, $customData, $matches))
		{
			return $matches[1];
		}

		return null;
	}

	public static function isPartnerAllowed($partnerId, $serviceType) {
	    if (kConf::hasParam(self::DRUID_URL)) {
		if (!kConf::hasParam($serviceType))
			return true;
		return !in_array($partnerId, kConf::get($serviceType));
	    }
	    return false;
	}

	public static function getCoordinatesKey($items)
	{
		$key = implode('_', $items);
		return 'coord_' . preg_replace('/[^a-z0-9_]/', '_', strtolower($key));
	}

	public static function parseCoordinates($coords)
	{
		return array_map('floatval', explode('/', $coords));
	}

	public static function getCoordinatesForKeys($keys)
	{
		$cache = kCacheManager::getSingleLayerCache(kCacheManager::CACHE_TYPE_GEO_COORDINATES);
		if (!$cache)
		{
			return array();
		}

		return $cache->multiGet($keys);
	}

	protected static function roundUpToMultiple($num, $mult)
	{
		$rem = $num % $mult;
		if (!$rem)
		{
			return $num;
		}

		return $num - $rem + $mult;
	}

}
