<?php

class kKavaCountryCodes
{
	public static $shortToLong = array(
		'AD' => 'Andorra',
		'AE' => 'United Arab Emirates',
		'AF' => 'Afghanistan',
		'AG' => 'Antigua and Barbuda',
		'AI' => 'Anguilla',
		'AL' => 'Albania',
		'AM' => 'Armenia',
		'AO' => 'Angola',
		'AQ' => 'Antarctica',
		'AR' => 'Argentina',
		'AS' => 'American Samoa',
		'AT' => 'Austria',
		'AU' => 'Australia',
		'AW' => 'Aruba',
		'AX' => 'Aland Islands',
		'AZ' => 'Azerbaijan',
		'BA' => 'Bosnia and Herzegovina',
		'BB' => 'Barbados',
		'BD' => 'Bangladesh',
		'BE' => 'Belgium',
		'BF' => 'Burkina Faso',
		'BG' => 'Bulgaria',
		'BH' => 'Bahrain',
		'BI' => 'Burundi',
		'BJ' => 'Benin',
		'BL' => 'Saint Barthelemy',
		'BM' => 'Bermuda',
		'BN' => 'Brunei Darussalam',
		'BO' => 'Bolivia, Plurinational State of',
		'BQ' => 'Bonaire, Sint Eustatius and Saba',
		'BR' => 'Brazil',
		'BS' => 'Bahamas',
		'BT' => 'Bhutan',
		'BV' => 'Bouvet Island',
		'BW' => 'Botswana',
		'BY' => 'Belarus',
		'BZ' => 'Belize',
		'CA' => 'Canada',
		'CC' => 'Cocos (Keeling) Islands',
		'CD' => 'Congo, The Democratic Republic of The',
		'CF' => 'Central African Republic',
		'CG' => 'Congo',
		'CH' => 'Switzerland',
		'CI' => 'Cote D\'ivoire',
		'CK' => 'Cook Islands',
		'CL' => 'Chile',
		'CM' => 'Cameroon',
		'CN' => 'China',
		'CO' => 'Colombia',
		'CR' => 'Costa Rica',
		'CU' => 'Cuba',
		'CV' => 'Cabo Verde',
		'CW' => 'Curacao',
		'CX' => 'Christmas Island',
		'CY' => 'Cyprus',
		'CZ' => 'Czech Republic',
		'DE' => 'Germany',
		'DJ' => 'Djibouti',
		'DK' => 'Denmark',
		'DM' => 'Dominica',
		'DO' => 'Dominican Republic',
		'DZ' => 'Algeria',
		'EC' => 'Ecuador',
		'EE' => 'Estonia',
		'EG' => 'Egypt',
		'EH' => 'Western Sahara',
		'ER' => 'Eritrea',
		'ES' => 'Spain',
		'ET' => 'Ethiopia',
		'FI' => 'Finland',
		'FJ' => 'Fiji',
		'FK' => 'Falkland Islands (Malvinas)',
		'FM' => 'Micronesia, Federated States of',
		'FO' => 'Faroe Islands',
		'FR' => 'France',
		'GA' => 'Gabon',
		'GB' => 'United Kingdom',
		'GD' => 'Grenada',
		'GE' => 'Georgia',
		'GF' => 'French Guiana',
		'GG' => 'Guernsey',
		'GH' => 'Ghana',
		'GI' => 'Gibraltar',
		'GL' => 'Greenland',
		'GM' => 'Gambia',
		'GN' => 'Guinea',
		'GP' => 'Guadeloupe',
		'GQ' => 'Equatorial Guinea',
		'GR' => 'Greece',
		'GS' => 'South Georgia and The South Sandwich Islands',
		'GT' => 'Guatemala',
		'GU' => 'Guam',
		'GW' => 'Guinea-Bissau',
		'GY' => 'Guyana',
		'HK' => 'Hong Kong',
		'HM' => 'Heard Island and Mcdonald Islands',
		'HN' => 'Honduras',
		'HR' => 'Croatia',
		'HT' => 'Haiti',
		'HU' => 'Hungary',
		'ID' => 'Indonesia',
		'IE' => 'Ireland',
		'IL' => 'Israel',
		'IM' => 'Isle of Man',
		'IN' => 'India',
		'IO' => 'British Indian Ocean Territory',
		'IQ' => 'Iraq',
		'IR' => 'Iran, Islamic Republic of',
		'IS' => 'Iceland',
		'IT' => 'Italy',
		'JE' => 'Jersey',
		'JM' => 'Jamaica',
		'JO' => 'Jordan',
		'JP' => 'Japan',
		'KE' => 'Kenya',
		'KG' => 'Kyrgyzstan',
		'KH' => 'Cambodia',
		'KI' => 'Kiribati',
		'KM' => 'Comoros',
		'KN' => 'Saint Kitts and Nevis',
		'KP' => 'Korea, Democratic People\'s Republic of',
		'KR' => 'Korea, Republic of',
		'KW' => 'Kuwait',
		'KY' => 'Cayman Islands',
		'KZ' => 'Kazakhstan',
		'LA' => 'Lao People\'s Democratic Republic',
		'LB' => 'Lebanon',
		'LC' => 'Saint Lucia',
		'LI' => 'Liechtenstein',
		'LK' => 'Sri Lanka',
		'LR' => 'Liberia',
		'LS' => 'Lesotho',
		'LT' => 'Lithuania',
		'LU' => 'Luxembourg',
		'LV' => 'Latvia',
		'LY' => 'Libya',
		'MA' => 'Morocco',
		'MC' => 'Monaco',
		'MD' => 'Moldova, Republic of',
		'ME' => 'Montenegro',
		'MF' => 'Saint Martin (French Part)',
		'MG' => 'Madagascar',
		'MH' => 'Marshall Islands',
		'MK' => 'Macedonia, The Former Yugoslav Republic of',
		'ML' => 'Mali',
		'MM' => 'Myanmar',
		'MN' => 'Mongolia',
		'MO' => 'Macao',
		'MP' => 'Northern Mariana Islands',
		'MQ' => 'Martinique',
		'MR' => 'Mauritania',
		'MS' => 'Montserrat',
		'MT' => 'Malta',
		'MU' => 'Mauritius',
		'MV' => 'Maldives',
		'MW' => 'Malawi',
		'MX' => 'Mexico',
		'MY' => 'Malaysia',
		'MZ' => 'Mozambique',
		'NA' => 'Namibia',
		'NC' => 'New Caledonia',
		'NE' => 'Niger',
		'NF' => 'Norfolk Island',
		'NG' => 'Nigeria',
		'NI' => 'Nicaragua',
		'NL' => 'Netherlands',
		'NO' => 'Norway',
		'NP' => 'Nepal',
		'NR' => 'Nauru',
		'NU' => 'Niue',
		'NZ' => 'New Zealand',
		'OM' => 'Oman',
		'PA' => 'Panama',
		'PE' => 'Peru',
		'PF' => 'French Polynesia',
		'PG' => 'Papua New Guinea',
		'PH' => 'Philippines',
		'PK' => 'Pakistan',
		'PL' => 'Poland',
		'PM' => 'Saint Pierre and Miquelon',
		'PN' => 'Pitcairn',
		'PR' => 'Puerto Rico',
		'PS' => 'Palestine, State of',
		'PT' => 'Portugal',
		'PW' => 'Palau',
		'PY' => 'Paraguay',
		'QA' => 'Qatar',
		'RE' => 'Reunion',
		'RO' => 'Romania',
		'RS' => 'Serbia',
		'RU' => 'Russian Federation',
		'RW' => 'Rwanda',
		'SA' => 'Saudi Arabia',
		'SB' => 'Solomon Islands',
		'SC' => 'Seychelles',
		'SD' => 'Sudan',
		'SE' => 'Sweden',
		'SG' => 'Singapore',
		'SH' => 'Saint Helena, Ascension and Tristan Da Cunha',
		'SI' => 'Slovenia',
		'SJ' => 'Svalbard and Jan Mayen',
		'SK' => 'Slovakia',
		'SL' => 'Sierra Leone',
		'SM' => 'San Marino',
		'SN' => 'Senegal',
		'SO' => 'Somalia',
		'SR' => 'Suriname',
		'SS' => 'South Sudan',
		'ST' => 'Sao Tome and Principe',
		'SV' => 'El Salvador',
		'SX' => 'Sint Maarten (Dutch Part)',
		'SY' => 'Syrian Arab Republic',
		'SZ' => 'Swaziland',
		'TC' => 'Turks and Caicos Islands',
		'TD' => 'Chad',
		'TF' => 'French Southern Territories',
		'TG' => 'Togo',
		'TH' => 'Thailand',
		'TJ' => 'Tajikistan',
		'TK' => 'Tokelau',
		'TL' => 'Timor-Leste',
		'TM' => 'Turkmenistan',
		'TN' => 'Tunisia',
		'TO' => 'Tonga',
		'TR' => 'Turkey',
		'TT' => 'Trinidad and Tobago',
		'TV' => 'Tuvalu',
		'TW' => 'Taiwan, Province of China',
		'TZ' => 'Tanzania, United Republic of',
		'UA' => 'Ukraine',
		'UG' => 'Uganda',
		'UK' => 'United Kingdom',
		'UM' => 'United States Minor Outlying Islands',
		'US' => 'United States',
		'UY' => 'Uruguay',
		'UZ' => 'Uzbekistan',
		'VA' => 'Holy See',
		'VC' => 'Saint Vincent and The Grenadines',
		'VE' => 'Venezuela, Bolivarian Republic of',
		'VG' => 'Virgin Islands, British',
		'VI' => 'Virgin Islands, U.S.',
		'VN' => 'Viet Nam',
		'VU' => 'Vanuatu',
		'WF' => 'Wallis and Futuna',
		'WS' => 'Samoa',
		'YE' => 'Yemen',
		'YT' => 'Mayotte',
		'ZA' => 'South Africa',
		'ZM' => 'Zambia',
		'ZW' => 'Zimbabwe',
	);
	
	public static $longToShort = array(
		'Andorra' => 'AD',
		'United Arab Emirates' => 'AE',
		'Afghanistan' => 'AF',
		'Antigua and Barbuda' => 'AG',
		'Anguilla' => 'AI',
		'Albania' => 'AL',
		'Armenia' => 'AM',
		'Angola' => 'AO',
		'Antarctica' => 'AQ',
		'Argentina' => 'AR',
		'American Samoa' => 'AS',
		'Austria' => 'AT',
		'Australia' => 'AU',
		'Aruba' => 'AW',
		'Aland Islands' => 'AX',
		'Azerbaijan' => 'AZ',
		'Bosnia and Herzegovina' => 'BA',
		'Barbados' => 'BB',
		'Bangladesh' => 'BD',
		'Belgium' => 'BE',
		'Burkina Faso' => 'BF',
		'Bulgaria' => 'BG',
		'Bahrain' => 'BH',
		'Burundi' => 'BI',
		'Benin' => 'BJ',
		'Saint Barthelemy' => 'BL',
		'Bermuda' => 'BM',
		'Brunei Darussalam' => 'BN',
		'Bolivia, Plurinational State of' => 'BO',
		'Bonaire, Sint Eustatius and Saba' => 'BQ',
		'Brazil' => 'BR',
		'Bahamas' => 'BS',
		'Bhutan' => 'BT',
		'Bouvet Island' => 'BV',
		'Botswana' => 'BW',
		'Belarus' => 'BY',
		'Belize' => 'BZ',
		'Canada' => 'CA',
		'Cocos (Keeling) Islands' => 'CC',
		'Congo, The Democratic Republic of The' => 'CD',
		'Central African Republic' => 'CF',
		'Congo' => 'CG',
		'Switzerland' => 'CH',
		'Cote D\'ivoire' => 'CI',
		'Cook Islands' => 'CK',
		'Chile' => 'CL',
		'Cameroon' => 'CM',
		'China' => 'CN',
		'Colombia' => 'CO',
		'Costa Rica' => 'CR',
		'Cuba' => 'CU',
		'Cabo Verde' => 'CV',
		'Curacao' => 'CW',
		'Christmas Island' => 'CX',
		'Cyprus' => 'CY',
		'Czech Republic' => 'CZ',
		'Germany' => 'DE',
		'Djibouti' => 'DJ',
		'Denmark' => 'DK',
		'Dominica' => 'DM',
		'Dominican Republic' => 'DO',
		'Algeria' => 'DZ',
		'Ecuador' => 'EC',
		'Estonia' => 'EE',
		'Egypt' => 'EG',
		'Western Sahara' => 'EH',
		'Eritrea' => 'ER',
		'Spain' => 'ES',
		'Ethiopia' => 'ET',
		'Finland' => 'FI',
		'Fiji' => 'FJ',
		'Falkland Islands (Malvinas)' => 'FK',
		'Micronesia, Federated States of' => 'FM',
		'Faroe Islands' => 'FO',
		'France' => 'FR',
		'Gabon' => 'GA',
		'United Kingdom' => 'UK',
		'Grenada' => 'GD',
		'Georgia' => 'GE',
		'French Guiana' => 'GF',
		'Guernsey' => 'GG',
		'Ghana' => 'GH',
		'Gibraltar' => 'GI',
		'Greenland' => 'GL',
		'Gambia' => 'GM',
		'Guinea' => 'GN',
		'Guadeloupe' => 'GP',
		'Equatorial Guinea' => 'GQ',
		'Greece' => 'GR',
		'South Georgia and The South Sandwich Islands' => 'GS',
		'Guatemala' => 'GT',
		'Guam' => 'GU',
		'Guinea-Bissau' => 'GW',
		'Guyana' => 'GY',
		'Hong Kong' => 'HK',
		'Heard Island and Mcdonald Islands' => 'HM',
		'Honduras' => 'HN',
		'Croatia' => 'HR',
		'Haiti' => 'HT',
		'Hungary' => 'HU',
		'Indonesia' => 'ID',
		'Ireland' => 'IE',
		'Israel' => 'IL',
		'Isle of Man' => 'IM',
		'India' => 'IN',
		'British Indian Ocean Territory' => 'IO',
		'Iraq' => 'IQ',
		'Iran, Islamic Republic of' => 'IR',
		'Iceland' => 'IS',
		'Italy' => 'IT',
		'Jersey' => 'JE',
		'Jamaica' => 'JM',
		'Jordan' => 'JO',
		'Japan' => 'JP',
		'Kenya' => 'KE',
		'Kyrgyzstan' => 'KG',
		'Cambodia' => 'KH',
		'Kiribati' => 'KI',
		'Comoros' => 'KM',
		'Saint Kitts and Nevis' => 'KN',
		'Korea, Democratic People\'s Republic of' => 'KP',
		'Korea, Republic of' => 'KR',
		'Kuwait' => 'KW',
		'Cayman Islands' => 'KY',
		'Kazakhstan' => 'KZ',
		'Lao People\'s Democratic Republic' => 'LA',
		'Lebanon' => 'LB',
		'Saint Lucia' => 'LC',
		'Liechtenstein' => 'LI',
		'Sri Lanka' => 'LK',
		'Liberia' => 'LR',
		'Lesotho' => 'LS',
		'Lithuania' => 'LT',
		'Luxembourg' => 'LU',
		'Latvia' => 'LV',
		'Libya' => 'LY',
		'Morocco' => 'MA',
		'Monaco' => 'MC',
		'Moldova, Republic of' => 'MD',
		'Montenegro' => 'ME',
		'Saint Martin (French Part)' => 'MF',
		'Madagascar' => 'MG',
		'Marshall Islands' => 'MH',
		'Macedonia, The Former Yugoslav Republic of' => 'MK',
		'Mali' => 'ML',
		'Myanmar' => 'MM',
		'Mongolia' => 'MN',
		'Macao' => 'MO',
		'Northern Mariana Islands' => 'MP',
		'Martinique' => 'MQ',
		'Mauritania' => 'MR',
		'Montserrat' => 'MS',
		'Malta' => 'MT',
		'Mauritius' => 'MU',
		'Maldives' => 'MV',
		'Malawi' => 'MW',
		'Mexico' => 'MX',
		'Malaysia' => 'MY',
		'Mozambique' => 'MZ',
		'Namibia' => 'NA',
		'New Caledonia' => 'NC',
		'Niger' => 'NE',
		'Norfolk Island' => 'NF',
		'Nigeria' => 'NG',
		'Nicaragua' => 'NI',
		'Netherlands' => 'NL',
		'Norway' => 'NO',
		'Nepal' => 'NP',
		'Nauru' => 'NR',
		'Niue' => 'NU',
		'New Zealand' => 'NZ',
		'Oman' => 'OM',
		'Panama' => 'PA',
		'Peru' => 'PE',
		'French Polynesia' => 'PF',
		'Papua New Guinea' => 'PG',
		'Philippines' => 'PH',
		'Pakistan' => 'PK',
		'Poland' => 'PL',
		'Saint Pierre and Miquelon' => 'PM',
		'Pitcairn' => 'PN',
		'Puerto Rico' => 'PR',
		'Palestine, State of' => 'PS',
		'Portugal' => 'PT',
		'Palau' => 'PW',
		'Paraguay' => 'PY',
		'Qatar' => 'QA',
		'Reunion' => 'RE',
		'Romania' => 'RO',
		'Serbia' => 'RS',
		'Russian Federation' => 'RU',
		'Rwanda' => 'RW',
		'Saudi Arabia' => 'SA',
		'Solomon Islands' => 'SB',
		'Seychelles' => 'SC',
		'Sudan' => 'SD',
		'Sweden' => 'SE',
		'Singapore' => 'SG',
		'Saint Helena, Ascension and Tristan Da Cunha' => 'SH',
		'Slovenia' => 'SI',
		'Svalbard and Jan Mayen' => 'SJ',
		'Slovakia' => 'SK',
		'Sierra Leone' => 'SL',
		'San Marino' => 'SM',
		'Senegal' => 'SN',
		'Somalia' => 'SO',
		'Suriname' => 'SR',
		'South Sudan' => 'SS',
		'Sao Tome and Principe' => 'ST',
		'El Salvador' => 'SV',
		'Sint Maarten (Dutch Part)' => 'SX',
		'Syrian Arab Republic' => 'SY',
		'Swaziland' => 'SZ',
		'Turks and Caicos Islands' => 'TC',
		'Chad' => 'TD',
		'French Southern Territories' => 'TF',
		'Togo' => 'TG',
		'Thailand' => 'TH',
		'Tajikistan' => 'TJ',
		'Tokelau' => 'TK',
		'Timor-Leste' => 'TL',
		'Turkmenistan' => 'TM',
		'Tunisia' => 'TN',
		'Tonga' => 'TO',
		'Turkey' => 'TR',
		'Trinidad and Tobago' => 'TT',
		'Tuvalu' => 'TV',
		'Taiwan, Province of China' => 'TW',
		'Tanzania, United Republic of' => 'TZ',
		'Ukraine' => 'UA',
		'Uganda' => 'UG',
		'United States Minor Outlying Islands' => 'UM',
		'United States' => 'US',
		'Uruguay' => 'UY',
		'Uzbekistan' => 'UZ',
		'Holy See' => 'VA',
		'Saint Vincent and The Grenadines' => 'VC',
		'Venezuela, Bolivarian Republic of' => 'VE',
		'Virgin Islands, British' => 'VG',
		'Virgin Islands, U.S.' => 'VI',
		'Viet Nam' => 'VN',
		'Vanuatu' => 'VU',
		'Wallis and Futuna' => 'WF',
		'Samoa' => 'WS',
		'Yemen' => 'YE',
		'Mayotte' => 'YT',
		'South Africa' => 'ZA',
		'Zambia' => 'ZM',
		'Zimbabwe' => 'ZW',
	);

	public static $longNameMap = array(
		'Taiwan, Province of China' => 'Taiwan',
	);

	public static function toShortName($name)
	{
		return self::$longToShort[$name];
	}

	public static function toLongName($name)
	{
		return self::$shortToLong[$name];
	}

	public static function toLongMappingName($name)
	{
		return isset(self::$longNameMap[$name]) ? self::$longNameMap[$name] : $name;
	}
}