<?php
/** 
 * @package server-infra
 * @subpackage request
 */
class kGeoUtils 
{
	private static $countryRegion = array(
		"AG" => "NorthAmerica",
		"AI" => "NorthAmerica",
		"AW" => "NorthAmerica",
		"BB" => "NorthAmerica",
		"BL" => "NorthAmerica",
		"BM" => "NorthAmerica",
		"BQ" => "NorthAmerica",
		"BS" => "NorthAmerica",
		"BZ" => "NorthAmerica",
		"CA" => "NorthAmerica",
		"CR" => "NorthAmerica",
		"CU" => "NorthAmerica",
		"CW" => "NorthAmerica",
		"DM" => "NorthAmerica",
		"DO" => "NorthAmerica",
		"GD" => "NorthAmerica",
		"GL" => "NorthAmerica",
		"GP" => "NorthAmerica",
		"GT" => "NorthAmerica",
		"HN" => "NorthAmerica",
		"HT" => "NorthAmerica",
		"JM" => "NorthAmerica",
		"KN" => "NorthAmerica",
		"KY" => "NorthAmerica",
		"LC" => "NorthAmerica",
		"MF" => "NorthAmerica",
		"MQ" => "NorthAmerica",
		"MS" => "NorthAmerica",
		"MX" => "NorthAmerica",
		"NI" => "NorthAmerica",
		"PA" => "NorthAmerica",
		"PM" => "NorthAmerica",
		"PR" => "NorthAmerica",
		"SV" => "NorthAmerica",
		"SX" => "NorthAmerica",
		"TC" => "NorthAmerica",
		"TT" => "NorthAmerica",
		"US" => "NorthAmerica",
		"VC" => "NorthAmerica",
		"VG" => "NorthAmerica",
		"VI" => "NorthAmerica",
		"AD" => "Europe",
		"AL" => "Europe",
		"AT" => "Europe",
		"AX" => "Europe",
		"BA" => "Europe",
		"BE" => "Europe",
		"BG" => "Europe",
		"BY" => "Europe",
		"CH" => "Europe",
		"CZ" => "Europe",
		"DE" => "Europe",
		"DK" => "Europe",
		"EE" => "Europe",
		"ES" => "Europe",
		"FI" => "Europe",
		"FO" => "Europe",
		"FR" => "Europe",
		"GB" => "Europe",
		"GG" => "Europe",
		"GI" => "Europe",
		"GR" => "Europe",
		"HR" => "Europe",
		"HU" => "Europe",
		"IE" => "Europe",
		"IM" => "Europe",
		"IS" => "Europe",
		"IT" => "Europe",
		"JE" => "Europe",
		"LI" => "Europe",
		"LT" => "Europe",
		"LU" => "Europe",
		"LV" => "Europe",
		"MC" => "Europe",
		"MD" => "Europe",
		"ME" => "Europe",
		"MK" => "Europe",
		"MT" => "Europe",
		"NL" => "Europe",
		"NO" => "Europe",
		"PL" => "Europe",
		"PT" => "Europe",
		"RO" => "Europe",
		"RS" => "Europe",
		"RU" => "Europe",
		"SE" => "Europe",
		"SI" => "Europe",
		"SK" => "Europe",
		"SM" => "Europe",
		"UA" => "Europe",
		"VA" => "Europe",
		"BR" => "SouthAmerica",
		"CO" => "SouthAmerica",
		"AR" => "SouthAmerica",
		"PE" => "SouthAmerica",
		"VE" => "SouthAmerica",
		"CL" => "SouthAmerica",
		"EC" => "SouthAmerica",
		"BO" => "SouthAmerica",
		"PY" => "SouthAmerica",
		"UY" => "SouthAmerica",
		"GY" => "SouthAmerica",
		"SR" => "SouthAmerica",
		"GF" => "SouthAmerica",
		"FK" => "SouthAmerica",
		"AE" => "Asia",
		"AF" => "Asia",
		"AM" => "Asia",
		"AZ" => "Asia",
		"BD" => "Asia",
		"BH" => "Asia",
		"BN" => "Asia",
		"BT" => "Asia",
		"CN" => "Asia",
		"CY" => "Asia",
		"GE" => "Asia",
		"HK" => "Asia",
		"ID" => "Asia",
		"IL" => "Asia",
		"IN" => "Asia",
		"IQ" => "Asia",
		"IR" => "Asia",
		"JO" => "Asia",
		"JP" => "Asia",
		"KG" => "Asia",
		"KH" => "Asia",
		"KP" => "Asia",
		"KR" => "Asia",
		"KW" => "Asia",
		"KZ" => "Asia",
		"LA" => "Asia",
		"LB" => "Asia",
		"LK" => "Asia",
		"MM" => "Asia",
		"MN" => "Asia",
		"MO" => "Asia",
		"MV" => "Asia",
		"MY" => "Asia",
		"NP" => "Asia",
		"OM" => "Asia",
		"PH" => "Asia",
		"PK" => "Asia",
		"PS" => "Asia",
		"QA" => "Asia",
		"SA" => "Asia",
		"SG" => "Asia",
		"SY" => "Asia",
		"TH" => "Asia",
		"TJ" => "Asia",
		"TL" => "Asia",
		"TM" => "Asia",
		"TR" => "Asia",
		"UZ" => "Asia",
		"VN" => "Asia",
		"YE" => "Asia",
		"AU" => "Oceania",
		"CK" => "Oceania",
		"FM" => "Oceania",
		"GU" => "Oceania",
		"KI" => "Oceania",
		"MH" => "Oceania",
		"NF" => "Oceania",
		"NR" => "Oceania",
		"NU" => "Oceania",
		"NZ" => "Oceania",
		"PN" => "Oceania",
		"PW" => "Oceania",
		"TK" => "Oceania",
		"TO" => "Oceania",
		"TV" => "Oceania",
		"WF" => "Oceania",
		"WS" => "Oceania",
		"AO" => "Africa",
		"BF" => "Africa",
		"BI" => "Africa",
		"BJ" => "Africa",
		"BW" => "Africa",
		"CD" => "Africa",
		"CF" => "Africa",
		"CG" => "Africa",
		"CI" => "Africa",
		"CM" => "Africa",
		"CV" => "Africa",
		"DJ" => "Africa",
		"DZ" => "Africa",
		"EG" => "Africa",
		"ER" => "Africa",
		"ET" => "Africa",
		"GA" => "Africa",
		"GH" => "Africa",
		"GM" => "Africa",
		"GN" => "Africa",
		"GQ" => "Africa",
		"GW" => "Africa",
		"KE" => "Africa",
		"KM" => "Africa",
		"LR" => "Africa",
		"LS" => "Africa",
		"LY" => "Africa",
		"MA" => "Africa",
		"MG" => "Africa",
		"ML" => "Africa",
		"MR" => "Africa",
		"MU" => "Africa",
		"MW" => "Africa",
		"MZ" => "Africa",
		"NA" => "Africa",
		"NE" => "Africa",
		"NG" => "Africa",
		"RE" => "Africa",
		"RW" => "Africa",
		"SC" => "Africa",
		"SD" => "Africa",
		"SH" => "Africa",
		"SL" => "Africa",
		"SN" => "Africa",
		"SO" => "Africa",
		"SS" => "Africa",
		"ST" => "Africa",
		"SZ" => "Africa",
		"TD" => "Africa",
		"TG" => "Africa",
		"TN" => "Africa",
		"TZ" => "Africa",
		"UG" => "Africa",
		"YT" => "Africa",
		"ZA" => "Africa",
		"ZM" => "Africa",
		"ZW" => "Africa",
	);

	public static function isInGeoDistance($coordinates, $range)
	{
		list($latitude1, $longitude1) = $coordinates;
		list($latitude2, $longitude2, $radius) = explode(",", $range);
		$latitudate2 = (double)$latitude2;
		$longitude2 = (double)$longitude2;
		$radius = (double)$radius;
		
		$theta = $longitude1 - $longitude2;
		$distance = sin(deg2rad($latitude1)) * sin(deg2rad($latitude2)) +  cos(deg2rad($latitude1)) * cos(deg2rad($latitude2)) * cos(deg2rad($theta));
		$distance = acos($distance);
		$distance = rad2deg($distance);
		$km = $distance * 60 * 1.1515 * 1.609344;

		if (class_exists('KalturaLog'))
			KalturaLog::info("distance ($latitude1,$longitude1) to ($latitude2,$longitude2) is $km , should be less than $radius");

		return $km <= $radius;
	}
	
	public static function getCDNRegionFromIP($getCoderType = null, $ip = null)
	{
		$geoCoder = kGeoCoderManager::getGeoCoder($getCoderType);
		$country = $geoCoder->getCountry($ip ? $ip : infraRequestUtils::getRemoteAddress());
		return isset(self::$countryRegion[$country]) ? self::$countryRegion[$country] : "unknown"; 
	}
}