<?php
/**
 * @package api
 * @subpackage ps2
 */
require_once 'listentriesAction.class.php';

/**
 * @package api
 * @subpackage ps2
 */
class listpartnerentriesAction extends listentriesAction
{
	public function describe()
	{
		return 	
			array (
				"display_name" => "listPartnerEntries",
				"desc" => "lists entries marked as global by partner" ,
				"in" => array (
					"mandatory" => array ( 
						"filter" => array ("type" => "entryFilter", "desc" => "")
						),
					"optional" => array (
						"detailed" => array ("type" => "boolean", "desc" => ""),
						"page_size" => array ("type" => "integer", "default" => 10, "desc" => ""),
						"page" => array ("type" => "boolean", "default" => 1, "desc" => ""),
						"use_filter_puser_id" => array ("type" => "boolean", "desc" => ""),
						)
					),
				"out" => array (
					"count" => array ("type" => "integer", "desc" => ""),
					"page_size" => array ("type" => "integer", "desc" => ""),
					"page" => array ("type" => "integer", "desc" => ""),
					"entrys" => array ("type" => "*entry", "desc" => ""),
					"user" => array ("type" => "kuser", "desc" => ""),
					),
				"errors" => array (
				)
			); 
	}
	
	protected function ticketType()
	{
		return self::REQUIED_TICKET_REGULAR;
	}
		
	// for this specific kshow list - the ticket is regular and the filter is for all
	// kshows for the current user only 
	protected function setExtraFilters ( entryFilter &$fields_set )
	{
		$fields_set->set( "_eq_group_id" , myPartnerUtils::PARTNER_GROUP );
		$fields_set->set( "_in_type" , entryType::MEDIA_CLIP . "," . entryType::MIX );
	}
}
?>