<?php


/**
 * This class defines the structure of the 'permission_item' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package Core
 * @subpackage model.map
 */
class PermissionItemTableMap extends TableMap {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'Core.PermissionItemTableMap';

	/**
	 * Initialize the table attributes, columns and validators
	 * Relations are not initialized by this method since they are lazy loaded
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function initialize()
	{
	  // attributes
		$this->setName('permission_item');
		$this->setPhpName('PermissionItem');
		$this->setClassname('PermissionItem');
		$this->setPackage('Core');
		$this->setUseIdGenerator(true);
		// columns
		$this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
		$this->addColumn('TYPE', 'Type', 'VARCHAR', true, 100, null);
		$this->addColumn('PARTNER_ID', 'PartnerId', 'INTEGER', true, null, null);
		$this->addColumn('PARAM_1', 'Param1', 'VARCHAR', true, 100, null);
		$this->addColumn('PARAM_2', 'Param2', 'VARCHAR', true, 100, null);
		$this->addColumn('PARAM_3', 'Param3', 'VARCHAR', true, 100, null);
		$this->addColumn('PARAM_4', 'Param4', 'VARCHAR', true, 100, null);
		$this->addColumn('PARAM_5', 'Param5', 'VARCHAR', true, 100, null);
		$this->addColumn('TAGS', 'Tags', 'LONGVARCHAR', false, null, null);
		$this->addColumn('CREATED_AT', 'CreatedAt', 'TIMESTAMP', false, null, null);
		$this->addColumn('UPDATED_AT', 'UpdatedAt', 'TIMESTAMP', false, null, null);
		$this->addColumn('CUSTOM_DATA', 'CustomData', 'LONGVARCHAR', false, null, null);
		// validators
	} // initialize()

	/**
	 * Build the RelationMap objects for this table relationships
	 */
	public function buildRelations()
	{
    $this->addRelation('PermissionToPermissionItem', 'PermissionToPermissionItem', RelationMap::ONE_TO_MANY, array('id' => 'permission_item_id', ), null, null);
	} // buildRelations()

} // PermissionItemTableMap
