<?php


/**
 * This class defines the structure of the 'permission_to_permission_item' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package Core
 * @subpackage model.map
 */
class PermissionToPermissionItemTableMap extends TableMap {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'Core.PermissionToPermissionItemTableMap';

	/**
	 * Initialize the table attributes, columns and validators
	 * Relations are not initialized by this method since they are lazy loaded
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function initialize()
	{
	  // attributes
		$this->setName('permission_to_permission_item');
		$this->setPhpName('PermissionToPermissionItem');
		$this->setClassname('PermissionToPermissionItem');
		$this->setPackage('Core');
		$this->setUseIdGenerator(true);
		// columns
		$this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
		$this->addForeignKey('PERMISSION_ID', 'PermissionId', 'INTEGER', 'permission', 'ID', true, null, null);
		$this->addForeignKey('PERMISSION_ITEM_ID', 'PermissionItemId', 'INTEGER', 'permission_item', 'ID', true, null, null);
		$this->addColumn('CREATED_AT', 'CreatedAt', 'TIMESTAMP', false, null, null);
		$this->addColumn('UPDATED_AT', 'UpdatedAt', 'TIMESTAMP', false, null, null);
		// validators
	} // initialize()

	/**
	 * Build the RelationMap objects for this table relationships
	 */
	public function buildRelations()
	{
    $this->addRelation('Permission', 'Permission', RelationMap::MANY_TO_ONE, array('permission_id' => 'id', ), null, null);
    $this->addRelation('PermissionItem', 'PermissionItem', RelationMap::MANY_TO_ONE, array('permission_item_id' => 'id', ), null, null);
	} // buildRelations()

} // PermissionToPermissionItemTableMap
