<?php
/**
 * Will hold data from the Kaltura UI components to be passed on to the reports and analytics system
 * @package api
 * @subpackage objects
 */
class KalturaStatsEvent extends KalturaObject 
{
/*
 * Bellow the definition of the event log line. The KalturaStatsEvent structure will strongly resemle this line but might differenciate slightly,
 * due to data that will come from other resources such as the suser's IP (coming from the HTTP header)
 * 
client version - will help interprete the line structure. different client versions might have slightly different data/data formats in the line
event_id - number is the row number in yuval's excel
datetime - same format as MySql's datetime - can change and should reflect the time zone
session id - can be some big random number or guid
partner id
entry id
unique viewer
widget id
ui_conf id
uid - the puser id as set by the partner
current point - in milliseconds
duration - milliseconds
user ip
process duration - in milliseconds
control id
seek
new point
referrer
 */
	
	/**
	 * @var string
	 */
	public $clientVer;

	/**
	 * @var KalturaStatsEventType
	 */
	public $eventType;
	
	/**
	 * the client's timestamp of this event
	 *  
	 * @var float
	 */
	public $eventTimestamp;

	/**
	 * a unique string generated by the client that will represent the client-side session: the primary component will pass it on to other components that sprout from it
	 * @var string
	 */
	public $sessionId;	
	
	/**
	 * @var int
	 */
	public $partnerId;
	
	/**
	 * @var string
	 */
	public $entryId;

	/**
	 * the UV cookie - creates in the operational system and should be passed on ofr every event 
	 * @var string
	 */
	public $uniqueViewer;
	
	/**
	 * @var string
	 */
	public $widgetId;
	
	/**
	 * @var int
	 */
	public $uiconfId;	
	
	/**
	 * the partner's user id 
	 * @var string
	 */
	public $userId;

	/**
	 * the timestamp along the video when the event happend 
	 * @var int
	 */
	public $currentPoint;
	
	/**
	 * the duration of the video in milliseconds - will make it much faster than quering the db for each entry 
	 * @var int
	 */
	public $duration;
	
	/**
	 * will be retrieved from the request of the user 
	 * @var string
	 * @readonly
	 */
	public $userIp;	

	/**
	 * the time in milliseconds the event took
	 * @var int
	 */
	public $processDuration;
	
	/**
	 * the id of the GUI control - will be used in the future to better understand what the user clicked
	 * @var string
	 */
	public $controlId;	
	
	/**
	 * true if the user ever used seek in this session 
	 * @var bool
	 */
	public $seek;	
	
	/**
	 * timestamp of the new point on the timeline of the video after the user seeks 
	 * @var int
	 */
	public $newPoint;	

	/**
	 * the referrer of the client
	 * @var string
	 */
	public $referrer;	
	
	/**
	 * will indicate if the event is thrown for the first video in the session
	 * @var bool
	 */
	public $isFirstInSession;
	
	/**
	 * kaltura application name 
	 * @var string 
	 */
	public $applicationId;
	
	/**
	 * @var int
	 */
	public $contextId;
	
	/**
	 * @var KalturaStatsFeatureType
	 */
	public $featureType;
		
}