<?php
/**
 * from the Andromeda Nov 25 document:
 * 1.
 * 2.KMC  Content Section events
 * page view (on each page)
 * Add playlist
 * Edit playlist
 * Delete playlist
 * Edit entry
 * Change thumbnail
 * Add tags
 * Remove tags
 * Add admin tags
 * Remove admin tags
 * Download
 * Approve Moderation
 * Reject Moderation
 * Bulk upload
 * Admin Upload via CW
 * 3.
 * 4.KMC Account events
 * Change partner info
 * Change login info
 * Contact us usage
 * Update server settings
 * 1.
 * 2.KMC App studio events
 * New player - single video
 * New player - Playlist
 * New player - Multi-tab playlist
 * Edit player - single video
 * Edit player - Playlist
 * Edit player - Multi-tab playlist
 * Duplicate player
 * 3. 
 * 
 * @package api
 * @subpackage enum
 */
class KalturaStatsKmcEventType extends KalturaEnum
{
	const CONTENT_PAGE_VIEW = 1001;
	
	const CONTENT_ADD_PLAYLIST = 1010;
	const CONTENT_EDIT_PLAYLIST = 1011;
	const CONTENT_DELETE_PLAYLIST = 1012;
    const CONTENT_DELETE_ITEM = 1058;
    const CONTENT_DELETE_MIX = 1059;
	const CONTENT_EDIT_ENTRY = 1013;
	const CONTENT_CHANGE_THUMBNAIL = 1014;
	const CONTENT_ADD_TAGS = 1015;
	const CONTENT_REMOVE_TAGS = 1016;
	const CONTENT_ADD_ADMIN_TAGS = 1017;
	const CONTENT_REMOVE_ADMIN_TAGS = 1018;
	const CONTENT_DOWNLOAD = 1019;
	const CONTENT_APPROVE_MODERATION = 1020;
	const CONTENT_REJECT_MODERATION = 1021;
	const CONTENT_BULK_UPLOAD = 1022;
	const CONTENT_ADMIN_KCW_UPLOAD = 1023;
    const CONTENT_CONTENT_GO_TO_PAGE = 1057;
    const CONTENT_ENTRY_DRILLDOWN = 1088;
    const CONTENT_OPEN_PREVIEW_AND_EMBED=1089;
	
	const ACCOUNT_CHANGE_PARTNER_INFO = 1030;
	const ACCOUNT_CHANGE_LOGIN_INFO  = 1031;
	const ACCOUNT_CONTACT_US_USAGE = 1032;
	const ACCOUNT_UPDATE_SERVER_SETTINGS  = 1033;
	const ACCOUNT_ACCOUNT_OVERVIEW  = 1034;
	const ACCOUNT_ACCESS_CONTROL  = 1035;
	const ACCOUNT_TRANSCODING_SETTINGS  = 1036;
	const ACCOUNT_ACCOUNT_UPGRADE  = 1037;
	const ACCOUNT_SAVE_SERVER_SETTINGS  = 1038;
	const ACCOUNT_ACCESS_CONTROL_DELETE  = 1039;
	const ACCOUNT_SAVE_TRANSCODING_SETTINGS  = 1040;
	
    const LOGIN =1041;
    
    const DASHBOARD_IMPORT_CONTENT  = 1042;
    const DASHBOARD_UPDATE_CONTENT  = 1043;
	const DASHBOARD_ACCOUNT_CONTACT_US = 1044;
	const DASHBOARD_VIEW_REPORTS= 1045;
	const DASHBOARD_EMBED_PLAYER=1046;
	const DASHBOARD_EMBED_PLAYLIST=1047;
	const DASHBOARD_CUSTOMIZE_PLAYERS=1048;
	
	const APP_STUDIO_NEW_PLAYER_SINGLE_VIDEO = 1050;
	const APP_STUDIO_NEW_PLAYER_PLAYLIST  = 1051;
	const APP_STUDIO_NEW_PLAYER_MULTI_TAB_PLAYLIST = 1052;
	const APP_STUDIO_EDIT_PLAYER_SINGLE_VIDEO = 1053;
	const APP_STUDIO_EDIT_PLAYER_PLAYLIST  = 1054;
	const APP_STUDIO_EDIT_PLAYER_MULTI_TAB_PLAYLIST = 1055;
	const APP_STUDIO_DUPLICATE_PLAYER = 1056;

    const REPORTS_AND_ANALYTICS_BANDWIDTH_USAGE_TAB =1070 ;
    const REPORTS_AND_ANALYTICS_CONTENT_REPORTS_TAB =1071;
    const REPORTS_AND_ANALYTICS_USERS_AND_COMMUNITY_REPORTS_TAB=1072;
    const REPORTS_AND_ANALYTICS_TOP_CONTRIBUTORS = 1073;
    const REPORTS_AND_ANALYTICS_MAP_OVERLAYS =1074; 
	const REPORTS_AND_ANALYTICS_TOP_SYNDICATIONS =1075; 
    const REPORTS_AND_ANALYTICS_TOP_CONTENT =1076; 
    const REPORTS_AND_ANALYTICS_CONTENT_DROPOFF =1077;
    const REPORTS_AND_ANALYTICS_CONTENT_INTERACTIONS =1078; 
    const REPORTS_AND_ANALYTICS_CONTENT_CONTRIBUTIONS =1079;
    const REPORTS_AND_ANALYTICS_VIDEO_DRILL_DOWN =1080;
    const REPORTS_AND_ANALYTICS_CONTENT_DRILL_DOWN_INTERACTION =1081;
    const REPORTS_AND_ANALYTICS_CONTENT_CONTRIBUTIONS_DRILLDOWN =1082;
    const REPORTS_AND_ANALYTICS_VIDEO_DRILL_DOWN_DROPOFF =1083;
    const REPORTS_AND_ANALYTICS_MAP_OVERLAYS_DRILLDOWN =1084;
    const REPORTS_AND_ANALYTICS_TOP_SYNDICATIONS_DRILL_DOWN=1085;
	const REPORTS_AND_ANALYTICS_BANDWIDTH_USAGE_VIEW_MONTHLY =1086 ;
    const REPORTS_AND_ANALYTICS_BANDWIDTH_USAGE_VIEW_YEARLY =1087; 


}
?>