<?php
/**
 * @package plugins.beacon
 * @subpackage model.search
 */
class kScheduledResourceSearch extends kBaseSearch
{
	public function __construct()
	{
		parent::__construct();
		$beaconElasticConfig = kConf::get('beacon', 'elastic');
		if(!$beaconElasticConfig)
		{
			throw new KalturaAPIException("Missing beacon configuration");
		}

		$host = isset($beaconElasticConfig['elasticHost']) ? $beaconElasticConfig['elasticHost'] : null;
		$port = isset($beaconElasticConfig['elasticPort']) ? $beaconElasticConfig['elasticPort'] : null;
		$elasticVersion = isset($beaconElasticConfig['elasticVersion']) ? $beaconElasticConfig['elasticVersion'] : elasticClient::ELASTIC_MAJOR_VERSION_5;
		$this->elasticClient = new elasticClient($host, $port, $elasticVersion);
	}

	public function doSearch(ESearchOperator $eSearchOperator, kPager $pager = null, $statuses = array(), $objectIdsCsvStr = null,
							 ESearchOrderBy $order = null)
	{
		kScheduledResourceSearchEntitlement::init();
		$this->initQuery($statuses, $objectIdsCsvStr, $pager, $order);
		$this->initEntitlement();
		$result = $this->execSearch($eSearchOperator);
		return $result;
	}

	protected function initQuery(array $statuses, $objectIdsCsvStr, kPager $pager = null, ESearchOrderBy $order = null,  ESearchAggregations $aggregations=null, $objectIdsNotIn = null)
	{
		$this->query = array(elasticClient::ELASTIC_INDEX_KEY => BeaconIndexName::SCHEDULED_RESOURCE_INDEX);
		$partnerId = kBaseElasticEntitlement::$partnerId;
		$this->initQueryAttributes($partnerId, $objectIdsCsvStr);
		$this->initPager($pager);
		$this->initOrderBy($order);
	}

	protected function initOrderBy(ESearchOrderBy $order = null)
	{
		if($order)
		{
			$sortConditions = $this->getSortConditions($order);
			$this->query['body']['sort'] = $sortConditions;
		}
	}

	protected function execSearch(ESearchOperator $eSearchOperator)
	{
		$subQuery = $eSearchOperator::createSearchQuery($eSearchOperator->getSearchItems(), null, $this->queryAttributes, $eSearchOperator->getOperator());
		$this->mainBoolQuery->addToFilter($subQuery);
		$this->applyElasticSearchConditions();
		$result = $this->elasticClient->search($this->query, true, true);
		return $result;
	}

	protected function initEntitlement()
	{
		$entitlementFilterQueries = kScheduledResourceSearchEntitlement::getEntitlementFilterQueries();
		if($entitlementFilterQueries)
		{
			$this->mainBoolQuery->addQueriesToFilter($entitlementFilterQueries);
		}
	}
}
