<?php

/**
 * @package plugins.facebookDistribution
 * @subpackage lib
 */
class KalturaFacebookLanguageMatch
{
	static function getFacebookCodeForKalturaLanguage($language)
	{
		$facebookLanguages = self::getFacebookLanguages();
		if (array_key_exists($language, $facebookLanguages))
			return $facebookLanguages[$language];
		return null;
	}

	static function getFacebookLanguages()
	{
		return array(
			'Afrikaans' 													=>	'af_ZA',
			'Akan' 															=>	'ak_GH',
			'Albanian' 														=>	'sq_AL',
			'Amharic' 														=>	'am_ET',
			'Arabic' 														=>	'ar_AR',
			'Armenian' 														=>	'hy_AM',
			'Assamese' 														=>	'as_IN',
			'Aymara' 														=>	'ay_BO',
			'Azerbaijani' 													=>	'az_AZ',
			'Basque' 														=>	'eu_ES',
			'Belarusian' 													=>	'be_BY',
			'Bengali' 														=>	'bn_IN',
			'Bengali (Bangla)' 												=>	'bn_IN',
			'Bosnian' 														=>	'bs_BA',
			'Breton' 														=>	'br_FR',
			'Bulgarian' 													=>	'bg_BG',
			'Burmese' 														=>	'my_MM',
			'Byelorussian (Belarusian)' 									=>	'be_BY',
			'Catalan' 														=>	'ca_ES',
			'Cebuano' 														=>	'cx_PH',
			'Cherokee' 														=>	'ck_US',
			'Chewa' 														=>	'ny_MW',
			'Chinese'					 									=>	'zh_CN',
			'Classical Greek' 												=>	'gx_GR',
			'Corsican' 														=>	'co_FR',
			'Croatian' 														=>	'hr_HR',
			'Czech' 														=>	'cs_CZ',
			'Danish' 														=>	'da_DK',
			'Dutch' 														=>	'nl_NL',
			'Dutch (België)' 												=>	'nl_BE',
			'English' 														=>	'en_US',
			'English (American)' 											=>	'en_US',
			'English (British)' 											=>	'en_GB',
			'English (India)' 												=>	'en_IN',
			'English (Pirate)' 												=>	'en_PI',
			'English (Upside Down)' 										=>	'en_UD',
			'Esperanto' 													=>	'eo_EO',
			'Estonian' 														=>	'et_EE',
			'Faroese' 														=>	'fo_FO',
			'Filipino' 														=>	'tl_PH',
			'Finnish' 														=>	'fi_FI',
			'French' 														=>	'fr_CA',
			'French (Canada)' 												=>	'fr_CA',
			'French (France)' 												=>	'fr_FR',
			'Frisian' 														=>	'fy_NL',
			'Farsi' 														=>	'fa_IR',
			'Fulah' 														=>	'ff_NG',
			'Galician' 														=>	'gl_ES',
			'Ganda' 														=>	'lg_UG',
			'Georgian' 														=>	'ka_GE',
			'German' 														=>	'de_DE',
			'Greek' 														=>	'el_GR',
			'Guarani' 														=>	'gn_PY',
			'Gujarati' 														=>	'gu_IN',
			'Hausa' 														=>	'ha_NG',
			'Hebrew' 														=>	'he_IL',
			'Hindi' 														=>	'hi_IN',
			'Hungarian' 													=>	'hu_HU',
			'Icelandic' 													=>	'is_IS',
			'Igbo' 															=>	'ig_NG',
			'Indonesian' 													=>	'id_ID',
			'Irish' 														=>	'ga_IE',
			'Italian' 														=>	'it_IT',
			'Japanese' 														=>	'ja_JP',
			'Japanese (Kansai)' 											=>	'ja_KS',
			'Javanese' 														=>	'jv_ID',
			'Kannada' 														=>	'kn_IN',
			'Kazakh' 														=>	'kk_KZ',
			'Khmer' 														=>	'km_KH',
			'Kinyarwanda' 													=>	'rw_RW',
			'Kinyarwanda (Ruanda)' 											=>	'rw_RW',
			'Klingon' 														=>	'tl_ST',
			'Korean' 														=>	'ko_KR',
			'Kurdish' 														=>	'ku_TR',
			'Kurdish (Kurmanji)' 											=>	'ku_TR',
			'Kyrgyz' 														=>	'ky_KG',
			'Lao' 															=>	'lo_LA',
			'Latin' 														=>	'la_VA',
			'Latvian' 														=>	'lv_LV',
			'Latvian (Lettish)'												=>	'lv_LV',
			'Leet Speak' 													=>	'fb_LT',
			'Limburgish' 													=>	'li_NL',
			'Limburgish ( Limburger)'										=>	'li_NL',
			'Lingala' 														=>	'ln_CD',
			'Lithuanian' 													=>	'lt_LT',
			'Macedonian' 													=>	'mk_MK',
			'Malagasy' 														=>	'mg_MG',
			'Malay' 														=>	'ms_MY',
			'Malayalam' 													=>	'ml_IN',
			'Maltese' 														=>	'mt_MT',
			'Māori' 														=>	'mi_NZ',
			'Maori' 														=>	'mi_NZ',
			'Marathi' 														=>	'mr_IN',
			'Mongolian' 													=>	'mn_MN',
			'Ndebele' 														=>	'nd_ZW',
			'Nepali' 														=>	'ne_NP',
			'Northern Sámi' 												=>	'se_NO',
			'Norwegian'			 											=>	'nn_NO',
			'Norwegian (bokmal)' 											=>	'nb_NO',
			'Norwegian (nynorsk)' 											=>	'nn_NO',
			'Oriya' 														=>	'or_IN',
			'Pashto' 														=>	'ps_AF',
			'Pashto (Pushto)' 												=>	'ps_AF',
			'Persian' 														=>	'fa_IR',
			'Polish' 														=>	'pl_PL',
			'Portuguese (Brazil)' 											=>	'pt_BR',
			'Portuguese (Portugal)' 										=>	'pt_PT',
			'Punjabi' 														=>	'pa_IN',
			'Quechua' 														=>	'qu_PE',
			'Romanian' 														=>	'ro_RO',
			'Romansh' 														=>	'rm_CH',
			'Russian' 														=>	'ru_RU',
			'Sanskrit' 														=>	'sa_IN',
			'Sardinian'														=>	'sc_IT',
			'Serbian' 														=>	'sr_RS',
			'Shona' 														=>	'sn_ZW',
			'Silesian' 														=>	'sz_PL',
			'Simplified Chinese (China)' 									=>	'zh_CN',
			'Sinhala' 														=>	'si_LK',
			'Slovak' 														=>	'sk_SK',
			'Slovenian' 													=>	'sl_SI',
			'Somali' 														=>	'so_SO',
			'Sorani Kurdish' 												=>	'cb_IQ',
			'Spanish' 														=>	'es_LA',
			'Spanish (Chile)' 												=>	'es_CL',
			'Spanish (Colombia)'											=>	'es_CO',
			'Spanish (Mexico)' 												=>	'es_MX',
			'Spanish (Spain)' 												=>	'es_ES',
			'Spanish (Venezuela)' 											=>	'es_VE',
			'Swahili' 														=>	'sw_KE',
			'Swahili (Kiswahili)' 											=>	'sw_KE',
			'Swedish' 														=>	'sv_SE',
			'Syriac' 														=>	'sy_SY',
			'Tajik' 														=>	'tg_TJ',
			'Tamazight' 													=>	'tz_MA',
			'Tamil' 														=>	'ta_IN',
			'Tatar' 														=>	'tt_RU',
			'Telugu' 														=>	'te_IN',
			'Thai' 															=>	'th_TH',
			'Traditional Chinese (Hong Kong)' 								=>	'zh_HK',
			'Traditional Chinese (Taiwan)' 									=>	'zh_TW',
			'Turkish' 														=>	'tr_TR',
			'Ukrainian' 													=>	'uk_UA',
			'Turkmen' 														=>	'tk_TM',
			'Urdu' 															=>	'ur_PK',
			'Uzbek' 														=>	'uz_UZ',
			'Vietnamese'													=>	'vi_VN',
			'Welsh' 														=>	'cy_GB',
			'Wolof' 														=>	'wo_SN',
			'Xhosa' 														=>	'xh_ZA',
			'Yiddish' 														=>	'yi_DE',
			'Yoruba' 														=>	'yo_NG',
			'Zazaki' 														=>	'zz_TR',
			'Zulu' 															=>	'zu_ZA'
		);
	}
}