<?php
/**
 * @package plugins.youTubeDistribution
 * @subpackage model.enum
 */ 
interface YouTubeDistributionField extends BaseEnum
{
	// item
	const NOTIFICATION_EMAIL 			= 'NOTIFICATION_EMAIL';
	const OWNER_NAME 					= 'OWNER_NAME';
	const TARGET 						= 'TARGET';
	const DATE_RECORDED 				= 'DATE_RECORDED';
	const LANGUAGE  					= 'LANGUAGE';
	const START_TIME  					= 'START_TIME';
	const END_TIME  					= 'END_TIME';
	const URGENT_REFERENCE_FILE			= 'URGENT_REFERENCE_FILE';
	const KEEP_FINGERPRINT				= 'KEEP_FINGERPRINT';
	
	// item/yt:account
	const ACCOUNT_USERNAME 				= 'ACCOUNT_USERNAME';
	const ACCOUNT_PASSWORD 				= 'ACCOUNT_PASSWORD';
	
	// item/media:content
	const MEDIA_TITLE  					= 'MEDIA_TITLE';
	const MEDIA_DESCRIPTION  			= 'MEDIA_DESCRIPTION';
	const MEDIA_KEYWORDS  				= 'MEDIA_KEYWORDS';
	const MEDIA_CATEGORY  				= 'MEDIA_CATEGORY';
	const MEDIA_RATING  				= 'MEDIA_RATING';
	
	// item/yt:community
	const ALLOW_COMMENTS  				= 'ALLOW_COMMENTS';
	const ALLOW_RESPONSES  				= 'ALLOW_RESPONSES';
	const ALLOW_RATINGS  				= 'ALLOW_RATINGS';
	const ALLOW_EMBEDDING  				= 'ALLOW_EMBEDDING';

	// item/yt:policy
	const POLICY_COMMERCIAL  			= 'POLICY_COMMERCIAL';
	const POLICY_UGC 					= 'POLICY_UGC';

	// item/yt:web_metadata
	const WEB_METADATA_CUSTOM_ID  		= 'WEB_METADATA_CUSTOM_ID';
	const WEB_METADATA_NOTES  			= 'WEB_METADATA_NOTES';
	
	// item/yt:movie_metadata
	const MOVIE_METADATA_CUSTOM_ID 		= 'MOVIE_METADATA_CUSTOM_ID';
	const MOVIE_METADATA_DIRECTOR 		= 'MOVIE_METADATA_DIRECTOR';
	const MOVIE_METADATA_NOTES  		= 'MOVIE_METADATA_NOTES';
	const MOVIE_METADATA_TITLE 			= 'MOVIE_METADATA_TITLE';
	const MOVIE_METADATA_TMS_ID 		= 'MOVIE_METADATA_TMS_ID';
	
	// item/yt:tv_metadata
	const TV_METADATA_CUSTOM_ID  		= 'TV_METADATA_CUSTOM_ID';
	const TV_METADATA_SHOW_TITLE 		= 'TV_METADATA_SHOW_TITLE';
	const TV_METADATA_EPISODE 			= 'TV_METADATA_EPISODE';
	const TV_METADATA_EPISODE_TITLE 	= 'TV_METADATA_EPISODE_TITLE';
	const TV_METADATA_NOTES 			= 'TV_METADATA_NOTES';
	const TV_METADATA_SEASON 			= 'TV_METADATA_SEASON';
	const TV_METADATA_TMS_ID 			= 'TV_METADATA_TMS_ID';
	
	// item/yt:playlists
	const PLAYLISTS 					= 'PLAYLISTS';

	// item/yt:advertising
	const ADVERTISING_ADSENSE_FOR_VIDEO = 'ADVERTISING_ADSENSE_FOR_VIDEO';
	const ADVERTISING_INVIDEO			= 'ADVERTISING_INVIDEO';
	const ADVERTISING_ALLOW_PRE_ROLL_ADS 	= 'ADVERTISING_ALLOW_PRE_ROLL_ADS';
	const ADVERTISING_ALLOW_MID_ROLL_ADS 	= 'ADVERTISING_ALLOW_MID_ROLL_ADS';
	const ADVERTISING_ALLOW_POST_ROLL_ADS 	= 'ADVERTISING_ALLOW_POST_ROLL_ADS';
	
	// item/yt:advertising/yt:third_party_ads
	const THIRD_PARTY_AD_SERVER_AD_TYPE 	= 'THIRD_PARTY_AD_SERVER_AD_TYPE';
	const THIRD_PARTY_AD_SERVER_PARTNER_ID 	= 'THIRD_PARTY_AD_SERVER_PARTNER_ID';
	const THIRD_PARTY_AD_SERVER_VIDEO_ID 	= 'THIRD_PARTY_AD_SERVER_VIDEO_ID';
	
	// item/yt:location
	const LOCATION_COUNTRY 				= 'LOCATION_COUNTRY';
	const LOCATION_LOCATION_TEXT		= 'LOCATION_LOCATION_TEXT';
	const LOCATION_ZIP_CODE				= 'LOCATION_ZIP_CODE';
	
	// item/yt:distribution_restriction
	const DISTRIBUTION_RESTRICTION_DISTRIBUTION_RULE = 'DISTRIBUTION_RESTRICTION_DISTRIBUTION_RULE';

	/**
	 * New spec - 'asset' attributes
	 */
	const ASSET_TYPE = 'ASSET_TYPE';
	const ASSET_OVERRIDE_MANUAL_EDITS = 'ASSET_OVERRIDE_MANUAL_EDITS';

	/**
	 * New spec - 'asset' elements
	 */
	const ASSET_ACTOR = 'ASSET_ACTOR';
	const ASSET_BROADCASTER = 'ASSET_BROADCASTER';
	const ASSET_CONTENT_TYPE = 'ASSET_CONTENT_TYPE';
	const ASSET_CUSTOM_ID = 'ASSET_CUSTOM_ID';
	const ASSET_LABLES = 'ASSET_LABLES';
	const ASSET_DESCRIPTION = 'ASSET_DESCRIPTION';
	const ASSET_DIRECTOR = 'ASSET_DIRECTOR';
	const ASSET_EIDR = 'ASSET_EIDR';
	const ASSET_END_YEAR = 'ASSET_END_YEAR';
	const ASSET_EPISODE = 'ASSET_EPISODE';
	const ASSET_GENRE = 'ASSET_GENRE';
	const ASSET_GRID = 'ASSET_GRID';
	const ASSET_ISAN = 'ASSET_ISAN';
	const ASSET_KEYWORDS = 'ASSET_KEYWORDS';
	const ASSET_NOTES = 'ASSET_NOTES';
	const ASSET_ORIGINAL_RELEASE_DATE = 'ASSET_ORIGINAL_RELEASE_DATE';
	const ASSET_ORIGINAL_RELEASE_MEDIUM = 'ASSET_ORIGINAL_RELEASE_MEDIUM';
	const ASSET_PRODUCER = 'ASSET_PRODUCER';
	const ASSET_RATING_SYSTEM = 'ASSET_RATING_SYSTEM';
	const ASSET_RATING_VALUE = 'ASSET_RATING_VALUE';
	const ASSET_SEASON = 'ASSET_SEASON';
	const ASSET_SHOW_AND_MOVIE_PROGRAMMING = 'ASSET_SHOW_AND_MOVIE_PROGRAMMING';
	const ASSET_SHOW_TITLE = 'ASSET_SHOW_TITLE';
	const ASSET_SPOKEN_LANGUAGE = 'ASSET_SPOKEN_LANGUAGE';
	const ASSET_START_YEAR = 'ASSET_START_YEAR';
	const ASSET_SUBTITLED_LANGUAGE = 'ASSET_SUBTITLED_LANGUAGE';
	const ASSET_TITLE = 'ASSET_TITLE';
	const ASSET_TMS_ID = 'ASSET_TMS_ID';
	const ASSET_UPC = 'ASSET_UPC';
	const ASSET_URL = 'ASSET_URL';
	const ASSET_WRITER = 'ASSET_WRITER';

	/**
	 * New spec- new elements for 'video'
	 */
	const VIDEO_ALLOW_COMMENT_RATINGS	= 'VIDEO_ALLOW_COMMENT_RATINGS';
	const VIDEO_ALLOW_SYNDICATION		= 'VIDEO_ALLOW_SYNDICATION';
	const VIDEO_CHANNEL 				= 'VIDEO_CHANNEL';
	const VIDEO_HIDE_VIEW_COUNT 		= 'VIDEO_HIDE_VIEW_COUNT';
	const VIDEO_DOMAIN_BLACK_LIST 		= 'VIDEO_DOMAIN_BLACK_LIST';
	const VIDEO_DOMAIN_WHITE_LIST 		= 'VIDEO_DOMAIN_WHITE_LIST';
	const VIDEO_NOTIFY_SUBSCRIBERS 		= 'VIDEO_NOTIFY_SUBSCRIBERS';
	const VIDEO_PUBLIC 					= 'VIDEO_PUBLIC';

	/**
	 * New spec- new elements for 'claim'
	 */
	const CLAIM_TYPE = 'CLAIM_TYPE';
	const CLAIM_BLOCK_OUTSIDE_OWNERSHIP = 'CLAIM_BLOCK_OUTSIDE_OWNERSHIP';

	/**
	 * New spec- new elements for 'ad_policy'
	 */
	const ADVERTISING_INSTREAM_STANDARD = 'ADVERTISING_INSTREAM_STANDARD';

	/**
	 * General control
	 */
	const DISABLE_FINGERPRINTING = 'DISABLE_FINGERPRINTING';

	const ENTRY_PRIVACY_STATUS  = 'ENTRY_PRIVACY_STATUS';
	const ENABLE_CONTENT_ID ='ENABLE_CONTENT_ID';
	const REQUIRE_PAID_SUBSCRIPTION_TO_VIEW = 'REQUIRE_PAID_SUBSCRIPTION_TO_VIEW';
	const PRODUCT_LISTING_ADS = 'PRODUCT_LISTING_ADS';
	const THIRD_PARTY_ADS = 'THIRD_PARTY_ADS ';
	const ADVERTISING_INSTREAM_TRUEVIEW = 'ADVERTISING_INSTREAM_TRUEVIEW';
	const ADVERTISING_ALLOW_INVIDEO = 'ADVERTISING_ALLOW_INVIDEO';
	const ADVERTISING_ALLOW_ADSENSE_FOR_VIDEO = 'ADVERTISING_ALLOW_ADSENSE_FOR_VIDEO';


}