<?php
/**
 * @package plugins.httpNotification
 * @subpackage admin
 */ 
class Form_HttpNotificationTemplateConfiguration extends Form_EventNotificationTemplateConfiguration
{
	/* (non-PHPdoc)
	 * @see Infra_Form::getObject()
	 */
	public function getObject($objectType, array $properties, $add_underscore = true, $include_empty_fields = false)
	{
		$object = parent::getObject($objectType, $properties, $add_underscore, $include_empty_fields);
		if($object instanceof Kaltura_Client_HttpNotification_Type_HttpNotificationTemplate)
		{
			if (isset($properties['secureHashingAlgo']))
			{
				$object->secureHashingAlgo = $properties['secureHashingAlgo'];
			}

			if (isset($properties['customHeaders']) && $properties['customHeaders'])
			{
				$object->customHeaders = [];
				$headersStr = explode(',', $properties['customHeaders']);
				foreach ($headersStr as $headerStr)
				{
					list ($key, $value) = explode(':', $headerStr);
					$keyValuePair = new Kaltura_Client_Type_KeyValue();
					$keyValuePair->key = $key;
					$keyValuePair->value = $value;
					$object->customHeaders[] = $keyValuePair;
				}
			}

			if(!isset($properties['dataType']) || !$properties['dataType'])
				return $object;
			
			switch ($properties['dataType'])
			{
				case 'object':
					$object->data = new Kaltura_Client_HttpNotification_Type_HttpNotificationObjectData();
					$object->data->apiObjectType = $properties['objectType'];
					$object->data->format = $properties['objectFormat'];
					$object->data->code = $properties['object'];
					$object->data->responseProfileId = $properties['responseProfileId'];
					break;
					
				case 'map':
					$object->data = new Kaltura_Client_HttpNotification_Type_HttpNotificationDataFields();
					break;
					
				case 'text':
					$stringField = new Kaltura_Client_Type_StringValue();
					$stringField->value = $properties['freeText'];
					
					$object->data = new Kaltura_Client_HttpNotification_Type_HttpNotificationDataText();
					$object->data->content = $stringField;
					$object->data->contentType = $properties['contentType'];

					break;
			}
		}
		
		return $object;
	}
	
	/* (non-PHPdoc)
	 * @see Infra_Form::populateFromObject()
	 */
	public function populateFromObject($object, $add_underscore = true)
	{
		parent::populateFromObject($object, $add_underscore);
		
		if(!($object instanceof Kaltura_Client_HttpNotification_Type_HttpNotificationTemplate))
			return;

		$this->getElement('secureHashingAlgo')->setValue($object->secureHashingAlgo);

		if (count($object->customHeaders))
		{
			$headerStrArr = [];
			foreach ($object->customHeaders as $header)
			{
				$headerStrArr[] = $header->key . ':' . $header->value;
			}
			$this->getElement('customHeaders')->setValue(implode(',', $headerStrArr));
		}

		if(!$object->data)
			return;
			
		if($object->data instanceof Kaltura_Client_HttpNotification_Type_HttpNotificationDataFields)
		{
			$this->getElement('dataType')->setValue('map');
		}
		elseif($object->data instanceof Kaltura_Client_HttpNotification_Type_HttpNotificationDataText)
		{
			$this->getElement('dataType')->setValue('text');
			$this->getElement('freeText')->setValue($object->data->content->value);
			$this->getElement('contentType')->setValue($object->data->contentType);
		}
		elseif($object->data instanceof Kaltura_Client_HttpNotification_Type_HttpNotificationObjectData)
		{
			$this->getElement('dataType')->setValue('object');
			$this->getElement('objectType')->setValue($object->data->apiObjectType);
			$this->getElement('objectFormat')->setValue($object->data->format);
			$this->getElement('object')->setValue($object->data->code);
			$this->getElement('responseProfileId')->setValue($object->data->responseProfileId);
		}
	}
	
	/* (non-PHPdoc)
	 * @see Form_EventNotificationTemplateConfiguration::addTypeElements()
	 */
	protected function addTypeElements(Kaltura_Client_EventNotification_Type_EventNotificationTemplate $eventNotificationTemplate)
	{
		$element = new Infra_Form_Html('http_title', array(
			'content' => '<b>Notification Handler Service  Details</b>',
		));
		$this->addElements(array($element));

		$this->addElement('select', 'event_delayed_condition', array(
			'label'			=> 'Delay Notification Condition:',
			'filters'		=> array('StringTrim'),
			'required'		=> true,
			'multiOptions' 	=> array(
				Kaltura_Client_EventNotification_Enum_EventNotificationDelayedCondition::NONE => 'None',
				Kaltura_Client_EventNotification_Enum_EventNotificationDelayedCondition::PENDING_ENTRY_READY => 'Until entry is ready',
			),
		));

		$this->addElement('select', 'secureHashingAlgo', array(
			'label'			=> 'Secure Hashing Algorithm:',
			'filters'		=> array('StringTrim'),
			'required'		=> true,
			'multiOptions' 	=> array(
				Kaltura_Client_HttpNotification_Enum_SecureHashingAlgo::SHA_1 => 'SHA 1',
				Kaltura_Client_HttpNotification_Enum_SecureHashingAlgo::SHA_256 => 'SHA 256',
				Kaltura_Client_HttpNotification_Enum_SecureHashingAlgo::SHA_512 => 'SHA 512',
			),
		));
		
		$this->addElement('text', 'url', array(
			'label'			=> 'URL:',
			'size'			=> 60,
			'filters'		=> array('StringTrim'),
		));

		$this->addElement('select', 'method', array(
			'label'			=> 'Method:',
			'filters'		=> array('StringTrim'),
			'multiOptions' 	=> array(
				Kaltura_Client_HttpNotification_Enum_HttpNotificationMethod::POST => 'POST',
				Kaltura_Client_HttpNotification_Enum_HttpNotificationMethod::GET => 'GET',
				Kaltura_Client_HttpNotification_Enum_HttpNotificationMethod::PUT => 'PUT',
				Kaltura_Client_HttpNotification_Enum_HttpNotificationMethod::DELETE => 'DELETE',
			),
		));

		$this->addElement('textarea', "customHeaders", array(
			'label' 		=> "Custom Headers (Array: enter item comma separated. for key-value insert: key:value)",
			'required'		=> false,
			'filters'		=> array('StringTrim'),
			'value'			=>	'N/A',
		));

		$this->addElement('select', 'dataType', array(
			'label'			=> 'Data Type:',
			'filters'		=> array('StringTrim'),
			'required'		=> true,
			'multiOptions' 	=> array(
				'' => 'Select Data Type',
				'object' => 'API Object',
				'map' => 'Fields',
				'text' => 'Free Text',
			),
		));
		
		$this->addElement('text', 'object', array(
			'label'			=> 'Object:',
			'filters'		=> array('StringTrim'),
			'readonly'		=> true,
		));

		$this->addElement('text', 'responseProfileId', array(
			'label'			=> 'Response profile ID:',
			'filters'		=> array('StringTrim'),
		));
		
		$this->addElement('text', 'objectType', array(
			'label'			=> 'Object Type (KalturaObject):',
			'filters'		=> array('StringTrim'),
			'readonly'		=> true,
		));
		
		$this->addElement('select', 'objectFormat', array(
			'label'			=> 'Format:',
			'filters'		=> array('StringTrim'),
			'required'		=> true,
			'multiOptions' 	=> array(
				Kaltura_Client_Enum_ResponseType::RESPONSE_TYPE_JSON => 'JSON',
				Kaltura_Client_Enum_ResponseType::RESPONSE_TYPE_XML => 'XML',
				Kaltura_Client_Enum_ResponseType::RESPONSE_TYPE_PHP => 'PHP',
			),
		));
			
		$this->addDisplayGroup(array('object', 'objectType', 'objectFormat', 'responseProfileId'),
			'frmObject', 
			array(
				'decorators' 	=> array('FormElements', 'Fieldset', array('HtmlTag', array('tag' => 'div', 'style' => 'display: none', 'id' => 'frmObject'))),
		));
		
		$this->addElement('textarea', 'freeText', array(
			'label'			=> 'Text:',
			'filters'		=> array('StringTrim'),
		));

		$this->addElement('text', 'contentType', array(
			'label'			=> 'Content Type:',
			'filters'		=> array('StringTrim'),
			'value'			=> 'application/json'
		));
			
		$this->addDisplayGroup(array('freeText', 'contentType'),
			'frmFreeText', 
			array(
				'decorators' 	=> array('FormElements', 'Fieldset', array('HtmlTag', array('tag' => 'div', 'style' => 'display: none', 'id' => 'frmFreeText'))),
		));
	}


}
