<?php
/**
 * @package plugins.reach
 * @subpackage Admin
 */
class Form_DictionariesSubForm extends ConfigureSubForm
{
	private $ignore = array('relatedObjects', 'type', 'gs','data');
	private $prefix = "Dictionary_";

	private $type;

	public function __construct($type)
	{
		$this->type = $type;
		parent::__construct();
	}

	public function init()
	{
		$this->setAttrib('id', 'frmDictionariesSubForm');
		$this->setMethod('post');
		$this->addDecorator('ViewScript', array(
			'viewScript' => 'dictionary-sub-form.phtml',
		));

		$obj = new $this->type();
		$this->addObjectProperties($obj, $this->ignore, $this->prefix);
		$this->addStringAreaElement("data", "Dictionary_");

	}

	public function isValid($data)
	{
		if(!$data['ReachProfileDictionaries'])
			return true;
		
		$jsonData = json_decode($data['ReachProfileDictionaries'], true);
		if(!empty($jsonData))
			return true;
		
		return false;
	}
}