<?php
/**
 * @package plugins.scheduledTask
 * @subpackage api.filters.base
 * @abstract
 */
abstract class KalturaScheduledTaskProfileBaseFilter extends KalturaFilter
{
	static private $map_between_objects = array
	(
		"idEqual" => "_eq_id",
		"idIn" => "_in_id",
		"partnerIdEqual" => "_eq_partner_id",
		"partnerIdIn" => "_in_partner_id",
		"systemNameEqual" => "_eq_system_name",
		"systemNameIn" => "_in_system_name",
		"statusEqual" => "_eq_status",
		"statusIn" => "_in_status",
		"createdAtGreaterThanOrEqual" => "_gte_created_at",
		"createdAtLessThanOrEqual" => "_lte_created_at",
		"updatedAtGreaterThanOrEqual" => "_gte_updated_at",
		"updatedAtLessThanOrEqual" => "_lte_updated_at",
		"lastExecutionStartedAtGreaterThanOrEqual" => "_gte_last_execution_started_at",
		"lastExecutionStartedAtLessThanOrEqual" => "_lte_last_execution_started_at",
		"lastExecutionStartedAtLessThanOrEqualOrNull" => "_lteornull_last_execution_started_at",
		"objectFilterEngineTypeIn" => "_in_object_filter_engine_type",
	);

	static private $order_by_map = array
	(
		"+id" => "+id",
		"-id" => "-id",
		"+createdAt" => "+created_at",
		"-createdAt" => "-created_at",
		"+updatedAt" => "+updated_at",
		"-updatedAt" => "-updated_at",
		"+lastExecutionStartedAt" => "+last_execution_started_at",
		"-lastExecutionStartedAt" => "-last_execution_started_at",
	);

	public function getMapBetweenObjects()
	{
		return array_merge(parent::getMapBetweenObjects(), self::$map_between_objects);
	}

	public function getOrderByMap()
	{
		return array_merge(parent::getOrderByMap(), self::$order_by_map);
	}

	/**
	 * @var int
	 */
	public $idEqual;

	/**
	 * @var string
	 */
	public $idIn;

	/**
	 * @var int
	 */
	public $partnerIdEqual;

	/**
	 * @var string
	 */
	public $partnerIdIn;

	/**
	 * @var string
	 */
	public $systemNameEqual;

	/**
	 * @var string
	 */
	public $systemNameIn;

	/**
	 * @var KalturaScheduledTaskProfileStatus
	 */
	public $statusEqual;

	/**
	 * @var string
	 */
	public $statusIn;

	/**
	 * @var time
	 */
	public $createdAtGreaterThanOrEqual;

	/**
	 * @var time
	 */
	public $createdAtLessThanOrEqual;

	/**
	 * @var time
	 */
	public $updatedAtGreaterThanOrEqual;

	/**
	 * @var time
	 */
	public $updatedAtLessThanOrEqual;

	/**
	 * @var time
	 */
	public $lastExecutionStartedAtGreaterThanOrEqual;

	/**
	 * @var time
	 */
	public $lastExecutionStartedAtLessThanOrEqual;

	/**
	 * @var time
	 */
	public $lastExecutionStartedAtLessThanOrEqualOrNull;
	
	/**
	 * @var string
	 */
	public $objectFilterEngineTypeIn;
}
