<?php
// This file was auto-generated from sdk-root/src/data/s3/2006-03-01/endpoint-tests-1.json
return [ 'testCases' => [ [ 'documentation' => 'region is not a valid DNS-suffix', 'expect' => [ 'error' => 'Invalid region: region was not a valid DNS name.', ], 'params' => [ 'Region' => 'a b', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'Invalid access point ARN: Not S3', 'expect' => [ 'error' => 'Invalid ARN: The ARN was not for the S3 service, found: not-s3', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:not-s3:us-west-2:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'Bucket' => 'arn:aws:not-s3:us-west-2:123456789012:accesspoint:myendpoint', ], ], [ 'documentation' => 'Invalid access point ARN: invalid resource', 'expect' => [ 'error' => 'Invalid ARN: The ARN may only contain a single resource component after `accesspoint`.', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint:more-data', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint:more-data', ], ], [ 'documentation' => 'Invalid access point ARN: invalid no ap name', 'expect' => [ 'error' => 'Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:', ], ], [ 'documentation' => 'Invalid access point ARN: AccountId is invalid', 'expect' => [ 'error' => 'Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123456_789012`', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west-2:123456_789012:accesspoint:apname', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'Bucket' => 'arn:aws:s3:us-west-2:123456_789012:accesspoint:apname', ], ], [ 'documentation' => 'Invalid access point ARN: access point name is invalid', 'expect' => [ 'error' => 'Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `ap_name`', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:ap_name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:ap_name', ], ], [ 'documentation' => 'Access points (disable access points explicitly false)', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'DisableAccessPoints' => false, 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', ], ], [ 'documentation' => 'Access points: partition does not support FIPS', 'expect' => [ 'error' => 'Partition does not support FIPS', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', 'AWS::UseFIPS' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:cn-north-1:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'cn-north-1', 'UseFIPS' => true, 'UseDualStack' => false, 'Accelerate' => false, 'Bucket' => 'arn:aws:s3:cn-north-1:123456789012:accesspoint:myendpoint', ], ], [ 'documentation' => 'Bucket region is invalid', 'expect' => [ 'error' => 'Invalid region in ARN: `us-west -2` (invalid DNS name)', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west -2:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'DisableAccessPoints' => false, 'Bucket' => 'arn:aws:s3:us-west -2:123456789012:accesspoint:myendpoint', ], ], [ 'documentation' => 'Access points when Access points explicitly disabled (used for CreateBucket)', 'expect' => [ 'error' => 'Access points are not supported for this operation', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'CreateBucket', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'DisableAccessPoints' => true, 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', ], ], [ 'documentation' => 'missing arn type', 'expect' => [ 'error' => 'Invalid ARN: `arn:aws:s3:us-west-2:123456789012:` was not a valid ARN', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'DisableAccessPoints' => true, 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:', ], ], [ 'documentation' => 'SDK::Host + access point + Dualstack is an error', 'expect' => [ 'error' => 'Cannot set dual-stack in combination with a custom endpoint.', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', 'AWS::UseDualStack' => true, 'SDK::Endpoint' => 'https://beta.example.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'Endpoint' => 'https://beta.example.com', 'Region' => 'cn-north-1', 'UseDualStack' => true, 'UseFIPS' => false, ], ], [ 'documentation' => 'Access point ARN with FIPS & Dualstack', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::UseFIPS' => true, 'AWS::UseDualStack' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => true, 'UseDualStack' => true, 'Accelerate' => false, 'DisableAccessPoints' => false, 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', ], ], [ 'documentation' => 'Access point ARN with Dualstack', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://myendpoint-123456789012.s3-accesspoint.dualstack.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::UseDualStack' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => false, 'UseDualStack' => true, 'Accelerate' => false, 'DisableAccessPoints' => false, 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', ], ], [ 'documentation' => 'vanilla MRAP', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4a', 'signingRegionSet' => [ '*', ], 'signingName' => 's3', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://mfzwi23gnjvgw.mrap.accesspoint.s3-global.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap', 'Key' => 'key', ], ], ], 'params' => [ 'Bucket' => 'arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap', 'Region' => 'us-east-1', 'DisableMultiRegionAccessPoints' => false, 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'MRAP does not support FIPS', 'expect' => [ 'error' => 'S3 MRAP does not support FIPS', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::UseFIPS' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap', 'Key' => 'key', ], ], ], 'params' => [ 'Bucket' => 'arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap', 'Region' => 'us-east-1', 'DisableMultiRegionAccessPoints' => false, 'UseFIPS' => true, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'MRAP does not support DualStack', 'expect' => [ 'error' => 'S3 MRAP does not support dual-stack', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::UseDualStack' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap', 'Key' => 'key', ], ], ], 'params' => [ 'Bucket' => 'arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap', 'Region' => 'us-east-1', 'DisableMultiRegionAccessPoints' => false, 'UseFIPS' => false, 'UseDualStack' => true, 'Accelerate' => false, ], ], [ 'documentation' => 'MRAP does not support S3 Accelerate', 'expect' => [ 'error' => 'S3 MRAP does not support S3 Accelerate', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::S3::Accelerate' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap', 'Key' => 'key', ], ], ], 'params' => [ 'Bucket' => 'arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap', 'Region' => 'us-east-1', 'DisableMultiRegionAccessPoints' => false, 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => true, ], ], [ 'documentation' => 'MRAP explicitly disabled', 'expect' => [ 'error' => 'Invalid configuration: Multi-Region Access Point ARNs are disabled.', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::S3::DisableMultiRegionAccessPoints' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap', 'Key' => 'key', ], ], ], 'params' => [ 'Bucket' => 'arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap', 'Region' => 'us-east-1', 'DisableMultiRegionAccessPoints' => true, 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'Dual-stack endpoint with path-style forced', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.dualstack.us-west-2.amazonaws.com/bucketname', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::UseDualStack' => true, 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucketname', 'Key' => 'key', ], ], ], 'params' => [ 'Bucket' => 'bucketname', 'Region' => 'us-west-2', 'ForcePathStyle' => true, 'UseFIPS' => false, 'Accelerate' => false, 'UseDualStack' => true, ], ], [ 'documentation' => 'Dual-stack endpoint + SDK::Host is error', 'expect' => [ 'error' => 'Cannot set dual-stack in combination with a custom endpoint.', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::UseDualStack' => true, 'SDK::Endpoint' => 'https://abc.com', 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucketname', 'Key' => 'key', ], ], ], 'params' => [ 'Bucket' => 'bucketname', 'Region' => 'us-west-2', 'ForcePathStyle' => true, 'UseFIPS' => false, 'Accelerate' => false, 'UseDualStack' => true, 'Endpoint' => 'https://abc.com', ], ], [ 'documentation' => 'path style + ARN bucket', 'expect' => [ 'error' => 'Path-style addressing cannot be used with ARN buckets', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap', 'ForcePathStyle' => true, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'implicit path style bucket + dualstack', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.dualstack.us-west-2.amazonaws.com/99_ab', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::UseDualStack' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => '99_ab', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => '99_ab', 'Region' => 'us-west-2', 'UseDualStack' => true, 'UseFIPS' => false, ], ], [ 'documentation' => 'implicit path style bucket + dualstack', 'expect' => [ 'error' => 'Cannot set dual-stack in combination with a custom endpoint.', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::UseDualStack' => true, 'SDK::Endpoint' => 'http://abc.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => '99_ab', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => '99_ab', 'Region' => 'us-west-2', 'UseDualStack' => true, 'UseFIPS' => false, 'Endpoint' => 'http://abc.com', ], ], [ 'documentation' => 'don\'t allow URL injections in the bucket', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.us-west-2.amazonaws.com/example.com%23', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'example.com#', 'Key' => 'key', ], ], ], 'params' => [ 'Bucket' => 'example.com#', 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'URI encode bucket names in the path', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.us-west-2.amazonaws.com/bucket%20name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket name', 'Key' => 'key', ], ], ], 'params' => [ 'Bucket' => 'bucket name', 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'scheme is respected', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/99_ab', ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => '99_ab', 'Endpoint' => 'http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'scheme is respected (virtual addressing)', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'http://bucketname.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/foo', ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucketname', 'Endpoint' => 'http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/foo', 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'path style + implicit private link', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/99_ab', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'SDK::Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => '99_ab', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => '99_ab', 'Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'invalid Endpoint override', 'expect' => [ 'error' => 'Custom endpoint `abcde://nota#url` was not a valid URI', ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucketname', 'Endpoint' => 'abcde://nota#url', 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'using an IPv4 address forces path style', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://123.123.0.1/bucketname', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'SDK::Endpoint' => 'https://123.123.0.1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucketname', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucketname', 'Endpoint' => 'https://123.123.0.1', 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'vanilla access point arn with region mismatch and UseArnRegion=false', 'expect' => [ 'error' => 'Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::UseArnRegion' => false, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-east-1:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3:us-east-1:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'UseArnRegion' => false, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'vanilla access point arn with region mismatch and UseArnRegion unset', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'Region' => 'us-east-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'vanilla access point arn with region mismatch and UseArnRegion=true', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::S3::UseArnRegion' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'UseArnRegion' => true, 'Region' => 'us-east-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'subdomains are not allowed in virtual buckets', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'https://s3.us-east-1.amazonaws.com/bucket.name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket.name', 'Key' => 'key', ], ], ], 'params' => [ 'Bucket' => 'bucket.name', 'Region' => 'us-east-1', ], ], [ 'documentation' => 'bucket names with 3 characters are allowed in virtual buckets', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'https://aaa.s3.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'aaa', 'Key' => 'key', ], ], ], 'params' => [ 'Bucket' => 'aaa', 'Region' => 'us-east-1', ], ], [ 'documentation' => 'bucket names with fewer than 3 characters are not allowed in virtual host', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'https://s3.us-east-1.amazonaws.com/aa', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'aa', 'Key' => 'key', ], ], ], 'params' => [ 'Bucket' => 'aa', 'Region' => 'us-east-1', ], ], [ 'documentation' => 'bucket names with uppercase characters are not allowed in virtual host', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'https://s3.us-east-1.amazonaws.com/BucketName', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'BucketName', 'Key' => 'key', ], ], ], 'params' => [ 'Bucket' => 'BucketName', 'Region' => 'us-east-1', ], ], [ 'documentation' => 'subdomains are allowed in virtual buckets on http endpoints', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'http://bucket.name.example.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'SDK::Endpoint' => 'http://example.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket.name', 'Key' => 'key', ], ], ], 'params' => [ 'Bucket' => 'bucket.name', 'Region' => 'us-east-1', 'Endpoint' => 'http://example.com', ], ], [ 'documentation' => 'no region set', 'expect' => [ 'error' => 'A region must be set when sending requests to S3.', ], 'params' => [ 'Bucket' => 'bucket-name', ], ], [ 'documentation' => 'UseGlobalEndpoints=true, region=us-east-1 uses the global endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'ListBuckets', ], ], 'params' => [ 'Region' => 'us-east-1', 'UseGlobalEndpoint' => true, 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'UseGlobalEndpoints=true, region=us-west-2 uses the regional endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'ListBuckets', ], ], 'params' => [ 'Region' => 'us-west-2', 'UseGlobalEndpoint' => true, 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'UseGlobalEndpoints=true, region=cn-north-1 uses the regional endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'cn-north-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.cn-north-1.amazonaws.com.cn', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'ListBuckets', ], ], 'params' => [ 'Region' => 'cn-north-1', 'UseGlobalEndpoint' => true, 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'UseGlobalEndpoints=true, region=us-east-1, fips=true uses the regional endpoint with fips', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3-fips.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::UseFIPS' => true, 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'ListBuckets', ], ], 'params' => [ 'Region' => 'us-east-1', 'UseGlobalEndpoint' => true, 'UseFIPS' => true, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'UseGlobalEndpoints=true, region=us-east-1, dualstack=true uses the regional endpoint with dualstack', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.dualstack.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::UseDualStack' => true, 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'ListBuckets', ], ], 'params' => [ 'Region' => 'us-east-1', 'UseGlobalEndpoint' => true, 'UseFIPS' => false, 'UseDualStack' => true, 'Accelerate' => false, ], ], [ 'documentation' => 'UseGlobalEndpoints=true, region=us-east-1, dualstack and fips uses the regional endpoint with fips/dualstack', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3-fips.dualstack.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::UseFIPS' => true, 'AWS::UseDualStack' => true, 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'ListBuckets', ], ], 'params' => [ 'Region' => 'us-east-1', 'UseGlobalEndpoint' => true, 'UseFIPS' => true, 'UseDualStack' => true, 'Accelerate' => false, ], ], [ 'documentation' => 'UseGlobalEndpoints=true, region=us-east-1 with custom endpoint, uses custom', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://example.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'SDK::Endpoint' => 'https://example.com', 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'ListBuckets', ], ], 'params' => [ 'Region' => 'us-east-1', 'Endpoint' => 'https://example.com', 'UseGlobalEndpoint' => true, 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'UseGlobalEndpoints=true, region=us-west-2 with custom endpoint, uses custom', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://example.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'SDK::Endpoint' => 'https://example.com', 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'ListBuckets', ], ], 'params' => [ 'Region' => 'us-west-2', 'Endpoint' => 'https://example.com', 'UseGlobalEndpoint' => true, 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'UseGlobalEndpoints=true, region=us-east-1 with accelerate on non bucket case uses the global endpoint and ignores accelerate', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::S3::Accelerate' => true, 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'ListBuckets', ], ], 'params' => [ 'Region' => 'us-east-1', 'UseGlobalEndpoint' => true, 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => true, ], ], [ 'documentation' => 'aws-global region uses the global endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', ], 'operationName' => 'ListBuckets', ], ], 'params' => [ 'Region' => 'aws-global', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'aws-global region with fips uses the regional endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3-fips.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', 'AWS::UseFIPS' => true, ], 'operationName' => 'ListBuckets', ], ], 'params' => [ 'Region' => 'aws-global', 'UseFIPS' => true, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'aws-global region with dualstack uses the regional endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.dualstack.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', 'AWS::UseDualStack' => true, ], 'operationName' => 'ListBuckets', ], ], 'params' => [ 'Region' => 'aws-global', 'UseFIPS' => false, 'UseDualStack' => true, 'Accelerate' => false, ], ], [ 'documentation' => 'aws-global region with fips and dualstack uses the regional endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3-fips.dualstack.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', 'AWS::UseFIPS' => true, 'AWS::UseDualStack' => true, ], 'operationName' => 'ListBuckets', ], ], 'params' => [ 'Region' => 'aws-global', 'UseFIPS' => true, 'UseDualStack' => true, 'Accelerate' => false, ], ], [ 'documentation' => 'aws-global region with accelerate on non-bucket case, uses global endpoint and ignores accelerate', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', 'AWS::S3::Accelerate' => true, ], 'operationName' => 'ListBuckets', ], ], 'params' => [ 'Region' => 'aws-global', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => true, ], ], [ 'documentation' => 'aws-global region with custom endpoint, uses custom', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://example.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', 'SDK::Endpoint' => 'https://example.com', ], 'operationName' => 'ListBuckets', ], ], 'params' => [ 'Region' => 'aws-global', 'Endpoint' => 'https://example.com', 'UseGlobalEndpoint' => false, 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'virtual addressing, aws-global region uses the global endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket-name', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'virtual addressing, aws-global region with Prefix, and Key uses the global endpoint. Prefix and Key parameters should not be used in endpoint evaluation.', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', ], 'operationName' => 'ListObjects', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Prefix' => 'prefix', ], ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket-name', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'Prefix' => 'prefix', 'Key' => 'key', ], ], [ 'documentation' => 'virtual addressing, aws-global region with fips uses the regional fips endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3-fips.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', 'AWS::UseFIPS' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket-name', 'UseFIPS' => true, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'virtual addressing, aws-global region with dualstack uses the regional dualstack endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3.dualstack.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', 'AWS::UseDualStack' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket-name', 'UseFIPS' => false, 'UseDualStack' => true, 'Accelerate' => false, ], ], [ 'documentation' => 'virtual addressing, aws-global region with fips/dualstack uses the regional fips/dualstack endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3-fips.dualstack.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', 'AWS::UseFIPS' => true, 'AWS::UseDualStack' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket-name', 'UseFIPS' => true, 'UseDualStack' => true, 'Accelerate' => false, ], ], [ 'documentation' => 'virtual addressing, aws-global region with accelerate uses the global accelerate endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3-accelerate.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', 'AWS::S3::Accelerate' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket-name', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => true, ], ], [ 'documentation' => 'virtual addressing, aws-global region with custom endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.example.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', 'SDK::Endpoint' => 'https://example.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'aws-global', 'Endpoint' => 'https://example.com', 'Bucket' => 'bucket-name', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'virtual addressing, UseGlobalEndpoint and us-east-1 region uses the global endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'UseGlobalEndpoint' => true, 'Bucket' => 'bucket-name', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'virtual addressing, UseGlobalEndpoint and us-west-2 region uses the regional endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-west-2', 'UseGlobalEndpoint' => true, 'Bucket' => 'bucket-name', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'virtual addressing, UseGlobalEndpoint and us-east-1 region and fips uses the regional fips endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3-fips.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::UseFIPS' => true, 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'UseGlobalEndpoint' => true, 'Bucket' => 'bucket-name', 'UseFIPS' => true, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'virtual addressing, UseGlobalEndpoint and us-east-1 region and dualstack uses the regional dualstack endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3.dualstack.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::UseDualStack' => true, 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'UseGlobalEndpoint' => true, 'Bucket' => 'bucket-name', 'UseFIPS' => false, 'UseDualStack' => true, 'Accelerate' => false, ], ], [ 'documentation' => 'virtual addressing, UseGlobalEndpoint and us-east-1 region and accelerate uses the global accelerate endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3-accelerate.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::S3::Accelerate' => true, 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'UseGlobalEndpoint' => true, 'Bucket' => 'bucket-name', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => true, ], ], [ 'documentation' => 'virtual addressing, UseGlobalEndpoint and us-east-1 region with custom endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.example.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'SDK::Endpoint' => 'https://example.com', 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'Endpoint' => 'https://example.com', 'UseGlobalEndpoint' => true, 'Bucket' => 'bucket-name', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'ForcePathStyle, aws-global region uses the global endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.amazonaws.com/bucket-name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'ForcePathStyle, aws-global region with fips is invalid', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, 'name' => 'sigv4', ], ], ], 'url' => 'https://s3-fips.us-east-1.amazonaws.com/bucket-name', ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'UseFIPS' => true, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'ForcePathStyle, aws-global region with dualstack uses regional dualstack endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.dualstack.us-east-1.amazonaws.com/bucket-name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', 'AWS::UseDualStack' => true, 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'UseFIPS' => false, 'UseDualStack' => true, 'Accelerate' => false, ], ], [ 'documentation' => 'ForcePathStyle, aws-global region custom endpoint uses the custom endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://example.com/bucket-name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', 'SDK::Endpoint' => 'https://example.com', 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'aws-global', 'Endpoint' => 'https://example.com', 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'ForcePathStyle, UseGlobalEndpoint us-east-1 region uses the global endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.amazonaws.com/bucket-name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::S3::ForcePathStyle' => true, 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket-name', 'UseGlobalEndpoint' => true, 'ForcePathStyle' => true, 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'ForcePathStyle, UseGlobalEndpoint us-west-2 region uses the regional endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.us-west-2.amazonaws.com/bucket-name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::ForcePathStyle' => true, 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-west-2', 'Bucket' => 'bucket-name', 'UseGlobalEndpoint' => true, 'ForcePathStyle' => true, 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'ForcePathStyle, UseGlobalEndpoint us-east-1 region, dualstack uses the regional dualstack endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.dualstack.us-east-1.amazonaws.com/bucket-name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::UseDualStack' => true, 'AWS::S3::ForcePathStyle' => true, 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket-name', 'UseGlobalEndpoint' => true, 'ForcePathStyle' => true, 'UseFIPS' => false, 'UseDualStack' => true, 'Accelerate' => false, ], ], [ 'documentation' => 'ForcePathStyle, UseGlobalEndpoint us-east-1 region custom endpoint uses the custom endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://example.com/bucket-name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'SDK::Endpoint' => 'https://example.com', 'AWS::S3::ForcePathStyle' => true, 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket-name', 'Endpoint' => 'https://example.com', 'UseGlobalEndpoint' => true, 'ForcePathStyle' => true, 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'ARN with aws-global region and UseArnRegion uses the regional endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-outposts', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://reports-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', 'AWS::S3::UseArnRegion' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456/accesspoint/reports', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'aws-global', 'UseArnRegion' => true, 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'Bucket' => 'arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456/accesspoint/reports', ], ], [ 'documentation' => 'cross partition MRAP ARN is an error', 'expect' => [ 'error' => 'Client was configured for partition `aws` but bucket referred to partition `aws-cn`', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws-cn:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap', 'Key' => 'key', ], ], ], 'params' => [ 'Bucket' => 'arn:aws-cn:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap', 'Region' => 'us-west-1', ], ], [ 'documentation' => 'Endpoint override, accesspoint with HTTP, port', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'http://myendpoint-123456789012.beta.example.com:1234', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'SDK::Endpoint' => 'http://beta.example.com:1234', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Endpoint' => 'http://beta.example.com:1234', 'Region' => 'us-west-2', 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', ], ], [ 'documentation' => 'Endpoint override, accesspoint with http, path, query, and port', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'http://myendpoint-123456789012.beta.example.com:1234/path', ], ], 'params' => [ 'Region' => 'us-west-2', 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'Endpoint' => 'http://beta.example.com:1234/path', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'non-bucket endpoint override with FIPS = error', 'expect' => [ 'error' => 'A custom endpoint cannot be combined with FIPS', ], 'params' => [ 'Region' => 'us-west-2', 'Endpoint' => 'http://beta.example.com:1234/path', 'UseFIPS' => true, 'UseDualStack' => false, ], ], [ 'documentation' => 'FIPS + dualstack + custom endpoint', 'expect' => [ 'error' => 'Cannot set dual-stack in combination with a custom endpoint.', ], 'params' => [ 'Region' => 'us-west-2', 'Endpoint' => 'http://beta.example.com:1234/path', 'UseFIPS' => true, 'UseDualStack' => true, ], ], [ 'documentation' => 'dualstack + custom endpoint', 'expect' => [ 'error' => 'Cannot set dual-stack in combination with a custom endpoint.', ], 'params' => [ 'Region' => 'us-west-2', 'Endpoint' => 'http://beta.example.com:1234/path', 'UseFIPS' => false, 'UseDualStack' => true, ], ], [ 'documentation' => 'custom endpoint without FIPS/dualstack', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'http://beta.example.com:1234/path', ], ], 'params' => [ 'Region' => 'us-west-2', 'Endpoint' => 'http://beta.example.com:1234/path', 'UseFIPS' => false, 'UseDualStack' => false, ], ], [ 'documentation' => 's3 object lambda with access points disabled', 'expect' => [ 'error' => 'Access points are not supported for this operation', ], 'params' => [ 'Region' => 'us-west-2', 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:myendpoint', 'DisableAccessPoints' => true, ], ], [ 'documentation' => 'non bucket + FIPS', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3-fips.us-west-2.amazonaws.com', ], ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => true, 'UseDualStack' => false, ], ], [ 'documentation' => 'standard non bucket endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.us-west-2.amazonaws.com', ], ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, ], ], [ 'documentation' => 'non bucket endpoint with FIPS + Dualstack', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3-fips.dualstack.us-west-2.amazonaws.com', ], ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => true, 'UseDualStack' => true, ], ], [ 'documentation' => 'non bucket endpoint with dualstack', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.dualstack.us-west-2.amazonaws.com', ], ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => true, ], ], [ 'documentation' => 'use global endpoint + IP address endpoint override', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'http://127.0.0.1/bucket', ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket', 'UseFIPS' => false, 'UseDualStack' => false, 'Endpoint' => 'http://127.0.0.1', 'UseGlobalEndpoint' => true, ], ], [ 'documentation' => 'non-dns endpoint + global endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'https://s3.amazonaws.com/bucket%21', ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket!', 'UseFIPS' => false, 'UseDualStack' => false, 'UseGlobalEndpoint' => true, ], ], [ 'documentation' => 'endpoint override + use global endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'http://foo.com/bucket%21', ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket!', 'UseFIPS' => false, 'UseDualStack' => false, 'UseGlobalEndpoint' => true, 'Endpoint' => 'http://foo.com', ], ], [ 'documentation' => 'FIPS + dualstack + non-bucket endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21', ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket!', 'UseFIPS' => true, 'UseDualStack' => true, ], ], [ 'documentation' => 'FIPS + dualstack + non-DNS endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21', ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket!', 'ForcePathStyle' => true, 'UseFIPS' => true, 'UseDualStack' => true, ], ], [ 'documentation' => 'endpoint override + FIPS + dualstack (BUG)', 'expect' => [ 'error' => 'A custom endpoint cannot be combined with FIPS', ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket!', 'ForcePathStyle' => true, 'UseFIPS' => true, 'UseDualStack' => false, 'Endpoint' => 'http://foo.com', ], ], [ 'documentation' => 'endpoint override + non-dns bucket + FIPS (BUG)', 'expect' => [ 'error' => 'A custom endpoint cannot be combined with FIPS', ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket!', 'UseFIPS' => true, 'UseDualStack' => false, 'Endpoint' => 'http://foo.com', ], ], [ 'documentation' => 'FIPS + bucket endpoint + force path style', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'https://s3-fips.us-east-1.amazonaws.com/bucket%21', ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket!', 'ForcePathStyle' => true, 'UseFIPS' => true, 'UseDualStack' => false, 'UseGlobalEndpoint' => true, ], ], [ 'documentation' => 'bucket + FIPS + force path style', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket', ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket', 'ForcePathStyle' => true, 'UseFIPS' => true, 'UseDualStack' => true, 'UseGlobalEndpoint' => true, ], ], [ 'documentation' => 'FIPS + dualstack + use global endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'https://bucket.s3-fips.dualstack.us-east-1.amazonaws.com', ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket', 'UseFIPS' => true, 'UseDualStack' => true, 'UseGlobalEndpoint' => true, ], ], [ 'documentation' => 'URI encoded bucket + use global endpoint', 'expect' => [ 'error' => 'A custom endpoint cannot be combined with FIPS', ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket!', 'UseFIPS' => true, 'UseDualStack' => false, 'UseGlobalEndpoint' => true, 'Endpoint' => 'https://foo.com', ], ], [ 'documentation' => 'FIPS + path based endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'https://s3-fips.us-east-1.amazonaws.com/bucket%21', ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket!', 'UseFIPS' => true, 'UseDualStack' => false, 'Accelerate' => false, 'UseGlobalEndpoint' => true, ], ], [ 'documentation' => 'accelerate + dualstack + global endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'https://bucket.s3-accelerate.dualstack.amazonaws.com', ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket', 'UseFIPS' => false, 'UseDualStack' => true, 'Accelerate' => true, 'UseGlobalEndpoint' => true, ], ], [ 'documentation' => 'dualstack + global endpoint + non URI safe bucket', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'https://s3.dualstack.us-east-1.amazonaws.com/bucket%21', ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket!', 'Accelerate' => false, 'UseDualStack' => true, 'UseFIPS' => false, 'UseGlobalEndpoint' => true, ], ], [ 'documentation' => 'FIPS + uri encoded bucket', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'https://s3-fips.us-east-1.amazonaws.com/bucket%21', ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket!', 'ForcePathStyle' => true, 'Accelerate' => false, 'UseDualStack' => false, 'UseFIPS' => true, 'UseGlobalEndpoint' => true, ], ], [ 'documentation' => 'endpoint override + non-uri safe endpoint + force path style', 'expect' => [ 'error' => 'A custom endpoint cannot be combined with FIPS', ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket!', 'ForcePathStyle' => true, 'Accelerate' => false, 'UseDualStack' => false, 'UseFIPS' => true, 'Endpoint' => 'http://foo.com', 'UseGlobalEndpoint' => true, ], ], [ 'documentation' => 'FIPS + Dualstack + global endpoint + non-dns bucket', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east-1', ], ], ], 'url' => 'https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21', ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'bucket!', 'Accelerate' => false, 'UseDualStack' => true, 'UseFIPS' => true, 'UseGlobalEndpoint' => true, ], ], [ 'documentation' => 'endpoint override + FIPS + dualstack', 'expect' => [ 'error' => 'Cannot set dual-stack in combination with a custom endpoint.', ], 'params' => [ 'Region' => 'us-east-1', 'UseDualStack' => true, 'UseFIPS' => true, 'UseGlobalEndpoint' => true, 'Endpoint' => 'http://foo.com', ], ], [ 'documentation' => 'non-bucket endpoint override + dualstack + global endpoint', 'expect' => [ 'error' => 'Cannot set dual-stack in combination with a custom endpoint.', ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => false, 'UseDualStack' => true, 'UseGlobalEndpoint' => true, 'Endpoint' => 'http://foo.com', ], ], [ 'documentation' => 'Endpoint override + UseGlobalEndpoint + us-east-1', 'expect' => [ 'error' => 'A custom endpoint cannot be combined with FIPS', ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => true, 'UseDualStack' => false, 'UseGlobalEndpoint' => true, 'Endpoint' => 'http://foo.com', ], ], [ 'documentation' => 'non-FIPS partition with FIPS set + custom endpoint', 'expect' => [ 'error' => 'Partition does not support FIPS', ], 'params' => [ 'Region' => 'cn-north-1', 'UseFIPS' => true, 'UseDualStack' => false, 'UseGlobalEndpoint' => true, ], ], [ 'documentation' => 'aws-global signs as us-east-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingRegion' => 'us-east-1', 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21', ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket!', 'UseFIPS' => true, 'Accelerate' => false, 'UseDualStack' => true, ], ], [ 'documentation' => 'aws-global signs as us-east-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingRegion' => 'us-east-1', 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket.foo.com', ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket', 'UseDualStack' => false, 'UseFIPS' => false, 'Accelerate' => false, 'Endpoint' => 'https://foo.com', ], ], [ 'documentation' => 'aws-global + dualstack + path-only bucket', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingRegion' => 'us-east-1', 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.dualstack.us-east-1.amazonaws.com/bucket%21', ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket!', 'UseDualStack' => true, 'UseFIPS' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'aws-global + path-only bucket', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingRegion' => 'us-east-1', 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.amazonaws.com/bucket%21', ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket!', ], ], [ 'documentation' => 'aws-global + fips + custom endpoint', 'expect' => [ 'error' => 'A custom endpoint cannot be combined with FIPS', ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket!', 'UseDualStack' => false, 'UseFIPS' => true, 'Accelerate' => false, 'Endpoint' => 'http://foo.com', ], ], [ 'documentation' => 'aws-global, endpoint override & path only-bucket', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingRegion' => 'us-east-1', 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'http://foo.com/bucket%21', ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket!', 'UseDualStack' => false, 'UseFIPS' => false, 'Accelerate' => false, 'Endpoint' => 'http://foo.com', ], ], [ 'documentation' => 'aws-global + dualstack + custom endpoint', 'expect' => [ 'error' => 'Cannot set dual-stack in combination with a custom endpoint.', ], 'params' => [ 'Region' => 'aws-global', 'UseDualStack' => true, 'UseFIPS' => false, 'Accelerate' => false, 'Endpoint' => 'http://foo.com', ], ], [ 'documentation' => 'accelerate, dualstack + aws-global', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingRegion' => 'us-east-1', 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket.s3-accelerate.dualstack.us-east-1.amazonaws.com', ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket', 'UseDualStack' => true, 'UseFIPS' => false, 'Accelerate' => true, ], ], [ 'documentation' => 'FIPS + aws-global + path only bucket. This is not supported by S3 but we allow garbage in garbage out', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingRegion' => 'us-east-1', 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21', ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket!', 'ForcePathStyle' => true, 'UseDualStack' => true, 'UseFIPS' => true, 'Accelerate' => false, ], ], [ 'documentation' => 'aws-global + FIPS + endpoint override.', 'expect' => [ 'error' => 'A custom endpoint cannot be combined with FIPS', ], 'params' => [ 'Region' => 'aws-global', 'UseFIPS' => true, 'Endpoint' => 'http://foo.com', ], ], [ 'documentation' => 'force path style, FIPS, aws-global & endpoint override', 'expect' => [ 'error' => 'A custom endpoint cannot be combined with FIPS', ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket!', 'ForcePathStyle' => true, 'UseFIPS' => true, 'Endpoint' => 'http://foo.com', ], ], [ 'documentation' => 'ip address causes path style to be forced', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingRegion' => 'us-east-1', 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'http://192.168.1.1/bucket', ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket', 'Endpoint' => 'http://192.168.1.1', ], ], [ 'documentation' => 'endpoint override with aws-global region', 'expect' => [ 'error' => 'Cannot set dual-stack in combination with a custom endpoint.', ], 'params' => [ 'Region' => 'aws-global', 'UseFIPS' => true, 'UseDualStack' => true, 'Endpoint' => 'http://foo.com', ], ], [ 'documentation' => 'FIPS + path-only (TODO: consider making this an error)', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingRegion' => 'us-east-1', 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3-fips.us-east-1.amazonaws.com/bucket%21', ], ], 'params' => [ 'Region' => 'aws-global', 'Bucket' => 'bucket!', 'UseFIPS' => true, ], ], [ 'documentation' => 'empty arn type', 'expect' => [ 'error' => 'Invalid ARN: No ARN type specified', ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'arn:aws:not-s3:us-west-2:123456789012::myendpoint', ], ], [ 'documentation' => 'path style can\'t be used with accelerate', 'expect' => [ 'error' => 'Path-style addressing cannot be used with S3 Accelerate', ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'bucket!', 'Accelerate' => true, ], ], [ 'documentation' => 'invalid region', 'expect' => [ 'error' => 'Invalid region: region was not a valid DNS name.', ], 'params' => [ 'Region' => 'us-east-2!', 'Bucket' => 'bucket.subdomain', 'Endpoint' => 'http://foo.com', ], ], [ 'documentation' => 'invalid region', 'expect' => [ 'error' => 'Invalid region: region was not a valid DNS name.', ], 'params' => [ 'Region' => 'us-east-2!', 'Bucket' => 'bucket', 'Endpoint' => 'http://foo.com', ], ], [ 'documentation' => 'empty arn type', 'expect' => [ 'error' => 'Invalid Access Point Name', ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'arn:aws:s3::123456789012:accesspoint:my_endpoint', ], ], [ 'documentation' => 'empty arn type', 'expect' => [ 'error' => 'Client was configured for partition `aws` but ARN (`arn:aws:s3:cn-north-1:123456789012:accesspoint:my-endpoint`) has `aws-cn`', ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'arn:aws:s3:cn-north-1:123456789012:accesspoint:my-endpoint', 'UseArnRegion' => true, ], ], [ 'documentation' => 'invalid arn region', 'expect' => [ 'error' => 'Invalid region in ARN: `us-east_2` (invalid DNS name)', ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'arn:aws:s3-object-lambda:us-east_2:123456789012:accesspoint:my-endpoint', 'UseArnRegion' => true, ], ], [ 'documentation' => 'invalid ARN outpost', 'expect' => [ 'error' => 'Invalid ARN: The outpost Id may only contain a-z, A-Z, 0-9 and `-`. Found: `op_01234567890123456`', ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'arn:aws:s3-outposts:us-east-1:123456789012:outpost/op_01234567890123456/accesspoint/reports', 'UseArnRegion' => true, ], ], [ 'documentation' => 'invalid ARN', 'expect' => [ 'error' => 'Invalid ARN: expected an access point name', ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456/reports', ], ], [ 'documentation' => 'invalid ARN', 'expect' => [ 'error' => 'Invalid ARN: Expected a 4-component resource', ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456', ], ], [ 'documentation' => 'invalid outpost type', 'expect' => [ 'error' => 'Expected an outpost type `accesspoint`, found not-accesspoint', ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456/not-accesspoint/reports', ], ], [ 'documentation' => 'invalid outpost type', 'expect' => [ 'error' => 'Invalid region in ARN: `us-east_1` (invalid DNS name)', ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'arn:aws:s3-outposts:us-east_1:123456789012:outpost/op-01234567890123456/not-accesspoint/reports', ], ], [ 'documentation' => 'invalid outpost type', 'expect' => [ 'error' => 'Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `12345_789012`', ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'arn:aws:s3-outposts:us-east-1:12345_789012:outpost/op-01234567890123456/not-accesspoint/reports', ], ], [ 'documentation' => 'invalid outpost type', 'expect' => [ 'error' => 'Invalid ARN: The Outpost Id was not set', ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'arn:aws:s3-outposts:us-east-1:12345789012:outpost', ], ], [ 'documentation' => 'use global endpoint virtual addressing', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingRegion' => 'us-east-2', 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'http://bucket.example.com', ], ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'bucket', 'Endpoint' => 'http://example.com', 'UseGlobalEndpoint' => true, ], ], [ 'documentation' => 'global endpoint + ip address', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingRegion' => 'us-east-2', 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'http://192.168.0.1/bucket', ], ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'bucket', 'Endpoint' => 'http://192.168.0.1', 'UseGlobalEndpoint' => true, ], ], [ 'documentation' => 'invalid outpost type', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingRegion' => 'us-east-2', 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.us-east-2.amazonaws.com/bucket%21', ], ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'bucket!', 'UseGlobalEndpoint' => true, ], ], [ 'documentation' => 'invalid outpost type', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingRegion' => 'us-east-2', 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket.s3-accelerate.amazonaws.com', ], ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'bucket', 'Accelerate' => true, 'UseGlobalEndpoint' => true, ], ], [ 'documentation' => 'use global endpoint + custom endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingRegion' => 'us-east-2', 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'http://foo.com/bucket%21', ], ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'bucket!', 'UseGlobalEndpoint' => true, 'Endpoint' => 'http://foo.com', ], ], [ 'documentation' => 'use global endpoint, not us-east-1, force path style', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingRegion' => 'us-east-2', 'name' => 'sigv4', 'signingName' => 's3', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'http://foo.com/bucket%21', ], ], 'params' => [ 'Region' => 'us-east-2', 'Bucket' => 'bucket!', 'UseGlobalEndpoint' => true, 'ForcePathStyle' => true, 'Endpoint' => 'http://foo.com', ], ], [ 'documentation' => 'vanilla virtual addressing@us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'virtual addressing + dualstack@us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3.dualstack.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::UseDualStack' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'us-west-2', 'UseDualStack' => true, 'UseFIPS' => false, ], ], [ 'documentation' => 'accelerate + dualstack@us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3-accelerate.dualstack.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::UseDualStack' => true, 'AWS::S3::Accelerate' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => true, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'us-west-2', 'UseDualStack' => true, 'UseFIPS' => false, ], ], [ 'documentation' => 'accelerate (dualstack=false)@us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3-accelerate.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::Accelerate' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => true, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'virtual addressing + fips@us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3-fips.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::UseFIPS' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => true, ], ], [ 'documentation' => 'virtual addressing + dualstack + fips@us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3-fips.dualstack.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::UseFIPS' => true, 'AWS::UseDualStack' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'us-west-2', 'UseDualStack' => true, 'UseFIPS' => true, ], ], [ 'documentation' => 'accelerate + fips = error@us-west-2', 'expect' => [ 'error' => 'Accelerate cannot be used with FIPS', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::UseFIPS' => true, 'AWS::S3::Accelerate' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => true, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => true, ], ], [ 'documentation' => 'vanilla virtual addressing@cn-north-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'cn-north-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3.cn-north-1.amazonaws.com.cn', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'cn-north-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'virtual addressing + dualstack@cn-north-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'cn-north-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3.dualstack.cn-north-1.amazonaws.com.cn', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', 'AWS::UseDualStack' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'cn-north-1', 'UseDualStack' => true, 'UseFIPS' => false, ], ], [ 'documentation' => 'accelerate (dualstack=false)@cn-north-1', 'expect' => [ 'error' => 'S3 Accelerate cannot be used in this region', ], 'params' => [ 'Accelerate' => true, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'cn-north-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'virtual addressing + fips@cn-north-1', 'expect' => [ 'error' => 'Partition does not support FIPS', ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'cn-north-1', 'UseDualStack' => false, 'UseFIPS' => true, ], ], [ 'documentation' => 'vanilla virtual addressing@af-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3.af-south-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'virtual addressing + dualstack@af-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3.dualstack.af-south-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'AWS::UseDualStack' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'af-south-1', 'UseDualStack' => true, 'UseFIPS' => false, ], ], [ 'documentation' => 'accelerate + dualstack@af-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3-accelerate.dualstack.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'AWS::UseDualStack' => true, 'AWS::S3::Accelerate' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => true, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'af-south-1', 'UseDualStack' => true, 'UseFIPS' => false, ], ], [ 'documentation' => 'accelerate (dualstack=false)@af-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3-accelerate.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'AWS::S3::Accelerate' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => true, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'virtual addressing + fips@af-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3-fips.af-south-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'AWS::UseFIPS' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => true, ], ], [ 'documentation' => 'virtual addressing + dualstack + fips@af-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.s3-fips.dualstack.af-south-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'AWS::UseFIPS' => true, 'AWS::UseDualStack' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'af-south-1', 'UseDualStack' => true, 'UseFIPS' => true, ], ], [ 'documentation' => 'accelerate + fips = error@af-south-1', 'expect' => [ 'error' => 'Accelerate cannot be used with FIPS', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'AWS::UseFIPS' => true, 'AWS::S3::Accelerate' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => true, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => true, ], ], [ 'documentation' => 'vanilla path style@us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.us-west-2.amazonaws.com/bucket-name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'fips@us-gov-west-2, bucket is not S3-dns-compatible (subdomains)', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingName' => 's3', 'signingRegion' => 'us-gov-west-1', 'disableDoubleEncoding' => true, 'name' => 'sigv4', ], ], ], 'url' => 'https://s3-fips.us-gov-west-1.amazonaws.com/bucket.with.dots', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-gov-west-1', 'AWS::UseFIPS' => true, 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket.with.dots', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket.with.dots', 'Region' => 'us-gov-west-1', 'UseDualStack' => false, 'UseFIPS' => true, ], ], [ 'documentation' => 'path style + accelerate = error@us-west-2', 'expect' => [ 'error' => 'Path-style addressing cannot be used with S3 Accelerate', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::ForcePathStyle' => true, 'AWS::S3::Accelerate' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => true, 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'path style + dualstack@us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.dualstack.us-west-2.amazonaws.com/bucket-name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::UseDualStack' => true, 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'Region' => 'us-west-2', 'UseDualStack' => true, 'UseFIPS' => false, ], ], [ 'documentation' => 'path style + arn is error@us-west-2', 'expect' => [ 'error' => 'Path-style addressing cannot be used with ARN buckets', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket', 'ForcePathStyle' => true, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'path style + invalid DNS name@us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.us-west-2.amazonaws.com/99a_b', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => '99a_b', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => '99a_b', 'ForcePathStyle' => true, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'no path style + invalid DNS name@us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.us-west-2.amazonaws.com/99a_b', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => '99a_b', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => '99a_b', 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'vanilla path style@cn-north-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'cn-north-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.cn-north-1.amazonaws.com.cn/bucket-name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'Region' => 'cn-north-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'path style + fips@cn-north-1', 'expect' => [ 'error' => 'Partition does not support FIPS', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', 'AWS::UseFIPS' => true, 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'Region' => 'cn-north-1', 'UseDualStack' => false, 'UseFIPS' => true, ], ], [ 'documentation' => 'path style + accelerate = error@cn-north-1', 'expect' => [ 'error' => 'Path-style addressing cannot be used with S3 Accelerate', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', 'AWS::S3::ForcePathStyle' => true, 'AWS::S3::Accelerate' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => true, 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'Region' => 'cn-north-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'path style + dualstack@cn-north-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'cn-north-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.dualstack.cn-north-1.amazonaws.com.cn/bucket-name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', 'AWS::UseDualStack' => true, 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'Region' => 'cn-north-1', 'UseDualStack' => true, 'UseFIPS' => false, ], ], [ 'documentation' => 'path style + arn is error@cn-north-1', 'expect' => [ 'error' => 'Path-style addressing cannot be used with ARN buckets', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket', 'ForcePathStyle' => true, 'Region' => 'cn-north-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'path style + invalid DNS name@cn-north-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'cn-north-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.cn-north-1.amazonaws.com.cn/99a_b', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => '99a_b', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => '99a_b', 'ForcePathStyle' => true, 'Region' => 'cn-north-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'no path style + invalid DNS name@cn-north-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'cn-north-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.cn-north-1.amazonaws.com.cn/99a_b', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => '99a_b', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => '99a_b', 'Region' => 'cn-north-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'vanilla path style@af-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.af-south-1.amazonaws.com/bucket-name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'path style + fips@af-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, 'name' => 'sigv4', ], ], ], 'url' => 'https://s3-fips.af-south-1.amazonaws.com/bucket-name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'AWS::UseFIPS' => true, 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => true, ], ], [ 'documentation' => 'path style + accelerate = error@af-south-1', 'expect' => [ 'error' => 'Path-style addressing cannot be used with S3 Accelerate', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'AWS::S3::ForcePathStyle' => true, 'AWS::S3::Accelerate' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => true, 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'path style + dualstack@af-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.dualstack.af-south-1.amazonaws.com/bucket-name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'AWS::UseDualStack' => true, 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'Region' => 'af-south-1', 'UseDualStack' => true, 'UseFIPS' => false, ], ], [ 'documentation' => 'path style + arn is error@af-south-1', 'expect' => [ 'error' => 'Path-style addressing cannot be used with ARN buckets', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket', 'ForcePathStyle' => true, 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'path style + invalid DNS name@af-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.af-south-1.amazonaws.com/99a_b', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => '99a_b', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => '99a_b', 'ForcePathStyle' => true, 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'no path style + invalid DNS name@af-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3.af-south-1.amazonaws.com/99a_b', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => '99a_b', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => '99a_b', 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'virtual addressing + private link@us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'http://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'SDK::Endpoint' => 'http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Endpoint' => 'http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'path style + private link@us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'SDK::Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'SDK::Host + FIPS@us-west-2', 'expect' => [ 'error' => 'A custom endpoint cannot be combined with FIPS', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::UseFIPS' => true, 'SDK::Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => true, ], ], [ 'documentation' => 'SDK::Host + DualStack@us-west-2', 'expect' => [ 'error' => 'Cannot set dual-stack in combination with a custom endpoint.', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::UseDualStack' => true, 'SDK::Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'Region' => 'us-west-2', 'UseDualStack' => true, 'UseFIPS' => false, ], ], [ 'documentation' => 'SDK::HOST + accelerate@us-west-2', 'expect' => [ 'error' => 'A custom endpoint cannot be combined with S3 Accelerate', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'SDK::Endpoint' => 'http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'AWS::S3::Accelerate' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => true, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Endpoint' => 'http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'SDK::Host + access point ARN@us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://myendpoint-123456789012.beta.example.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'SDK::Endpoint' => 'https://beta.example.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'Endpoint' => 'https://beta.example.com', 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'virtual addressing + private link@cn-north-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'cn-north-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', 'SDK::Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'Region' => 'cn-north-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'path style + private link@cn-north-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'cn-north-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', 'SDK::Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'Region' => 'cn-north-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'FIPS@cn-north-1', 'expect' => [ 'error' => 'Partition does not support FIPS', ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Region' => 'cn-north-1', 'UseDualStack' => false, 'UseFIPS' => true, ], ], [ 'documentation' => 'SDK::Host + DualStack@cn-north-1', 'expect' => [ 'error' => 'Cannot set dual-stack in combination with a custom endpoint.', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', 'AWS::UseDualStack' => true, 'SDK::Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'Region' => 'cn-north-1', 'UseDualStack' => true, 'UseFIPS' => false, ], ], [ 'documentation' => 'SDK::HOST + accelerate@cn-north-1', 'expect' => [ 'error' => 'A custom endpoint cannot be combined with S3 Accelerate', ], 'params' => [ 'Accelerate' => true, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'Region' => 'cn-north-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'SDK::Host + access point ARN@cn-north-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'cn-north-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://myendpoint-123456789012.beta.example.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', 'SDK::Endpoint' => 'https://beta.example.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'Endpoint' => 'https://beta.example.com', 'Region' => 'cn-north-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'virtual addressing + private link@af-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'SDK::Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'path style + private link@af-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'SDK::Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'AWS::S3::ForcePathStyle' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => true, 'Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'SDK::Host + FIPS@af-south-1', 'expect' => [ 'error' => 'A custom endpoint cannot be combined with FIPS', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'AWS::UseFIPS' => true, 'SDK::Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => true, ], ], [ 'documentation' => 'SDK::Host + DualStack@af-south-1', 'expect' => [ 'error' => 'Cannot set dual-stack in combination with a custom endpoint.', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'AWS::UseDualStack' => true, 'SDK::Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'Region' => 'af-south-1', 'UseDualStack' => true, 'UseFIPS' => false, ], ], [ 'documentation' => 'SDK::HOST + accelerate@af-south-1', 'expect' => [ 'error' => 'A custom endpoint cannot be combined with S3 Accelerate', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'SDK::Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'AWS::S3::Accelerate' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'bucket-name', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => true, 'Bucket' => 'bucket-name', 'ForcePathStyle' => false, 'Endpoint' => 'https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com', 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'SDK::Host + access point ARN@af-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://myendpoint-123456789012.beta.example.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'SDK::Endpoint' => 'https://beta.example.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'Endpoint' => 'https://beta.example.com', 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'vanilla access point arn@us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'access point arn + FIPS@us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://myendpoint-123456789012.s3-accesspoint-fips.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::UseFIPS' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => true, ], ], [ 'documentation' => 'access point arn + accelerate = error@us-west-2', 'expect' => [ 'error' => 'Access Points do not support S3 Accelerate', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::Accelerate' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => true, 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'access point arn + FIPS + DualStack@us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::UseFIPS' => true, 'AWS::UseDualStack' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'Region' => 'us-west-2', 'UseDualStack' => true, 'UseFIPS' => true, ], ], [ 'documentation' => 'vanilla access point arn@cn-north-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'cn-north-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://myendpoint-123456789012.s3-accesspoint.cn-north-1.amazonaws.com.cn', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'Region' => 'cn-north-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'access point arn + FIPS@cn-north-1', 'expect' => [ 'error' => 'Partition does not support FIPS', ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'Region' => 'cn-north-1', 'UseDualStack' => false, 'UseFIPS' => true, ], ], [ 'documentation' => 'access point arn + accelerate = error@cn-north-1', 'expect' => [ 'error' => 'Access Points do not support S3 Accelerate', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'cn-north-1', 'AWS::S3::Accelerate' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => true, 'Bucket' => 'arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'Region' => 'cn-north-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'access point arn + FIPS + DualStack@cn-north-1', 'expect' => [ 'error' => 'Partition does not support FIPS', ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'Region' => 'cn-north-1', 'UseDualStack' => true, 'UseFIPS' => true, ], ], [ 'documentation' => 'vanilla access point arn@af-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://myendpoint-123456789012.s3-accesspoint.af-south-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'access point arn + FIPS@af-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://myendpoint-123456789012.s3-accesspoint-fips.af-south-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'AWS::UseFIPS' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => true, ], ], [ 'documentation' => 'access point arn + accelerate = error@af-south-1', 'expect' => [ 'error' => 'Access Points do not support S3 Accelerate', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'AWS::S3::Accelerate' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => true, 'Bucket' => 'arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'Region' => 'af-south-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'access point arn + FIPS + DualStack@af-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'af-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.af-south-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'af-south-1', 'AWS::UseFIPS' => true, 'AWS::UseDualStack' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint', 'ForcePathStyle' => false, 'Region' => 'af-south-1', 'UseDualStack' => true, 'UseFIPS' => true, ], ], [ 'documentation' => 'S3 outposts vanilla test', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-outposts', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://reports-123456789012.op-01234567890123456.s3-outposts.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'Bucket' => 'arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports', ], ], [ 'documentation' => 'S3 outposts custom endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-outposts', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://reports-123456789012.op-01234567890123456.example.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'SDK::Endpoint' => 'https://example.amazonaws.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'Bucket' => 'arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports', 'Endpoint' => 'https://example.amazonaws.com', ], ], [ 'documentation' => 'outposts arn with region mismatch and UseArnRegion=false', 'expect' => [ 'error' => 'Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::UseArnRegion' => false, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint', 'ForcePathStyle' => false, 'UseArnRegion' => false, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'outposts arn with region mismatch, custom region and UseArnRegion=false', 'expect' => [ 'error' => 'Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'SDK::Endpoint' => 'https://example.com', 'AWS::S3::UseArnRegion' => false, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint', 'Endpoint' => 'https://example.com', 'ForcePathStyle' => false, 'UseArnRegion' => false, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'outposts arn with region mismatch and UseArnRegion=true', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-outposts', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://myaccesspoint-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::UseArnRegion' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint', 'ForcePathStyle' => false, 'UseArnRegion' => true, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'outposts arn with region mismatch and UseArnRegion unset', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-outposts', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://myaccesspoint-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint', 'ForcePathStyle' => false, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'outposts arn with partition mismatch and UseArnRegion=true', 'expect' => [ 'error' => 'Client was configured for partition `aws` but ARN (`arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint`) has `aws-cn`', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::UseArnRegion' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint', 'ForcePathStyle' => false, 'UseArnRegion' => true, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'ARN with UseGlobalEndpoint and use-east-1 region uses the regional endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-outposts', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://reports-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::S3::UseGlobalEndpoint' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456/accesspoint/reports', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'UseGlobalEndpoint' => true, 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'Bucket' => 'arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456/accesspoint/reports', ], ], [ 'documentation' => 'S3 outposts does not support dualstack', 'expect' => [ 'error' => 'S3 Outposts does not support Dual-stack', ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => false, 'UseDualStack' => true, 'Accelerate' => false, 'Bucket' => 'arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports', ], ], [ 'documentation' => 'S3 outposts does not support fips', 'expect' => [ 'error' => 'S3 Outposts does not support FIPS', ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => true, 'UseDualStack' => false, 'Accelerate' => false, 'Bucket' => 'arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports', ], ], [ 'documentation' => 'S3 outposts does not support accelerate', 'expect' => [ 'error' => 'S3 Outposts does not support S3 Accelerate', ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => true, 'Bucket' => 'arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports', ], ], [ 'documentation' => 'validates against subresource', 'expect' => [ 'error' => 'Invalid Arn: Outpost Access Point ARN contains sub resources', ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'Bucket' => 'arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:mybucket:object:foo', ], ], [ 'documentation' => 'object lambda @us-east-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-object-lambda', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::S3::UseArnRegion' => false, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => false, 'Bucket' => 'arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner', ], ], [ 'documentation' => 'object lambda @us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-object-lambda', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://mybanner-123456789012.s3-object-lambda.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::UseArnRegion' => false, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => false, 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner', ], ], [ 'documentation' => 'object lambda, colon resource deliminator @us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-object-lambda', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://mybanner-123456789012.s3-object-lambda.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::UseArnRegion' => false, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:mybanner', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => false, 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:mybanner', ], ], [ 'documentation' => 'object lambda @us-east-1, client region us-west-2, useArnRegion=true', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-object-lambda', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::UseArnRegion' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => true, 'Bucket' => 'arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner', ], ], [ 'documentation' => 'object lambda @us-east-1, client region s3-external-1, useArnRegion=true', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-object-lambda', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 's3-external-1', 'AWS::S3::UseArnRegion' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 's3-external-1', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => true, 'Bucket' => 'arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner', ], ], [ 'documentation' => 'object lambda @us-east-1, client region s3-external-1, useArnRegion=false', 'expect' => [ 'error' => 'Invalid configuration: region from ARN `us-east-1` does not match client region `s3-external-1` and UseArnRegion is `false`', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 's3-external-1', 'AWS::S3::UseArnRegion' => false, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 's3-external-1', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => false, 'Bucket' => 'arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner', ], ], [ 'documentation' => 'object lambda @us-east-1, client region aws-global, useArnRegion=true', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-object-lambda', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', 'AWS::S3::UseArnRegion' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'aws-global', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => true, 'Bucket' => 'arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner', ], ], [ 'documentation' => 'object lambda @us-east-1, client region aws-global, useArnRegion=false', 'expect' => [ 'error' => 'Invalid configuration: region from ARN `us-east-1` does not match client region `aws-global` and UseArnRegion is `false`', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', 'AWS::S3::UseArnRegion' => false, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'aws-global', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => false, 'Bucket' => 'arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner', ], ], [ 'documentation' => 'object lambda @cn-north-1, client region us-west-2 (cross partition), useArnRegion=true', 'expect' => [ 'error' => 'Client was configured for partition `aws` but ARN (`arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner`) has `aws-cn`', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'aws-global', 'AWS::S3::UseArnRegion' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'aws-global', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => true, 'Bucket' => 'arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner', ], ], [ 'documentation' => 'object lambda with dualstack', 'expect' => [ 'error' => 'S3 Object Lambda does not support Dual-stack', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::UseDualStack' => true, 'AWS::S3::UseArnRegion' => false, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => true, 'Accelerate' => false, 'UseArnRegion' => false, 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner', ], ], [ 'documentation' => 'object lambda @us-gov-east-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-object-lambda', 'signingRegion' => 'us-gov-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://mybanner-123456789012.s3-object-lambda.us-gov-east-1.amazonaws.com', ], ], 'params' => [ 'Region' => 'us-gov-east-1', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => false, 'Bucket' => 'arn:aws-us-gov:s3-object-lambda:us-gov-east-1:123456789012:accesspoint/mybanner', ], ], [ 'documentation' => 'object lambda @us-gov-east-1, with fips', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-object-lambda', 'signingRegion' => 'us-gov-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://mybanner-123456789012.s3-object-lambda-fips.us-gov-east-1.amazonaws.com', ], ], 'params' => [ 'Region' => 'us-gov-east-1', 'UseFIPS' => true, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => false, 'Bucket' => 'arn:aws-us-gov:s3-object-lambda:us-gov-east-1:123456789012:accesspoint/mybanner', ], ], [ 'documentation' => 'object lambda @cn-north-1, with fips', 'expect' => [ 'error' => 'Partition does not support FIPS', ], 'params' => [ 'Region' => 'cn-north-1', 'UseFIPS' => true, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => false, 'Bucket' => 'arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner', ], ], [ 'documentation' => 'object lambda with accelerate', 'expect' => [ 'error' => 'S3 Object Lambda does not support S3 Accelerate', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::Accelerate' => true, 'AWS::S3::UseArnRegion' => false, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => true, 'UseArnRegion' => false, 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner', ], ], [ 'documentation' => 'object lambda with invalid arn - bad service and someresource', 'expect' => [ 'error' => 'Invalid ARN: Unrecognized format: arn:aws:sqs:us-west-2:123456789012:someresource (type: someresource)', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::UseArnRegion' => false, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:sqs:us-west-2:123456789012:someresource', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => false, 'Bucket' => 'arn:aws:sqs:us-west-2:123456789012:someresource', ], ], [ 'documentation' => 'object lambda with invalid arn - invalid resource', 'expect' => [ 'error' => 'Invalid ARN: Object Lambda ARNs only support `accesspoint` arn types, but found: `bucket_name`', ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => false, 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123456789012:bucket_name:mybucket', ], ], [ 'documentation' => 'object lambda with invalid arn - missing region', 'expect' => [ 'error' => 'Invalid ARN: bucket ARN is missing a region', ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => false, 'Bucket' => 'arn:aws:s3-object-lambda::123456789012:accesspoint/mybanner', ], ], [ 'documentation' => 'object lambda with invalid arn - missing account-id', 'expect' => [ 'error' => 'Invalid ARN: Missing account id', ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => true, 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2::accesspoint/mybanner', ], ], [ 'documentation' => 'object lambda with invalid arn - account id contains invalid characters', 'expect' => [ 'error' => 'Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123.45678.9012`', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::UseArnRegion' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123.45678.9012:accesspoint:mybucket', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => true, 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123.45678.9012:accesspoint:mybucket', ], ], [ 'documentation' => 'object lambda with invalid arn - missing access point name', 'expect' => [ 'error' => 'Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided', ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => true, 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint', ], ], [ 'documentation' => 'object lambda with invalid arn - access point name contains invalid character: *', 'expect' => [ 'error' => 'Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `*`', ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => true, 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:*', ], ], [ 'documentation' => 'object lambda with invalid arn - access point name contains invalid character: .', 'expect' => [ 'error' => 'Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `my.bucket`', ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => true, 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:my.bucket', ], ], [ 'documentation' => 'object lambda with invalid arn - access point name contains sub resources', 'expect' => [ 'error' => 'Invalid ARN: The ARN may only contain a single resource component after `accesspoint`.', ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => true, 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:mybucket:object:foo', ], ], [ 'documentation' => 'object lambda with custom endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-object-lambda', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://mybanner-123456789012.my-endpoint.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'SDK::Endpoint' => 'https://my-endpoint.com', 'AWS::S3::UseArnRegion' => false, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseArnRegion' => false, 'Bucket' => 'arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner', 'Endpoint' => 'https://my-endpoint.com', ], ], [ 'documentation' => 'object lambda arn with region mismatch and UseArnRegion=false', 'expect' => [ 'error' => 'Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'AWS::S3::UseArnRegion' => false, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner', 'Key' => 'key', ], ], ], 'params' => [ 'Accelerate' => false, 'Bucket' => 'arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner', 'ForcePathStyle' => false, 'UseArnRegion' => false, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'WriteGetObjectResponse @ us-west-2', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-object-lambda', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3-object-lambda.us-west-2.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', ], 'operationName' => 'WriteGetObjectResponse', 'operationParams' => [ 'RequestRoute' => 'RequestRoute', 'RequestToken' => 'RequestToken', ], ], ], 'params' => [ 'Accelerate' => false, 'UseObjectLambdaEndpoint' => true, 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'WriteGetObjectResponse with custom endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-object-lambda', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://my-endpoint.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'SDK::Endpoint' => 'https://my-endpoint.com', ], 'operationName' => 'WriteGetObjectResponse', 'operationParams' => [ 'RequestRoute' => 'RequestRoute', 'RequestToken' => 'RequestToken', ], ], ], 'params' => [ 'Accelerate' => false, 'UseObjectLambdaEndpoint' => true, 'Endpoint' => 'https://my-endpoint.com', 'Region' => 'us-west-2', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'WriteGetObjectResponse @ us-east-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-object-lambda', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3-object-lambda.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'WriteGetObjectResponse', 'operationParams' => [ 'RequestRoute' => 'RequestRoute', 'RequestToken' => 'RequestToken', ], ], ], 'params' => [ 'Accelerate' => false, 'UseObjectLambdaEndpoint' => true, 'Region' => 'us-east-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'WriteGetObjectResponse with fips', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-object-lambda', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://s3-object-lambda-fips.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::UseFIPS' => true, ], 'operationName' => 'WriteGetObjectResponse', 'operationParams' => [ 'RequestRoute' => 'RequestRoute', 'RequestToken' => 'RequestToken', ], ], ], 'params' => [ 'Accelerate' => false, 'UseObjectLambdaEndpoint' => true, 'Region' => 'us-east-1', 'UseDualStack' => false, 'UseFIPS' => true, ], ], [ 'documentation' => 'WriteGetObjectResponse with dualstack', 'expect' => [ 'error' => 'S3 Object Lambda does not support Dual-stack', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::UseDualStack' => true, ], 'operationName' => 'WriteGetObjectResponse', 'operationParams' => [ 'RequestRoute' => 'RequestRoute', 'RequestToken' => 'RequestToken', ], ], ], 'params' => [ 'Accelerate' => false, 'UseObjectLambdaEndpoint' => true, 'Region' => 'us-east-1', 'UseDualStack' => true, 'UseFIPS' => false, ], ], [ 'documentation' => 'WriteGetObjectResponse with accelerate', 'expect' => [ 'error' => 'S3 Object Lambda does not support S3 Accelerate', ], 'params' => [ 'Accelerate' => true, 'UseObjectLambdaEndpoint' => true, 'Region' => 'us-east-1', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'WriteGetObjectResponse with fips in CN', 'expect' => [ 'error' => 'Partition does not support FIPS', ], 'params' => [ 'Accelerate' => false, 'Region' => 'cn-north-1', 'UseObjectLambdaEndpoint' => true, 'UseDualStack' => false, 'UseFIPS' => true, ], ], [ 'documentation' => 'WriteGetObjectResponse with invalid partition', 'expect' => [ 'error' => 'Invalid region: region was not a valid DNS name.', ], 'params' => [ 'Accelerate' => false, 'UseObjectLambdaEndpoint' => true, 'Region' => 'not a valid DNS name', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'WriteGetObjectResponse with an unknown partition', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-object-lambda', 'disableDoubleEncoding' => true, 'signingRegion' => 'us-east.special', ], ], ], 'url' => 'https://s3-object-lambda.us-east.special.amazonaws.com', ], ], 'params' => [ 'Accelerate' => false, 'UseObjectLambdaEndpoint' => true, 'Region' => 'us-east.special', 'UseDualStack' => false, 'UseFIPS' => false, ], ], [ 'documentation' => 'S3 Outposts bucketAlias Real Outpost Prod us-west-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-outposts', 'signingRegion' => 'us-west-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3.op-0b1d075431d83bebd.s3-outposts.us-west-1.amazonaws.com', ], ], 'params' => [ 'Region' => 'us-west-1', 'Bucket' => 'test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'S3 Outposts bucketAlias Real Outpost Prod ap-east-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-outposts', 'signingRegion' => 'ap-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3.op-0b1d075431d83bebd.s3-outposts.ap-east-1.amazonaws.com', ], ], 'params' => [ 'Region' => 'ap-east-1', 'Bucket' => 'test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'S3 Outposts bucketAlias Ec2 Outpost Prod us-east-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-outposts', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://test-accessp-e0000075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3.ec2.s3-outposts.us-east-1.amazonaws.com', ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'test-accessp-e0000075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'S3 Outposts bucketAlias Ec2 Outpost Prod me-south-1', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-outposts', 'signingRegion' => 'me-south-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://test-accessp-e0000075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3.ec2.s3-outposts.me-south-1.amazonaws.com', ], ], 'params' => [ 'Region' => 'me-south-1', 'Bucket' => 'test-accessp-e0000075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'S3 Outposts bucketAlias Real Outpost Beta', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-outposts', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kbeta0--op-s3.op-0b1d075431d83bebd.example.amazonaws.com', ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kbeta0--op-s3', 'Endpoint' => 'https://example.amazonaws.com', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'S3 Outposts bucketAlias Ec2 Outpost Beta', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3-outposts', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://161743052723-e00000136899934034jeahy1t8gpzpbwjj8kb7beta0--op-s3.ec2.example.amazonaws.com', ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => '161743052723-e00000136899934034jeahy1t8gpzpbwjj8kb7beta0--op-s3', 'Endpoint' => 'https://example.amazonaws.com', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'S3 Outposts bucketAlias - No endpoint set for beta', 'expect' => [ 'error' => 'Expected a endpoint to be specified but no endpoint was found', ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kbeta0--op-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'S3 Outposts bucketAlias Invalid hardware type', 'expect' => [ 'error' => 'Unrecognized hardware type: "Expected hardware type o or e but got h"', ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'test-accessp-h0000075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'S3 Outposts bucketAlias Special character in Outpost Arn', 'expect' => [ 'error' => 'Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`.', ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'test-accessp-o00000754%1d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'S3 Outposts bucketAlias - No endpoint set for beta', 'expect' => [ 'error' => 'Expected a endpoint to be specified but no endpoint was found', ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'test-accessp-e0b1d075431d83bebde8xz5w8ijx1qzlbp3i3ebeta0--op-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'S3 Snow with bucket', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'snow', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'http://10.0.1.12:433/bucketName', ], ], 'params' => [ 'Region' => 'snow', 'Bucket' => 'bucketName', 'Endpoint' => 'http://10.0.1.12:433', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'S3 Snow without bucket', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'snow', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://10.0.1.12:433', ], ], 'params' => [ 'Region' => 'snow', 'Endpoint' => 'https://10.0.1.12:433', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'S3 Snow no port', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'snow', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'http://10.0.1.12/bucketName', ], ], 'params' => [ 'Region' => 'snow', 'Bucket' => 'bucketName', 'Endpoint' => 'http://10.0.1.12', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'S3 Snow dns endpoint', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3', 'signingRegion' => 'snow', 'disableDoubleEncoding' => true, ], ], ], 'url' => 'https://amazonaws.com/bucketName', ], ], 'params' => [ 'Region' => 'snow', 'Bucket' => 'bucketName', 'Endpoint' => 'https://amazonaws.com', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, ], ], [ 'documentation' => 'Data Plane with short AZ', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4-s3express', 'signingName' => 's3express', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], 'backend' => 'S3Express', ], 'url' => 'https://mybucket--use1-az1--x-s3.s3express-use1-az1.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'mybucket--use1-az1--x-s3', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'mybucket--use1-az1--x-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseS3ExpressControlEndpoint' => false, ], ], [ 'documentation' => 'Data Plane with short AZ fips', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4-s3express', 'signingName' => 's3express', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], 'backend' => 'S3Express', ], 'url' => 'https://mybucket--use1-az1--x-s3.s3express-fips-use1-az1.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::UseFIPS' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'mybucket--use1-az1--x-s3', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'mybucket--use1-az1--x-s3', 'UseFIPS' => true, 'UseDualStack' => false, 'Accelerate' => false, 'UseS3ExpressControlEndpoint' => false, ], ], [ 'documentation' => 'Data Plane with long AZ', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4-s3express', 'signingName' => 's3express', 'signingRegion' => 'ap-northeast-1', 'disableDoubleEncoding' => true, ], ], 'backend' => 'S3Express', ], 'url' => 'https://mybucket--apne1-az1--x-s3.s3express-apne1-az1.ap-northeast-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'ap-northeast-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'mybucket--apne1-az1--x-s3', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'ap-northeast-1', 'Bucket' => 'mybucket--apne1-az1--x-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseS3ExpressControlEndpoint' => false, ], ], [ 'documentation' => 'Data Plane with long AZ fips', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4-s3express', 'signingName' => 's3express', 'signingRegion' => 'ap-northeast-1', 'disableDoubleEncoding' => true, ], ], 'backend' => 'S3Express', ], 'url' => 'https://mybucket--apne1-az1--x-s3.s3express-fips-apne1-az1.ap-northeast-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'ap-northeast-1', 'AWS::UseFIPS' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'mybucket--apne1-az1--x-s3', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'ap-northeast-1', 'Bucket' => 'mybucket--apne1-az1--x-s3', 'UseFIPS' => true, 'UseDualStack' => false, 'Accelerate' => false, 'UseS3ExpressControlEndpoint' => false, ], ], [ 'documentation' => 'Control plane with short AZ bucket', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3express', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], 'backend' => 'S3Express', ], 'url' => 'https://s3express-control.us-east-1.amazonaws.com/mybucket--use1-az1--x-s3', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'CreateBucket', 'operationParams' => [ 'Bucket' => 'mybucket--use1-az1--x-s3', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'mybucket--use1-az1--x-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseS3ExpressControlEndpoint' => true, 'DisableS3ExpressSessionAuth' => false, ], ], [ 'documentation' => 'Control plane with short AZ bucket and fips', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3express', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], 'backend' => 'S3Express', ], 'url' => 'https://s3express-control-fips.us-east-1.amazonaws.com/mybucket--use1-az1--x-s3', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::UseFIPS' => true, ], 'operationName' => 'CreateBucket', 'operationParams' => [ 'Bucket' => 'mybucket--use1-az1--x-s3', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'mybucket--use1-az1--x-s3', 'UseFIPS' => true, 'UseDualStack' => false, 'Accelerate' => false, 'UseS3ExpressControlEndpoint' => true, 'DisableS3ExpressSessionAuth' => false, ], ], [ 'documentation' => 'Control plane without bucket', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3express', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], 'backend' => 'S3Express', ], 'url' => 'https://s3express-control.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'ListDirectoryBuckets', ], ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseS3ExpressControlEndpoint' => true, 'DisableS3ExpressSessionAuth' => false, ], ], [ 'documentation' => 'Control plane without bucket and fips', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3express', 'signingRegion' => 'us-east-1', 'disableDoubleEncoding' => true, ], ], 'backend' => 'S3Express', ], 'url' => 'https://s3express-control-fips.us-east-1.amazonaws.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::UseFIPS' => true, ], 'operationName' => 'ListDirectoryBuckets', ], ], 'params' => [ 'Region' => 'us-east-1', 'UseFIPS' => true, 'UseDualStack' => false, 'Accelerate' => false, 'UseS3ExpressControlEndpoint' => true, 'DisableS3ExpressSessionAuth' => false, ], ], [ 'documentation' => 'Data Plane sigv4 auth with short AZ', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3express', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], 'backend' => 'S3Express', ], 'url' => 'https://mybucket--usw2-az1--x-s3.s3express-usw2-az1.us-west-2.amazonaws.com', ], ], 'params' => [ 'Region' => 'us-west-2', 'Bucket' => 'mybucket--usw2-az1--x-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'DisableS3ExpressSessionAuth' => true, ], ], [ 'documentation' => 'Data Plane sigv4 auth with short AZ fips', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3express', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], 'backend' => 'S3Express', ], 'url' => 'https://mybucket--usw2-az1--x-s3.s3express-fips-usw2-az1.us-west-2.amazonaws.com', ], ], 'params' => [ 'Region' => 'us-west-2', 'Bucket' => 'mybucket--usw2-az1--x-s3', 'UseFIPS' => true, 'UseDualStack' => false, 'Accelerate' => false, 'DisableS3ExpressSessionAuth' => true, ], ], [ 'documentation' => 'Data Plane sigv4 auth with long AZ', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3express', 'signingRegion' => 'ap-northeast-1', 'disableDoubleEncoding' => true, ], ], 'backend' => 'S3Express', ], 'url' => 'https://mybucket--apne1-az1--x-s3.s3express-apne1-az1.ap-northeast-1.amazonaws.com', ], ], 'params' => [ 'Region' => 'ap-northeast-1', 'Bucket' => 'mybucket--apne1-az1--x-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseS3ExpressControlEndpoint' => false, 'DisableS3ExpressSessionAuth' => true, ], ], [ 'documentation' => 'Data Plane sigv4 auth with long AZ fips', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3express', 'signingRegion' => 'ap-northeast-1', 'disableDoubleEncoding' => true, ], ], 'backend' => 'S3Express', ], 'url' => 'https://mybucket--apne1-az1--x-s3.s3express-fips-apne1-az1.ap-northeast-1.amazonaws.com', ], ], 'params' => [ 'Region' => 'ap-northeast-1', 'Bucket' => 'mybucket--apne1-az1--x-s3', 'UseFIPS' => true, 'UseDualStack' => false, 'Accelerate' => false, 'UseS3ExpressControlEndpoint' => false, 'DisableS3ExpressSessionAuth' => true, ], ], [ 'documentation' => 'Control Plane host override', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3express', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], 'backend' => 'S3Express', ], 'url' => 'https://mybucket--usw2-az1--x-s3.custom.com', ], ], 'params' => [ 'Region' => 'us-west-2', 'Bucket' => 'mybucket--usw2-az1--x-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseS3ExpressControlEndpoint' => true, 'DisableS3ExpressSessionAuth' => true, 'Endpoint' => 'https://custom.com', ], ], [ 'documentation' => 'Control Plane host override no bucket', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3express', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], 'backend' => 'S3Express', ], 'url' => 'https://custom.com', ], ], 'params' => [ 'Region' => 'us-west-2', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseS3ExpressControlEndpoint' => true, 'DisableS3ExpressSessionAuth' => true, 'Endpoint' => 'https://custom.com', ], ], [ 'documentation' => 'Data plane host override non virtual session auth', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4-s3express', 'signingName' => 's3express', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], 'backend' => 'S3Express', ], 'url' => 'https://10.0.0.1/mybucket--usw2-az1--x-s3', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'SDK::Endpoint' => 'https://10.0.0.1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'mybucket--usw2-az1--x-s3', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-west-2', 'Bucket' => 'mybucket--usw2-az1--x-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'Endpoint' => 'https://10.0.0.1', ], ], [ 'documentation' => 'Control Plane host override ip', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4', 'signingName' => 's3express', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], 'backend' => 'S3Express', ], 'url' => 'https://10.0.0.1/mybucket--usw2-az1--x-s3', ], ], 'params' => [ 'Region' => 'us-west-2', 'Bucket' => 'mybucket--usw2-az1--x-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseS3ExpressControlEndpoint' => true, 'DisableS3ExpressSessionAuth' => true, 'Endpoint' => 'https://10.0.0.1', ], ], [ 'documentation' => 'Data plane host override', 'expect' => [ 'endpoint' => [ 'properties' => [ 'authSchemes' => [ [ 'name' => 'sigv4-s3express', 'signingName' => 's3express', 'signingRegion' => 'us-west-2', 'disableDoubleEncoding' => true, ], ], 'backend' => 'S3Express', ], 'url' => 'https://mybucket--usw2-az1--x-s3.custom.com', ], ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'SDK::Endpoint' => 'https://custom.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'mybucket--usw2-az1--x-s3', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-west-2', 'Bucket' => 'mybucket--usw2-az1--x-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'Endpoint' => 'https://custom.com', ], ], [ 'documentation' => 'bad format error', 'expect' => [ 'error' => 'Unrecognized S3Express bucket name format.', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'mybucket--usaz1--x-s3', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'mybucket--usaz1--x-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseS3ExpressControlEndpoint' => false, ], ], [ 'documentation' => 'bad format error no session auth', 'expect' => [ 'error' => 'Unrecognized S3Express bucket name format.', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'mybucket--usaz1--x-s3', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'mybucket--usaz1--x-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseS3ExpressControlEndpoint' => false, 'DisableS3ExpressSessionAuth' => true, ], ], [ 'documentation' => 'dual-stack error', 'expect' => [ 'error' => 'S3Express does not support Dual-stack.', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::UseDualStack' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'mybucket--use1-az1--x-s3', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'mybucket--use1-az1--x-s3', 'UseFIPS' => false, 'UseDualStack' => true, 'Accelerate' => false, 'UseS3ExpressControlEndpoint' => false, ], ], [ 'documentation' => 'accelerate error', 'expect' => [ 'error' => 'S3Express does not support S3 Accelerate.', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', 'AWS::S3::Accelerate' => true, ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'mybucket--use1-az1--x-s3', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'mybucket--use1-az1--x-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => true, 'UseS3ExpressControlEndpoint' => false, ], ], [ 'documentation' => 'Data plane bucket format error', 'expect' => [ 'error' => 'S3Express bucket name is not a valid virtual hostable name.', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-east-1', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'my.bucket--use1-az1--x-s3', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-east-1', 'Bucket' => 'my.bucket--use1-az1--x-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'UseS3ExpressControlEndpoint' => false, ], ], [ 'documentation' => 'host override data plane bucket error session auth', 'expect' => [ 'error' => 'S3Express bucket name is not a valid virtual hostable name.', ], 'operationInputs' => [ [ 'builtInParams' => [ 'AWS::Region' => 'us-west-2', 'SDK::Endpoint' => 'https://custom.com', ], 'operationName' => 'GetObject', 'operationParams' => [ 'Bucket' => 'my.bucket--usw2-az1--x-s3', 'Key' => 'key', ], ], ], 'params' => [ 'Region' => 'us-west-2', 'Bucket' => 'my.bucket--usw2-az1--x-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'Endpoint' => 'https://custom.com', ], ], [ 'documentation' => 'host override data plane bucket error', 'expect' => [ 'error' => 'S3Express bucket name is not a valid virtual hostable name.', ], 'params' => [ 'Region' => 'us-west-2', 'Bucket' => 'my.bucket--usw2-az1--x-s3', 'UseFIPS' => false, 'UseDualStack' => false, 'Accelerate' => false, 'Endpoint' => 'https://custom.com', 'DisableS3ExpressSessionAuth' => true, ], ], ], 'version' => '1.0',];
