<?php

// Create a MapBuilder class for describing the current database at runtime.
//
// $Id: MapBuilder.tpl,v 1.2 2004/12/04 14:32:45 micha Exp $

echo '<' . '?' . 'php';

?>

require_once 'propel/map/MapBuilder.php';
include_once 'creole/CreoleTypes.php';

/**
 * This class adds structure of '<?php echo $table->getName() ?>' table to '<?php echo $table->getDatabase()->getName() ?>' DatabaseMap object.
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an 
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive 
 * (i.e. if it's a text column type).
 *
<?php if ($addTimeStamp) { ?>
 *  This class was autogenerated by Propel on:
 *
 * [<?php echo $now ?>]
 *
<?php } ?>
 * @see BasePeer
 * @see DatabaseMap
 * @package <?php echo $package ?>.map
 */
class <?php echo $table->getPhpName() ?>MapBuilder implements MapBuilder {

    /**
     * The name of this class
     */
    const CLASS_NAME = "<?php echo $pkmap . '.' . $table->getPhpName() ?>MapBuilder";
	
    /**
     * The database map.
     */
    private $dbMap = null;

    /**
     * Tells us if this DatabaseMapBuilder is built so that we
     * don't have to re-build it every time.
     *
     * @return true if this DatabaseMapBuilder is built
     */
    public function isBuilt()
    {
        return ($this->dbMap !== null);
    }

    /**
     * Gets the databasemap this map builder built.
     *
     * @return the databasemap
     */
    public function getDatabaseMap()
    {
        return $this->dbMap;
    }

    /**
     * The doBuild() method builds the DatabaseMap
     *
	 * @return void
     * @throws PropelException
     */
    public function doBuild()
    {
		$this->dbMap = Propel::getDatabaseMap("<?php echo $table->getDatabase()->getName() ?>");
		
		$tMap = $this->dbMap->addTable("<?php echo $table->getName()?>");
		$tMap->setPhpName("<?php echo $table->getPhpName()?>");
		
        <?php if ($table->getIdMethod() == "native") { ?> 
		$tMap->setUseIdGenerator(true);
		<?php } else { ?> 
		$tMap->setUseIdGenerator(false);
		<?php } ?> 
						
		<?php if ($table->getIdMethodParameters()) {
			$params = $table->getIdMethodParameters();
			$imp = $params[0]; ?> 
		$tMap->setPrimaryKeyMethodInfo("<?php echo $imp->getValue() ?>");
		<?php } elseif ($table->getIdMethod() == "native" && ($platform->getNativeIdMethod() == Platform::SEQUENCE)) { ?> 
		$tMap->setPrimaryKeyMethodInfo("<?php echo $table->getSequenceName() ?>");
		<?php } elseif ($table->getIdMethod() == "native" && ($platform->getNativeIdMethod() == Platform::SEQUENCE)) { ?> 
		$tMap->setPrimaryKeyMethodInfo("<?php echo $table->getName() ?>");
		<?php } ?> 
		
		// Add columns to map
<?php foreach ($table->getColumns() as $col) {
	$tfc=$table->getPhpName();
	$cfc=$col->getPhpName();
	$cup=strtoupper($col->getName());
	if (!$col->getSize()) {
		$size = "null";
	} else {
		$size = $col->getSize();
	}
	if($col->isPrimaryKey()) {
		if($col->isForeignKey()) { ?>
		$tMap->addForeignPrimaryKey("<?php echo $cup ?>", "<?php echo $cfc?>", "<?php echo $col->getPhpType() ?>" , CreoleTypes::<?php echo $col->getType() ?>, "<?php echo $col->getRelatedTableName()?>", "<?php echo strtoupper($col->getRelatedColumnName()) ?>", <?php echo $col->isNotNull() ? 'true' : 'false' ?>, <?php echo $size ?>);
<?php	} else { ?>
		$tMap->addPrimaryKey("<?php echo $cup ?>", "<?php echo $cfc?>", "<?php echo $col->getPhpType() ?>", CreoleTypes::<?php echo $col->getType() ?>, <?php echo $col->isNotNull() ? 'true' : 'false' ?>, <?php echo $size ?>);
<?php } 

	} else {
		if($col->isForeignKey()) { ?>
		$tMap->addForeignKey("<?php echo $cup ?>", "<?php echo $cfc?>", "<?php echo $col->getPhpType()?>", CreoleTypes::<?php echo $col->getType() ?>, "<?php echo $col->getRelatedTableName() ?>" , "<?php echo strtoupper($col->getRelatedColumnName()) ?>", <?php echo $col->isNotNull() ? 'true' : 'false' ?>, <?php echo $size ?>);
<?php	} else { ?>
		$tMap->addColumn("<?php echo $cup ?>", "<?php echo $cfc?>", "<?php echo $col->getPhpType()?>", CreoleTypes::<?php echo $col->getType() ?>, <?php echo $col->isNotNull() ? 'true' : 'false' ?>, <?php echo $size ?>);
<?php 	} 
	} // if col-is prim key
} // foreach
foreach($table->getValidators() as $val) {
  $col = $val->getColumn();
  $cup = strtoupper($col->getName());
  foreach($val->getRules() as $rule) {
    if ($val->getTranslate() !== Validator::TRANSLATE_NONE) {
?>
        $tMap->addValidator("<?php echo $cup ?>", "<?php echo $rule->getName() ?>", "<?php echo $rule->getClass() ?>", "<?php echo $rule->getValue()?>", <?php echo $val->getTranslate() ?>("<?php echo str_replace('"', '\"', $rule->getMessage()) ?>"));
<?php } else { ?>
        $tMap->addValidator("<?php echo $cup ?>", "<?php echo $rule->getName() ?>", "<?php echo $rule->getClass() ?>", "<?php echo $rule->getValue()?>", "<?php echo str_replace('"', '\"', $rule->getMessage()) ?>");
<?php        
    } // if ($rule->getTranslation() ...
  } // foreach validator
}
?>
				
    }
}
