/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.Comparator;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.EqualsMethod;
import net.bytebuddy.implementation.HashCodeMethod;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

@Enhance
public class HashCodeAndEqualsPlugin
implements Plugin,
Plugin.Factory {
    @Override
    public Plugin make() {
        return this;
    }

    @Override
    public boolean matches(TypeDescription target) {
        return target.getDeclaredAnnotations().isAnnotationPresent(Enhance.class);
    }

    @Override
    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        Enhance enhance = typeDescription.getDeclaredAnnotations().ofType(Enhance.class).load();
        if (((MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.isHashCode())).isEmpty()) {
            builder = builder.method(ElementMatchers.isHashCode()).intercept(enhance.invokeSuper().hashCodeMethod(typeDescription, enhance.useTypeHashConstant(), enhance.permitSubclassEquality()).withIgnoredFields(enhance.includeSyntheticFields() ? ElementMatchers.none() : ElementMatchers.isSynthetic()).withIgnoredFields(new ValueMatcher(ValueHandling.Sort.IGNORE)).withNonNullableFields(this.nonNullable(new ValueMatcher(ValueHandling.Sort.REVERSE_NULLABILITY))));
        }
        if (((MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.isEquals())).isEmpty()) {
            EqualsMethod equalsMethod = enhance.invokeSuper().equalsMethod(typeDescription).withIgnoredFields(enhance.includeSyntheticFields() ? ElementMatchers.none() : ElementMatchers.isSynthetic()).withIgnoredFields(new ValueMatcher(ValueHandling.Sort.IGNORE)).withNonNullableFields(this.nonNullable(new ValueMatcher(ValueHandling.Sort.REVERSE_NULLABILITY))).withFieldOrder(AnnotationOrderComparator.INSTANCE);
            if (enhance.simpleComparisonsFirst()) {
                equalsMethod = equalsMethod.withPrimitiveTypedFieldsFirst().withEnumerationTypedFieldsFirst().withPrimitiveWrapperTypedFieldsFirst().withStringTypedFieldsFirst();
            }
            builder = builder.method(ElementMatchers.isEquals()).intercept(enhance.permitSubclassEquality() ? equalsMethod.withSubclassEquality() : equalsMethod);
        }
        return builder;
    }

    protected ElementMatcher<FieldDescription> nonNullable(ElementMatcher<FieldDescription> matcher) {
        return matcher;
    }

    @Override
    public void close() {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.getClass() == object.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Enhance
    protected static class ValueMatcher
    implements ElementMatcher<FieldDescription> {
        private final ValueHandling.Sort sort;

        protected ValueMatcher(ValueHandling.Sort sort) {
            this.sort = sort;
        }

        @Override
        public boolean matches(FieldDescription target) {
            AnnotationDescription.Loadable<ValueHandling> annotation = target.getDeclaredAnnotations().ofType(ValueHandling.class);
            return annotation != null && annotation.load().value() == this.sort;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.sort.equals((Object)((ValueMatcher)object).sort);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.sort.hashCode();
        }
    }

    protected static enum AnnotationOrderComparator implements Comparator<FieldDescription.InDefinedShape>
    {
        INSTANCE;


        @Override
        public int compare(FieldDescription.InDefinedShape left, FieldDescription.InDefinedShape right) {
            int rightValue;
            AnnotationDescription.Loadable<Sorted> leftAnnotation = left.getDeclaredAnnotations().ofType(Sorted.class);
            AnnotationDescription.Loadable<Sorted> rightAnnotation = right.getDeclaredAnnotations().ofType(Sorted.class);
            int leftValue = leftAnnotation == null ? 0 : leftAnnotation.load().value();
            int n = rightValue = rightAnnotation == null ? 0 : rightAnnotation.load().value();
            if (leftValue > rightValue) {
                return -1;
            }
            if (leftValue < rightValue) {
                return 1;
            }
            return 0;
        }
    }

    @Documented
    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Sorted {
        public static final int DEFAULT = 0;

        public int value();
    }

    @Documented
    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ValueHandling {
        public Sort value();

        public static enum Sort {
            IGNORE,
            REVERSE_NULLABILITY;

        }
    }

    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Enhance {
        public InvokeSuper invokeSuper() default InvokeSuper.IF_DECLARED;

        public boolean simpleComparisonsFirst() default true;

        public boolean includeSyntheticFields() default false;

        public boolean permitSubclassEquality() default false;

        public boolean useTypeHashConstant() default true;

        public static enum InvokeSuper {
            IF_DECLARED{

                @Override
                protected HashCodeMethod hashCodeMethod(TypeDescription instrumentedType, boolean typeHash, boolean subclassEquality) {
                    for (TypeDescription.Generic typeDefinition = instrumentedType.getSuperClass(); typeDefinition != null && !typeDefinition.represents((Type)((Object)Object.class)); typeDefinition = typeDefinition.getSuperClass()) {
                        if (typeDefinition.asErasure().getDeclaredAnnotations().isAnnotationPresent(Enhance.class)) {
                            return HashCodeMethod.usingSuperClassOffset();
                        }
                        MethodList hashCode = (MethodList)typeDefinition.getDeclaredMethods().filter(ElementMatchers.isHashCode());
                        if (hashCode.isEmpty()) continue;
                        return ((MethodDescription)hashCode.getOnly()).isAbstract() ? (typeHash ? HashCodeMethod.usingTypeHashOffset(!subclassEquality) : HashCodeMethod.usingDefaultOffset()) : HashCodeMethod.usingSuperClassOffset();
                    }
                    return typeHash ? HashCodeMethod.usingTypeHashOffset(!subclassEquality) : HashCodeMethod.usingDefaultOffset();
                }

                @Override
                protected EqualsMethod equalsMethod(TypeDescription instrumentedType) {
                    TypeDefinition typeDefinition = instrumentedType.getSuperClass();
                    while (typeDefinition != null && !typeDefinition.represents((Type)((Object)Object.class))) {
                        if (typeDefinition.asErasure().getDeclaredAnnotations().isAnnotationPresent(Enhance.class)) {
                            return EqualsMethod.requiringSuperClassEquality();
                        }
                        MethodList hashCode = (MethodList)typeDefinition.getDeclaredMethods().filter(ElementMatchers.isHashCode());
                        if (!hashCode.isEmpty()) {
                            return ((MethodDescription)hashCode.getOnly()).isAbstract() ? EqualsMethod.isolated() : EqualsMethod.requiringSuperClassEquality();
                        }
                        typeDefinition = typeDefinition.getSuperClass().asErasure();
                    }
                    return EqualsMethod.isolated();
                }
            }
            ,
            IF_ANNOTATED{

                @Override
                protected HashCodeMethod hashCodeMethod(TypeDescription instrumentedType, boolean typeHash, boolean subclassEquality) {
                    TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                    return superClass != null && superClass.asErasure().getDeclaredAnnotations().isAnnotationPresent(Enhance.class) ? HashCodeMethod.usingSuperClassOffset() : (typeHash ? HashCodeMethod.usingTypeHashOffset(!subclassEquality) : HashCodeMethod.usingDefaultOffset());
                }

                @Override
                protected EqualsMethod equalsMethod(TypeDescription instrumentedType) {
                    TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                    return superClass != null && superClass.asErasure().getDeclaredAnnotations().isAnnotationPresent(Enhance.class) ? EqualsMethod.requiringSuperClassEquality() : EqualsMethod.isolated();
                }
            }
            ,
            ALWAYS{

                @Override
                protected HashCodeMethod hashCodeMethod(TypeDescription instrumentedType, boolean typeHash, boolean subclassEquality) {
                    return HashCodeMethod.usingSuperClassOffset();
                }

                @Override
                protected EqualsMethod equalsMethod(TypeDescription instrumentedType) {
                    return EqualsMethod.requiringSuperClassEquality();
                }
            }
            ,
            NEVER{

                @Override
                protected HashCodeMethod hashCodeMethod(TypeDescription instrumentedType, boolean typeHash, boolean subclassEquality) {
                    return typeHash ? HashCodeMethod.usingTypeHashOffset(!subclassEquality) : HashCodeMethod.usingDefaultOffset();
                }

                @Override
                protected EqualsMethod equalsMethod(TypeDescription instrumentedType) {
                    return EqualsMethod.isolated();
                }
            };


            protected abstract HashCodeMethod hashCodeMethod(TypeDescription var1, boolean var2, boolean var3);

            protected abstract EqualsMethod equalsMethod(TypeDescription var1);
        }
    }

    @Enhance
    public static class WithNonNullableFields
    extends HashCodeAndEqualsPlugin {
        @Override
        protected ElementMatcher<FieldDescription> nonNullable(ElementMatcher<FieldDescription> matcher) {
            return ElementMatchers.not(matcher);
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

