/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.matcher.ElementMatcher;

@HashCodeAndEqualsPlugin.Enhance
public class ClassLoaderParentMatcher<T extends ClassLoader>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final ClassLoader classLoader;

    public ClassLoaderParentMatcher(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public boolean matches(T target) {
        for (ClassLoader current = this.classLoader; current != null; current = current.getParent()) {
            if (current != target) continue;
            return true;
        }
        return target == null;
    }

    public String toString() {
        return "isParentOf(" + this.classLoader + ')';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.classLoader.equals(((ClassLoaderParentMatcher)object).classLoader);
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + this.classLoader.hashCode();
    }
}

